/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class BSHExpression
extends AbstractExpression {
    private static final Log logger = LogFactory.getLog(BSHExpression.class);
    public static final String BSHHEADERFILE = "org/pentaho/reporting/engine/classic/core/modules/misc/beanshell/BSHExpressionHeader.txt";
    private transient Interpreter interpreter;
    private transient boolean invalid;
    private String expression;

    protected Interpreter createInterpreter() {
        try {
            Interpreter interpreter = new Interpreter();
            this.initializeInterpreter(interpreter);
            return interpreter;
        }
        catch (Throwable e) {
            logger.warn((Object)"Unable to initialize the expression", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeInterpreter(Interpreter interpreter) throws EvalError, IOException {
        InputStream in = ObjectUtilities.getResourceRelativeAsStream((String)"BSHExpressionHeader.txt", BSHExpression.class);
        try (InputStreamReader r = new InputStreamReader(new BufferedInputStream(in));){
            interpreter.eval((Reader)r);
        }
        if (this.getExpression() != null) {
            interpreter.eval(this.expression);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue() {
        if (this.invalid) {
            return null;
        }
        if (this.interpreter == null) {
            this.interpreter = this.createInterpreter();
            if (this.interpreter == null) {
                this.invalid = true;
                return null;
            }
        }
        try {
            this.interpreter.set("runtime", (Object)this.getRuntime());
            this.interpreter.set("dataRow", (Object)this.getDataRow());
            Object object = this.interpreter.eval("getValue ();");
            return object;
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Evaluation error: " + e.getClass() + " - " + e.getMessage()));
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Evaluation error: " + e.getClass() + " - " + e.getMessage()), (Throwable)e);
            }
            Object var2_4 = null;
            return var2_4;
        }
        finally {
            try {
                this.interpreter.set("runtime", null);
                this.interpreter.set("dataRow", null);
            }
            catch (EvalError evalError) {}
        }
    }

    @Override
    public Expression getInstance() {
        BSHExpression ex = (BSHExpression)super.getInstance();
        ex.interpreter = null;
        return ex;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.invalid = false;
        this.interpreter = null;
    }
}

