/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.richtext.html;

import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderCorner;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.richtext.html.HtmlEncoderUtil;
import org.pentaho.reporting.engine.classic.core.layout.richtext.html.StyleBuilder;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class FilterStyleBuilder
implements StyleBuilder {
    private StyleBuilder builder;
    private StyleBuilder.StyleCarrier[] parentStyle;

    public FilterStyleBuilder(StyleBuilder builder, StyleBuilder.StyleCarrier[] parentStyle) {
        this.builder = builder;
        this.parentStyle = parentStyle;
    }

    @Override
    public void clear() {
        this.builder.clear();
    }

    private boolean isFiltered(StyleBuilder.CSSKeys key, StyleBuilder.StyleCarrier value) {
        if (this.parentStyle == null) {
            return false;
        }
        if (!key.isInherit()) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.parentStyle[key.ordinal()], (Object)value);
    }

    @Override
    public void append(StyleBuilder.CSSKeys key, String value) {
        if (this.isFiltered(key, new StyleBuilder.StyleCarrier(key, HtmlEncoderUtil.encodeCSS(value), null))) {
            return;
        }
        this.builder.append(key, value);
    }

    @Override
    public void appendRaw(StyleBuilder.CSSKeys key, String value) {
        if (this.isFiltered(key, new StyleBuilder.StyleCarrier(key, value, null))) {
            return;
        }
        this.builder.appendRaw(key, value);
    }

    @Override
    public void append(StyleBuilder.CSSKeys key, String value, String unit) {
        if (this.isFiltered(key, new StyleBuilder.StyleCarrier(key, HtmlEncoderUtil.encodeCSS(value), unit))) {
            return;
        }
        this.builder.append(key, value, unit);
    }

    @Override
    public void append(StyleBuilder.CSSKeys key, String value, boolean replace) {
        if (this.isFiltered(key, new StyleBuilder.StyleCarrier(key, HtmlEncoderUtil.encodeCSS(value), null))) {
            return;
        }
        this.builder.append(key, value, replace);
    }

    @Override
    public void append(StyleBuilder.CSSKeys key, String value, String unit, boolean replace) {
        if (this.isFiltered(key, new StyleBuilder.StyleCarrier(key, HtmlEncoderUtil.encodeCSS(value), unit))) {
            return;
        }
        this.builder.append(key, value, unit, replace);
    }

    @Override
    public String toString() {
        return this.builder.toString();
    }

    @Override
    public String toString(boolean compact) {
        return this.builder.toString(compact);
    }

    @Override
    public void print(Writer writer, boolean compact) throws IOException {
        this.builder.print(writer, compact);
    }

    @Override
    public String printEdgeAsCSS(BorderEdge edge) {
        return this.builder.printEdgeAsCSS(edge);
    }

    @Override
    public String printCornerAsCSS(BorderCorner edge) {
        return this.builder.printCornerAsCSS(edge);
    }

    @Override
    public NumberFormat getPointConverter() {
        return this.builder.getPointConverter();
    }

    @Override
    public StyleBuilder.StyleCarrier[] toArray() {
        return this.builder.toArray();
    }

    @Override
    public boolean isEmpty() {
        return this.builder.isEmpty();
    }
}

