/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.ql.exec.mapjoin.MapJoinMemoryExhaustionError;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinFastHashTable
implements VectorMapJoinHashTable {
    public static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastHashTable.class);
    protected int logicalHashBucketCount;
    protected int logicalHashBucketMask;
    protected float loadFactor;
    protected final int writeBuffersSize;
    protected long estimatedKeyCount;
    protected int metricPutConflict;
    protected int largestNumberOfSteps;
    protected int keysAssigned;
    protected int resizeThreshold;
    protected int metricExpands;
    public static final int HIGHEST_INT_POWER_OF_2 = 0x40000000;
    public static final int ONE_QUARTER_LIMIT = 0x10000000;
    public static final int ONE_SIXTH_LIMIT = 0xAAAAAAA;

    public void throwExpandError(int limit, String dataTypeName) {
        throw new MapJoinMemoryExhaustionError("Vector MapJoin " + dataTypeName + " Hash Table cannot grow any more -- use a smaller container size. " + "Current logical size is " + this.logicalHashBucketCount + " and " + "the limit is " + limit + ". " + "Estimated key count was " + (this.estimatedKeyCount == -1L ? "not available" : Long.valueOf(this.estimatedKeyCount)) + ".");
    }

    private static void validateCapacity(long capacity) {
        if (Long.bitCount(capacity) != 1) {
            throw new AssertionError((Object)"Capacity must be a power of two");
        }
        if (capacity <= 0L) {
            throw new AssertionError((Object)("Invalid capacity " + capacity));
        }
    }

    private static int nextHighestPowerOfTwo(int v) {
        return Integer.highestOneBit(v) << 1;
    }

    public VectorMapJoinFastHashTable(int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount) {
        initialCapacity = Long.bitCount(initialCapacity) == 1 ? initialCapacity : VectorMapJoinFastHashTable.nextHighestPowerOfTwo(initialCapacity);
        VectorMapJoinFastHashTable.validateCapacity(initialCapacity);
        this.estimatedKeyCount = estimatedKeyCount;
        this.logicalHashBucketCount = initialCapacity;
        this.logicalHashBucketMask = this.logicalHashBucketCount - 1;
        this.resizeThreshold = (int)((float)this.logicalHashBucketCount * loadFactor);
        this.loadFactor = loadFactor;
        this.writeBuffersSize = writeBuffersSize;
    }

    @Override
    public int size() {
        return this.keysAssigned;
    }

    public long getEstimatedMemorySize() {
        JavaDataModel jdm = JavaDataModel.get();
        return JavaDataModel.alignUp((long)(10L * (long)jdm.primitive1() + (long)jdm.primitive2()), (long)jdm.memoryAlign());
    }
}

