/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www.jaxrs;

import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobAdapter;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CarteSingleton;
import org.pentaho.di.www.jaxrs.CarteResource;
import org.pentaho.di.www.jaxrs.JobStatus;

@Path(value="/carte/job")
public class JobResource {
    @GET
    @Path(value="/log/{id : .+}")
    @Produces(value={"text/plain"})
    public String getJobLog(@PathParam(value="id") String id) {
        return this.getJobLog(id, 0);
    }

    @GET
    @Path(value="/log/{id : .+}/{logStart : .+}")
    @Produces(value={"text/plain"})
    public String getJobLog(@PathParam(value="id") String id, @PathParam(value="logStart") int startLineNr) {
        int lastLineNr = KettleLogStore.getLastBufferLineNr();
        Job job = CarteResource.getJob(id);
        String logText = KettleLogStore.getAppender().getBuffer(job.getLogChannel().getLogChannelId(), false, startLineNr, lastLineNr).toString();
        return logText;
    }

    @GET
    @Path(value="/status/{id : .+}")
    @Produces(value={"application/json"})
    public JobStatus getJobStatus(@PathParam(value="id") String id) {
        JobStatus status = new JobStatus();
        Job job = CarteResource.getJob(id);
        CarteObjectEntry entry = CarteResource.getCarteObjectEntry(id);
        status.setId(entry.getId());
        status.setName(entry.getName());
        status.setStatus(job.getStatus());
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/start/{id : .+}")
    @Produces(value={"application/json"})
    public JobStatus startJob(@PathParam(value="id") String id) {
        Job job = CarteResource.getJob(id);
        CarteObjectEntry entry = CarteResource.getCarteObjectEntry(id);
        try {
            if (job.isInitialized() && !job.isActive()) {
                if (job.getRep() != null && !job.getRep().isConnected()) {
                    if (job.getRep().getUserInfo() != null) {
                        job.getRep().connect(job.getRep().getUserInfo().getLogin(), job.getRep().getUserInfo().getPassword());
                    } else {
                        job.getRep().connect(null, null);
                    }
                }
                JobResource jobResource = this;
                synchronized (jobResource) {
                    JobConfiguration jobConfiguration = CarteSingleton.getInstance().getJobMap().getConfiguration(entry);
                    String carteObjectId = UUID.randomUUID().toString();
                    SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(this.getClass().getName(), LoggingObjectType.CARTE, null);
                    servletLoggingObject.setContainerObjectId(carteObjectId);
                    Job newJob = new Job(job.getRep(), job.getJobMeta(), (LoggingObjectInterface)servletLoggingObject);
                    newJob.setLogLevel(job.getLogLevel());
                    KettleLogStore.discardLines((String)job.getLogChannelId(), (boolean)true);
                    CarteSingleton.getInstance().getJobMap().replaceJob(entry, newJob, jobConfiguration);
                    job = newJob;
                }
            }
            job.start();
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
        return this.getJobStatus(id);
    }

    @GET
    @Path(value="/stop/{id : .+}")
    @Produces(value={"application/json"})
    public JobStatus stopJob(@PathParam(value="id") String id) {
        Job job = CarteResource.getJob(id);
        job.stopAll();
        return this.getJobStatus(id);
    }

    @GET
    @Path(value="/remove/{id : .+}")
    public Response removeJob(@PathParam(value="id") String id) {
        Job job = CarteResource.getJob(id);
        CarteObjectEntry entry = CarteResource.getCarteObjectEntry(id);
        KettleLogStore.discardLines((String)job.getLogChannelId(), (boolean)true);
        CarteSingleton.getInstance().getJobMap().removeJob(entry);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/add")
    @Produces(value={"application/json"})
    public JobStatus addJob(String xml) {
        try {
            JobConfiguration jobConfiguration = JobConfiguration.fromXML(xml.toString());
            JobMeta jobMeta = jobConfiguration.getJobMeta();
            JobExecutionConfiguration jobExecutionConfiguration = jobConfiguration.getJobExecutionConfiguration();
            jobMeta.setLogLevel(jobExecutionConfiguration.getLogLevel());
            jobMeta.injectVariables(jobExecutionConfiguration.getVariables());
            final Repository repository = jobConfiguration.getJobExecutionConfiguration().getRepository();
            String carteObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(this.getClass().getName(), LoggingObjectType.CARTE, null);
            servletLoggingObject.setContainerObjectId(carteObjectId);
            servletLoggingObject.setLogLevel(jobExecutionConfiguration.getLogLevel());
            Job job = new Job(repository, jobMeta, (LoggingObjectInterface)servletLoggingObject);
            job.initializeVariablesFrom(null);
            job.getJobMeta().setInternalKettleVariables(job);
            job.injectVariables(jobConfiguration.getJobExecutionConfiguration().getVariables());
            job.setArguments(jobExecutionConfiguration.getArgumentStrings());
            job.copyParametersFrom(jobMeta);
            job.clearParameters();
            String[] parameterNames = job.listParameters();
            for (int idx = 0; idx < parameterNames.length; ++idx) {
                String thisValue = jobExecutionConfiguration.getParams().get(parameterNames[idx]);
                if (Utils.isEmpty((CharSequence)thisValue)) continue;
                jobMeta.setParameterValue(parameterNames[idx], thisValue);
            }
            jobMeta.activateParameters();
            job.setSocketRepository(CarteSingleton.getInstance().getSocketRepository());
            CarteSingleton.getInstance().getJobMap().addJob(job.getJobname(), carteObjectId, job, jobConfiguration);
            if (repository != null) {
                job.addJobListener(new JobAdapter(){

                    @Override
                    public void jobFinished(Job job) {
                        repository.disconnect();
                    }
                });
            }
            return this.getJobStatus(carteObjectId);
        }
        catch (KettleException e) {
            e.printStackTrace();
            return null;
        }
    }
}

