/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.transexecutor;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.DelegationListener;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.TransStepUtil;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorData;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorParameters;

public class TransExecutor
extends BaseStep
implements StepInterface {
    private static final Class<?> PKG = TransExecutorMeta.class;
    private TransExecutorMeta meta;
    private TransExecutorData data;

    public TransExecutor(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            this.meta = (TransExecutorMeta)smi;
            this.setData((TransExecutorData)sdi);
            TransExecutorData transExecutorData = this.getData();
            Object[] row = this.getRow();
            if (row == null) {
                this.executeTransformation(null);
                this.setOutputDone();
                return false;
            }
            ArrayList<String> incomingFieldValues = new ArrayList<String>();
            if (this.getInputRowMeta() != null) {
                for (int i = 0; i < this.getInputRowMeta().size(); ++i) {
                    String fieldvalue = this.getInputRowMeta().getString(row, i);
                    incomingFieldValues.add(fieldvalue);
                }
            }
            if (this.first) {
                this.first = false;
                this.initOnFirstProcessingIteration();
            }
            RowSet executorStepOutputRowSet = transExecutorData.getExecutorStepOutputRowSet();
            if (transExecutorData.getExecutorStepOutputRowMeta() != null && executorStepOutputRowSet != null) {
                this.putRowTo(transExecutorData.getExecutorStepOutputRowMeta(), row, executorStepOutputRowSet);
            }
            if (transExecutorData.groupSize < 0) {
                long now;
                if (transExecutorData.groupFieldIndex >= 0) {
                    Object groupFieldData = row[transExecutorData.groupFieldIndex];
                    if (transExecutorData.prevGroupFieldData != null && transExecutorData.groupFieldMeta.compare(transExecutorData.prevGroupFieldData, groupFieldData) != 0) {
                        this.executeTransformation(incomingFieldValues);
                    }
                    transExecutorData.prevGroupFieldData = groupFieldData;
                } else if (transExecutorData.groupTime > 0 && (now = System.currentTimeMillis()) - transExecutorData.groupTimeStart >= (long)transExecutorData.groupTime) {
                    this.executeTransformation(incomingFieldValues);
                }
            }
            transExecutorData.groupBuffer.add(new RowMetaAndData(this.getInputRowMeta(), row));
            if (transExecutorData.groupSize > 0 && transExecutorData.groupBuffer.size() >= transExecutorData.groupSize) {
                this.executeTransformation(incomingFieldValues);
            }
            return true;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.UnexpectedError", (String[])new String[0]), (Throwable)e);
        }
    }

    private void initOnFirstProcessingIteration() throws KettleException {
        TransExecutorData transExecutorData = this.getData();
        transExecutorData.setInputRowMeta(this.getInputRowMeta());
        transExecutorData.setExecutionResultsOutputRowMeta((RowMetaInterface)new RowMeta());
        if (this.meta.getExecutionResultTargetStepMeta() != null) {
            this.meta.prepareExecutionResultsFields(transExecutorData.getExecutionResultsOutputRowMeta(), this.meta.getExecutionResultTargetStepMeta());
            transExecutorData.setExecutionResultRowSet(this.findOutputRowSet(this.meta.getExecutionResultTargetStepMeta().getName()));
        }
        transExecutorData.setResultFilesOutputRowMeta((RowMetaInterface)new RowMeta());
        if (this.meta.getResultFilesTargetStepMeta() != null) {
            this.meta.prepareExecutionResultsFileFields(transExecutorData.getResultFilesOutputRowMeta(), this.meta.getResultFilesTargetStepMeta());
            transExecutorData.setResultFilesRowSet(this.findOutputRowSet(this.meta.getResultFilesTargetStepMeta().getName()));
        }
        transExecutorData.setResultRowsOutputRowMeta((RowMetaInterface)new RowMeta());
        if (this.meta.getOutputRowsSourceStepMeta() != null) {
            this.meta.prepareResultsRowsFields(transExecutorData.getResultRowsOutputRowMeta());
            transExecutorData.setResultRowsRowSet(this.findOutputRowSet(this.meta.getOutputRowsSourceStepMeta().getName()));
        }
        if (this.meta.getExecutorsOutputStepMeta() != null) {
            transExecutorData.setExecutorStepOutputRowMeta(this.getInputRowMeta().clone());
            transExecutorData.setExecutorStepOutputRowSet(this.findOutputRowSet(this.meta.getExecutorsOutputStepMeta().getName()));
        }
        transExecutorData.groupFieldIndex = -1;
        if (!Utils.isEmpty((CharSequence)transExecutorData.groupField)) {
            transExecutorData.groupFieldIndex = this.getInputRowMeta().indexOfValue(transExecutorData.groupField);
            if (transExecutorData.groupFieldIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.Exception.GroupFieldNotFound", (String[])new String[]{transExecutorData.groupField}));
            }
            transExecutorData.groupFieldMeta = this.getInputRowMeta().getValueMeta(transExecutorData.groupFieldIndex);
        }
    }

    private void executeTransformation(List<String> incomingFieldValues) throws KettleException {
        TransExecutorData transExecutorData = this.getData();
        if (transExecutorData.groupBuffer.isEmpty()) {
            return;
        }
        transExecutorData.groupTimeStart = System.currentTimeMillis();
        if (this.first) {
            this.discardLogLines(transExecutorData);
        }
        Trans executorTrans = this.createInternalTrans();
        transExecutorData.setExecutorTrans(executorTrans);
        this.passParametersToTrans(incomingFieldValues);
        this.getTrans().addActiveSubTransformation(this.getStepname(), executorTrans);
        Result result = new Result();
        result.setRows(transExecutorData.groupBuffer);
        executorTrans.setPreviousResult(result);
        try {
            executorTrans.prepareExecution(this.getTrans().getArguments());
            executorTrans.startThreads();
            for (DelegationListener delegationListener : this.getTrans().getDelegationListeners()) {
                delegationListener.transformationDelegationStarted(executorTrans, new TransExecutionConfiguration());
            }
            executorTrans.waitUntilFinished();
            result = executorTrans.getResult();
        }
        catch (KettleException e) {
            this.log.logError("An error occurred executing the transformation: ", (Throwable)e);
            result.setResult(false);
            result.setNrErrors(1L);
        }
        if (result.isSafeStop()) {
            this.getTrans().safeStop();
        } else if (result.getNrErrors() > 0L) {
            this.getTrans().stopAll();
        }
        this.collectTransResults(result);
        this.collectExecutionResults(result);
        this.collectExecutionResultFiles(result);
        transExecutorData.groupBuffer.clear();
    }

    @VisibleForTesting
    void discardLogLines(TransExecutorData transExecutorData) {
        Trans executorTrans = transExecutorData.getExecutorTrans();
        if (executorTrans != null) {
            KettleLogStore.discardLines((String)executorTrans.getLogChannelId(), (boolean)false);
            LoggingRegistry.getInstance().removeIncludingChildren(executorTrans.getLogChannelId());
        }
    }

    @VisibleForTesting
    Trans createInternalTrans() throws KettleException {
        Trans executorTrans = new Trans(this.getData().getExecutorTransMeta(), this);
        executorTrans.setParentTrans(this.getTrans());
        executorTrans.setRepository(this.getTrans().getRepository());
        executorTrans.setLogLevel(this.getLogLevel());
        executorTrans.setArguments(this.getTrans().getArguments());
        executorTrans.setInternalKettleVariables(this);
        executorTrans.setPreview(this.getTrans().isPreview());
        TransStepUtil.initServletConfig(this.getTrans(), executorTrans);
        return executorTrans;
    }

    @VisibleForTesting
    void passParametersToTrans(List<String> incomingFieldValues) throws KettleException {
        if (incomingFieldValues == null) {
            incomingFieldValues = new ArrayList<String>();
        }
        TransExecutorParameters parameters = this.meta.getParameters();
        LinkedHashMap<String, String> resolvingValuesMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            resolvingValuesMap.put(parameters.getVariable()[i], null);
        }
        List<Object> fieldsToUse = new ArrayList();
        if (parameters.getField() != null) {
            fieldsToUse = Arrays.asList(parameters.getField());
        }
        List<Object> incomingFields = new ArrayList();
        if (this.data.getInputRowMeta() != null) {
            incomingFields = Arrays.asList(this.data.getInputRowMeta().getFieldNames());
        }
        List<String> staticInputs = Arrays.asList(parameters.getInput());
        for (int i = 0; i < fieldsToUse.size(); ++i) {
            try {
                String value = null;
                if (incomingFields.contains(fieldsToUse.get(i)) && (value = incomingFieldValues.get(incomingFields.indexOf(fieldsToUse.get(i)))) != null) {
                    resolvingValuesMap.put((String)resolvingValuesMap.keySet().toArray()[i], value);
                    continue;
                }
                resolvingValuesMap.put((String)resolvingValuesMap.keySet().toArray()[i], staticInputs.get(i));
                continue;
            }
            catch (Exception e) {
                resolvingValuesMap.put((String)resolvingValuesMap.keySet().toArray()[i], null);
            }
        }
        String[] inputFieldValues = new String[parameters.getVariable().length];
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            inputFieldValues[i] = (String)resolvingValuesMap.get(parameters.getVariable()[i]);
        }
        Trans trans = this.getExecutorTrans();
        StepWithMappingMeta.activateParams(trans, trans, this, trans.listParameters(), parameters.getVariable(), inputFieldValues);
    }

    @VisibleForTesting
    void collectTransResults(Result result) throws KettleException {
        RowSet transResultsRowSet = this.getData().getResultRowsRowSet();
        if (this.meta.getOutputRowsSourceStepMeta() != null && transResultsRowSet != null) {
            for (RowMetaAndData metaAndData : result.getRows()) {
                this.putRowTo(metaAndData.getRowMeta(), metaAndData.getData(), transResultsRowSet);
            }
        }
    }

    @VisibleForTesting
    void collectExecutionResults(Result result) throws KettleException {
        RowSet executionResultsRowSet = this.getData().getExecutionResultRowSet();
        if (this.meta.getExecutionResultTargetStepMeta() != null && executionResultsRowSet != null) {
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.getData().getExecutionResultsOutputRowMeta().size());
            int idx = 0;
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionTimeField())) {
                outputRow[idx++] = System.currentTimeMillis() - this.getData().groupTimeStart;
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionResultField())) {
                outputRow[idx++] = result.getResult();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionNrErrorsField())) {
                outputRow[idx++] = result.getNrErrors();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesReadField())) {
                outputRow[idx++] = result.getNrLinesRead();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesWrittenField())) {
                outputRow[idx++] = result.getNrLinesWritten();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesInputField())) {
                outputRow[idx++] = result.getNrLinesInput();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesOutputField())) {
                outputRow[idx++] = result.getNrLinesOutput();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesRejectedField())) {
                outputRow[idx++] = result.getNrLinesRejected();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesUpdatedField())) {
                outputRow[idx++] = result.getNrLinesUpdated();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLinesDeletedField())) {
                outputRow[idx++] = result.getNrLinesDeleted();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionFilesRetrievedField())) {
                outputRow[idx++] = result.getNrFilesRetrieved();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionExitStatusField())) {
                outputRow[idx++] = (long)result.getExitStatus();
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLogTextField())) {
                String channelId = this.getData().getExecutorTrans().getLogChannelId();
                String logText = KettleLogStore.getAppender().getBuffer(channelId, false).toString();
                outputRow[idx++] = logText;
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getExecutionLogChannelIdField())) {
                outputRow[idx++] = this.getData().getExecutorTrans().getLogChannelId();
            }
            this.putRowTo(this.getData().getExecutionResultsOutputRowMeta(), outputRow, executionResultsRowSet);
        }
    }

    @VisibleForTesting
    void collectExecutionResultFiles(Result result) throws KettleException {
        RowSet resultFilesRowSet = this.getData().getResultFilesRowSet();
        if (this.meta.getResultFilesTargetStepMeta() != null && result.getResultFilesList() != null && resultFilesRowSet != null) {
            for (ResultFile resultFile : result.getResultFilesList()) {
                Object[] targetRow = RowDataUtil.allocateRowData((int)this.getData().getResultFilesOutputRowMeta().size());
                int idx = 0;
                targetRow[idx++] = resultFile.getFile().getName().toString();
                this.putRowTo(this.getData().getResultFilesOutputRowMeta(), targetRow, resultFilesRowSet);
            }
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TransExecutorMeta)smi;
        this.setData((TransExecutorData)sdi);
        TransExecutorData transExecutorData = this.getData();
        if (super.init(smi, sdi)) {
            try {
                this.meta.setRepository(this.getTransMeta().getRepository());
                transExecutorData.setExecutorTransMeta(this.loadExecutorTransMeta());
                if (transExecutorData.getExecutorTransMeta() != null) {
                    transExecutorData.groupBuffer = new ArrayList<RowMetaAndData>();
                    transExecutorData.groupSize = !Utils.isEmpty((CharSequence)this.meta.getGroupSize()) ? Const.toInt((String)this.environmentSubstitute(this.meta.getGroupSize()), (int)-1) : -1;
                    transExecutorData.groupTime = !Utils.isEmpty((CharSequence)this.meta.getGroupTime()) ? Const.toInt((String)this.environmentSubstitute(this.meta.getGroupTime()), (int)-1) : -1;
                    transExecutorData.groupTimeStart = System.currentTimeMillis();
                    if (!Utils.isEmpty((CharSequence)this.meta.getGroupField())) {
                        transExecutorData.groupField = this.environmentSubstitute(this.meta.getGroupField());
                    }
                    return true;
                }
                this.logError("No valid transformation was specified nor loaded!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the transformation executor because of an error : ", e);
            }
        }
        return false;
    }

    @VisibleForTesting
    TransMeta loadExecutorTransMeta() throws KettleException {
        return TransExecutorMeta.loadMappingMeta(this.meta, this.meta.getRepository(), this.meta.getMetaStore(), this, this.meta.getParameters().isInheritingAllVariables());
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        TransExecutorData transExecutorData = this.getData();
        transExecutorData.groupBuffer = null;
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.getData().getExecutorTrans() != null) {
            this.getData().getExecutorTrans().stopAll();
        }
    }

    @Override
    public void stopAll() {
        if (this.getData().getExecutorTrans() != null) {
            this.getData().getExecutorTrans().stopAll();
        }
        super.stopAll();
    }

    public Trans getExecutorTrans() {
        return this.getData().getExecutorTrans();
    }

    @VisibleForTesting
    TransExecutorData getData() {
        return this.data;
    }

    private void setData(TransExecutorData data) {
        this.data = data;
    }
}

