/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileinput.text;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.common.CsvInputAwareMeta;
import org.pentaho.di.trans.steps.file.BaseFileField;
import org.pentaho.di.trans.steps.file.BaseFileInputAdditionalField;
import org.pentaho.di.trans.steps.file.BaseFileInputFiles;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileFilter;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInput;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputData;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="TextFileInput.Injection.", groups={"FILENAME_LINES", "FIELDS", "FILTERS"})
public class TextFileInputMeta
extends BaseFileInputMeta<BaseFileInputAdditionalField, BaseFileInputFiles, BaseFileField>
implements StepMetaInterface,
ResolvableResource,
CsvInputAwareMeta {
    private static Class<?> PKG = TextFileInputMeta.class;
    private static final String STRING_BASE64_PREFIX = "Base64: ";
    public static final int FILE_FORMAT_DOS = 0;
    public static final int FILE_FORMAT_UNIX = 1;
    public static final int FILE_FORMAT_MIXED = 2;
    public static final int FILE_TYPE_CSV = 0;
    public static final int FILE_TYPE_FIXED = 1;
    @InjectionDeep
    public Content content = new Content();
    @InjectionDeep
    private TextFileFilter[] filter = new TextFileFilter[0];
    @Injection(name="ERROR_COUNT_FIELD")
    public String errorCountField;
    @Injection(name="ERROR_FIELDS_FIELD")
    public String errorFieldsField;
    @Injection(name="ERROR_TEXT_FIELD")
    public String errorTextField;
    @Injection(name="ERROR_LINES_SKIPPED")
    public boolean errorLineSkipped;
    private StepMeta acceptingStep;

    public TextFileInputMeta() {
        this.additionalOutputFields = new BaseFileInputAdditionalField();
        this.inputFiles = new BaseFileInputFiles();
        this.inputFields = new BaseFileField[0];
    }

    public String[] getFileName() {
        return this.inputFiles.fileName;
    }

    public void setFileName(String[] fileName) {
        this.inputFiles.fileName = fileName;
    }

    public TextFileFilter[] getFilter() {
        return this.filter;
    }

    public void setFilter(TextFileFilter[] filter) {
        this.filter = filter;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            Node fnode;
            int i;
            this.inputFiles.acceptingFilenames = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"accept_filenames"));
            this.inputFiles.passingThruFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"passing_through_fields"));
            this.inputFiles.acceptingField = XMLHandler.getTagValue((Node)stepnode, (String)"accept_field");
            this.inputFiles.acceptingStepName = XMLHandler.getTagValue((Node)stepnode, (String)"accept_stepname");
            this.content.separator = XMLHandler.getTagValue((Node)stepnode, (String)"separator");
            this.content.enclosure = XMLHandler.getTagValue((Node)stepnode, (String)"enclosure");
            this.content.breakInEnclosureAllowed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"enclosure_breaks"));
            this.content.escapeCharacter = XMLHandler.getTagValue((Node)stepnode, (String)"escapechar");
            this.content.header = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"header"));
            this.content.nrHeaderLines = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"nr_headerlines"), (int)1);
            this.content.footer = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"footer"));
            this.content.nrFooterLines = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"nr_footerlines"), (int)1);
            this.content.lineWrapped = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"line_wrapped"));
            this.content.nrWraps = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"nr_wraps"), (int)1);
            this.content.layoutPaged = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"layout_paged"));
            this.content.nrLinesPerPage = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"nr_lines_per_page"), (int)1);
            this.content.nrLinesDocHeader = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"nr_lines_doc_header"), (int)1);
            String addToResult = XMLHandler.getTagValue((Node)stepnode, (String)"add_to_result_filenames");
            this.inputFiles.isaddresult = Utils.isEmpty((CharSequence)addToResult) ? true : "Y".equalsIgnoreCase(addToResult);
            String nempty = XMLHandler.getTagValue((Node)stepnode, (String)"noempty");
            this.content.noEmptyLines = "Y".equalsIgnoreCase(nempty) || nempty == null;
            this.content.includeFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.content.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.content.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.content.rowNumberByFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownumByFile"));
            this.content.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.content.fileFormat = XMLHandler.getTagValue((Node)stepnode, (String)"format");
            this.content.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.content.length = XMLHandler.getTagValue((Node)stepnode, (String)"length");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            Node filtersNode = XMLHandler.getSubNode((Node)stepnode, (String)"filters");
            int nrfiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            int nrfilters = XMLHandler.countNodes((Node)filtersNode, (String)"filter");
            this.allocate(nrfiles, nrfields, nrfilters);
            for (i = 0; i < nrfiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.inputFiles.fileName[i] = this.loadSource(filenode, filenamenode, i, metaStore);
                this.inputFiles.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.inputFiles.excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.inputFiles.fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
                this.inputFiles.includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            this.content.fileType = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"type");
            this.content.fileCompression = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"compression");
            if (this.content.fileCompression == null) {
                this.content.fileCompression = "None";
                if ("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"zipped"))) {
                    this.content.fileCompression = "Zip";
                }
            }
            if (XMLHandler.getTagValue((Node)stepnode, (String)"filter") != null) {
                this.filter = new TextFileFilter[1];
                this.filter[0] = new TextFileFilter();
                this.filter[0].setFilterPosition(Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"filter_position"), (int)-1));
                this.filter[0].setFilterString(XMLHandler.getTagValue((Node)stepnode, (String)"filter_string"));
                this.filter[0].setFilterLastLine("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"filter_is_last_line")));
                this.filter[0].setFilterPositive("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"filter_is_positive")));
            } else {
                for (i = 0; i < nrfilters; ++i) {
                    fnode = XMLHandler.getSubNodeByNr((Node)filtersNode, (String)"filter", (int)i);
                    this.filter[i] = new TextFileFilter();
                    this.filter[i].setFilterPosition(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"filter_position"), (int)-1));
                    String filterString = XMLHandler.getTagValue((Node)fnode, (String)"filter_string");
                    if (filterString != null && filterString.startsWith(STRING_BASE64_PREFIX)) {
                        this.filter[i].setFilterString(new String(Base64.decodeBase64((byte[])filterString.substring(STRING_BASE64_PREFIX.length()).getBytes())));
                    } else {
                        this.filter[i].setFilterString(filterString);
                    }
                    this.filter[i].setFilterLastLine("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"filter_is_last_line")));
                    this.filter[i].setFilterPositive("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"filter_is_positive")));
                }
            }
            for (i = 0; i < nrfields; ++i) {
                fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                BaseFileField field = new BaseFileField();
                field.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                field.setType(ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
                field.setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                field.setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                field.setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                field.setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
                field.setNullString(XMLHandler.getTagValue((Node)fnode, (String)"nullif"));
                field.setIfNullValue(XMLHandler.getTagValue((Node)fnode, (String)"ifnull"));
                field.setPosition(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"position"), (int)-1));
                field.setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                field.setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                field.setTrimType(ValueMetaString.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
                field.setRepeated("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"repeat")));
                this.inputFields[i] = field;
            }
            this.content.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            this.errorHandling.errorIgnored = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"error_ignored"));
            this.errorHandling.skipBadFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"skip_bad_files"));
            this.errorHandling.fileErrorField = XMLHandler.getTagValue((Node)stepnode, (String)"file_error_field");
            this.errorHandling.fileErrorMessageField = XMLHandler.getTagValue((Node)stepnode, (String)"file_error_message_field");
            this.errorLineSkipped = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"error_line_skipped"));
            this.errorCountField = XMLHandler.getTagValue((Node)stepnode, (String)"error_count_field");
            this.errorFieldsField = XMLHandler.getTagValue((Node)stepnode, (String)"error_fields_field");
            this.errorTextField = XMLHandler.getTagValue((Node)stepnode, (String)"error_text_field");
            this.errorHandling.warningFilesDestinationDirectory = XMLHandler.getTagValue((Node)stepnode, (String)"bad_line_files_destination_directory");
            this.errorHandling.warningFilesExtension = XMLHandler.getTagValue((Node)stepnode, (String)"bad_line_files_extension");
            this.errorHandling.errorFilesDestinationDirectory = XMLHandler.getTagValue((Node)stepnode, (String)"error_line_files_destination_directory");
            this.errorHandling.errorFilesExtension = XMLHandler.getTagValue((Node)stepnode, (String)"error_line_files_extension");
            this.errorHandling.lineNumberFilesDestinationDirectory = XMLHandler.getTagValue((Node)stepnode, (String)"line_number_files_destination_directory");
            this.errorHandling.lineNumberFilesExtension = XMLHandler.getTagValue((Node)stepnode, (String)"line_number_files_extension");
            this.content.dateFormatLenient = !"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"date_format_lenient"));
            String dateLocale = XMLHandler.getTagValue((Node)stepnode, (String)"date_format_locale");
            this.content.dateFormatLocale = dateLocale != null ? EnvUtil.createLocale((String)dateLocale) : Locale.getDefault();
            this.additionalOutputFields.shortFilenameField = XMLHandler.getTagValue((Node)stepnode, (String)"shortFileFieldName");
            this.additionalOutputFields.pathField = XMLHandler.getTagValue((Node)stepnode, (String)"pathFieldName");
            this.additionalOutputFields.hiddenField = XMLHandler.getTagValue((Node)stepnode, (String)"hiddenFieldName");
            this.additionalOutputFields.lastModificationField = XMLHandler.getTagValue((Node)stepnode, (String)"lastModificationTimeFieldName");
            this.additionalOutputFields.uriField = XMLHandler.getTagValue((Node)stepnode, (String)"uriNameFieldName");
            this.additionalOutputFields.rootUriField = XMLHandler.getTagValue((Node)stepnode, (String)"rootUriNameFieldName");
            this.additionalOutputFields.extensionField = XMLHandler.getTagValue((Node)stepnode, (String)"extensionFieldName");
            this.additionalOutputFields.sizeField = XMLHandler.getTagValue((Node)stepnode, (String)"sizeFieldName");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public Object clone() {
        int i;
        TextFileInputMeta retval = (TextFileInputMeta)super.clone();
        retval.inputFiles = (BaseFileInputFiles)this.inputFiles.clone();
        retval.inputFields = new BaseFileField[this.inputFields.length];
        for (i = 0; i < this.inputFields.length; ++i) {
            retval.inputFields[i] = (BaseFileField)this.inputFields[i].clone();
        }
        retval.filter = new TextFileFilter[this.filter.length];
        for (i = 0; i < this.filter.length; ++i) {
            retval.filter[i] = (TextFileFilter)this.filter[i].clone();
        }
        return retval;
    }

    public void allocate(int nrfiles, int nrfields, int nrfilters) {
        this.allocateFiles(nrfiles);
        this.inputFields = new BaseFileField[nrfields];
        this.filter = new TextFileFilter[nrfilters];
    }

    public void allocateFiles(int nrFiles) {
        this.inputFiles.fileName = new String[nrFiles];
        this.inputFiles.fileMask = new String[nrFiles];
        this.inputFiles.excludeFileMask = new String[nrFiles];
        this.inputFiles.fileRequired = new String[nrFiles];
        this.inputFiles.includeSubFolders = new String[nrFiles];
    }

    @Override
    public void setDefault() {
        int i;
        this.additionalOutputFields.shortFilenameField = null;
        this.additionalOutputFields.pathField = null;
        this.additionalOutputFields.hiddenField = null;
        this.additionalOutputFields.lastModificationField = null;
        this.additionalOutputFields.uriField = null;
        this.additionalOutputFields.rootUriField = null;
        this.additionalOutputFields.extensionField = null;
        this.additionalOutputFields.sizeField = null;
        this.inputFiles.isaddresult = true;
        this.content.separator = ";";
        this.content.enclosure = "\"";
        this.content.breakInEnclosureAllowed = false;
        this.content.header = true;
        this.content.nrHeaderLines = 1;
        this.content.footer = false;
        this.content.nrFooterLines = 1;
        this.content.lineWrapped = false;
        this.content.nrWraps = 1;
        this.content.layoutPaged = false;
        this.content.nrLinesPerPage = 80;
        this.content.nrLinesDocHeader = 0;
        this.content.fileCompression = "None";
        this.content.noEmptyLines = true;
        this.content.fileFormat = "DOS";
        this.content.fileType = "CSV";
        this.content.includeFilename = false;
        this.content.filenameField = "";
        this.content.includeRowNumber = false;
        this.content.rowNumberField = "";
        this.content.dateFormatLenient = true;
        this.content.rowNumberByFile = false;
        this.errorHandling.errorIgnored = false;
        this.errorHandling.skipBadFiles = false;
        this.errorLineSkipped = false;
        this.errorHandling.warningFilesDestinationDirectory = null;
        this.errorHandling.warningFilesExtension = "warning";
        this.errorHandling.errorFilesDestinationDirectory = null;
        this.errorHandling.errorFilesExtension = "error";
        this.errorHandling.lineNumberFilesDestinationDirectory = null;
        this.errorHandling.lineNumberFilesExtension = "line";
        int nrfiles = 0;
        int nrfields = 0;
        int nrfilters = 0;
        this.allocate(nrfiles, nrfields, nrfilters);
        for (i = 0; i < nrfiles; ++i) {
            this.inputFiles.fileName[i] = "filename" + (i + 1);
            this.inputFiles.fileMask[i] = "";
            this.inputFiles.excludeFileMask[i] = "";
            this.inputFiles.fileRequired[i] = "N";
            this.inputFiles.includeSubFolders[i] = "N";
        }
        for (i = 0; i < nrfields; ++i) {
            this.inputFields[i] = new BaseFileField("field" + (i + 1), 1, -1);
        }
        this.content.dateFormatLocale = Locale.getDefault();
        this.content.rowLimit = 0L;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (!this.inputFiles.passingThruFields) {
            row.clear();
        } else if (info != null) {
            boolean found = false;
            for (int i = 0; i < info.length && !found; ++i) {
                if (info[i] == null) continue;
                row.mergeRowMeta(info[i], name);
                found = true;
            }
        }
        for (int i = 0; i < this.inputFields.length; ++i) {
            BaseFileField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)field.getName(), (int)type);
                v.setLength(field.getLength());
                v.setPrecision(field.getPrecision());
                v.setOrigin(name);
                v.setConversionMask(field.getFormat());
                v.setDecimalSymbol(field.getDecimalSymbol());
                v.setGroupingSymbol(field.getGroupSymbol());
                v.setCurrencySymbol(field.getCurrencySymbol());
                v.setDateFormatLenient(this.content.dateFormatLenient);
                v.setDateFormatLocale(this.content.dateFormatLocale);
                v.setTrimType(field.getTrimType());
                row.addValueMeta(v);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.errorHandling.errorIgnored) {
            if (this.errorCountField != null && this.errorCountField.length() > 0) {
                ValueMetaInteger v = new ValueMetaInteger(this.errorCountField);
                v.setLength(10, 0);
                v.setOrigin(name);
                row.addValueMeta((ValueMetaInterface)v);
            }
            if (this.errorFieldsField != null && this.errorFieldsField.length() > 0) {
                ValueMetaString v = new ValueMetaString(this.errorFieldsField);
                v.setOrigin(name);
                row.addValueMeta((ValueMetaInterface)v);
            }
            if (this.errorTextField != null && this.errorTextField.length() > 0) {
                ValueMetaString v = new ValueMetaString(this.errorTextField);
                v.setOrigin(name);
                row.addValueMeta((ValueMetaInterface)v);
            }
        }
        if (this.content.includeFilename) {
            ValueMetaString v = new ValueMetaString(this.content.filenameField);
            v.setLength(100);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.content.includeRowNumber) {
            ValueMetaInteger v = new ValueMetaInteger(this.content.rowNumberField);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.shortFilenameField)) {
            ValueMetaString v = new ValueMetaString(space.environmentSubstitute(this.additionalOutputFields.shortFilenameField));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.extensionField)) {
            ValueMetaString v = new ValueMetaString(space.environmentSubstitute(this.additionalOutputFields.extensionField));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.pathField)) {
            ValueMetaString v = new ValueMetaString(space.environmentSubstitute(this.additionalOutputFields.pathField));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.sizeField)) {
            ValueMetaString v = new ValueMetaString(space.environmentSubstitute(this.additionalOutputFields.sizeField));
            v.setOrigin(name);
            v.setLength(9);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.hiddenField)) {
            ValueMetaBoolean v = new ValueMetaBoolean(space.environmentSubstitute(this.additionalOutputFields.hiddenField));
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.lastModificationField)) {
            ValueMetaDate v = new ValueMetaDate(space.environmentSubstitute(this.additionalOutputFields.lastModificationField));
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.uriField)) {
            ValueMetaString v = new ValueMetaString(space.environmentSubstitute(this.additionalOutputFields.uriField));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (StringUtils.isNotBlank((String)this.additionalOutputFields.rootUriField)) {
            ValueMetaString v = new ValueMetaString(this.additionalOutputFields.rootUriField);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    @Deprecated
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        this.getFields(inputRowMeta, name, info, nextStep, space, null, null);
    }

    @Override
    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder(1500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"accept_filenames", (boolean)this.inputFiles.acceptingFilenames));
        retval.append("    ").append(XMLHandler.addTagValue((String)"passing_through_fields", (boolean)this.inputFiles.passingThruFields));
        retval.append("    ").append(XMLHandler.addTagValue((String)"accept_field", (String)this.inputFiles.acceptingField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"accept_stepname", (String)(this.acceptingStep != null ? this.acceptingStep.getName() : "")));
        retval.append("    ").append(XMLHandler.addTagValue((String)"separator", (String)this.content.separator));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enclosure", (String)this.content.enclosure));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enclosure_breaks", (boolean)this.content.breakInEnclosureAllowed));
        retval.append("    ").append(XMLHandler.addTagValue((String)"escapechar", (String)this.content.escapeCharacter));
        retval.append("    ").append(XMLHandler.addTagValue((String)"header", (boolean)this.content.header));
        retval.append("    ").append(XMLHandler.addTagValue((String)"nr_headerlines", (int)this.content.nrHeaderLines));
        retval.append("    ").append(XMLHandler.addTagValue((String)"footer", (boolean)this.content.footer));
        retval.append("    ").append(XMLHandler.addTagValue((String)"nr_footerlines", (int)this.content.nrFooterLines));
        retval.append("    ").append(XMLHandler.addTagValue((String)"line_wrapped", (boolean)this.content.lineWrapped));
        retval.append("    ").append(XMLHandler.addTagValue((String)"nr_wraps", (int)this.content.nrWraps));
        retval.append("    ").append(XMLHandler.addTagValue((String)"layout_paged", (boolean)this.content.layoutPaged));
        retval.append("    ").append(XMLHandler.addTagValue((String)"nr_lines_per_page", (int)this.content.nrLinesPerPage));
        retval.append("    ").append(XMLHandler.addTagValue((String)"nr_lines_doc_header", (int)this.content.nrLinesDocHeader));
        retval.append("    ").append(XMLHandler.addTagValue((String)"noempty", (boolean)this.content.noEmptyLines));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include", (boolean)this.content.includeFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_field", (String)this.content.filenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.content.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownumByFile", (boolean)this.content.rowNumberByFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.content.rowNumberField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"format", (String)this.content.fileFormat));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.content.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"length", (String)this.content.length));
        retval.append("    " + XMLHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.inputFiles.isaddresult));
        retval.append("    <file>").append(Const.CR);
        this.inputFiles.normalizeAllocation(this.inputFiles.fileName.length);
        for (i = 0; i < this.inputFiles.fileName.length; ++i) {
            this.saveSource(retval, this.inputFiles.fileName[i]);
            this.parentStepMeta.getParentTransMeta().getNamedClusterEmbedManager().registerUrl(this.inputFiles.fileName[i]);
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)this.inputFiles.fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)this.inputFiles.excludeFileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.inputFiles.fileRequired[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (String)this.inputFiles.includeSubFolders[i]));
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"type", (String)this.content.fileType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compression", (String)(this.content.fileCompression == null ? "None" : this.content.fileCompression)));
        retval.append("    </file>").append(Const.CR);
        retval.append("    <filters>").append(Const.CR);
        for (i = 0; i < this.filter.length; ++i) {
            String filterString = this.filter[i].getFilterString();
            byte[] filterBytes = new byte[]{};
            String filterPrefix = "";
            if (filterString != null) {
                filterBytes = filterString.getBytes();
                filterPrefix = STRING_BASE64_PREFIX;
            }
            String filterEncoded = filterPrefix + new String(Base64.encodeBase64((byte[])filterBytes));
            retval.append("      <filter>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"filter_string", (String)filterEncoded, (boolean)false, (String[])new String[0]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"filter_position", (int)this.filter[i].getFilterPosition(), (boolean)false));
            retval.append("        ").append(XMLHandler.addTagValue((String)"filter_is_last_line", (boolean)this.filter[i].isFilterLastLine(), (boolean)false));
            retval.append("        ").append(XMLHandler.addTagValue((String)"filter_is_positive", (boolean)this.filter[i].isFilterPositive(), (boolean)false));
            retval.append("      </filter>").append(Const.CR);
        }
        retval.append("    </filters>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            BaseFileField field = this.inputFields[i];
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)field.getGroupSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"ifnull", (String)field.getIfNullValue()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"position", (int)field.getPosition()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)field.getTrimTypeCode()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"repeat", (boolean)field.isRepeated()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (long)this.content.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_ignored", (boolean)this.errorHandling.errorIgnored));
        retval.append("    ").append(XMLHandler.addTagValue((String)"skip_bad_files", (boolean)this.errorHandling.skipBadFiles));
        retval.append("    ").append(XMLHandler.addTagValue((String)"file_error_field", (String)this.errorHandling.fileErrorField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"file_error_message_field", (String)this.errorHandling.fileErrorMessageField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_line_skipped", (boolean)this.errorLineSkipped));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_count_field", (String)this.errorCountField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_fields_field", (String)this.errorFieldsField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_text_field", (String)this.errorTextField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"bad_line_files_destination_directory", (String)this.errorHandling.warningFilesDestinationDirectory));
        retval.append("    ").append(XMLHandler.addTagValue((String)"bad_line_files_extension", (String)this.errorHandling.warningFilesExtension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_line_files_destination_directory", (String)this.errorHandling.errorFilesDestinationDirectory));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_line_files_extension", (String)this.errorHandling.errorFilesExtension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"line_number_files_destination_directory", (String)this.errorHandling.lineNumberFilesDestinationDirectory));
        retval.append("    ").append(XMLHandler.addTagValue((String)"line_number_files_extension", (String)this.errorHandling.lineNumberFilesExtension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"date_format_lenient", (boolean)this.content.dateFormatLenient));
        retval.append("    ").append(XMLHandler.addTagValue((String)"date_format_locale", this.content.dateFormatLocale != null ? this.content.dateFormatLocale.toString() : null));
        retval.append("    ").append(XMLHandler.addTagValue((String)"shortFileFieldName", (String)this.additionalOutputFields.shortFilenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"pathFieldName", (String)this.additionalOutputFields.pathField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"hiddenFieldName", (String)this.additionalOutputFields.hiddenField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.additionalOutputFields.lastModificationField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"uriNameFieldName", (String)this.additionalOutputFields.uriField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rootUriNameFieldName", (String)this.additionalOutputFields.rootUriField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extensionFieldName", (String)this.additionalOutputFields.extensionField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sizeFieldName", (String)this.additionalOutputFields.sizeField));
        return retval.toString();
    }

    public String getLookupStepname() {
        if (this.inputFiles.acceptingFilenames && this.acceptingStep != null && !Utils.isEmpty((CharSequence)this.acceptingStep.getName())) {
            return this.acceptingStep.getName();
        }
        return null;
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.acceptingStep = StepMeta.findStep(steps, this.inputFiles.acceptingStepName);
    }

    public String[] getInfoSteps() {
        if (this.inputFiles.acceptingFilenames && this.acceptingStep != null) {
            return new String[]{this.acceptingStep.getName()};
        }
        return null;
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.inputFiles.acceptingFilenames = rep.getStepAttributeBoolean(id_step, "accept_filenames");
            this.inputFiles.passingThruFields = rep.getStepAttributeBoolean(id_step, "passing_through_fields");
            this.inputFiles.acceptingField = rep.getStepAttributeString(id_step, "accept_field");
            this.inputFiles.acceptingStepName = rep.getStepAttributeString(id_step, "accept_stepname");
            this.content.separator = rep.getStepAttributeString(id_step, "separator");
            this.content.enclosure = rep.getStepAttributeString(id_step, "enclosure");
            this.content.breakInEnclosureAllowed = rep.getStepAttributeBoolean(id_step, "enclosure_breaks");
            this.content.escapeCharacter = rep.getStepAttributeString(id_step, "escapechar");
            this.content.header = rep.getStepAttributeBoolean(id_step, "header");
            this.content.nrHeaderLines = (int)rep.getStepAttributeInteger(id_step, "nr_headerlines");
            this.content.footer = rep.getStepAttributeBoolean(id_step, "footer");
            this.content.nrFooterLines = (int)rep.getStepAttributeInteger(id_step, "nr_footerlines");
            this.content.lineWrapped = rep.getStepAttributeBoolean(id_step, "line_wrapped");
            this.content.nrWraps = (int)rep.getStepAttributeInteger(id_step, "nr_wraps");
            this.content.layoutPaged = rep.getStepAttributeBoolean(id_step, "layout_paged");
            this.content.nrLinesPerPage = (int)rep.getStepAttributeInteger(id_step, "nr_lines_per_page");
            this.content.nrLinesDocHeader = (int)rep.getStepAttributeInteger(id_step, "nr_lines_doc_header");
            this.content.noEmptyLines = rep.getStepAttributeBoolean(id_step, "noempty");
            this.content.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.content.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.content.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.content.rowNumberByFile = rep.getStepAttributeBoolean(id_step, "rownumByFile");
            this.content.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.content.fileFormat = rep.getStepAttributeString(id_step, "format");
            this.content.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.content.length = rep.getStepAttributeString(id_step, "length");
            String addToResult = rep.getStepAttributeString(id_step, "add_to_result_filenames");
            this.inputFiles.isaddresult = Utils.isEmpty((CharSequence)addToResult) ? true : rep.getStepAttributeBoolean(id_step, "add_to_result_filenames");
            this.content.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            int nrfiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            int nrfilters = rep.countNrStepAttributes(id_step, "filter_string");
            this.allocate(nrfiles, nrfields, nrfilters);
            for (i = 0; i < nrfiles; ++i) {
                this.inputFiles.fileName[i] = this.loadSourceRep(rep, id_step, i, metaStore);
                this.inputFiles.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                this.inputFiles.excludeFileMask[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                this.inputFiles.fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
                if (!"Y".equalsIgnoreCase(this.inputFiles.fileRequired[i])) {
                    this.inputFiles.fileRequired[i] = "N";
                }
                this.inputFiles.includeSubFolders[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
                if ("Y".equalsIgnoreCase(this.inputFiles.includeSubFolders[i])) continue;
                this.inputFiles.includeSubFolders[i] = "N";
            }
            this.content.fileType = rep.getStepAttributeString(id_step, "file_type");
            this.content.fileCompression = rep.getStepAttributeString(id_step, "compression");
            if (this.content.fileCompression == null) {
                this.content.fileCompression = "None";
                if (rep.getStepAttributeBoolean(id_step, "file_zipped")) {
                    this.content.fileCompression = "Zip";
                }
            }
            for (i = 0; i < nrfilters; ++i) {
                this.filter[i] = new TextFileFilter();
                this.filter[i].setFilterPosition((int)rep.getStepAttributeInteger(id_step, i, "filter_position"));
                this.filter[i].setFilterString(rep.getStepAttributeString(id_step, i, "filter_string"));
                this.filter[i].setFilterLastLine(rep.getStepAttributeBoolean(id_step, i, "filter_is_last_line"));
                this.filter[i].setFilterPositive(rep.getStepAttributeBoolean(id_step, i, "filter_is_positive"));
            }
            for (i = 0; i < nrfields; ++i) {
                BaseFileField field = new BaseFileField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setType(ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setNullString(rep.getStepAttributeString(id_step, i, "field_nullif"));
                field.setIfNullValue(rep.getStepAttributeString(id_step, i, "field_ifnull"));
                field.setPosition((int)rep.getStepAttributeInteger(id_step, i, "field_position"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(ValueMetaString.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
            this.errorHandling.errorIgnored = rep.getStepAttributeBoolean(id_step, "error_ignored");
            this.errorHandling.skipBadFiles = rep.getStepAttributeBoolean(id_step, "skip_bad_files");
            this.errorHandling.fileErrorField = rep.getStepAttributeString(id_step, "file_error_field");
            this.errorHandling.fileErrorMessageField = rep.getStepAttributeString(id_step, "file_error_message_field");
            this.errorLineSkipped = rep.getStepAttributeBoolean(id_step, "error_line_skipped");
            this.errorCountField = rep.getStepAttributeString(id_step, "error_count_field");
            this.errorFieldsField = rep.getStepAttributeString(id_step, "error_fields_field");
            this.errorTextField = rep.getStepAttributeString(id_step, "error_text_field");
            this.errorHandling.warningFilesDestinationDirectory = rep.getStepAttributeString(id_step, "bad_line_files_dest_dir");
            this.errorHandling.warningFilesExtension = rep.getStepAttributeString(id_step, "bad_line_files_ext");
            this.errorHandling.errorFilesDestinationDirectory = rep.getStepAttributeString(id_step, "error_line_files_dest_dir");
            this.errorHandling.errorFilesExtension = rep.getStepAttributeString(id_step, "error_line_files_ext");
            this.errorHandling.lineNumberFilesDestinationDirectory = rep.getStepAttributeString(id_step, "line_number_files_dest_dir");
            this.errorHandling.lineNumberFilesExtension = rep.getStepAttributeString(id_step, "line_number_files_ext");
            this.content.dateFormatLenient = rep.getStepAttributeBoolean(id_step, 0, "date_format_lenient", true);
            String dateLocale = rep.getStepAttributeString(id_step, 0, "date_format_locale");
            this.content.dateFormatLocale = dateLocale != null ? EnvUtil.createLocale((String)dateLocale) : Locale.getDefault();
            this.additionalOutputFields.shortFilenameField = rep.getStepAttributeString(id_step, "shortFileFieldName");
            this.additionalOutputFields.pathField = rep.getStepAttributeString(id_step, "pathFieldName");
            this.additionalOutputFields.hiddenField = rep.getStepAttributeString(id_step, "hiddenFieldName");
            this.additionalOutputFields.lastModificationField = rep.getStepAttributeString(id_step, "lastModificationTimeFieldName");
            this.additionalOutputFields.uriField = rep.getStepAttributeString(id_step, "uriNameFieldName");
            this.additionalOutputFields.rootUriField = rep.getStepAttributeString(id_step, "rootUriNameFieldName");
            this.additionalOutputFields.extensionField = rep.getStepAttributeString(id_step, "extensionFieldName");
            this.additionalOutputFields.sizeField = rep.getStepAttributeString(id_step, "sizeFieldName");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "accept_filenames", this.inputFiles.acceptingFilenames);
            rep.saveStepAttribute(id_transformation, id_step, "passing_through_fields", this.inputFiles.passingThruFields);
            rep.saveStepAttribute(id_transformation, id_step, "accept_field", this.inputFiles.acceptingField);
            rep.saveStepAttribute(id_transformation, id_step, "accept_stepname", this.acceptingStep != null ? this.acceptingStep.getName() : "");
            rep.saveStepAttribute(id_transformation, id_step, "separator", this.content.separator);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure", this.content.enclosure);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure_breaks", this.content.breakInEnclosureAllowed);
            rep.saveStepAttribute(id_transformation, id_step, "escapechar", this.content.escapeCharacter);
            rep.saveStepAttribute(id_transformation, id_step, "header", this.content.header);
            rep.saveStepAttribute(id_transformation, id_step, "nr_headerlines", this.content.nrHeaderLines);
            rep.saveStepAttribute(id_transformation, id_step, "footer", this.content.footer);
            rep.saveStepAttribute(id_transformation, id_step, "nr_footerlines", this.content.nrFooterLines);
            rep.saveStepAttribute(id_transformation, id_step, "line_wrapped", this.content.lineWrapped);
            rep.saveStepAttribute(id_transformation, id_step, "nr_wraps", this.content.nrWraps);
            rep.saveStepAttribute(id_transformation, id_step, "layout_paged", this.content.layoutPaged);
            rep.saveStepAttribute(id_transformation, id_step, "nr_lines_per_page", this.content.nrLinesPerPage);
            rep.saveStepAttribute(id_transformation, id_step, "nr_lines_doc_header", this.content.nrLinesDocHeader);
            rep.saveStepAttribute(id_transformation, id_step, "noempty", this.content.noEmptyLines);
            rep.saveStepAttribute(id_transformation, id_step, "include", this.content.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.content.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.content.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownumByFile", this.content.rowNumberByFile);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.content.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "format", this.content.fileFormat);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.content.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "length", this.content.length);
            rep.saveStepAttribute(id_transformation, id_step, "add_to_result_filenames", this.inputFiles.isaddresult);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.content.rowLimit);
            this.inputFiles.normalizeAllocation(this.inputFiles.fileName.length);
            for (i = 0; i < this.inputFiles.fileName.length; ++i) {
                this.saveSourceRep(rep, id_transformation, id_step, i, this.inputFiles.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.inputFiles.fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "exclude_file_mask", this.inputFiles.excludeFileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", this.inputFiles.fileRequired[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", this.inputFiles.includeSubFolders[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "file_type", this.content.fileType);
            rep.saveStepAttribute(id_transformation, id_step, "compression", this.content.fileCompression == null ? "None" : this.content.fileCompression);
            for (i = 0; i < this.filter.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "filter_position", this.filter[i].getFilterPosition());
                rep.saveStepAttribute(id_transformation, id_step, i, "filter_string", this.filter[i].getFilterString());
                rep.saveStepAttribute(id_transformation, id_step, i, "filter_is_last_line", this.filter[i].isFilterLastLine());
                rep.saveStepAttribute(id_transformation, id_step, i, "filter_is_positive", this.filter[i].isFilterPositive());
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                BaseFileField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_nullif", field.getNullString());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_ifnull", field.getIfNullValue());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_position", field.getPosition());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
            }
            rep.saveStepAttribute(id_transformation, id_step, "error_ignored", this.errorHandling.errorIgnored);
            rep.saveStepAttribute(id_transformation, id_step, "skip_bad_files", this.errorHandling.skipBadFiles);
            rep.saveStepAttribute(id_transformation, id_step, "file_error_field", this.errorHandling.fileErrorField);
            rep.saveStepAttribute(id_transformation, id_step, "file_error_message_field", this.errorHandling.fileErrorMessageField);
            rep.saveStepAttribute(id_transformation, id_step, "error_line_skipped", this.errorLineSkipped);
            rep.saveStepAttribute(id_transformation, id_step, "error_count_field", this.errorCountField);
            rep.saveStepAttribute(id_transformation, id_step, "error_fields_field", this.errorFieldsField);
            rep.saveStepAttribute(id_transformation, id_step, "error_text_field", this.errorTextField);
            rep.saveStepAttribute(id_transformation, id_step, "bad_line_files_dest_dir", this.errorHandling.warningFilesDestinationDirectory);
            rep.saveStepAttribute(id_transformation, id_step, "bad_line_files_ext", this.errorHandling.warningFilesExtension);
            rep.saveStepAttribute(id_transformation, id_step, "error_line_files_dest_dir", this.errorHandling.errorFilesDestinationDirectory);
            rep.saveStepAttribute(id_transformation, id_step, "error_line_files_ext", this.errorHandling.errorFilesExtension);
            rep.saveStepAttribute(id_transformation, id_step, "line_number_files_dest_dir", this.errorHandling.lineNumberFilesDestinationDirectory);
            rep.saveStepAttribute(id_transformation, id_step, "line_number_files_ext", this.errorHandling.lineNumberFilesExtension);
            rep.saveStepAttribute(id_transformation, id_step, "date_format_lenient", this.content.dateFormatLenient);
            rep.saveStepAttribute(id_transformation, id_step, "date_format_locale", this.content.dateFormatLocale != null ? this.content.dateFormatLocale.toString() : null);
            rep.saveStepAttribute(id_transformation, id_step, "shortFileFieldName", this.additionalOutputFields.shortFilenameField);
            rep.saveStepAttribute(id_transformation, id_step, "pathFieldName", this.additionalOutputFields.pathField);
            rep.saveStepAttribute(id_transformation, id_step, "hiddenFieldName", this.additionalOutputFields.hiddenField);
            rep.saveStepAttribute(id_transformation, id_step, "lastModificationTimeFieldName", this.additionalOutputFields.lastModificationField);
            rep.saveStepAttribute(id_transformation, id_step, "uriNameFieldName", this.additionalOutputFields.uriField);
            rep.saveStepAttribute(id_transformation, id_step, "rootUriNameFieldName", this.additionalOutputFields.rootUriField);
            rep.saveStepAttribute(id_transformation, id_step, "extensionFieldName", this.additionalOutputFields.extensionField);
            rep.saveStepAttribute(id_transformation, id_step, "sizeFieldName", this.additionalOutputFields.sizeField);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (input.length > 0) {
            if (!this.inputFiles.acceptingFilenames) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.AcceptFilenamesOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.NoInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        FileInputList textFileList = this.getFileInputList(transMeta);
        if (textFileList.nrOfFiles() == 0) {
            if (!this.inputFiles.acceptingFilenames) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.ExpectedFilesError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + textFileList.nrOfFiles()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TextFileInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TextFileInputData();
    }

    public String getErrorCountField() {
        return this.errorCountField;
    }

    public void setErrorCountField(String errorCountField) {
        this.errorCountField = errorCountField;
    }

    public String getErrorFieldsField() {
        return this.errorFieldsField;
    }

    public void setErrorFieldsField(String errorFieldsField) {
        this.errorFieldsField = errorFieldsField;
    }

    public String getErrorTextField() {
        return this.errorTextField;
    }

    public void setErrorTextField(String errorTextField) {
        this.errorTextField = errorTextField;
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public boolean isErrorLineSkipped() {
        return this.errorLineSkipped;
    }

    public void setErrorLineSkipped(boolean errorLineSkipped) {
        this.errorLineSkipped = errorLineSkipped;
    }

    public void setAcceptingStep(StepMeta acceptingStep) {
        this.acceptingStep = acceptingStep;
    }

    @Override
    public int getFileFormatTypeNr() {
        if (this.content.fileFormat.equalsIgnoreCase("DOS")) {
            return 0;
        }
        if (this.content.fileFormat.equalsIgnoreCase("unix")) {
            return 1;
        }
        return 2;
    }

    public int getFileTypeNr() {
        if (this.content.fileType.equalsIgnoreCase("CSV")) {
            return 0;
        }
        return 1;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!this.inputFiles.acceptingFilenames) {
                for (int i = 0; i < this.inputFiles.fileName.length; ++i) {
                    String fileName = this.inputFiles.fileName[i];
                    if (fileName == null || fileName.isEmpty()) continue;
                    FileObject fileObject = this.getFileObject(space.environmentSubstitute(fileName), space);
                    this.inputFiles.fileName[i] = resourceNamingInterface.nameResource(fileObject, space, Utils.isEmpty((CharSequence)this.inputFiles.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public boolean supportsErrorHandling() {
        return this.errorHandling.errorIgnored && this.errorHandling.skipBadFiles;
    }

    @VisibleForTesting
    public void setFileNameForTest(String[] fileName) {
        this.allocateFiles(fileName.length);
        this.setFileName(fileName);
    }

    protected String loadSource(Node filenode, Node filenamenode, int i, IMetaStore metaStore) {
        return XMLHandler.getNodeValue((Node)filenamenode);
    }

    protected void saveSource(StringBuilder retVal, String source) {
        retVal.append("      ").append(XMLHandler.addTagValue((String)"name", (String)source));
    }

    protected String loadSourceRep(Repository rep, ObjectId id_step, int i, IMetaStore metaStore) throws KettleException {
        return rep.getStepAttributeString(id_step, i, "file_name");
    }

    protected void saveSourceRep(Repository rep, ObjectId id_transformation, ObjectId id_step, int i, String fileName) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, i, "file_name", fileName);
    }

    @Override
    public String getEncoding() {
        return this.content.encoding;
    }

    public String getLength() {
        return this.content.length;
    }

    public void setLength(String length) {
        this.content.length = length;
    }

    @Override
    public boolean isAcceptingFilenames() {
        return this.inputFiles.acceptingFilenames;
    }

    @Override
    public String getAcceptingStepName() {
        return this.inputFiles.acceptingStepName;
    }

    public StepMeta getAcceptingStep() {
        return this.acceptingStep;
    }

    @Override
    public String getAcceptingField() {
        return this.inputFiles.acceptingField;
    }

    public String[] getFilePaths(VariableSpace space) {
        return FileInputList.createFilePathList((VariableSpace)space, (String[])this.inputFiles.fileName, (String[])this.inputFiles.fileMask, (String[])this.inputFiles.excludeFileMask, (String[])this.inputFiles.fileRequired, (boolean[])this.inputFiles.includeSubFolderBoolean());
    }

    public FileInputList getTextFileList(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.inputFiles.fileName, (String[])this.inputFiles.fileMask, (String[])this.inputFiles.excludeFileMask, (String[])this.inputFiles.fileRequired, (boolean[])this.inputFiles.includeSubFolderBoolean());
    }

    FileObject getFileObject(String vfsFileName, VariableSpace variableSpace) throws KettleFileException {
        return KettleVFS.getFileObject((String)variableSpace.environmentSubstitute(vfsFileName), (VariableSpace)variableSpace);
    }

    @Override
    public void resolve() {
        for (int i = 0; i < this.inputFiles.fileName.length; ++i) {
            if (this.inputFiles.fileName[i] == null || this.inputFiles.fileName[i].isEmpty()) continue;
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.inputFiles.fileName[i]));
                if (!AliasedFileObject.isAliasedFile((FileObject)fileObject)) continue;
                this.inputFiles.fileName[i] = ((AliasedFileObject)fileObject).getOriginalURIString();
                continue;
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean hasHeader() {
        return this.content == null ? false : this.content.header;
    }

    @Override
    public String getEscapeCharacter() {
        return this.content == null ? null : this.content.escapeCharacter;
    }

    @Override
    public String getDelimiter() {
        return this.content == null ? null : this.content.separator;
    }

    @Override
    public String getEnclosure() {
        return this.content == null ? null : this.content.enclosure;
    }

    @Override
    public FileObject getHeaderFileObject(TransMeta transMeta) {
        FileInputList fileList = this.getFileInputList(transMeta);
        return fileList.nrOfFiles() == 0 ? null : fileList.getFile(0);
    }

    public static class Content
    implements Cloneable {
        @Injection(name="FILE_TYPE")
        public String fileType;
        @Injection(name="SEPARATOR")
        public String separator;
        @Injection(name="ENCLOSURE")
        public String enclosure;
        @Injection(name="BREAK_IN_ENCLOSURE")
        public boolean breakInEnclosureAllowed;
        @Injection(name="ESCAPE_CHAR")
        public String escapeCharacter;
        @Injection(name="HEADER_PRESENT")
        public boolean header;
        @Injection(name="NR_HEADER_LINES")
        public int nrHeaderLines = -1;
        @Injection(name="HAS_FOOTER")
        public boolean footer;
        @Injection(name="NR_FOOTER_LINES")
        public int nrFooterLines = -1;
        @Injection(name="HAS_WRAPPED_LINES")
        public boolean lineWrapped;
        @Injection(name="NR_WRAPS")
        public int nrWraps = -1;
        @Injection(name="HAS_PAGED_LAYOUT")
        public boolean layoutPaged;
        @Injection(name="NR_LINES_PER_PAGE")
        public int nrLinesPerPage = -1;
        @Injection(name="NR_DOC_HEADER_LINES")
        public int nrLinesDocHeader = -1;
        @Injection(name="COMPRESSION_TYPE")
        public String fileCompression;
        @Injection(name="NO_EMPTY_LINES")
        public boolean noEmptyLines;
        @Injection(name="INCLUDE_FILENAME")
        public boolean includeFilename;
        @Injection(name="FILENAME_FIELD")
        public String filenameField;
        @Injection(name="INCLUDE_ROW_NUMBER")
        public boolean includeRowNumber;
        @Injection(name="ROW_NUMBER_FIELD")
        public String rowNumberField;
        @Injection(name="ROW_NUMBER_BY_FILE")
        public boolean rowNumberByFile;
        @Injection(name="FILE_FORMAT")
        public String fileFormat;
        @Injection(name="ENCODING")
        public String encoding;
        @Injection(name="ROW_LIMIT")
        public long rowLimit = -1L;
        @Injection(name="DATE_FORMAT_LENIENT")
        public boolean dateFormatLenient;
        public Locale dateFormatLocale;
        @Injection(name="LENGTH")
        public String length;

        @Injection(name="DATE_FORMAT_LOCALE")
        public void setDateFormatLocale(String locale) {
            this.dateFormatLocale = new Locale(locale);
        }
    }
}

