/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.email.IEmailService;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.Base64PasswordService;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.messages.Messages;

public class Emailer {
    private static final Log logger = LogFactory.getLog(Emailer.class);
    private static final String MAILER = "smtpsend";
    private static final String EMBEDDED_HTML = "mime-message/text/html";
    private Properties props = new Properties();
    private InputStream attachment = null;
    private String attachmentName = null;
    private String attachmentMimeType = null;
    private Authenticator authenticator = null;

    public void setTo(String to) {
        if (to != null && !"".equals(to)) {
            to = to.replaceAll(";", ",");
            this.props.put("to", to);
        }
    }

    public void setCc(String cc) {
        if (cc != null && !"".equals(cc)) {
            cc = cc.replaceAll(";", ",");
            this.props.put("cc", cc);
        }
    }

    public void setBcc(String bcc) {
        if (bcc != null && !"".equals(bcc)) {
            bcc = bcc.replaceAll(";", ",");
            this.props.put("bcc", bcc);
        }
    }

    public void setSubject(String subject) {
        this.props.put("subject", this.cleanEmailField(subject));
    }

    public String getSubject() {
        return this.props.getProperty("subject");
    }

    public void setFrom(String from) {
        this.props.put("mail.from.default", from);
    }

    public void setFromName(String fromName) {
        this.props.put("mail.from.name", fromName);
    }

    public void setUseAuthentication(boolean useAuthentication) {
        this.props.put("mail.smtp.auth", ObjectUtils.toString((Object)useAuthentication));
    }

    public void setSmtpHost(String smtpHost) {
        this.props.put("mail.smtp.host", smtpHost);
    }

    public void setSmtpPort(int port) {
        this.props.put("mail.smtp.port", ObjectUtils.toString((Object)port));
    }

    public void setTransportProtocol(String protocol) {
        this.props.put("mail.transport.protocol", protocol);
    }

    public void setUseSSL(boolean useSSL) {
        this.props.put("mail.smtp.ssl", ObjectUtils.toString((Object)useSSL));
    }

    public void setStartTLS(boolean startTLS) {
        this.props.put("mail.smtp.starttls.enable", ObjectUtils.toString((Object)startTLS));
    }

    public void setQuitWait(boolean quitWait) {
        this.props.put("mail.smtp.quitwait", ObjectUtils.toString((Object)quitWait));
    }

    public void setAttachment(InputStream attachment) {
        this.attachment = attachment;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentMimeType(String mimeType) {
        this.attachmentMimeType = mimeType;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setBody(String body) {
        this.props.put("body", body);
    }

    public String getEmailFromName() {
        return Messages.getInstance().getString("emailFromName");
    }

    public Properties getProperties() {
        return this.props;
    }

    public boolean setup() {
        try {
            final IEmailService service = PentahoSystem.get(IEmailService.class, "IEmailService", PentahoSessionHolder.getSession());
            this.props.put("mail.smtp.host", service.getEmailConfig().getSmtpHost());
            this.props.put("mail.smtp.port", ObjectUtils.toString((Object)service.getEmailConfig().getSmtpPort()));
            this.props.put("mail.transport.protocol", service.getEmailConfig().getSmtpProtocol());
            this.props.put("mail.smtp.starttls.enable", ObjectUtils.toString((Object)service.getEmailConfig().isUseStartTls()));
            this.props.put("mail.smtp.auth", ObjectUtils.toString((Object)service.getEmailConfig().isAuthenticate()));
            this.props.put("mail.smtp.ssl", ObjectUtils.toString((Object)service.getEmailConfig().isUseSsl()));
            this.props.put("mail.smtp.quitwait", ObjectUtils.toString((Object)service.getEmailConfig().isSmtpQuitWait()));
            this.props.put("mail.from.default", service.getEmailConfig().getDefaultFrom());
            String fromName = service.getEmailConfig().getFromName();
            if (StringUtils.isEmpty((String)fromName)) {
                fromName = this.getEmailFromName();
            }
            this.props.put("mail.from.name", fromName);
            this.props.put("mail.debug", ObjectUtils.toString((Object)service.getEmailConfig().isDebug()));
            if (service.getEmailConfig().isAuthenticate()) {
                this.props.put("mail.userid", service.getEmailConfig().getUserId());
                this.props.put("mail.password", service.getEmailConfig().getPassword());
                this.setAuthenticator(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        String decrypted;
                        try {
                            Base64PasswordService ps = new Base64PasswordService();
                            String pass = service.getEmailConfig().getPassword();
                            decrypted = pass.startsWith("ENC:") ? ps.decrypt(service.getEmailConfig().getPassword().substring(4, pass.length())) : ps.decrypt(service.getEmailConfig().getPassword());
                        }
                        catch (Exception e) {
                            decrypted = service.getEmailConfig().getPassword();
                        }
                        return new PasswordAuthentication(service.getEmailConfig().getUserId(), decrypted);
                    }
                });
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Email.ERROR_0013_CONFIG_FILE_INVALID", (Throwable)e);
            return false;
        }
    }

    private String cleanEmailField(String emailField) {
        if (emailField != null) {
            emailField = emailField.replaceAll("\r", "");
            return emailField.replaceAll("\n", "");
        }
        return null;
    }

    public boolean send() {
        String from = this.props.getProperty("mail.from.default");
        String fromName = this.props.getProperty("mail.from.name");
        String to = this.props.getProperty("to");
        String cc = this.props.getProperty("cc");
        String bcc = this.props.getProperty("bcc");
        boolean authenticate = "true".equalsIgnoreCase(this.props.getProperty("mail.smtp.auth"));
        String subject = this.props.getProperty("subject");
        String body = this.props.getProperty("body");
        logger.info((Object)("Going to send an email to " + to + " from " + from + " with the subject '" + subject + "' and the body " + body));
        try {
            MimeMessage msg;
            Session session = authenticate ? Session.getInstance((Properties)this.props, (Authenticator)this.authenticator) : Session.getInstance((Properties)this.props);
            if (!this.props.containsKey("mail.debug")) {
                session.setDebug(false);
            }
            if (EMBEDDED_HTML.equals(this.attachmentMimeType)) {
                msg = new MimeMessage(session, this.attachment);
                if (body != null) {
                    MimeMultipart oldMultipart = (MimeMultipart)msg.getContent();
                    MimeMultipart newMultipart = new MimeMultipart("related");
                    for (int i = 0; i < oldMultipart.getCount(); ++i) {
                        BodyPart bodyPart = oldMultipart.getBodyPart(i);
                        Object content = bodyPart.getContent();
                        if (content instanceof String) {
                            String newContent = body + "<br/><br/>" + content;
                            MimeBodyPart part = new MimeBodyPart();
                            part.setText(newContent, "UTF-8", "html");
                            newMultipart.addBodyPart((BodyPart)part);
                            continue;
                        }
                        newMultipart.addBodyPart(bodyPart);
                    }
                    msg.setContent((Multipart)newMultipart);
                }
            } else {
                msg = new MimeMessage(session);
                MimeMultipart multipart = new MimeMultipart();
                if (this.attachment == null) {
                    logger.error((Object)"Email.ERROR_0015_ATTACHMENT_FAILED");
                    return false;
                }
                ByteArrayDataSource dataSource = new ByteArrayDataSource(this.attachment, this.attachmentMimeType);
                if (body != null) {
                    MimeBodyPart bodyMessagePart = new MimeBodyPart();
                    bodyMessagePart.setText(body, LocaleHelper.getSystemEncoding());
                    multipart.addBodyPart((BodyPart)bodyMessagePart);
                }
                MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                attachmentBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                attachmentBodyPart.setFileName(MimeUtility.encodeText((String)this.attachmentName, (String)"UTF-8", null));
                multipart.addBodyPart((BodyPart)attachmentBodyPart);
                msg.setContent((Multipart)multipart);
            }
            if (from != null) {
                msg.setFrom((Address)new InternetAddress(from, fromName));
            } else {
                logger.error((Object)"Email.ERROR_0012_FROM_NOT_DEFINED");
            }
            if (to != null && to.trim().length() > 0) {
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
            }
            if (cc != null && cc.trim().length() > 0) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc, (boolean)false));
            }
            if (bcc != null && bcc.trim().length() > 0) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc, (boolean)false));
            }
            if (subject != null) {
                msg.setSubject(subject, LocaleHelper.getSystemEncoding());
            }
            msg.setHeader("X-Mailer", MAILER);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            return true;
        }
        catch (SendFailedException e) {
            logger.error((Object)("Email.ERROR_0011_SEND_FAILED -" + to), (Throwable)e);
        }
        catch (AuthenticationFailedException e) {
            logger.error((Object)("Email.ERROR_0014_AUTHENTICATION_FAILED - " + to), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error((Object)("Email.ERROR_0011_SEND_FAILED - " + to), e);
        }
        return false;
    }
}

