/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.net.Address;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RSGroupInfo {
    public static final String DEFAULT_GROUP = "default";
    public static final String NAMESPACE_DESC_PROP_GROUP = "hbase.rsgroup.name";
    private final String name;
    private final SortedSet<Address> servers;
    private final SortedSet<TableName> tables;

    public RSGroupInfo(String name) {
        this(name, new TreeSet<Address>(), new TreeSet<TableName>());
    }

    RSGroupInfo(String name, SortedSet<Address> servers, SortedSet<TableName> tables) {
        this.name = name;
        this.servers = servers == null ? new TreeSet() : servers;
        this.servers.addAll(servers);
        this.tables = new TreeSet<TableName>(tables);
    }

    public RSGroupInfo(RSGroupInfo src) {
        this(src.getName(), src.servers, src.tables);
    }

    public String getName() {
        return this.name;
    }

    public void addServer(Address hostPort) {
        this.servers.add(hostPort);
    }

    public void addAllServers(Collection<Address> hostPort) {
        this.servers.addAll(hostPort);
    }

    public boolean containsServer(Address hostPort) {
        return this.servers.contains(hostPort);
    }

    public Set<Address> getServers() {
        return this.servers;
    }

    public boolean removeServer(Address hostPort) {
        return this.servers.remove(hostPort);
    }

    public SortedSet<TableName> getTables() {
        return this.tables;
    }

    public void addTable(TableName table) {
        this.tables.add(table);
    }

    public void addAllTables(Collection<TableName> arg) {
        this.tables.addAll(arg);
    }

    public boolean containsTable(TableName table) {
        return this.tables.contains(table);
    }

    public boolean removeTable(TableName table) {
        return this.tables.remove(table);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Name:");
        sb.append(this.name);
        sb.append(", ");
        sb.append(" Servers:");
        sb.append(this.servers);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RSGroupInfo RSGroupInfo2 = (RSGroupInfo)o;
        if (!this.name.equals(RSGroupInfo2.name)) {
            return false;
        }
        if (!this.servers.equals(RSGroupInfo2.servers)) {
            return false;
        }
        return this.tables.equals(RSGroupInfo2.tables);
    }

    public int hashCode() {
        int result = this.servers.hashCode();
        result = 31 * result + this.tables.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

