/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.dependency;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.util.WritableUtils;

public class CoordUnResolvedInputDependency
implements Writable {
    private boolean isResolved;
    private List<String> dependency = new ArrayList<String>();
    private List<String> resolvedList = new ArrayList<String>();

    public CoordUnResolvedInputDependency(List<String> dependency) {
        this.dependency = dependency;
    }

    public CoordUnResolvedInputDependency() {
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setResolved(boolean isResolved) {
        this.isResolved = isResolved;
    }

    public List<String> getDependencies() {
        return this.dependency;
    }

    public List<String> getResolvedList() {
        return this.resolvedList;
    }

    public void setResolvedList(List<String> resolvedList) {
        this.resolvedList = resolvedList;
    }

    public void addResolvedList(List<String> resolvedList) {
        this.resolvedList.addAll(resolvedList);
    }

    public String getUnResolvedList() {
        if (!this.isResolved) {
            return StringUtils.join(this.dependency, (String)"#");
        }
        return "";
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isResolved);
        WritableUtils.writeStringList(out, this.dependency);
        WritableUtils.writeStringList(out, this.resolvedList);
    }

    public void readFields(DataInput in) throws IOException {
        this.isResolved = in.readBoolean();
        this.dependency = WritableUtils.readStringList(in);
        this.resolvedList = WritableUtils.readStringList(in);
    }
}

