/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.example;

import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.query.example.AliasedSelection;
import org.pentaho.metadata.query.model.Order;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdvancedQueryXmlHelper
extends QueryXmlHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addSelectionFromXmlNode(Query query, Element selectionElement) {
        NodeList nodes;
        String view = null;
        String column = null;
        String alias = null;
        String formula = null;
        NodeList viewnodes = selectionElement.getElementsByTagName("view");
        if (viewnodes.getLength() > 0 && (view = XMLHandler.getNodeValue((Node)viewnodes.item(0))) != null && view.trim().length() == 0) {
            view = null;
        }
        if ((nodes = selectionElement.getElementsByTagName("column")).getLength() > 0 && (column = XMLHandler.getNodeValue((Node)nodes.item(0))) != null && column.trim().length() == 0) {
            column = null;
        }
        if ((nodes = selectionElement.getElementsByTagName("alias")).getLength() > 0 && (alias = XMLHandler.getNodeValue((Node)nodes.item(0))) != null && alias.trim().length() == 0) {
            alias = null;
        }
        if ((nodes = selectionElement.getElementsByTagName("formula")).getLength() > 0 && (formula = XMLHandler.getNodeValue((Node)nodes.item(0))) != null && formula.trim().length() == 0) {
            formula = null;
        }
        if (view != null && column != null) {
            Category category = query.getLogicalModel().findCategory(view);
            LogicalColumn businessColumn = category.findLogicalColumn(column);
            if (businessColumn == null) throw new RuntimeException("Failed to find business column '" + column + "' in model.");
            query.getSelections().add(new AliasedSelection(category, businessColumn, null, alias));
            return;
        }
        if (formula == null) throw new RuntimeException("Failed to parse selection, no column or formula provided");
        try {
            query.getSelections().add(new AliasedSelection(formula));
            return;
        }
        catch (PentahoMetadataException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void addSelectionToDocument(Document doc, Selection selection, Element selectionElement) {
        AliasedSelection aliasedSelection = (AliasedSelection)selection;
        Category view = selection.getCategory();
        LogicalColumn column = selection.getLogicalColumn();
        Element element = null;
        if (view != null && column != null) {
            element = doc.createElement("view");
            element.appendChild(doc.createTextNode(view.getId()));
            selectionElement.appendChild(element);
            element = doc.createElement("column");
            element.appendChild(doc.createTextNode(column.getId()));
            selectionElement.appendChild(element);
            if (aliasedSelection.getAlias() != null) {
                element = doc.createElement("alias");
                element.appendChild(doc.createTextNode(aliasedSelection.getAlias()));
                selectionElement.appendChild(element);
            }
        } else if (aliasedSelection.getFormula() != null) {
            element = doc.createElement("formula");
            element.appendChild(doc.createTextNode(aliasedSelection.getFormula()));
            selectionElement.appendChild(element);
        }
    }

    @Override
    protected void addOrderByFromXmlNode(Query query, Element orderElement) throws PentahoMetadataException {
        boolean ascending = true;
        String view = null;
        String column = null;
        String formula = null;
        String alias = null;
        NodeList nodes = orderElement.getElementsByTagName("direction");
        if (nodes.getLength() > 0) {
            ascending = XMLHandler.getNodeValue((Node)nodes.item(0)).equals("asc");
        }
        if ((nodes = orderElement.getElementsByTagName("view")).getLength() > 0) {
            view = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if ((nodes = orderElement.getElementsByTagName("column")).getLength() > 0) {
            column = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if ((nodes = orderElement.getElementsByTagName("alias")).getLength() > 0) {
            alias = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if ((nodes = orderElement.getElementsByTagName("formula")).getLength() > 0) {
            formula = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if (view != null && column != null) {
            Category category = query.getLogicalModel().findCategory(view);
            if (category == null) {
                throw new PentahoMetadataException(Messages.getErrorString("QueryXmlHelper.ERROR_0015_BUSINESS_CATEGORY_NOT_FOUND", view));
            }
            LogicalColumn businessColumn = category.findLogicalColumn(column);
            if (businessColumn == null) {
                throw new PentahoMetadataException(Messages.getErrorString("QueryXmlHelper.ERROR_0013_BUSINESS_COL_NOT_FOUND", category.getId(), column));
            }
            query.getOrders().add(new Order(new AliasedSelection(category, businessColumn, null, alias), ascending ? Order.Type.ASC : Order.Type.DESC));
        } else if (formula != null) {
            query.getOrders().add(new Order(new AliasedSelection(formula), ascending ? Order.Type.ASC : Order.Type.DESC));
        } else {
            throw new PentahoMetadataException("no column or formula specified");
        }
    }

    @Override
    protected void addOrderByToDocument(Document doc, Order orderBy, Element orderElement) {
        Element element = doc.createElement("direction");
        element.appendChild(doc.createTextNode(orderBy.getType().toString().toLowerCase()));
        orderElement.appendChild(element);
        AliasedSelection selection = (AliasedSelection)orderBy.getSelection();
        if (!selection.hasFormula()) {
            element = doc.createElement("view");
            element.appendChild(doc.createTextNode(selection.getCategory().getId()));
            orderElement.appendChild(element);
            element = doc.createElement("column");
            element.appendChild(doc.createTextNode(selection.getLogicalColumn().getId()));
            orderElement.appendChild(element);
            if (selection.getAlias() != null) {
                orderElement.appendChild(element);
                element = doc.createElement("alias");
                element.appendChild(doc.createTextNode(selection.getAlias()));
                orderElement.appendChild(element);
            }
        } else {
            orderElement.appendChild(element);
            element = doc.createElement("formula");
            element.appendChild(doc.createTextNode(selection.getFormula()));
            orderElement.appendChild(element);
        }
    }
}

