/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public abstract class IfExprTimestampScalarColumnBase
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int arg1Column;
    private int arg3Column;
    private Timestamp arg2Scalar;
    private int outputColumn;

    public IfExprTimestampScalarColumnBase(int arg1Column, Timestamp arg2Scalar, int arg3Column, int outputColumn) {
        this.arg1Column = arg1Column;
        this.arg2Scalar = arg2Scalar;
        this.arg3Column = arg3Column;
        this.outputColumn = outputColumn;
    }

    public IfExprTimestampScalarColumnBase() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        TimestampColumnVector arg3ColVector = (TimestampColumnVector)batch.cols[this.arg3Column];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = arg3ColVector.noNulls;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        if (arg1ColVector.isRepeating) {
            if (vector1[0] == 1L) {
                outputColVector.fill(this.arg2Scalar);
            } else {
                arg3ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            }
            return;
        }
        arg3ColVector.flatten(batch.selectedInUse, sel, n);
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i;
                    outputColVector.set(i, vector1[i = sel[j]] == 1L ? this.arg2Scalar : arg3ColVector.asScratchTimestamp(i));
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputColVector.set(i, vector1[i] == 1L ? this.arg2Scalar : arg3ColVector.asScratchTimestamp(i));
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i;
                outputColVector.set(i, !arg1ColVector.isNull[i = sel[j]] && vector1[i] == 1L ? this.arg2Scalar : arg3ColVector.asScratchTimestamp(i));
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? false : arg3ColVector.isNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputColVector.set(i, !arg1ColVector.isNull[i] && vector1[i] == 1L ? this.arg2Scalar : arg3ColVector.asScratchTimestamp(i));
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? false : arg3ColVector.isNull[i];
            }
        }
        arg3ColVector.unFlatten();
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "timestamp";
    }
}

