/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.scriptvalues_mod;

import java.io.InputStream;
import java.util.Hashtable;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScriptValuesHelp {
    private static Document dom;
    private static Hashtable<String, String> hatFunctionsList;

    public ScriptValuesHelp(String strFileName) throws KettleXMLException {
        ScriptValuesHelp.xparseXmlFile(strFileName);
        ScriptValuesHelp.buildFunctionList();
    }

    public Hashtable<String, String> getFunctionList() {
        return hatFunctionsList;
    }

    private static void buildFunctionList() {
        hatFunctionsList = new Hashtable();
        NodeList nlFunctions = dom.getElementsByTagName("jsFunction");
        for (int i = 0; i < nlFunctions.getLength(); ++i) {
            String strFunctionName = nlFunctions.item(i).getAttributes().getNamedItem("name").getNodeValue();
            Node elType = ((Element)nlFunctions.item(i)).getElementsByTagName("type").item(0);
            String strType = "";
            if (elType.hasChildNodes()) {
                strType = elType.getFirstChild().getNodeValue();
            }
            NodeList nlFunctionArgs = ((Element)nlFunctions.item(i)).getElementsByTagName("argument");
            for (int j = 0; j < nlFunctionArgs.getLength(); ++j) {
                String strFunctionArgs = nlFunctionArgs.item(j).getFirstChild().getNodeValue();
                hatFunctionsList.put(strFunctionName + "(" + strFunctionArgs + ")", strType);
            }
            if (nlFunctionArgs.getLength() != 0) continue;
            hatFunctionsList.put(strFunctionName + "()", strType);
        }
    }

    public String getSample(String strFunctionName, String strFunctionNameWithArgs) {
        String sRC = "// Sorry, no Script available for " + strFunctionNameWithArgs;
        NodeList nl = dom.getElementsByTagName("jsFunction");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node elSample;
            if (!nl.item(i).getAttributes().getNamedItem("name").getNodeValue().equals(strFunctionName) || !(elSample = ((Element)nl.item(i)).getElementsByTagName("sample").item(0)).hasChildNodes()) continue;
            return elSample.getFirstChild().getNodeValue();
        }
        return sRC;
    }

    private static void xparseXmlFile(String strFileName) throws KettleXMLException {
        try {
            int c;
            InputStream is = ScriptValuesHelp.class.getResourceAsStream(strFileName);
            StringBuilder buffer = new StringBuilder();
            while ((c = is.read()) != -1) {
                buffer.append((char)c);
            }
            is.close();
            dom = XMLHandler.loadXMLString((String)buffer.toString());
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read script values help file from file [" + strFileName + "]", (Throwable)e);
        }
    }
}

