/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspectiveImageProvider;
import org.pentaho.di.ui.spoon.SpoonPerspectiveListener;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.di.ui.util.ImageUtil;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.impl.DefaultXulOverlay;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.xul.swt.tab.TabItem;
import org.pentaho.xul.swt.tab.TabSet;

public class MainSpoonPerspective
implements SpoonPerspectiveImageProvider {
    public static final String ID = "001-spoon-jobs";
    private Composite ui;
    private List<SpoonPerspectiveListener> listeners = new ArrayList<SpoonPerspectiveListener>();
    private TabSet tabfolder;
    private static final Class<?> PKG = Spoon.class;

    public MainSpoonPerspective(Composite ui, TabSet tabfolder) {
        this.ui = ui;
        this.tabfolder = tabfolder;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDisplayName(Locale l) {
        return BaseMessages.getString(PKG, (String)"Spoon.Perspectives.DI", (String[])new String[0]);
    }

    @Override
    public InputStream getPerspectiveIcon() {
        return ImageUtil.getImageInputStream(Display.getCurrent(), "ui/images/transformation.png");
    }

    @Override
    public String getPerspectiveIconPath() {
        return "ui/images/transformation.svg";
    }

    @Override
    public Composite getUI() {
        return this.ui;
    }

    @Override
    public void setActive(boolean active) {
        for (SpoonPerspectiveListener l : this.listeners) {
            if (active) {
                l.onActivation();
                Spoon.getInstance().enableMenus();
                continue;
            }
            l.onDeactication();
        }
    }

    @Override
    public List<XulEventHandler> getEventHandlers() {
        return null;
    }

    @Override
    public List<XulOverlay> getOverlays() {
        return Collections.singletonList(new DefaultXulOverlay("ui/main_perspective_overlay.xul"));
    }

    @Override
    public void addPerspectiveListener(SpoonPerspectiveListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public EngineMetaInterface getActiveMeta() {
        if (this.tabfolder == null) {
            return null;
        }
        TabItem tabItem = this.tabfolder.getSelected();
        if (tabItem == null) {
            return null;
        }
        TabMapEntry mapEntry = ((Spoon)SpoonFactory.getInstance()).delegates.tabs.getTab(this.tabfolder.getSelected());
        EngineMetaInterface meta = null;
        if (mapEntry != null) {
            if (mapEntry.getObject() instanceof TransGraph) {
                meta = mapEntry.getObject().getMeta();
            }
            if (mapEntry.getObject() instanceof JobGraph) {
                meta = mapEntry.getObject().getMeta();
            }
        }
        return meta;
    }

    void setTabset(TabSet tabs) {
        this.tabfolder = tabs;
    }
}

