/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.undo.TransAction;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterConditionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.GetCaretPositionInterface;
import org.pentaho.di.ui.core.widget.InsertTextInterface;
import org.pentaho.di.ui.core.widget.OsHelper;
import org.pentaho.di.ui.core.widget.PasswordTextVar;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.core.widget.TextVarButton;

public class TableView
extends Composite {
    private static Class<?> PKG = TableView.class;
    private Composite parent;
    private ColumnInfo[] columns;
    private int rows;
    private boolean readonly;
    private int buttonRownr;
    private int buttonColnr;
    private String buttonContent;
    private boolean previousShift;
    private int selectionStart;
    public Table table;
    private TableEditor editor;
    private TableColumn[] tablecolumn;
    private PropsUI props;
    private Control text;
    private Composite combo;
    private Button button;
    private TableItem activeTableItem;
    private int activeTableColumn;
    private int activeTableRow;
    private KeyListener lsKeyText;
    private KeyListener lsKeyCombo;
    private FocusAdapter lsFocusText;
    private FocusAdapter lsFocusCombo;
    private ModifyListener lsModCombo;
    private TraverseListener lsTraverse;
    private Listener lsFocusInTabItem;
    private int sortfield;
    private int sortfieldLast;
    private boolean sortingDescending;
    private Boolean sortingDescendingLast;
    private boolean sortable;
    private int lastRowCount;
    private boolean fieldChanged;
    private Menu mRow;
    private ModifyListener lsMod;
    private ModifyListener lsUndo;
    private ModifyListener lsContent;
    private Clipboard clipboard;
    private static Image dummyImage;
    private static GC dummyGC;
    private Font gridFont;
    private ArrayList<TransAction> undo;
    private int undoPosition;
    private String[] beforeEdit;
    private MenuItem miEditUndo;
    private MenuItem miEditRedo;
    private static final String CLIPBOARD_DELIMITER = "\t";
    private Condition condition;
    private Color defaultBackgroundColor;
    private Map<String, Color> usedColors;
    private ColumnInfo numberColumn;
    protected int textWidgetCaretPosition;
    private VariableSpace variables;
    private boolean showingBlueNullValues;
    private boolean showingConversionErrorsInline;
    private boolean isTextButton = false;
    private boolean addIndexColumn = true;
    private TableViewModifyListener tableViewModifyListener = new TableViewModifyListener(){

        @Override
        public void moveRow(int position1, int position2) {
        }

        @Override
        public void insertRow(int rowIndex) {
        }

        @Override
        public void cellFocusLost(int rowIndex) {
        }

        @Override
        public void delete(int[] items) {
        }
    };
    private List<Integer> nonEmptyIndexes;

    public TableView(VariableSpace space, Composite parent, int style, ColumnInfo[] columnInfo, int nrRows, ModifyListener lsm, PropsUI pr) {
        this(space, parent, style, columnInfo, nrRows, false, lsm, pr);
    }

    public TableView(VariableSpace space, Composite parent, int style, ColumnInfo[] columnInfo, int nrRows, boolean readOnly, ModifyListener lsm, PropsUI pr) {
        this(space, parent, style, columnInfo, nrRows, readOnly, lsm, pr, true);
    }

    public TableView(VariableSpace space, Composite parent, int style, ColumnInfo[] columnInfo, int nrRows, boolean readOnly, ModifyListener lsm, PropsUI pr, boolean addIndexColumn) {
        this(space, parent, style, columnInfo, nrRows, readOnly, lsm, pr, addIndexColumn, null);
    }

    public TableView(VariableSpace space, Composite parent, int style, ColumnInfo[] columnInfo, int nrRows, boolean readOnly, ModifyListener lsm, PropsUI pr, boolean addIndexColumn, Listener lsnr) {
        super(parent, 0x6C0000);
        this.parent = parent;
        this.columns = columnInfo;
        this.rows = nrRows;
        this.props = pr;
        this.readonly = readOnly;
        this.clipboard = null;
        this.variables = space;
        this.addIndexColumn = addIndexColumn;
        this.lsFocusInTabItem = lsnr;
        this.sortfield = 0;
        this.sortfieldLast = -1;
        this.sortingDescending = false;
        this.sortingDescendingLast = null;
        this.sortable = true;
        this.selectionStart = -1;
        this.previousShift = false;
        this.usedColors = new Hashtable<String, Color>();
        this.condition = null;
        this.lsMod = lsm;
        this.clearUndo();
        this.numberColumn = new ColumnInfo("#", 1, true, true);
        ValueMetaNumber numberColumnValueMeta = new ValueMetaNumber("#");
        numberColumnValueMeta.setConversionMask("####0.###");
        this.numberColumn.setValueMeta((ValueMetaInterface)numberColumnValueMeta);
        this.lsUndo = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                TableView.this.fieldChanged = true;
            }
        };
        if (dummyGC == null) {
            Display disp = parent.getDisplay();
            dummyImage = new Image((Device)disp, 1, 1);
            dummyGC = new GC((Drawable)dummyImage);
            this.gridFont = new Font((Device)disp, this.props.getGridFont());
            dummyGC.setFont(this.gridFont);
        }
        FormLayout controlLayout = new FormLayout();
        controlLayout.marginLeft = 0;
        controlLayout.marginRight = 0;
        controlLayout.marginTop = 0;
        controlLayout.marginBottom = 0;
        this.setLayout((Layout)controlLayout);
        this.table = new Table((Composite)this, style | 2);
        this.props.setLook((Control)this.table, 2);
        this.table.setLinesVisible(true);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(0, 0);
        fdTable.right = new FormAttachment(100, 0);
        fdTable.top = new FormAttachment(0, 0);
        fdTable.bottom = new FormAttachment(100, 0);
        this.table.setLayoutData((Object)fdTable);
        this.tablecolumn = new TableColumn[this.columns.length + 1];
        this.tablecolumn[0] = new TableColumn(this.table, 131072);
        this.tablecolumn[0].setResizable(true);
        this.tablecolumn[0].setText("#");
        this.tablecolumn[0].setWidth(addIndexColumn ? 25 : 0);
        this.tablecolumn[0].setAlignment(131072);
        for (int i = 0; i < this.columns.length; ++i) {
            ValueMetaInterface valueMeta;
            int allignment = this.columns[i].getAllignement();
            this.tablecolumn[i + 1] = new TableColumn(this.table, allignment);
            this.tablecolumn[i + 1].setResizable(true);
            if (this.columns[i].getName() != null) {
                this.tablecolumn[i + 1].setText(this.columns[i].getName());
            }
            if (this.columns[i].getToolTip() != null) {
                this.tablecolumn[i + 1].setToolTipText(this.columns[i].getToolTip());
            }
            if ((valueMeta = this.columns[i].getValueMeta()) != null && valueMeta.isNumeric()) {
                this.tablecolumn[i + 1].setAlignment(131072);
            }
            this.tablecolumn[i + 1].pack();
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        if (this.rows > 0) {
            this.table.setItemCount(this.rows);
        } else {
            this.table.setItemCount(1);
        }
        this.defaultBackgroundColor = this.table.getItem(0).getBackground();
        this.setRowNums();
        this.table.setSortColumn(this.table.getColumn(this.sortfield));
        this.table.setSortDirection(this.sortingDescending ? 1024 : 128);
        this.editor = new TableEditor(this.table);
        this.editor.grabHorizontal = true;
        this.editor.grabVertical = true;
        this.mRow = new Menu((Control)this.table);
        MenuItem miRowInsBef = new MenuItem(this.mRow, 0);
        miRowInsBef.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.InsertBeforeRow", (String[])new String[0])));
        MenuItem miRowInsAft = new MenuItem(this.mRow, 0);
        miRowInsAft.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.InsertAfterRow", (String[])new String[0])));
        new MenuItem(this.mRow, 2);
        MenuItem miRowUp = new MenuItem(this.mRow, 0);
        miRowUp.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.MoveUp", (String[])new String[0])));
        MenuItem miRowDown = new MenuItem(this.mRow, 0);
        miRowDown.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.MoveDown", (String[])new String[0])));
        MenuItem miCol1 = new MenuItem(this.mRow, 0);
        miCol1.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.OptimalSizeWithHeader", (String[])new String[0])));
        MenuItem miCol2 = new MenuItem(this.mRow, 0);
        miCol2.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.OptimalSizeWithoutHeader", (String[])new String[0])));
        new MenuItem(this.mRow, 2);
        MenuItem miClear = new MenuItem(this.mRow, 0);
        miClear.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.ClearAll", (String[])new String[0])));
        new MenuItem(this.mRow, 2);
        MenuItem miSelAll = new MenuItem(this.mRow, 0);
        miSelAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.SelectAll", (String[])new String[0])));
        MenuItem miUnselAll = new MenuItem(this.mRow, 0);
        miUnselAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.ClearSelection", (String[])new String[0])));
        MenuItem miFilter = new MenuItem(this.mRow, 0);
        miFilter.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.FilteredSelection", (String[])new String[0])));
        new MenuItem(this.mRow, 2);
        MenuItem miClipAll = new MenuItem(this.mRow, 0);
        miClipAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.CopyToClipboard", (String[])new String[0])));
        MenuItem miPasteAll = new MenuItem(this.mRow, 0);
        miPasteAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.PasteFromClipboard", (String[])new String[0])));
        MenuItem miCutAll = new MenuItem(this.mRow, 0);
        miCutAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.CutSelected", (String[])new String[0])));
        MenuItem miDelAll = new MenuItem(this.mRow, 0);
        miDelAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.DeleteSelected", (String[])new String[0])));
        MenuItem miKeep = new MenuItem(this.mRow, 0);
        miKeep.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.KeepSelected", (String[])new String[0])));
        new MenuItem(this.mRow, 2);
        MenuItem miCopyToAll = new MenuItem(this.mRow, 0);
        miCopyToAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.CopyFieldToAllRows", (String[])new String[0])));
        new MenuItem(this.mRow, 2);
        this.miEditUndo = new MenuItem(this.mRow, 0);
        this.miEditRedo = new MenuItem(this.mRow, 0);
        this.setUndoMenu();
        if (this.readonly) {
            miRowInsBef.setEnabled(false);
            miRowInsAft.setEnabled(false);
            miRowUp.setEnabled(false);
            miRowDown.setEnabled(false);
            miClear.setEnabled(false);
            miCopyToAll.setEnabled(false);
            miPasteAll.setEnabled(false);
            miDelAll.setEnabled(false);
            miCutAll.setEnabled(false);
            miKeep.setEnabled(false);
        }
        SelectionAdapter lsRowInsBef = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.insertRowBefore();
            }
        };
        SelectionAdapter lsRowInsAft = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.insertRowAfter();
            }
        };
        SelectionAdapter lsCol1 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.optWidth(true);
            }
        };
        SelectionAdapter lsCol2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.optWidth(false);
            }
        };
        SelectionAdapter lsRowUp = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.moveRows(-1);
            }
        };
        SelectionAdapter lsRowDown = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.moveRows(1);
            }
        };
        SelectionAdapter lsClear = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.clearAll(true);
            }
        };
        SelectionAdapter lsClipAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.clipSelected();
            }
        };
        SelectionAdapter lsCopyToAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.copyToAll();
            }
        };
        SelectionAdapter lsSelAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.selectAll();
            }
        };
        SelectionAdapter lsUnselAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.unselectAll();
            }
        };
        SelectionAdapter lsPasteAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.pasteSelected();
            }
        };
        SelectionAdapter lsCutAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.cutSelected();
            }
        };
        SelectionAdapter lsDelAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.delSelected();
            }
        };
        SelectionAdapter lsKeep = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.keepSelected();
            }
        };
        SelectionAdapter lsFilter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.setFilter();
            }
        };
        SelectionAdapter lsEditUndo = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.undoAction();
            }
        };
        SelectionAdapter lsEditRedo = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.redoAction();
            }
        };
        miRowInsBef.addSelectionListener((SelectionListener)lsRowInsBef);
        miRowInsAft.addSelectionListener((SelectionListener)lsRowInsAft);
        miCol1.addSelectionListener((SelectionListener)lsCol1);
        miCol2.addSelectionListener((SelectionListener)lsCol2);
        miRowUp.addSelectionListener((SelectionListener)lsRowUp);
        miRowDown.addSelectionListener((SelectionListener)lsRowDown);
        miClear.addSelectionListener((SelectionListener)lsClear);
        miClipAll.addSelectionListener((SelectionListener)lsClipAll);
        miCopyToAll.addSelectionListener((SelectionListener)lsCopyToAll);
        miSelAll.addSelectionListener((SelectionListener)lsSelAll);
        miUnselAll.addSelectionListener((SelectionListener)lsUnselAll);
        miPasteAll.addSelectionListener((SelectionListener)lsPasteAll);
        miCutAll.addSelectionListener((SelectionListener)lsCutAll);
        miDelAll.addSelectionListener((SelectionListener)lsDelAll);
        miKeep.addSelectionListener((SelectionListener)lsKeep);
        miFilter.addSelectionListener((SelectionListener)lsFilter);
        this.miEditUndo.addSelectionListener((SelectionListener)lsEditUndo);
        this.miEditRedo.addSelectionListener((SelectionListener)lsEditRedo);
        this.table.setMenu(this.mRow);
        this.lsFocusText = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (this.isWrongLostFocusEvent()) {
                    return;
                }
                final Display d = Display.getCurrent();
                if (TableView.this.table.isDisposed()) {
                    return;
                }
                final TableItem row = TableView.this.activeTableItem;
                if (row == null) {
                    return;
                }
                final int colnr = TableView.this.activeTableColumn;
                final int rownr = TableView.this.table.indexOf(row);
                final Control ftext = TableView.this.text;
                final String[] fBeforeEdit = TableView.this.beforeEdit;
                TableView.this.textWidgetCaretPosition = TableView.this.getTextWidgetCaretPosition(colnr);
                final String value = TableView.this.getTextWidgetValue(colnr);
                final Runnable worker = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (row.isDisposed()) {
                                return;
                            }
                            row.setText(colnr, value);
                            ftext.dispose();
                            String[] afterEdit = TableView.this.getItemText(row);
                            TableView.this.checkChanged(new String[][]{fBeforeEdit}, new String[][]{afterEdit}, new int[]{rownr});
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                if (!row.isDisposed()) {
                    row.setText(colnr, value);
                }
                if (TableView.this.columns[colnr - 1].getType() == 6) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            d.asyncExec(worker);
                        }
                    };
                    Thread t = new Thread(r);
                    t.start();
                } else {
                    worker.run();
                }
                TableView.this.tableViewModifyListener.cellFocusLost(rownr);
            }

            private boolean isWrongLostFocusEvent() {
                Control controlGotFocus = Display.getCurrent().getCursorControl();
                return Const.isLinux() && (controlGotFocus == null || TableView.this.text.equals(controlGotFocus));
            }
        };
        this.lsFocusCombo = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TableItem row = TableView.this.activeTableItem;
                if (row == null) {
                    return;
                }
                int colnr = TableView.this.activeTableColumn;
                int rownr = TableView.this.table.indexOf(row);
                if (colnr > 0) {
                    try {
                        if (TableView.this.combo instanceof ComboVar) {
                            row.setText(colnr, ((ComboVar)TableView.this.combo).getText());
                        } else {
                            row.setText(colnr, ((CCombo)TableView.this.combo).getText());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String[] afterEdit = TableView.this.getItemText(row);
                    if (afterEdit != null) {
                        TableView.this.checkChanged(new String[][]{TableView.this.beforeEdit}, new String[][]{afterEdit}, new int[]{rownr});
                    }
                }
                TableView.this.combo.dispose();
                TableView.this.tableViewModifyListener.cellFocusLost(rownr);
            }
        };
        this.lsModCombo = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableItem row = TableView.this.activeTableItem;
                if (row == null) {
                    return;
                }
                int colnr = TableView.this.activeTableColumn;
                int rownr = TableView.this.table.indexOf(row);
                if (TableView.this.combo instanceof ComboVar) {
                    row.setText(colnr, ((ComboVar)TableView.this.combo).getText());
                } else {
                    row.setText(colnr, ((CCombo)TableView.this.combo).getText());
                }
                String[] afterEdit = TableView.this.getItemText(row);
                TableView.this.checkChanged(new String[][]{TableView.this.beforeEdit}, new String[][]{afterEdit}, new int[]{rownr});
            }
        };
        this.lsKeyText = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean right = false;
                boolean left = false;
                if (e.character == '\r' || e.keyCode == 0x1000002 || e.keyCode == 0x1000001 || e.keyCode == 9 || left || right) {
                    if (TableView.this.activeTableItem == null) {
                        return;
                    }
                    TableView.this.applyTextChange(TableView.this.activeTableItem, TableView.this.activeTableRow, TableView.this.activeTableColumn);
                    int maxcols = TableView.this.table.getColumnCount();
                    int maxrows = TableView.this.table.getItemCount();
                    boolean editNextCell = false;
                    if (e.keyCode == 0x1000002 && TableView.this.activeTableRow < maxrows - 1) {
                        TableView.this.activeTableRow++;
                        editNextCell = true;
                    }
                    if (e.keyCode == 0x1000001 && TableView.this.activeTableRow > 0) {
                        TableView.this.activeTableRow--;
                        editNextCell = true;
                    }
                    if (e.keyCode == 9 && (e.stateMask & 0x20000) == 0 || right) {
                        TableView.this.activeTableColumn++;
                        editNextCell = true;
                    }
                    if (e.keyCode == 9 && (e.stateMask & 0x20000) != 0 || left) {
                        TableView.this.activeTableColumn--;
                        editNextCell = true;
                    }
                    if (TableView.this.activeTableColumn < 1) {
                        TableView.this.activeTableColumn = maxcols - 1;
                        if (TableView.this.activeTableRow > 0) {
                            TableView.this.activeTableRow--;
                        }
                    }
                    if (TableView.this.activeTableColumn >= maxcols) {
                        TableView.this.activeTableColumn = 1;
                        TableView.this.activeTableRow++;
                    }
                    if (TableView.this.activeTableRow >= maxrows) {
                        TableItem item = new TableItem(TableView.this.table, 0, TableView.this.activeTableRow);
                        item.setText(1, "");
                        TableView.this.setRowNums();
                    }
                    TableView.this.activeTableItem = TableView.this.table.getItem(TableView.this.activeTableRow);
                    if (editNextCell) {
                        TableView.this.edit(TableView.this.activeTableRow, TableView.this.activeTableColumn);
                    } else if (e.keyCode == 0x1000002 && TableView.this.activeTableRow == maxrows - 1) {
                        TableView.this.insertRowAfter();
                    }
                } else if (e.keyCode == 27) {
                    TableView.this.text.dispose();
                    TableView.this.table.setFocus();
                }
            }
        };
        this.lsKeyCombo = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean ctrl;
                boolean bl = ctrl = (e.stateMask & SWT.MOD1) != 0;
                if (e.keyCode == 118 && ctrl) {
                    e.doit = false;
                    if (TableView.this.clipboard != null) {
                        TableView.this.clipboard.dispose();
                        TableView.this.clipboard = null;
                    }
                    TableView.this.clipboard = new Clipboard(TableView.this.getDisplay());
                    TextTransfer tran = TextTransfer.getInstance();
                    String text = (String)TableView.this.clipboard.getContents((Transfer)tran);
                    if (TableView.this.combo instanceof ComboVar) {
                        ((ComboVar)TableView.this.combo).setText(text);
                    } else {
                        ((CCombo)TableView.this.combo).setText(text);
                    }
                    return;
                }
                boolean right = false;
                boolean left = false;
                if (e.keyCode == 13 || e.keyCode == 9 || left || right) {
                    if (TableView.this.activeTableItem == null) {
                        return;
                    }
                    TableView.this.applyComboChange(TableView.this.activeTableItem, TableView.this.activeTableRow, TableView.this.activeTableColumn);
                    String[] afterEdit = TableView.this.getItemText(TableView.this.activeTableItem);
                    TableView.this.checkChanged(new String[][]{TableView.this.beforeEdit}, new String[][]{afterEdit}, new int[]{TableView.this.activeTableRow});
                    int maxcols = TableView.this.table.getColumnCount();
                    int maxrows = TableView.this.table.getItemCount();
                    boolean sel = false;
                    if (e.keyCode == 9 && (e.stateMask & 0x20000) == 0 || right) {
                        TableView.this.activeTableColumn++;
                        sel = true;
                    }
                    if (e.keyCode == 9 && (e.stateMask & 0x20000) != 0 || right) {
                        TableView.this.activeTableColumn--;
                        sel = true;
                    }
                    if (TableView.this.activeTableColumn < 1) {
                        TableView.this.activeTableColumn = maxcols - 1;
                        if (TableView.this.activeTableRow > 0) {
                            TableView.this.activeTableRow--;
                        }
                    }
                    if (TableView.this.activeTableColumn >= maxcols) {
                        TableView.this.activeTableColumn = 1;
                        TableView.this.activeTableRow++;
                    }
                    if (TableView.this.activeTableRow >= maxrows) {
                        TableItem item = new TableItem(TableView.this.table, 0, TableView.this.activeTableRow);
                        item.setText(1, "");
                        TableView.this.setRowNums();
                    }
                    if (sel) {
                        TableView.this.edit(TableView.this.activeTableRow, TableView.this.activeTableColumn);
                    }
                    TableView.this.table.setFocus();
                } else if (e.keyCode == 27) {
                    if (TableView.this.activeTableItem != null) {
                        TableView.this.activeTableItem.setText(TableView.this.activeTableColumn, TableView.this.beforeEdit[TableView.this.activeTableColumn - 1]);
                    }
                    TableView.this.combo.dispose();
                    TableView.this.table.setFocus();
                    e.doit = false;
                }
            }
        };
        KeyAdapter lsKeyTable = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean ctrl;
                boolean shift;
                if (TableView.this.activeTableItem == null) {
                    return;
                }
                int maxcols = TableView.this.table.getColumnCount();
                int maxrows = TableView.this.table.getItemCount();
                boolean bl = shift = (e.stateMask & 0x20000) != 0;
                if (!TableView.this.previousShift && shift || TableView.this.selectionStart < 0) {
                    TableView.this.selectionStart = TableView.this.activeTableRow;
                }
                TableView.this.previousShift = shift;
                boolean bl2 = ctrl = (e.stateMask & SWT.MOD1) != 0;
                if (!TableView.this.readonly && e.keyCode == 0x1000002 && ctrl) {
                    TableView.this.moveRows(1);
                    e.doit = false;
                    return;
                }
                if (!TableView.this.readonly && e.keyCode == 0x1000001 && ctrl) {
                    TableView.this.moveRows(-1);
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 0x1000002 && shift) {
                    TableView.this.activeTableRow++;
                    if (TableView.this.activeTableRow >= maxrows) {
                        TableView.this.activeTableRow = maxrows - 1;
                    }
                    TableView.this.selectRows(TableView.this.selectionStart, TableView.this.activeTableRow);
                    TableView.this.table.showItem(TableView.this.table.getItem(TableView.this.activeTableRow));
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 0x1000001 && shift) {
                    TableView.this.activeTableRow--;
                    if (TableView.this.activeTableRow < 0) {
                        TableView.this.activeTableRow = 0;
                    }
                    TableView.this.selectRows(TableView.this.activeTableRow, TableView.this.selectionStart);
                    TableView.this.table.showItem(TableView.this.table.getItem(TableView.this.activeTableRow));
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 0x1000007 && shift) {
                    TableView.this.activeTableRow = 0;
                    TableView.this.selectRows(TableView.this.selectionStart, TableView.this.activeTableRow);
                    TableView.this.table.showItem(TableView.this.activeTableItem);
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 0x1000008 && shift) {
                    TableView.this.activeTableRow = maxrows;
                    TableView.this.selectRows(TableView.this.selectionStart, TableView.this.activeTableRow);
                    TableView.this.table.showItem(TableView.this.activeTableItem);
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 0x1000002 && !shift || e.keyCode == 0x1000001 && !shift || e.keyCode == 0x1000007 && !shift || e.keyCode == 0x1000008 && !shift) {
                    switch (e.keyCode) {
                        case 0x1000002: {
                            TableView.this.activeTableRow++;
                            if (TableView.this.activeTableRow < maxrows) break;
                            if (!TableView.this.readonly) {
                                TableView.this.insertRowAfter();
                                break;
                            }
                            TableView.this.activeTableRow = maxrows - 1;
                            break;
                        }
                        case 0x1000001: {
                            TableView.this.activeTableRow--;
                            if (TableView.this.activeTableRow >= 0) break;
                            TableView.this.activeTableRow = 0;
                            break;
                        }
                        case 0x1000007: {
                            TableView.this.activeTableRow = 0;
                            break;
                        }
                        case 0x1000008: {
                            TableView.this.activeTableRow = maxrows - 1;
                            break;
                        }
                    }
                    TableView.this.setPosition(TableView.this.activeTableRow, TableView.this.activeTableColumn);
                    TableView.this.table.deselectAll();
                    TableView.this.table.select(TableView.this.activeTableRow);
                    TableView.this.table.showItem(TableView.this.table.getItem(TableView.this.activeTableRow));
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 97 && ctrl) {
                    e.doit = false;
                    TableView.this.selectAll();
                    return;
                }
                if (e.keyCode == 27) {
                    e.doit = false;
                    TableView.this.unselectAll();
                    TableView.this.selectRows(TableView.this.activeTableRow, TableView.this.activeTableRow);
                    TableView.this.setFocus();
                    return;
                }
                if (e.keyCode == 99 && ctrl) {
                    e.doit = false;
                    TableView.this.clipSelected();
                    return;
                }
                if (!TableView.this.readonly && e.keyCode == 107 && ctrl) {
                    e.doit = false;
                    TableView.this.keepSelected();
                    return;
                }
                if (!TableView.this.readonly && e.keyCode == 120 && ctrl) {
                    e.doit = false;
                    TableView.this.cutSelected();
                    return;
                }
                if (!TableView.this.readonly && e.keyCode == 118 && ctrl) {
                    e.doit = false;
                    TableView.this.pasteSelected();
                    return;
                }
                if (e.keyCode == 0x100000C) {
                    e.doit = false;
                    TableView.this.optWidth(true);
                    return;
                }
                if (!TableView.this.readonly && e.keyCode == 127) {
                    e.doit = false;
                    TableView.this.delSelected();
                    return;
                }
                if (e.keyCode == 0x100000D) {
                    e.doit = false;
                    TableView.this.optWidth(false);
                    return;
                }
                if (e.keyCode == 121 && ctrl) {
                    e.doit = false;
                    TableView.this.redoAction();
                    return;
                }
                if (e.keyCode == 122 && ctrl) {
                    e.doit = false;
                    TableView.this.undoAction();
                    return;
                }
                if (e.keyCode == 13 || e.keyCode == 0x1000004 || e.keyCode == 9) {
                    TableView.this.activeTableColumn = 1;
                    TableView.this.edit(TableView.this.activeTableRow, TableView.this.activeTableColumn);
                    e.doit = false;
                    return;
                }
                if (TableView.this.activeTableColumn > 0) {
                    boolean textChar;
                    boolean bl3 = textChar = e.character >= 'a' && e.character <= 'z' || e.character >= 'A' && e.character <= 'Z' || e.character >= '0' && e.character <= '9' || e.character == ' ' || e.character == '_' || e.character == ',' || e.character == '.' || e.character == '+' || e.character == '-' || e.character == '*' || e.character == '/' || e.character == ';';
                    if (e.character == '\r' || e.keyCode == 0x100000B || textChar) {
                        boolean selectText = true;
                        char extraChar = '\u0000';
                        if (textChar) {
                            extraChar = e.character;
                            selectText = false;
                        }
                        e.doit = false;
                        TableView.this.edit(TableView.this.activeTableRow, TableView.this.activeTableColumn, selectText, extraChar);
                    }
                    if (e.character == '\t') {
                        if (e.keyCode == 9 && (e.stateMask & 0x20000) == 0) {
                            TableView.this.activeTableColumn++;
                        }
                        if (e.keyCode == 9 && (e.stateMask & 0x20000) != 0) {
                            TableView.this.activeTableColumn--;
                        }
                        if (TableView.this.activeTableColumn < 1) {
                            TableView.this.activeTableColumn = maxcols - 1;
                            if (TableView.this.activeTableRow > 0) {
                                TableView.this.activeTableRow--;
                            }
                        }
                        if (TableView.this.activeTableColumn >= maxcols) {
                            TableView.this.activeTableColumn = 1;
                            TableView.this.activeTableRow++;
                        }
                        if (TableView.this.activeTableRow >= maxrows) {
                            TableItem item = new TableItem(TableView.this.table, 0, TableView.this.activeTableRow);
                            item.setText(1, "");
                            TableView.this.setRowNums();
                        }
                        e.doit = false;
                        TableView.this.edit(TableView.this.activeTableRow, TableView.this.activeTableColumn);
                    }
                }
                TableView.this.setFocus();
                TableView.this.table.setFocus();
            }
        };
        this.table.addKeyListener((KeyListener)lsKeyTable);
        MouseAdapter lsMouseT = new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                boolean rightClick;
                if (TableView.this.activeTableItem != null && !TableView.this.activeTableItem.isDisposed() && TableView.this.editor != null && TableView.this.editor.getEditor() != null && !TableView.this.editor.getEditor().isDisposed() && TableView.this.activeTableColumn > 0) {
                    switch (TableView.this.columns[TableView.this.activeTableColumn - 1].getType()) {
                        case 1: {
                            TableView.this.applyTextChange(TableView.this.activeTableItem, TableView.this.activeTableRow, TableView.this.activeTableColumn);
                            break;
                        }
                        case 2: {
                            TableView.this.applyComboChange(TableView.this.activeTableItem, TableView.this.activeTableRow, TableView.this.activeTableColumn);
                        }
                    }
                }
                boolean bl = rightClick = event.button == 3;
                if (event.button == 1 || rightClick) {
                    boolean control;
                    boolean shift = (event.stateMask & 0x20000) != 0;
                    boolean bl2 = control = (event.stateMask & SWT.MOD1) != 0;
                    if (!shift && !control) {
                        Rectangle clientArea = TableView.this.table.getClientArea();
                        Point pt = new Point(event.x, event.y);
                        for (int index = TableView.this.table.getTopIndex(); index < TableView.this.table.getItemCount(); ++index) {
                            boolean visible = false;
                            TableItem item = TableView.this.table.getItem(index);
                            for (int i = 0; i < TableView.this.table.getColumnCount(); ++i) {
                                Rectangle rect = item.getBounds(i);
                                if (rect.contains(pt)) {
                                    TableView.this.activeTableItem = item;
                                    TableView.this.activeTableColumn = i;
                                    TableView.this.activeTableRow = index;
                                    if (!rightClick) {
                                        TableView.this.editSelected();
                                    }
                                    return;
                                }
                                if (i == TableView.this.table.getColumnCount() - 1 && pt.x > rect.x + rect.width && pt.y >= rect.y && pt.y <= rect.y + rect.height) {
                                    return;
                                }
                                if (visible || !rect.intersects(clientArea)) continue;
                                visible = true;
                            }
                            if (visible) continue;
                            return;
                        }
                        if (rightClick) {
                            return;
                        }
                        TableView.this.setPosition(TableView.this.table.getItemCount() - 1, 1);
                        TableView.this.insertRowAfter();
                    }
                }
            }
        };
        this.table.addMouseListener((MouseListener)lsMouseT);
        int nrcols = this.tablecolumn.length;
        for (int i = 0; i < nrcols; ++i) {
            final int colnr = i;
            Listener lsSort = new Listener(){

                public void handleEvent(Event e) {
                    TableView.this.clearUndo();
                    TableView.this.sortTable(colnr);
                }
            };
            this.tablecolumn[i].addListener(13, lsSort);
        }
        this.lsTraverse = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = false;
            }
        };
        this.table.addTraverseListener(this.lsTraverse);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TableView.this.clipboard != null) {
                    TableView.this.clipboard.dispose();
                    TableView.this.clipboard = null;
                }
                if (TableView.this.gridFont != null) {
                    TableView.this.gridFont.dispose();
                }
            }
        });
        Transfer[] ttypes = new Transfer[]{TextTransfer.getInstance()};
        DragSource ddSource = new DragSource((Control)this.table, 3);
        ddSource.setTransfer(ttypes);
        ddSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = "TableView" + Const.CR + TableView.this.getSelectedText();
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.table.layout();
        this.table.pack();
        this.optWidth(true);
        this.layout();
        this.pack();
    }

    protected String getTextWidgetValue(int colNr) {
        boolean b = this.columns[colNr - 1].isUsingVariables();
        if (b) {
            return ((TextVar)this.text).getText();
        }
        return ((Text)this.text).getText();
    }

    protected int getTextWidgetCaretPosition(int colNr) {
        boolean b = this.columns[colNr - 1].isUsingVariables();
        if (b) {
            return ((TextVar)this.text).getTextWidget().getCaretPosition();
        }
        return ((Text)this.text).getCaretPosition();
    }

    public void sortTable(int colnr) {
        if (!this.sortable) {
            return;
        }
        if (this.sortfield == colnr) {
            this.sortingDescending = !this.sortingDescending;
        } else {
            this.sortfield = colnr;
            this.sortingDescending = false;
        }
        this.sortTable(this.sortfield, this.sortingDescending);
    }

    public void setSelection(int[] selectedItems) {
        this.table.select(selectedItems);
    }

    public void sortTable(int sortField, boolean sortingDescending) {
        boolean shouldRefresh = false;
        if (this.sortfieldLast == -1 && this.sortingDescendingLast == null) {
            shouldRefresh = true;
            this.sortfieldLast = this.sortfield;
            this.sortingDescendingLast = new Boolean(this.sortingDescending);
            this.sortfield = sortField;
            this.sortingDescending = sortingDescending;
        }
        if (this.sortfieldLast != this.sortfield) {
            this.sortfieldLast = this.sortfield;
            this.sortfield = sortField;
            shouldRefresh = true;
        }
        if (this.sortingDescendingLast != this.sortingDescending) {
            this.sortingDescendingLast = this.sortingDescending;
            this.sortingDescending = sortingDescending;
            shouldRefresh = true;
        }
        if (!shouldRefresh && this.table.getItemCount() == this.lastRowCount) {
            return;
        }
        this.removeEmptyRows();
        try {
            Object[] r;
            int i;
            TableItem[] items = this.table.getItems();
            ArrayList<Object[]> v = new ArrayList<Object[]>();
            RowMeta rowMeta = new RowMeta();
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("colorname"));
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger("color"));
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                ColumnInfo colInfo = j > 0 ? this.columns[j - 1] : this.numberColumn;
                ValueMetaInterface valueMeta = colInfo.getValueMeta();
                if (j == sortField) {
                    valueMeta.setSortedDescending(sortingDescending);
                }
                rowMeta.addValueMeta(valueMeta);
            }
            RowMetaInterface sourceRowMeta = rowMeta.cloneToType(2);
            final RowMetaInterface conversionRowMeta = rowMeta.clone();
            for (i = 0; i < sourceRowMeta.size(); ++i) {
                ValueMetaInterface sourceValueMeta = sourceRowMeta.getValueMeta(i);
                sourceValueMeta.setStorageType(0);
                ValueMetaInterface conversionMetaData = conversionRowMeta.getValueMeta(i);
                conversionMetaData.setStorageType(0);
                sourceRowMeta.getValueMeta(i).setConversionMetadata(conversionMetaData);
            }
            for (i = 0; i < items.length; ++i) {
                TableItem item = items[i];
                r = new Object[this.table.getColumnCount() + 2];
                Color bg = item.getBackground();
                if (!bg.equals((Object)this.defaultBackgroundColor)) {
                    String colorName = "bg " + bg.toString();
                    r[0] = colorName;
                    r[1] = new Long((bg.getRed() << 16) + (bg.getGreen() << 8) + bg.getBlue());
                    this.usedColors.put(colorName, bg);
                }
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    String data = item.getText(j);
                    if (GUIResource.getInstance().getColorBlue().equals((Object)item.getForeground(j))) {
                        data = null;
                    }
                    ValueMetaInterface sourceValueMeta = sourceRowMeta.getValueMeta(j + 2);
                    try {
                        r[j + 2] = sourceValueMeta.convertDataUsingConversionMetaData((Object)data);
                        continue;
                    }
                    catch (Exception e) {
                        if (this.isShowingConversionErrorsInline()) {
                            r[j + 2] = Const.getStackTracker((Throwable)e);
                            continue;
                        }
                        throw e;
                    }
                }
                v.add(r);
            }
            final int[] sortIndex = new int[]{sortField + 2};
            Collections.sort(v, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] r1, Object[] r2) {
                    try {
                        return conversionRowMeta.compare(r1, r2, sortIndex);
                    }
                    catch (KettleValueException e) {
                        throw new RuntimeException("Error comparing rows", e);
                    }
                }
            });
            this.table.removeAll();
            for (int i2 = 0; i2 < v.size(); ++i2) {
                Color bg;
                r = (Object[])v.get(i2);
                TableItem item = new TableItem(this.table, 0);
                String colorName = (String)r[0];
                Long colorValue = (Long)r[1];
                if (colorValue != null && (bg = this.usedColors.get(colorName)) != null) {
                    item.setBackground(bg);
                }
                for (int j = 2; j < r.length; ++j) {
                    String string = conversionRowMeta.getString(r, j);
                    if (this.showingBlueNullValues && string == null) {
                        string = "<null>";
                        item.setForeground(j - 2, GUIResource.getInstance().getColorBlue());
                    } else {
                        item.setForeground(j - 2, GUIResource.getInstance().getColorBlack());
                    }
                    if (string == null) continue;
                    item.setText(j - 2, string);
                }
            }
            this.table.setSortColumn(this.table.getColumn(this.sortfield));
            this.table.setSortDirection(sortingDescending ? 1024 : 128);
            this.lastRowCount = this.table.getItemCount();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"TableView.ErrorDialog.title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableView.ErrorDialog.description", (String[])new String[0]), e);
        }
    }

    private void selectRows(int from, int to) {
        this.table.deselectAll();
        if (from == to) {
            this.table.select(from);
        } else if (from > to) {
            this.table.select(to, from);
        } else {
            this.table.select(from, to);
        }
    }

    private void applyTextChange(TableItem row, int rownr, int colnr) {
        String textData = this.getTextWidgetValue(colnr);
        row.setText(colnr, textData);
        this.text.dispose();
        this.table.setFocus();
        this.tableViewModifyListener.cellFocusLost(rownr);
        String[] afterEdit = this.getItemText(row);
        this.checkChanged(new String[][]{this.beforeEdit}, new String[][]{afterEdit}, new int[]{rownr});
        this.selectionStart = -1;
        this.fireContentChangedListener(rownr, colnr, textData);
    }

    private void fireContentChangedListener(int rownr, int colnr, String textData) {
        if (this.lsContent != null) {
            Event event = new Event();
            event.data = textData;
            event.widget = this.table;
            event.x = rownr;
            event.y = colnr;
            this.lsContent.modifyText(new ModifyEvent(event));
        }
    }

    private void applyComboChange(TableItem row, int rownr, int colnr) {
        String textData = this.combo instanceof ComboVar ? ((ComboVar)this.combo).getText() : ((CCombo)this.combo).getText();
        row.setText(colnr, textData);
        this.combo.dispose();
        String[] afterEdit = this.getItemText(row);
        this.checkChanged(new String[][]{this.beforeEdit}, new String[][]{afterEdit}, new int[]{rownr});
        this.selectionStart = -1;
        this.fireContentChangedListener(rownr, colnr, textData);
    }

    public void addModifyListener(ModifyListener ls) {
        this.lsMod = ls;
    }

    public void setColumnInfo(int idx, ColumnInfo col) {
        this.columns[idx] = col;
    }

    public void setColumnText(int idx, String text) {
        TableColumn col = this.table.getColumn(idx);
        col.setText(text);
    }

    public void setColumnToolTip(int idx, String text) {
        this.columns[idx].setToolTip(text);
    }

    private void editSelected() {
        if (this.activeTableItem == null) {
            return;
        }
        if (this.activeTableColumn > 0) {
            this.edit(this.activeTableRow, this.activeTableColumn);
        } else {
            this.selectRows(this.activeTableRow, this.activeTableRow);
        }
    }

    private void checkChanged(String[][] before, String[][] after, int[] index) {
        if (this.fieldChanged) {
            TransAction ta = new TransAction();
            ta.setChanged((Object[])before, (Object[])after, index);
            this.addUndo(ta);
        }
    }

    private void setModified() {
        if (this.lsMod != null) {
            Event e = new Event();
            e.widget = this;
            this.lsMod.modifyText(new ModifyEvent(e));
        }
    }

    private void insertRowBefore() {
        if (this.readonly) {
            return;
        }
        TableItem row = this.activeTableItem;
        if (row == null) {
            return;
        }
        int rownr = this.table.indexOf(row);
        this.insertRow(rownr);
    }

    private void insertRowAfter() {
        if (this.readonly) {
            return;
        }
        TableItem row = this.activeTableItem;
        if (row == null) {
            return;
        }
        int rownr = this.table.indexOf(row);
        this.insertRow(rownr + 1);
    }

    private void insertRow(int ronr) {
        TableItem item = new TableItem(this.table, 0, ronr);
        item.setText(1, "");
        TransAction ta = new TransAction();
        String[] str = this.getItemText(item);
        ta.setNew((Object[])new String[][]{str}, new int[]{ronr});
        this.addUndo(ta);
        this.setRowNums();
        this.edit(ronr, 1);
        this.tableViewModifyListener.insertRow(ronr);
    }

    public void clearAll() {
        this.clearAll(false);
    }

    public void clearAll(boolean ask) {
        int id = 64;
        if (ask) {
            MessageBox mb = new MessageBox(this.parent.getShell(), 196);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableView.MessageBox.ClearTable.message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TableView.MessageBox.ClearTable.title", (String[])new String[0]));
            id = mb.open();
        }
        if (id == 64) {
            this.table.removeAll();
            new TableItem(this.table, 0);
            if (!this.readonly) {
                this.parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TableView.this.edit(0, 1);
                    }
                });
            }
            this.setModified();
        }
    }

    private void moveRows(int offset) {
        if (offset != 1 && offset != -1) {
            return;
        }
        int[] selectionIndicies = this.table.getSelectionIndices();
        int selectedIndex = this.table.getSelectionIndex();
        Arrays.sort(selectionIndicies);
        if (offset == 1) {
            if (selectionIndicies[selectionIndicies.length - 1] >= this.table.getItemCount() - 1) {
                return;
            }
            selectionIndicies = this.moveRowsDown(selectionIndicies);
        } else {
            if (selectionIndicies[0] == 0) {
                return;
            }
            selectionIndicies = this.moveRowsUp(selectionIndicies);
        }
        this.activeTableRow = selectedIndex + offset;
        this.table.setSelection(this.activeTableRow);
        this.table.setSelection(selectionIndicies);
        this.activeTableItem = this.table.getItem(this.activeTableRow);
    }

    private int[] moveRowsDown(int[] selectionIndicies) {
        for (int i = selectionIndicies.length - 1; i >= 0; --i) {
            int row = selectionIndicies[i];
            int newRow = row + 1;
            this.moveRow(row, newRow);
            TransAction ta = new TransAction();
            ta.setItemMove(new int[]{row}, new int[]{newRow});
            this.addUndo(ta);
            selectionIndicies[i] = newRow;
        }
        return selectionIndicies;
    }

    private int[] moveRowsUp(int[] selectionIndicies) {
        for (int i = 0; i < selectionIndicies.length; ++i) {
            int row = selectionIndicies[i];
            int newRow = row - 1;
            this.moveRow(row, newRow);
            TransAction ta = new TransAction();
            ta.setItemMove(new int[]{row}, new int[]{newRow});
            this.addUndo(ta);
            selectionIndicies[i] = newRow;
        }
        return selectionIndicies;
    }

    private void moveRow(int from, int to) {
        TableItem rowfrom = this.table.getItem(from);
        TableItem rowto = this.table.getItem(to);
        String[] strfrom = this.getItemText(rowfrom);
        String[] strto = this.getItemText(rowto);
        for (int i = 0; i < strfrom.length; ++i) {
            rowfrom.setText(i + 1, strto[i]);
            rowto.setText(i + 1, strfrom[i]);
        }
        this.tableViewModifyListener.moveRow(from, to);
        this.setModified();
    }

    private void copyToAll() {
        TableItem row = this.activeTableItem;
        if (row == null || row.isDisposed()) {
            return;
        }
        int colnr = this.activeTableColumn;
        if (colnr == 0) {
            return;
        }
        String str = row.getText(colnr);
        int size = this.table.getItemCount();
        String[][] before = new String[size][];
        String[][] after = new String[size][];
        int[] index = new int[size];
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            TableItem item = this.table.getItem(i);
            index[i] = i;
            before[i] = this.getItemText(item);
            item.setText(colnr, str);
            after[i] = this.getItemText(item);
        }
        TransAction ta = new TransAction();
        ta.setChanged((Object[])before, (Object[])after, index);
        this.addUndo(ta);
    }

    private void selectAll() {
        this.table.selectAll();
    }

    private void unselectAll() {
        this.table.deselectAll();
    }

    private void clipSelected() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        this.clipboard = new Clipboard(this.getDisplay());
        TextTransfer tran = TextTransfer.getInstance();
        String clip = this.getSelectedText();
        if (clip == null) {
            return;
        }
        this.clipboard.setContents((Object[])new String[]{clip}, new Transfer[]{tran});
    }

    private String getSelectedText() {
        String selection = "";
        for (int c = 1; c < this.table.getColumnCount(); ++c) {
            TableColumn tc = this.table.getColumn(c);
            if (c > 1) {
                selection = selection + CLIPBOARD_DELIMITER;
            }
            selection = selection + tc.getText();
        }
        selection = selection + Const.CR;
        TableItem[] items = this.table.getSelection();
        if (items.length == 0) {
            return null;
        }
        for (int r = 0; r < items.length; ++r) {
            TableItem ti = items[r];
            for (int c = 1; c < this.table.getColumnCount(); ++c) {
                if (c > 1) {
                    selection = selection + CLIPBOARD_DELIMITER;
                }
                selection = selection + ti.getText(c);
            }
            selection = selection + Const.CR;
        }
        return selection;
    }

    private int getCurrentRownr() {
        if (this.table.getItemCount() <= 1) {
            return 0;
        }
        TableItem row = this.activeTableItem;
        if (row == null) {
            return 0;
        }
        int rownr = this.table.indexOf(row);
        if (rownr < 0) {
            rownr = 0;
        }
        return rownr;
    }

    private void pasteSelected() {
        int rownr = this.getCurrentRownr();
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        this.clipboard = new Clipboard(this.getDisplay());
        TextTransfer tran = TextTransfer.getInstance();
        String text = (String)this.clipboard.getContents((Transfer)tran);
        if (text != null) {
            String[] lines = text.split(Const.CR);
            if (lines.length > 1) {
                String[][] grid = new String[lines.length - 1][];
                int[] idx = new int[lines.length - 1];
                for (int i = 1; i < lines.length; ++i) {
                    grid[i - 1] = lines[i].split(CLIPBOARD_DELIMITER);
                    idx[i - 1] = rownr + i;
                    this.addItem(idx[i - 1], grid[i - 1]);
                }
                TransAction ta = new TransAction();
                ta.setNew((Object[])grid, idx);
                this.addUndo(ta);
            }
            if (rownr == 0 && this.table.getItemCount() > rownr + 1 && this.isEmpty(rownr, -1)) {
                this.table.remove(rownr);
            }
            this.setRowNums();
            this.unEdit();
            this.setModified();
        }
    }

    private void addItem(int pos, String[] str) {
        TableItem item = new TableItem(this.table, 0, pos);
        for (int i = 0; i < str.length; ++i) {
            item.setText(i + 1, str[i]);
        }
        this.setModified();
    }

    private void cutSelected() {
        this.clipSelected();
        this.delSelected();
    }

    private void delSelected() {
        if (this.nrNonEmpty() == 0) {
            return;
        }
        int[] items = this.table.getSelectionIndices();
        if (items.length == 0) {
            return;
        }
        String[][] before = new String[items.length][];
        for (int i = 0; i < items.length; ++i) {
            TableItem ti = this.table.getItem(items[i]);
            before[i] = this.getItemText(ti);
        }
        TransAction ta = new TransAction();
        ta.setDelete((Object[])before, items);
        this.addUndo(ta);
        TableItem row = this.activeTableItem;
        if (row == null) {
            return;
        }
        int rowbefore = this.table.indexOf(row);
        this.table.remove(items);
        if (this.table.getItemCount() == 0) {
            TableItem item = new TableItem(this.table, 0);
            String[] stritem = this.getItemText(item);
            ta = new TransAction();
            ta.setNew((Object[])new String[][]{stritem}, new int[]{0});
            this.addUndo(ta);
        }
        if (rowbefore >= this.table.getItemCount()) {
            rowbefore = this.table.getItemCount() - 1;
        }
        if (rowbefore < this.table.getItemCount() && this.table.getItemCount() > 0) {
            this.setPosition(rowbefore, 1);
            this.table.setSelection(rowbefore);
            this.activeTableRow = rowbefore;
        }
        this.tableViewModifyListener.delete(items);
        this.setRowNums();
        this.setModified();
    }

    private void keepSelected() {
        int[] sels = this.table.getSelectionIndices();
        int size = this.table.getItemCount();
        int[] items = new int[size - sels.length];
        if (items.length == 0) {
            return;
        }
        int nr = 0;
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            boolean selected = false;
            for (int j = 0; j < sels.length && !selected; ++j) {
                if (sels[j] != i) continue;
                selected = true;
            }
            if (selected) continue;
            items[nr] = i;
            ++nr;
        }
        String[][] before = new String[items.length][];
        for (int i = 0; i < items.length; ++i) {
            TableItem ti = this.table.getItem(items[i]);
            before[i] = this.getItemText(ti);
        }
        TransAction ta = new TransAction();
        ta.setDelete((Object[])before, items);
        this.addUndo(ta);
        this.table.remove(items);
        if (this.table.getItemCount() == 0) {
            TableItem item = new TableItem(this.table, 0);
            String[] stritem = this.getItemText(item);
            ta = new TransAction();
            ta.setNew((Object[])new String[][]{stritem}, new int[]{0});
            this.addUndo(ta);
        }
        this.setRowNums();
        this.setModified();
    }

    private void setPosition(int rownr, int colnr) {
        this.activeTableColumn = colnr;
        this.activeTableRow = rownr;
        if (rownr >= 0) {
            this.activeTableItem = this.table.getItem(rownr);
        }
    }

    public void edit(int rownr, int colnr) {
        this.setPosition(rownr, colnr);
        this.edit(rownr, colnr, true, '\u0000');
    }

    private void edit(int rownr, int colnr, boolean selectText, char extra) {
        this.selectionStart = -1;
        TableItem row = this.table.getItem(rownr);
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null && !oldEditor.isDisposed()) {
            try {
                oldEditor.dispose();
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
        this.activeTableItem = this.table.getItem(this.activeTableRow);
        this.table.showItem(row);
        this.table.setSelection(new TableItem[]{row});
        if (this.columns.length == 0) {
            return;
        }
        switch (this.columns[colnr - 1].getType()) {
            case 1: {
                this.isTextButton = false;
                this.editText(row, rownr, colnr, selectText, extra, this.columns[colnr - 1]);
                break;
            }
            case 2: 
            case 5: {
                this.editCombo(row, rownr, colnr);
                break;
            }
            case 3: {
                this.editButton(row, rownr, colnr);
                break;
            }
            case 6: {
                this.isTextButton = this.columns[colnr - 1].shouldRenderTextVarButton();
                this.editText(row, rownr, colnr, selectText, extra, this.columns[colnr - 1]);
                break;
            }
        }
    }

    private String[] getItemText(TableItem row) {
        if (row.isDisposed()) {
            return null;
        }
        String[] retval = new String[this.table.getColumnCount() - 1];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = row.getText(i + 1);
        }
        return retval;
    }

    private void editText(TableItem row, final int rownr, final int colnr, boolean selectText, char extra, ColumnInfo columnInfo) {
        boolean disabled;
        this.beforeEdit = this.getItemText(row);
        this.fieldChanged = false;
        ColumnInfo colinfo = this.columns[colnr - 1];
        if (colinfo.isReadOnly()) {
            return;
        }
        if (colinfo.getDisabledListener() != null && (disabled = colinfo.getDisabledListener().isFieldDisabled(rownr))) {
            return;
        }
        if (this.text != null && !this.text.isDisposed()) {
            this.text.dispose();
        }
        if (colinfo.getSelectionAdapter() != null) {
            Event e = new Event();
            e.widget = this;
            e.x = colnr;
            e.y = rownr;
            this.columns[colnr - 1].getSelectionAdapter().widgetSelected(new SelectionEvent(e));
            return;
        }
        String content = row.getText(colnr) + (extra != '\u0000' ? "" + extra : "");
        String tooltip = this.columns[colnr - 1].getToolTip();
        final boolean useVariables = this.columns[colnr - 1].isUsingVariables();
        boolean passwordField = this.columns[colnr - 1].isPasswordField();
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                TableView.this.setColumnWidthBasedOnTextField(colnr, useVariables);
            }
        };
        if (useVariables) {
            GetCaretPositionInterface getCaretPositionInterface = new GetCaretPositionInterface(){

                @Override
                public int getCaretPosition() {
                    return ((TextVar)TableView.this.text).getTextWidget().getCaretPosition();
                }
            };
            InsertTextInterface insertTextInterface = new InsertTextInterface(){

                @Override
                public void insertText(String string, int position) {
                    StringBuilder buffer = new StringBuilder(TableView.this.table.getItem(rownr).getText(colnr));
                    buffer.insert(position, string);
                    TableView.this.table.getItem(rownr).setText(colnr, buffer.toString());
                    int newPosition = position + string.length();
                    TableView.this.edit(rownr, colnr);
                    ((TextVar)TableView.this.text).setSelection(newPosition);
                    ((TextVar)TableView.this.text).showSelection();
                    TableView.this.setColumnWidthBasedOnTextField(colnr, useVariables);
                }
            };
            TextVar textWidget = passwordField ? new PasswordTextVar(this.variables, (Composite)this.table, 0, getCaretPositionInterface, insertTextInterface) : (this.isTextButton ? new TextVarButton(this.variables, (Composite)this.table, 0, getCaretPositionInterface, insertTextInterface, columnInfo.getTextVarButtonSelectionListener()) : new TextVar(this.variables, (Composite)this.table, 0, getCaretPositionInterface, insertTextInterface));
            this.text = textWidget;
            textWidget.setText(content);
            if (this.lsMod != null) {
                textWidget.addModifyListener(this.lsMod);
            }
            textWidget.addModifyListener(this.lsUndo);
            textWidget.setSelection(content.length());
            textWidget.addKeyListener(this.lsKeyText);
            textWidget.addModifyListener(modifyListener);
            if (selectText) {
                textWidget.selectAll();
            }
            if (tooltip != null) {
                textWidget.setToolTipText(tooltip);
            } else {
                textWidget.setToolTipText("");
            }
            textWidget.addTraverseListener(this.lsTraverse);
            textWidget.addFocusListener((FocusListener)this.lsFocusText);
        } else {
            Text textWidget = new Text((Composite)this.table, 0);
            this.text = textWidget;
            textWidget.setText(content);
            if (this.lsMod != null) {
                textWidget.addModifyListener(this.lsMod);
            }
            textWidget.addModifyListener(this.lsUndo);
            textWidget.setSelection(content.length());
            textWidget.addKeyListener(this.lsKeyText);
            textWidget.addModifyListener(modifyListener);
            if (selectText) {
                textWidget.selectAll();
            }
            if (tooltip != null) {
                textWidget.setToolTipText(tooltip);
            } else {
                textWidget.setToolTipText("");
            }
            textWidget.addTraverseListener(this.lsTraverse);
            textWidget.addFocusListener((FocusListener)this.lsFocusText);
        }
        this.props.setLook(this.text, 2);
        int width = this.tablecolumn[colnr].getWidth();
        int height = 30;
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.setEditor(this.text, row, colnr);
        this.text.setFocus();
        this.text.setSize(width, height);
        this.editor.layout();
    }

    private void setColumnWidthBasedOnTextField(int colnr, boolean useVariables) {
        if (!this.columns[colnr - 1].isAutoResize()) {
            return;
        }
        String str = this.getTextWidgetValue(colnr);
        int strmax = TableView.dummyGC.textExtent((String)str, (int)6).x + 20;
        int colmax = this.tablecolumn[colnr].getWidth();
        if (strmax > colmax) {
            if (Const.isOSX() || Const.isLinux()) {
                strmax = (int)((double)strmax * 1.4);
            }
            this.tablecolumn[colnr].setWidth(strmax + 30);
            if (useVariables) {
                TextVar widget = (TextVar)this.text;
                int idx = widget.getTextWidget().getCaretPosition();
                widget.selectAll();
                widget.showSelection();
                widget.setSelection(0);
                widget.showSelection();
                widget.setSelection(idx);
            } else {
                Text widget = (Text)this.text;
                int idx = widget.getCaretPosition();
                widget.selectAll();
                widget.showSelection();
                widget.setSelection(0);
                widget.showSelection();
                widget.setSelection(idx);
            }
        }
    }

    private String[] getComboValues(TableItem row, ColumnInfo colinfo) {
        if (colinfo.getType() == 5) {
            int type = ValueMetaFactory.getIdForValueMeta((String)row.getText(colinfo.getFieldTypeColumn()));
            switch (type) {
                case 3: {
                    return Const.getDateFormats();
                }
                case 1: 
                case 5: 
                case 6: {
                    return Const.getNumberFormats();
                }
                case 2: {
                    return Const.getConversionFormats();
                }
            }
            return new String[0];
        }
        return colinfo.getComboValues();
    }

    private void editCombo(TableItem row, final int rownr, final int colnr) {
        boolean useVariables;
        boolean disabled;
        this.beforeEdit = this.getItemText(row);
        this.fieldChanged = false;
        ColumnInfo colinfo = this.columns[colnr - 1];
        if (colinfo.isReadOnly() && colinfo.getSelectionAdapter() != null) {
            return;
        }
        if (colinfo.getDisabledListener() != null && (disabled = colinfo.getDisabledListener().isFieldDisabled(rownr))) {
            return;
        }
        String[] opt = this.getComboValues(row, colinfo);
        if (colinfo.getComboValuesSelectionListener() != null) {
            opt = colinfo.getComboValuesSelectionListener().getComboValues(row, rownr, colnr);
        }
        if (useVariables = colinfo.isUsingVariables()) {
            GetCaretPositionInterface getCaretPositionInterface = new GetCaretPositionInterface(){

                @Override
                public int getCaretPosition() {
                    return 0;
                }
            };
            InsertTextInterface insertTextInterface = new InsertTextInterface(){

                @Override
                public void insertText(String string, int position) {
                    StringBuilder buffer = new StringBuilder(TableView.this.table.getItem(rownr).getText(colnr));
                    buffer.insert(position, string);
                    TableView.this.table.getItem(rownr).setText(colnr, buffer.toString());
                    TableView.this.edit(rownr, colnr);
                    TableView.this.setModified();
                }
            };
            this.combo = new ComboVar(this.variables, (Composite)this.table, 16388, getCaretPositionInterface, insertTextInterface);
            ComboVar widget = (ComboVar)this.combo;
            if (this.lsFocusInTabItem != null) {
                widget.getCComboWidget().addListener(15, this.lsFocusInTabItem);
            } else {
                widget.setItems(opt);
            }
            this.props.setLook((Control)widget, 2);
            widget.addTraverseListener(this.lsTraverse);
            widget.addModifyListener(this.lsModCombo);
            widget.addFocusListener((FocusListener)this.lsFocusCombo);
            widget.setText(row.getText(colnr));
            if (this.lsMod != null) {
                widget.addModifyListener(this.lsMod);
            }
            widget.addModifyListener(this.lsUndo);
            widget.setToolTipText(colinfo.getToolTip() == null ? "" : colinfo.getToolTip());
            widget.setVisible(true);
            widget.addKeyListener(this.lsKeyCombo);
            ((FormData)widget.getCComboWidget().getLayoutData()).bottom = new FormAttachment(100, 0);
            this.editor.horizontalAlignment = 16384;
            this.editor.layout();
            this.editor.setEditor((Control)widget, row, colnr);
            widget.setFocus();
            widget.layout();
        } else {
            this.combo = new CCombo((Composite)this.table, colinfo.isReadOnly() ? 8 : 0);
            CCombo widget = (CCombo)this.combo;
            this.props.setLook((Control)widget, 2);
            widget.addTraverseListener(this.lsTraverse);
            widget.addModifyListener(this.lsModCombo);
            widget.addFocusListener((FocusListener)this.lsFocusCombo);
            widget.setItems(opt);
            widget.setVisibleItemCount(opt.length);
            widget.setText(row.getText(colnr));
            if (this.lsMod != null) {
                widget.addModifyListener(this.lsMod);
            }
            widget.addModifyListener(this.lsUndo);
            widget.setToolTipText(colinfo.getToolTip() == null ? "" : colinfo.getToolTip());
            widget.setVisible(true);
            widget.addKeyListener(this.lsKeyCombo);
            if (colinfo.getSelectionAdapter() != null) {
                widget.addSelectionListener(this.columns[colnr - 1].getSelectionAdapter());
            }
            this.editor.horizontalAlignment = 16384;
            this.editor.layout();
            this.editor.setEditor((Control)widget, row, colnr);
            widget.setFocus();
            widget.layout();
        }
    }

    private void editButton(TableItem row, int rownr, int colnr) {
        boolean disabled;
        this.beforeEdit = this.getItemText(row);
        this.fieldChanged = false;
        ColumnInfo colinfo = this.columns[colnr - 1];
        if (colinfo.isReadOnly()) {
            return;
        }
        if (colinfo.getDisabledListener() != null && (disabled = colinfo.getDisabledListener().isFieldDisabled(rownr))) {
            return;
        }
        this.button = new Button((Composite)this.table, 8);
        this.props.setLook((Control)this.button, 2);
        String buttonText = this.columns[colnr - 1].getButtonText();
        if (buttonText != null) {
            this.button.setText(buttonText);
        }
        this.button.setImage(GUIResource.getInstance().getImage("ui/images/edittext.svg"));
        SelectionListener selAdpt = colinfo.getSelectionAdapter();
        if (selAdpt != null) {
            this.button.addSelectionListener(selAdpt);
        }
        this.buttonRownr = rownr;
        this.buttonColnr = colnr;
        this.buttonContent = row.getText(colnr);
        String tooltip = this.columns[colnr - 1].getToolTip();
        if (tooltip != null) {
            this.button.setToolTipText(tooltip);
        } else {
            this.button.setToolTipText("");
        }
        this.button.addTraverseListener(this.lsTraverse);
        this.button.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent arg0) {
                TableView.this.closeActiveButton();
            }
        });
        this.editor.horizontalAlignment = 16384;
        this.editor.verticalAlignment = 128;
        this.editor.grabHorizontal = false;
        this.editor.grabVertical = false;
        Point size = this.button.computeSize(-1, -1);
        this.editor.minimumWidth = size.x;
        this.editor.minimumHeight = size.y - 2;
        this.editor.layout();
        this.editor.setEditor((Control)this.button);
        this.button.setFocus();
    }

    public void setRowNums() {
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            TableItem item = this.table.getItem(i);
            if (item == null) continue;
            String num = "" + (i + 1);
            if (item.getText(0).equals(num)) continue;
            item.setText(0, num);
        }
    }

    public void optWidth(boolean header) {
        this.optWidth(header, 0);
    }

    /*
     * Unable to fully structure code
     */
    public void optWidth(boolean header, int nrLines) {
        for (c = 0; c < this.table.getColumnCount(); ++c) {
            block18: {
                block17: {
                    tc = this.table.getColumn(c);
                    max = 0;
                    if (header) {
                        max = TableView.dummyGC.textExtent((String)tc.getText(), (int)6).x;
                        if (c == this.sortfield && this.sortable) {
                            max += 15;
                        }
                    }
                    columnStrings = new HashSet<String>();
                    haveToGetTexts = false;
                    if (c <= 0) break block17;
                    column = this.columns[c - 1];
                    if (column == null) break block18;
                    switch (column.getType()) {
                        case 1: {
                            haveToGetTexts = true;
                            ** break;
                        }
                        case 2: 
                        case 5: {
                            haveToGetTexts = true;
                            if (column.getComboValues() == null) ** break;
                            for (String comboValue : this.columns[c - 1].getComboValues()) {
                                columnStrings.add(comboValue);
                            }
                            break block18;
                        }
                        case 3: {
                            columnStrings.add(column.getButtonText());
                            ** break;
                        }
                    }
lbl30:
                    // 4 sources

                    break block18;
                }
                haveToGetTexts = true;
            }
            if (haveToGetTexts) {
                for (r = 0; r < this.table.getItemCount() && (r < nrLines || nrLines <= 0); ++r) {
                    ti = this.table.getItem(r);
                    if (ti == null) continue;
                    columnStrings.add(ti.getText(c));
                }
            }
            r = columnStrings.iterator();
            while (r.hasNext()) {
                len = TableView.dummyGC.textExtent((String)((str = (String)r.next()) == null ? "" : str), (int)6).x;
                if (len <= max) continue;
                max = len;
            }
            try {
                extra = 15;
                if (Const.isWindows() || Const.isLinux()) {
                    extra += 15;
                }
                if (tc.getWidth() == max + extra || c <= 0) continue;
                if (this.columns[c - 1].getWidth() == -1) {
                    tc.setWidth(max + extra);
                    continue;
                }
                tc.setWidth(this.columns[c - 1].getWidth());
                continue;
            }
            catch (Exception var8_12) {
                // empty catch block
            }
        }
        if (this.table.isListening(11)) {
            resizeEvent = new Event();
            resizeEvent.widget = this.table;
            resizeEvent.type = 11;
            resizeEvent.display = this.getDisplay();
            resizeEvent.setBounds(this.table.getBounds());
            this.table.notifyListeners(11, resizeEvent);
        }
        this.unEdit();
    }

    public void removeEmptyRows() {
        this.removeEmptyRows(-1);
    }

    private boolean isEmpty(int rownr, int colnr) {
        boolean empty = false;
        TableItem item = this.table.getItem(rownr);
        if (item != null) {
            if (colnr >= 0) {
                String str = item.getText(colnr);
                if (str == null || str.length() == 0) {
                    empty = true;
                }
            } else {
                empty = true;
                for (int j = 1; j < this.table.getColumnCount(); ++j) {
                    String str = item.getText(j);
                    if (str == null || str.length() <= 0) continue;
                    empty = false;
                }
            }
        }
        return empty;
    }

    public void removeEmptyRows(int column) {
        for (int i = this.table.getItemCount() - 1; i >= 0; --i) {
            if (!this.isEmpty(i, column)) continue;
            this.table.remove(i);
        }
        if (this.table.getItemCount() == 0) {
            new TableItem(this.table, 0);
        }
    }

    public List<Integer> getNonEmptyIndexes() {
        return this.nonEmptyIndexes;
    }

    public int nrNonEmpty() {
        this.nonEmptyIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            if (this.isEmpty(i, -1)) continue;
            this.nonEmptyIndexes.add(i);
        }
        return this.nonEmptyIndexes.size();
    }

    public TableItem getNonEmpty(int index) {
        int nonEmptyIndex = this.nonEmptyIndexes.get(index);
        return this.table.getItem(nonEmptyIndex);
    }

    public int indexOfString(String str, int column) {
        int nrNonEmptyFields = this.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            String cmp = this.getNonEmpty(i).getText(column);
            if (!str.equalsIgnoreCase(cmp)) continue;
            return i;
        }
        return -1;
    }

    public ScrollBar getHorizontalBar() {
        return this.table.getHorizontalBar();
    }

    public ScrollBar getVerticalBar() {
        return this.table.getVerticalBar();
    }

    private void addUndo(TransAction ta) {
        while (this.undo.size() > this.undoPosition + 1 && this.undo.size() > 0) {
            int last = this.undo.size() - 1;
            this.undo.remove(last);
        }
        this.undo.add(ta);
        ++this.undoPosition;
        while (this.undo.size() > this.props.getMaxUndo()) {
            this.undo.remove(0);
            --this.undoPosition;
        }
        this.setUndoMenu();
    }

    private void undoAction() {
        TransAction ta = this.previousUndo();
        if (ta == null) {
            return;
        }
        int rownr = this.getCurrentRownr();
        this.setUndoMenu();
        switch (ta.getType()) {
            case 23: {
                int[] idx = ta.getCurrentIndex();
                this.table.remove(idx);
                for (int i = 0; i < idx.length; ++i) {
                    if (idx[i] >= rownr) continue;
                    --rownr;
                }
                if (this.table.getItemCount() == 0) {
                    this.undoAction();
                }
                this.setRowNums();
                break;
            }
            case 24: {
                int[] idx = ta.getCurrentIndex();
                String[][] str = (String[][])ta.getCurrent();
                for (int i = 0; i < idx.length; ++i) {
                    this.addItem(idx[i], str[i]);
                    if (idx[i] > rownr) continue;
                    ++rownr;
                }
                this.setRowNums();
                break;
            }
            case 22: {
                int[] idx = ta.getCurrentIndex();
                String[][] prev = (String[][])ta.getPrevious();
                for (int x = 0; x < idx.length; ++x) {
                    TableItem item = this.table.getItem(idx[x]);
                    for (int i = 0; i < prev[x].length; ++i) {
                        item.setText(i + 1, prev[x][i]);
                    }
                }
                break;
            }
            case 25: {
                int[] curr = ta.getCurrentIndex();
                int[] prevIdx = ta.getPreviousIndex();
                for (int i = 0; i < curr.length; ++i) {
                    this.moveRow(prevIdx[i], curr[i]);
                }
                this.setRowNums();
                break;
            }
        }
        if (rownr >= this.table.getItemCount()) {
            rownr = this.table.getItemCount() - 1;
        }
        if (rownr < 0) {
            rownr = 0;
        }
        this.selectRows(rownr, rownr);
    }

    private void redoAction() {
        TransAction ta = this.nextUndo();
        if (ta == null) {
            return;
        }
        int rownr = this.getCurrentRownr();
        this.setUndoMenu();
        switch (ta.getType()) {
            case 23: {
                int[] idx = ta.getCurrentIndex();
                String[][] str = (String[][])ta.getCurrent();
                for (int i = 0; i < idx.length; ++i) {
                    this.addItem(idx[i], str[i]);
                    if (idx[i] > rownr) continue;
                    ++rownr;
                }
                this.setRowNums();
                break;
            }
            case 24: {
                int[] idx = ta.getCurrentIndex();
                this.table.remove(idx);
                for (int i = 0; i < idx.length; ++i) {
                    if (idx[i] >= rownr) continue;
                    --rownr;
                }
                if (this.table.getItemCount() == 0) {
                    this.undoAction();
                }
                this.setRowNums();
                break;
            }
            case 22: {
                int[] idx = ta.getCurrentIndex();
                String[][] curr = (String[][])ta.getCurrent();
                for (int x = 0; x < idx.length; ++x) {
                    TableItem item = this.table.getItem(idx[x]);
                    for (int i = 0; i < curr[x].length; ++i) {
                        item.setText(i + 1, curr[x][i]);
                    }
                }
                break;
            }
            case 25: {
                int[] currIdx = ta.getCurrentIndex();
                int[] prev = ta.getPreviousIndex();
                for (int i = 0; i < currIdx.length; ++i) {
                    this.moveRow(currIdx[i], prev[i]);
                }
                this.setRowNums();
                break;
            }
        }
        if (rownr >= this.table.getItemCount()) {
            rownr = this.table.getItemCount() - 1;
        }
        if (rownr < 0) {
            rownr = 0;
        }
        this.selectRows(rownr, rownr);
    }

    private void setUndoMenu() {
        TransAction prev = this.viewPreviousUndo();
        TransAction next = this.viewNextUndo();
        if (this.miEditUndo.isDisposed() || this.miEditRedo.isDisposed()) {
            return;
        }
        if (prev != null) {
            this.miEditUndo.setEnabled(true);
            this.miEditUndo.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.Undo", (String[])new String[]{prev.toString()})));
        } else {
            this.miEditUndo.setEnabled(false);
            this.miEditUndo.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.UndoNotAvailable", (String[])new String[0])));
        }
        if (next != null) {
            this.miEditRedo.setEnabled(true);
            this.miEditRedo.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.Redo", (String[])new String[]{next.toString()})));
        } else {
            this.miEditRedo.setEnabled(false);
            this.miEditRedo.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.RedoNotAvailable", (String[])new String[0])));
        }
    }

    private TransAction previousUndo() {
        if (this.undo.isEmpty() || this.undoPosition < 0) {
            return null;
        }
        TransAction retval = this.undo.get(this.undoPosition);
        --this.undoPosition;
        return retval;
    }

    private TransAction viewPreviousUndo() {
        if (this.undo.isEmpty() || this.undoPosition < 0) {
            return null;
        }
        TransAction retval = this.undo.get(this.undoPosition);
        return retval;
    }

    private TransAction nextUndo() {
        int size = this.undo.size();
        if (size == 0 || this.undoPosition >= size - 1) {
            return null;
        }
        ++this.undoPosition;
        TransAction retval = this.undo.get(this.undoPosition);
        return retval;
    }

    private TransAction viewNextUndo() {
        int size = this.undo.size();
        if (size == 0 || this.undoPosition >= size - 1) {
            return null;
        }
        TransAction retval = this.undo.get(this.undoPosition + 1);
        return retval;
    }

    private void clearUndo() {
        this.undo = new ArrayList();
        this.undoPosition = -1;
    }

    private Point getButtonPosition() {
        return new Point(this.buttonColnr, this.buttonRownr);
    }

    public String getButtonString() {
        return this.buttonContent;
    }

    public void setButtonString(String str) {
        Point p = this.getButtonPosition();
        TableItem item = this.table.getItem(p.y);
        item.setText(p.x, str);
    }

    public void closeActiveButton() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.dispose();
        }
    }

    public void unEdit() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.dispose();
        }
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.dispose();
        }
    }

    public void setFilter() {
        if (this.condition == null) {
            this.condition = new Condition();
        }
        RowMetaInterface f = this.getRowWithoutValues();
        EnterConditionDialog ecd = new EnterConditionDialog(this.parent.getShell(), 0, f, this.condition);
        Condition cond = ecd.open();
        if (cond != null) {
            ArrayList<Integer> tokeep = new ArrayList<Integer>();
            int nr = this.table.getItemCount();
            for (int i = nr - 1; i >= 0; --i) {
                RowMetaAndData r = this.getRow(i);
                boolean keep = cond.evaluate(r.getRowMeta(), r.getData());
                if (!keep) continue;
                tokeep.add(i);
            }
            int[] sels = new int[tokeep.size()];
            for (int i = 0; i < sels.length; ++i) {
                sels[i] = (Integer)tokeep.get(i);
            }
            this.table.setSelection(sels);
        }
    }

    public RowMetaInterface getRowWithoutValues() {
        RowMeta f = new RowMeta();
        f.addValueMeta((ValueMetaInterface)new ValueMetaInteger("#"));
        for (int i = 0; i < this.columns.length; ++i) {
            f.addValueMeta((ValueMetaInterface)new ValueMetaString(this.columns[i].getName()));
        }
        return f;
    }

    public RowMetaAndData getRow(int nr) {
        TableItem ti = this.table.getItem(nr);
        RowMetaInterface rowMeta = this.getRowWithoutValues();
        Object[] rowData = new Object[rowMeta.size()];
        rowData[0] = new Long(nr);
        for (int i = 1; i < rowMeta.size(); ++i) {
            rowData[i] = ti.getText(i);
        }
        return new RowMetaAndData(rowMeta, rowData);
    }

    public int[] getSelectionIndices() {
        return this.table.getSelectionIndices();
    }

    public int getSelectionIndex() {
        return this.table.getSelectionIndex();
    }

    public void remove(int index) {
        this.table.remove(index);
        if (this.table.getItemCount() == 0) {
            new TableItem(this.table, 0);
        }
    }

    public void remove(int[] index) {
        this.table.remove(index);
        if (this.table.getItemCount() == 0) {
            new TableItem(this.table, 0);
        }
    }

    public String getItem(int rownr, int colnr) {
        TableItem item = this.table.getItem(rownr);
        if (item != null) {
            return item.getText(colnr);
        }
        return null;
    }

    public void add(String ... string) {
        TableItem item = new TableItem(this.table, 0);
        for (int i = 0; i < string.length && i + 1 < this.table.getColumnCount(); ++i) {
            if (string[i] == null) continue;
            item.setText(i + 1, string[i]);
        }
    }

    public String[] getItem(int rownr) {
        TableItem item = this.table.getItem(rownr);
        if (item != null) {
            return this.getItemText(item);
        }
        return null;
    }

    public String[] getItems(int colnr) {
        String[] retval = new String[this.table.getItemCount()];
        for (int i = 0; i < retval.length; ++i) {
            TableItem item = this.table.getItem(i);
            retval[i] = item.getText(colnr + 1);
        }
        return retval;
    }

    public void removeAll() {
        this.table.removeAll();
        if (this.table.getItemCount() == 0) {
            new TableItem(this.table, 0);
        }
    }

    public int getItemCount() {
        return this.table.getItemCount();
    }

    public void setText(String text, int colnr, int rownr) {
        TableItem item = this.table.getItem(rownr);
        item.setText(colnr, text);
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
        if (!sortable) {
            this.table.setSortColumn(null);
        } else {
            this.table.setSortColumn(this.table.getColumn(this.sortfield));
        }
    }

    public void setFocusOnFirstEditableField() {
        int rownr = 0;
        boolean gotOne = false;
        for (int colnr = 0; colnr < this.columns.length && !gotOne; ++colnr) {
            if (this.columns[colnr].isReadOnly()) continue;
            gotOne = true;
            this.activeTableItem = this.table.getItem(rownr);
            this.activeTableColumn = colnr + 1;
            this.edit(rownr, colnr + 1);
        }
    }

    public int getSortField() {
        return this.sortfield;
    }

    public boolean isSortingDescending() {
        return this.sortingDescending;
    }

    public void setSortingDescending(boolean sortingDescending) {
        this.sortingDescending = sortingDescending;
    }

    public Table getTable() {
        return this.table;
    }

    public ColumnInfo getNumberColumn() {
        return this.numberColumn;
    }

    public void setNumberColumn(ColumnInfo numberColumn) {
        this.numberColumn = numberColumn;
    }

    public TableEditor getEditor() {
        return this.editor;
    }

    public void setEditor(TableEditor editor) {
        this.editor = editor;
    }

    public void applyOSXChanges() {
        if (this.text != null && !this.text.isDisposed() && this.lsFocusText != null) {
            this.lsFocusText.focusLost(null);
        }
    }

    public boolean isShowingBlueNullValues() {
        return this.showingBlueNullValues;
    }

    public void setShowingBlueNullValues(boolean showingBlueNullValues) {
        this.showingBlueNullValues = showingBlueNullValues;
    }

    public ModifyListener getContentListener() {
        return this.lsContent;
    }

    public void setContentListener(ModifyListener lsContent) {
        this.lsContent = lsContent;
    }

    public boolean isShowingConversionErrorsInline() {
        return this.showingConversionErrorsInline;
    }

    public void setShowingConversionErrorsInline(boolean showingConversionErrorsInline) {
        this.showingConversionErrorsInline = showingConversionErrorsInline;
    }

    public ColumnInfo[] getColumns() {
        return Arrays.copyOf(this.columns, this.columns.length);
    }

    public TableItem getActiveTableItem() {
        return this.activeTableItem;
    }

    public int getActiveTableColumn() {
        return this.activeTableColumn;
    }

    public void setTableViewModifyListener(TableViewModifyListener tableViewModifyListener) {
        this.tableViewModifyListener = tableViewModifyListener;
    }

    public boolean hasIndexColumn() {
        return this.addIndexColumn;
    }

    public static interface TableViewModifyListener {
        public void moveRow(int var1, int var2);

        public void insertRow(int var1);

        public void cellFocusLost(int var1);

        public void delete(int[] var1);
    }
}

