/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.ISubTransAwareMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputStep;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.api.AnalysisContext;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.messages.Messages;
import org.pentaho.metaverse.api.model.ExternalResourceInfoFactory;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KettleAnalyzerUtil {
    private static final Logger log = LoggerFactory.getLogger(KettleAnalyzerUtil.class);

    public static String normalizeFilePath(String filePath) throws MetaverseException {
        try {
            String path = filePath;
            FileObject fo = KettleVFS.getFileObject((String)filePath);
            try {
                path = fo.getURL().getPath();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            File f = new File(path);
            return f.getAbsolutePath();
        }
        catch (Exception e) {
            throw new MetaverseException(e);
        }
    }

    public static String normalizeFilePathSafely(String filePath) {
        try {
            return KettleAnalyzerUtil.normalizeFilePath(filePath);
        }
        catch (MetaverseException e) {
            log.error(e.getMessage());
            return filePath;
        }
    }

    public static Collection<IExternalResourceInfo> getResourcesFromMeta(StepMeta parentStepMeta, String[] filePaths) {
        List<IExternalResourceInfo> resources = Collections.emptyList();
        if (parentStepMeta != null && filePaths != null && filePaths.length > 0) {
            resources = new ArrayList<IExternalResourceInfo>(filePaths.length);
            for (String path : filePaths) {
                if (Const.isEmpty((String)path)) continue;
                try {
                    IExternalResourceInfo resource = ExternalResourceInfoFactory.createFileResource(KettleVFS.getFileObject((String)path), true);
                    if (resource == null) {
                        throw new KettleFileException("Error getting file resource!");
                    }
                    resources.add(resource);
                }
                catch (KettleFileException kettleFileException) {
                    // empty catch block
                }
            }
        }
        return resources;
    }

    public static Collection<IExternalResourceInfo> getResourcesFromRow(BaseFileInputStep step, RowMetaInterface rowMeta, Object[] row) {
        LinkedList<IExternalResourceInfo> resources = new LinkedList<IExternalResourceInfo>();
        BaseFileInputMeta meta = (BaseFileInputMeta)step.getStepMetaInterface();
        if (meta == null) {
            meta = (BaseFileInputMeta)step.getStepMeta().getStepMetaInterface();
        }
        try {
            String filename;
            String string = filename = meta == null ? null : step.environmentSubstitute(rowMeta.getString(row, meta.getAcceptingField(), null));
            if (!Const.isEmpty(filename)) {
                FileObject fileObject = KettleVFS.getFileObject((String)filename, (VariableSpace)step);
                resources.add(ExternalResourceInfoFactory.createFileResource(fileObject, true));
            }
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        return resources;
    }

    public static TransMeta getSubTransMeta(ISubTransAwareMeta meta) throws MetaverseAnalyzerException {
        TransMeta parentTransMeta = meta.getParentStepMeta().getParentTransMeta();
        Repository repo = parentTransMeta.getRepository();
        TransMeta subTransMeta = null;
        switch (meta.getSpecificationMethod()) {
            case FILENAME: {
                String transPath = KettleAnalyzerUtil.normalizeFilePathSafely(parentTransMeta.environmentSubstitute(meta.getFileName()));
                try {
                    subTransMeta = KettleAnalyzerUtil.getSubTransMeta(transPath);
                    break;
                }
                catch (Exception e) {
                    throw new MetaverseAnalyzerException("Sub transformation can not be found - " + transPath, e);
                }
            }
            case REPOSITORY_BY_NAME: {
                if (repo != null) {
                    String dir = parentTransMeta.environmentSubstitute(meta.getDirectoryPath());
                    String file = parentTransMeta.environmentSubstitute(meta.getTransName());
                    try {
                        RepositoryDirectoryInterface rdi = repo.findDirectory(dir);
                        subTransMeta = repo.loadTransformation(file, rdi, null, true, null);
                        break;
                    }
                    catch (KettleException e) {
                        throw new MetaverseAnalyzerException("Sub transformation can not be found in repository - " + file, e);
                    }
                }
                throw new MetaverseAnalyzerException("Not connected to a repository, can't get the transformation");
            }
            case REPOSITORY_BY_REFERENCE: {
                if (repo != null) {
                    try {
                        subTransMeta = repo.loadTransformation(meta.getTransObjectId(), null);
                        break;
                    }
                    catch (KettleException e) {
                        throw new MetaverseAnalyzerException("Sub transformation can not be found by reference - " + meta.getTransObjectId(), e);
                    }
                }
                throw new MetaverseAnalyzerException("Not connected to a repository, can't get the transformation");
            }
        }
        return subTransMeta;
    }

    public static String getSubTransMetaPath(ISubTransAwareMeta meta, TransMeta subTransMeta) throws MetaverseAnalyzerException {
        String transPath;
        String string = transPath = meta == null ? null : meta.getFileName();
        if (meta != null && meta.getSpecificationMethod() != null) {
            switch (meta.getSpecificationMethod()) {
                case FILENAME: {
                    transPath = meta.getFileName();
                    break;
                }
                case REPOSITORY_BY_NAME: 
                case REPOSITORY_BY_REFERENCE: {
                    if (subTransMeta == null || subTransMeta.getPathAndName() == null) break;
                    transPath = subTransMeta.getPathAndName() + (subTransMeta.getDefaultExtension() == null ? "" : "." + subTransMeta.getDefaultExtension());
                }
            }
        }
        TransMeta parentTransMeta = meta == null || meta.getParentStepMeta() == null ? null : meta.getParentStepMeta().getParentTransMeta();
        transPath = KettleAnalyzerUtil.normalizeFilePathSafely(parentTransMeta == null || transPath == null ? transPath : parentTransMeta.environmentSubstitute(transPath));
        return transPath;
    }

    public static TransMeta getSubTransMeta(String filePath) throws FileNotFoundException, KettleXMLException, KettleMissingPluginsException {
        FileInputStream fis = new FileInputStream(filePath);
        return new TransMeta((InputStream)fis, null, true, null, null);
    }

    public static IDocument buildDocument(IMetaverseBuilder builder, AbstractMeta meta, String id, INamespace namespace) {
        if (builder == null || builder.getMetaverseObjectFactory() == null) {
            log.warn(Messages.getString("WARN.UnableToBuildDocument"));
            return null;
        }
        IDocument metaverseDocument = builder.getMetaverseObjectFactory().createDocumentObject();
        if (metaverseDocument == null) {
            log.warn(Messages.getString("WARN.UnableToBuildDocument"));
            return null;
        }
        metaverseDocument.setNamespace(namespace);
        metaverseDocument.setContent(meta);
        metaverseDocument.setStringID(id);
        metaverseDocument.setName(meta.getName());
        metaverseDocument.setExtension(meta.getDefaultExtension());
        metaverseDocument.setMimeType(URLConnection.getFileNameMap().getContentTypeFor(meta instanceof TransMeta ? "trans.ktr" : "job.kjb"));
        metaverseDocument.setContext(new AnalysisContext("runtime"));
        String normalizedPath = KettleAnalyzerUtil.normalizeFilePathSafely(id);
        metaverseDocument.setProperty("name", meta.getName());
        metaverseDocument.setProperty("path", normalizedPath);
        metaverseDocument.setProperty("namespace", namespace.getNamespaceId());
        return metaverseDocument;
    }

    public static String getFilename(TransMeta transMeta) {
        if (transMeta != null) {
            String filename = transMeta.getFilename();
            if (filename == null) {
                filename = transMeta.getPathAndName();
                if (transMeta.getDefaultExtension() != null) {
                    filename = filename + "." + transMeta.getDefaultExtension();
                }
            }
            return filename;
        }
        return null;
    }

    public static String getFilename(JobMeta jobMeta) {
        if (jobMeta != null) {
            String filename = jobMeta.getFilename();
            if (filename == null) {
                filename = jobMeta.getName();
                if (jobMeta.getDefaultExtension() != null) {
                    filename = filename + "." + jobMeta.getDefaultExtension();
                }
            }
            return filename;
        }
        return null;
    }

    public static IMetaverseNode analyze(StepAnalyzer analyzer, TransMeta transMeta, ISubTransAwareMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        TransMeta subTransMeta = KettleAnalyzerUtil.getSubTransMeta(meta);
        subTransMeta.copyVariablesFrom((VariableSpace)transMeta);
        String subTransMetaPath = KettleAnalyzerUtil.getSubTransMetaPath(meta, subTransMeta);
        subTransMeta.setFilename(subTransMetaPath);
        rootNode.setProperty("subTransformation", subTransMetaPath);
        IMetaverseNode subTransNode = analyzer.getNode(subTransMeta.getName(), "Transformation", analyzer.getDocumentDescriptor().getNamespace(), null, null);
        subTransNode.setProperty("namespace", analyzer.getDocumentDescriptor().getNamespace().getNamespaceId());
        subTransNode.setProperty("path", subTransMetaPath);
        subTransNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_DOCUMENT);
        analyzer.getMetaverseBuilder().addLink(rootNode, "executes", subTransNode);
        IDocument subTransDocument = KettleAnalyzerUtil.buildDocument(analyzer.getMetaverseBuilder(), (AbstractMeta)subTransMeta, subTransMetaPath, analyzer.getDocumentDescriptor().getNamespace());
        if (subTransDocument != null) {
            MetaverseComponentDescriptor subtransDocumentDescriptor = new MetaverseComponentDescriptor(subTransDocument.getStringID(), "Transformation", analyzer.getDocumentDescriptor().getNamespace(), analyzer.getDescriptor().getContext());
            return analyzer.getDocumentAnalyzer().analyze(subtransDocumentDescriptor, (AbstractMeta)subTransMeta, subTransNode, subTransMetaPath);
        }
        return null;
    }
}

