/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.extension;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.refinery.DataProviderHelper;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.entries.build.JobEntryBuildModel;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.steps.annotation.BaseAnnotationMeta;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationData;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

@ExtensionPoint(id="DataRefineryTransFinishListener", description="Updates data provider info on annotated steps.", extensionPointId="TransformationFinish")
public class DataRefineryTransFinishListener
implements ExtensionPointInterface {
    private static final Class<?> PKG = ModelAnnotationMeta.class;

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        Trans trans = (Trans)object;
        try {
            if (trans.getParentJob() != null) {
                this.setBuildModelOutputStep(trans.getParentJob(), trans);
            }
        }
        catch (KettleException e) {
            log.logError(e.getLocalizedMessage());
        }
        catch (Exception e) {
            log.logError("Error setting output step for Build Model", (Throwable)e);
        }
        try {
            IMetaStore metaStore = trans.getMetaStore();
            this.updateDataProviders(log, trans, metaStore);
        }
        catch (KettleException e) {
            log.logError(e.getLocalizedMessage());
        }
        catch (Exception e) {
            log.logError("Error processing data providers for annotations.", (Throwable)e);
        }
    }

    public void setBuildModelOutputStep(Job job, Trans trans) throws KettleException {
        for (JobEntryCopy jeCopy : job.getJobMeta().getJobCopies()) {
            JobEntryBuildModel jeBuildModel;
            String outputStepName;
            if (!"DataRefineryBuildModel".equals(jeCopy.getEntry().getPluginId()) || (outputStepName = StringUtils.trimToNull((String)job.environmentSubstitute((jeBuildModel = (JobEntryBuildModel)jeCopy.getEntry()).getOutputStep()))) == null) continue;
            for (StepMetaDataCombi stepMetaData : trans.getSteps()) {
                String key;
                String stepName = StringUtils.trimToNull((String)stepMetaData.stepname);
                if (!outputStepName.equals(stepName)) continue;
                Map map = job.getExtensionDataMap();
                if (map.containsKey(key = "JobEntryBuildModel.OutputStep." + jeBuildModel.getName())) {
                    throw new KettleException("Unable to auto-model because more than one step with the same name was found: " + stepMetaData.stepname);
                }
                map.put(key, stepMetaData);
            }
        }
    }

    public void updateDataProviders(LogChannelInterface log, Trans trans, IMetaStore metaStore) throws KettleException, MetaStoreException {
        log.logDebug("searching for annotations");
        boolean hasAnnotations = false;
        for (StepMetaDataCombi combi : trans.getSteps()) {
            if (!(combi.meta instanceof BaseAnnotationMeta)) continue;
            hasAnnotations = true;
            log.logDebug("found annotations step '" + combi.stepname + "'");
            ModelAnnotationData maData = (ModelAnnotationData)combi.data;
            if (maData.annotations == null || !maData.annotations.isSharedDimension()) continue;
            if (metaStore == null) {
                log.logError(BaseMessages.getString(PKG, (String)"ModelAnnotation.Runtime.NoMetastore", (String[])new String[0]));
                return;
            }
            log.logDebug("found shared dimension " + maData.annotations.getName());
            StepMetaDataCombi outCombi = this.getOutputStep(combi, trans);
            if (outCombi.data.getStatus() == BaseStepData.StepExecutionStatus.STATUS_DISPOSED) {
                DataProviderHelper dataProviderHelper = this.getDataProviderHelper(metaStore);
                dataProviderHelper.updateDataProvider(maData.annotations, outCombi);
                continue;
            }
            log.logError(BaseMessages.getString(PKG, (String)"ModelAnnotation.Runtime.OutputStepFail", (Object[])new Object[]{outCombi.stepname, outCombi.data.getStatus()}));
        }
        if (!hasAnnotations) {
            log.logDebug("no annotations found");
        }
    }

    protected DataProviderHelper getDataProviderHelper(IMetaStore mstore) {
        return new DataProviderHelper(mstore);
    }

    private StepMetaDataCombi getOutputStep(StepMetaDataCombi annotationCombi, Trans trans) throws KettleException {
        String outStepName = this.getOutputStepName(annotationCombi, trans);
        for (StepMetaDataCombi outCombi : annotationCombi.step.getTrans().getSteps()) {
            if (!outCombi.stepname.equals(outStepName)) continue;
            return outCombi;
        }
        throw new KettleException(BaseMessages.getString(JobEntryBuildModel.class, (String)"BuildModelJob.Error.UnableToFindStep", (String[])new String[]{outStepName}));
    }

    private String getOutputStepName(StepMetaDataCombi annotationCombi, Trans trans) throws KettleException {
        String outputStepName;
        if (annotationCombi.meta instanceof BaseAnnotationMeta && StringUtils.isNotBlank((String)(outputStepName = trans.environmentSubstitute(((BaseAnnotationMeta)annotationCombi.meta).getTargetOutputStep())))) {
            return outputStepName;
        }
        throw new KettleException("output step not set");
    }
}

