/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.loading;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.loading.LoadContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityLoadContext {
    private static final Logger log = LoggerFactory.getLogger(EntityLoadContext.class);
    private final LoadContexts loadContexts;
    private final ResultSet resultSet;
    private final List hydratingEntities = new ArrayList(20);

    public EntityLoadContext(LoadContexts loadContexts, ResultSet resultSet) {
        this.loadContexts = loadContexts;
        this.resultSet = resultSet;
    }

    void cleanup() {
        if (!this.hydratingEntities.isEmpty()) {
            log.warn("On EntityLoadContext#clear, hydratingEntities contained [" + this.hydratingEntities.size() + "] entries");
        }
        this.hydratingEntities.clear();
    }

    public String toString() {
        return super.toString() + "<rs=" + this.resultSet + ">";
    }
}

