/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.orc;

import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.hadoop.shim.api.format.OrcSpec;

public class OrcTypeConverter {
    public static String convertToOrcType(int pdiType) {
        switch (pdiType) {
            case 2: 
            case 10: {
                return OrcSpec.DataType.STRING.getName();
            }
            case 9: {
                return OrcSpec.DataType.TIMESTAMP.getName();
            }
            case 8: {
                return OrcSpec.DataType.BINARY.getName();
            }
            case 6: {
                return OrcSpec.DataType.DECIMAL.getName();
            }
            case 4: {
                return OrcSpec.DataType.BOOLEAN.getName();
            }
            case 3: {
                return OrcSpec.DataType.DATE.getName();
            }
            case 5: {
                return OrcSpec.DataType.INTEGER.getName();
            }
            case 1: {
                return OrcSpec.DataType.DOUBLE.getName();
            }
        }
        return OrcSpec.DataType.NULL.getName();
    }

    public static String convertToOrcType(String type) {
        int pdiType = ValueMetaFactory.getIdForValueMeta((String)type);
        if (pdiType > 0) {
            return OrcTypeConverter.convertToOrcType(pdiType);
        }
        return type;
    }
}

