/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.pentaho.platform.api.engine.IConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileConfiguration
implements IConfiguration {
    private Properties properties;
    private String id;
    private File propFile;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public PropertiesFileConfiguration(String id, Properties properties) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null");
        }
        this.id = id;
        this.properties = properties;
    }

    public PropertiesFileConfiguration(String id, File propFile) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (propFile == null) {
            throw new IllegalArgumentException("properties cannot be null");
        }
        if (!propFile.exists()) {
            throw new IllegalArgumentException("properties file does not exist");
        }
        this.id = id;
        this.propFile = propFile;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() throws IOException {
        if (this.properties == null) {
            this.loadProperties();
        }
        Properties p = new Properties();
        Properties properties = this.properties;
        synchronized (properties) {
            p.putAll((Map<?, ?>)this.properties);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() throws IOException {
        this.properties = new Properties();
        File file = this.propFile;
        synchronized (file) {
            this.properties.load(new FileInputStream(this.propFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Properties newProperties) throws IOException {
        if (this.properties == null) {
            this.loadProperties();
        }
        Serializable serializable = this.properties;
        synchronized (serializable) {
            long unixTime = System.currentTimeMillis() / 1000L;
            this.properties.store(new FileOutputStream(this.propFile + "." + String.valueOf(unixTime)), "");
            this.properties.clear();
            this.properties.putAll((Map<?, ?>)newProperties);
        }
        serializable = this.propFile;
        synchronized (serializable) {
            this.properties.store(new FileOutputStream(this.propFile), "");
        }
    }

    protected void setPropFile(File propFile) {
        this.propFile = propFile;
    }
}

