/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.exporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.aries.rsa.spi.ExportPolicy;
import org.apache.aries.rsa.topologymanager.exporter.EndpointRepository;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyManagerExport
implements ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyManagerExport.class);
    private final Executor execService;
    private final EndpointRepository endpointRepo;
    private ExportPolicy policy;
    private final Set<RemoteServiceAdmin> rsaSet;

    public TopologyManagerExport(EndpointRepository endpointRepo, Executor executor, ExportPolicy policy) {
        this.endpointRepo = endpointRepo;
        this.policy = policy;
        this.rsaSet = new HashSet<RemoteServiceAdmin>();
        this.execService = executor;
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference sref = event.getServiceReference();
        if (event.getType() == 1) {
            LOG.debug("Received REGISTERED ServiceEvent: {}", (Object)event);
            this.export(sref);
        } else if (event.getType() == 4) {
            LOG.debug("Received UNREGISTERING ServiceEvent: {}", (Object)event);
            this.endpointRepo.removeService(sref);
        }
    }

    public void add(RemoteServiceAdmin rsa) {
        this.rsaSet.add(rsa);
        for (ServiceReference serviceRef : this.endpointRepo.getServicesToBeExportedFor(rsa)) {
            this.export(serviceRef);
        }
    }

    public void remove(RemoteServiceAdmin rsa) {
        this.rsaSet.remove(rsa);
        this.endpointRepo.removeRemoteServiceAdmin(rsa);
    }

    private void export(final ServiceReference<?> sref) {
        this.execService.execute(new Runnable(){

            @Override
            public void run() {
                TopologyManagerExport.this.doExport(sref);
            }
        });
    }

    private void doExport(ServiceReference<?> sref) {
        Map addProps = this.policy.additionalParameters(sref);
        if (!this.shouldExport(sref, addProps)) {
            LOG.debug("Skipping service {}", sref);
            return;
        }
        LOG.debug("Exporting service {}", sref);
        this.endpointRepo.addService(sref);
        if (this.rsaSet.size() == 0) {
            LOG.error("No RemoteServiceAdmin available! Unable to export service from bundle {}, interfaces: {}", this.getSymbolicName(sref.getBundle()), sref.getProperty("objectClass"));
            return;
        }
        HashSet<RemoteServiceAdmin> rsaSetCopy = new HashSet<RemoteServiceAdmin>(this.rsaSet);
        for (RemoteServiceAdmin remoteServiceAdmin : rsaSetCopy) {
            LOG.debug("TopologyManager: handling remoteServiceAdmin " + remoteServiceAdmin);
            if (this.endpointRepo.isAlreadyExportedForRsa(sref, remoteServiceAdmin)) {
                LOG.debug("already handled by this remoteServiceAdmin -> skipping");
                continue;
            }
            this.exportServiceUsingRemoteServiceAdmin(sref, remoteServiceAdmin, addProps);
        }
    }

    private boolean shouldExport(ServiceReference<?> sref, Map<String, ?> addProps) {
        String exported = (String)sref.getProperty("service.exported.interfaces");
        String addExported = (String)addProps.get("service.exported.interfaces");
        String effectiveExported = addExported != null ? addExported : exported;
        return effectiveExported != null && !effectiveExported.isEmpty();
    }

    private Object getSymbolicName(Bundle bundle) {
        return bundle == null ? null : bundle.getSymbolicName();
    }

    private void exportServiceUsingRemoteServiceAdmin(ServiceReference<?> sref, RemoteServiceAdmin remoteServiceAdmin, Map<String, ?> addProps) {
        if (sref.getBundle() == null) {
            LOG.info("TopologyManager: export aborted for {} since it was unregistered", sref);
            this.endpointRepo.removeService(sref);
            return;
        }
        LOG.debug("exporting {}...", sref);
        Collection exportRegs = remoteServiceAdmin.exportService(sref, addProps);
        ArrayList<EndpointDescription> endpoints = new ArrayList<EndpointDescription>();
        for (ExportRegistration reg : exportRegs) {
            if (reg.getException() == null) {
                EndpointDescription endpoint = this.getExportedEndpoint(reg);
                LOG.debug("TopologyManager: export succeeded for {}, endpoint {}, rsa {}", new Object[]{sref, endpoint, remoteServiceAdmin.getClass()});
                endpoints.add(endpoint);
                continue;
            }
            LOG.error("TopologyManager: export failed for {}", sref, (Object)reg.getException());
            reg.close();
        }
        if (sref.getBundle() == null) {
            LOG.info("TopologyManager: export reverted for {} since service was unregistered", sref);
            this.endpointRepo.removeService(sref);
            for (ExportRegistration reg : exportRegs) {
                reg.close();
            }
            return;
        }
        if (!endpoints.isEmpty()) {
            LOG.info("TopologyManager: export successful for {}, endpoints: {}", sref, endpoints);
            this.endpointRepo.addEndpoints(sref, remoteServiceAdmin, endpoints);
        }
    }

    private EndpointDescription getExportedEndpoint(ExportRegistration exReg) {
        ExportReference ref = exReg == null ? null : exReg.getExportReference();
        return ref == null ? null : ref.getExportedEndpoint();
    }
}

