/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.simplemapping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mapping.MappingParameters;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.simplemapping.SimpleMappingMeta;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.repository.dialog.SelectObjectDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.SwtSvgImageUtil;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class SimpleMappingDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = SimpleMappingMeta.class;
    private SimpleMappingMeta mappingMeta;
    private Label wlPath;
    private TextVar wPath;
    private Button wbBrowse;
    private CTabFolder wTabFolder;
    private TransMeta mappingTransMeta = null;
    protected boolean transModified;
    private ModifyListener lsMod;
    private int middle;
    private int margin;
    private MappingParameters mappingParameters;
    private MappingIODefinition inputMapping;
    private MappingIODefinition outputMapping;
    private ObjectId referenceObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    private List<ApplyChanges> changeList;

    public SimpleMappingDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.mappingMeta = (SimpleMappingMeta)in;
        this.transModified = false;
        this.mappingParameters = (MappingParameters)this.mappingMeta.getMappingParameters().clone();
        this.inputMapping = (MappingIODefinition)this.mappingMeta.getInputMapping().clone();
        this.outputMapping = (MappingIODefinition)this.mappingMeta.getOutputMapping().clone();
        this.changeList = new ArrayList<ApplyChanges>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.mappingMeta);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimpleMappingDialog.this.mappingMeta.setChanged();
            }
        };
        this.changed = this.mappingMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Shell.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.width = 250;
        this.fdStepname.left = new FormAttachment(0, 0);
        this.fdStepname.top = new FormAttachment((Control)this.wlStepname, 5);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 1;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wlPath = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlPath);
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Transformation.Label", (String[])new String[0]));
        FormData fdlTransformation = new FormData();
        fdlTransformation.left = new FormAttachment(0, 0);
        fdlTransformation.top = new FormAttachment((Control)spacer, 20);
        fdlTransformation.right = new FormAttachment(50, 0);
        this.wlPath.setLayoutData((Object)fdlTransformation);
        this.wPath = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPath);
        FormData fdTransformation = new FormData();
        fdTransformation.left = new FormAttachment(0, 0);
        fdTransformation.top = new FormAttachment((Control)this.wlPath, 5);
        fdTransformation.width = 350;
        this.wPath.setLayoutData(fdTransformation);
        this.wbBrowse = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbBrowse.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.left = new FormAttachment((Control)this.wPath, 5);
        fdBrowse.top = new FormAttachment((Control)this.wlPath, 5);
        this.wbBrowse.setLayoutData((Object)fdBrowse);
        this.wbBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimpleMappingDialog.this.repository != null) {
                    SimpleMappingDialog.this.selectRepositoryTrans();
                } else {
                    SimpleMappingDialog.this.selectFileTrans();
                }
            }
        });
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wTabFolder.setUnselectedCloseVisible(true);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.height = 1;
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wPath, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SimpleMappingDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SimpleMappingDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SimpleMappingDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wPath.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SimpleMappingDialog.this.cancel();
            }
        });
        SimpleMappingDialog.setSize(this.shell, 670, 690);
        this.getData();
        this.mappingMeta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage(this.shell.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader(), "MAP.svg", 32, 32);
    }

    private void selectRepositoryTrans() {
        try {
            SelectObjectDialog sod = new SelectObjectDialog(this.shell, this.repository);
            String transName = sod.open();
            RepositoryDirectoryInterface repdir = sod.getDirectory();
            if (transName != null && repdir != null) {
                this.loadRepositoryTrans(transName, repdir);
                String path = this.getPath(this.mappingTransMeta.getRepositoryDirectory().getPath());
                String fullPath = path + "/" + this.mappingTransMeta.getName();
                this.wPath.setText(fullPath);
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorSelectingObject.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorSelectingObject.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    protected String getPath(String path) {
        String parentPath = this.transMeta.getRepositoryDirectory().getPath();
        if (path.startsWith(parentPath)) {
            path = path.replace(parentPath, "${Internal.Entry.Current.Directory}");
        }
        return path;
    }

    private void loadRepositoryTrans(String transName, RepositoryDirectoryInterface repdir) throws KettleException {
        this.mappingTransMeta = this.repository.loadTransformation(this.transMeta.environmentSubstitute(transName), repdir, null, true, null);
        this.mappingTransMeta.clearChanged();
    }

    private void selectFileTrans() {
        String curFile = this.transMeta.environmentSubstitute(this.wPath.getText());
        FileObject root = null;
        String parentFolder = null;
        try {
            parentFolder = KettleVFS.getFileObject((String)this.transMeta.environmentSubstitute(this.transMeta.getFilename())).getParent().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            root = KettleVFS.getFileObject((String)(curFile != null ? curFile : Const.getUserHomeDirectory()));
            VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(root.getParent(), root);
            FileObject file = vfsFileChooser.open(this.shell, null, Const.STRING_TRANS_FILTER_EXT, Const.getTransformationFilterNames(), 0);
            if (file == null) {
                return;
            }
            String fileName = file.getName().toString();
            if (fileName != null) {
                this.loadFileTrans(fileName);
                if (parentFolder != null && fileName.startsWith(parentFolder)) {
                    fileName = fileName.replace(parentFolder, "${Internal.Entry.Current.Directory}");
                }
                this.wPath.setText(fileName);
                this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
            }
        }
        catch (IOException | KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), (Exception)e);
        }
    }

    private void loadFileTrans(String fname) throws KettleException {
        this.mappingTransMeta = new TransMeta(this.transMeta.environmentSubstitute(fname));
        this.mappingTransMeta.clearChanged();
    }

    void loadTransformation() throws KettleException {
        String filename = this.wPath.getText();
        this.specificationMethod = this.repository != null ? ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME : ObjectLocationSpecificationMethod.FILENAME;
        switch (this.getSpecificationMethod()) {
            case FILENAME: {
                if (Utils.isEmpty((CharSequence)filename)) {
                    return;
                }
                if (!filename.endsWith(".ktr")) {
                    filename = filename + ".ktr";
                    this.wPath.setText(filename);
                }
                this.loadFileTrans(filename);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                if (Utils.isEmpty((CharSequence)filename)) {
                    return;
                }
                if (filename.endsWith(".ktr")) {
                    filename = filename.replace(".ktr", "");
                    this.wPath.setText(filename);
                }
                String realTransname = transPath = this.transMeta.environmentSubstitute(filename);
                String realDirectory = "";
                int index = transPath.lastIndexOf("/");
                if (index != -1) {
                    realTransname = transPath.substring(index + 1);
                    realDirectory = transPath.substring(0, index);
                }
                if (Utils.isEmpty((CharSequence)realDirectory) || Utils.isEmpty((CharSequence)realTransname)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Exception.NoValidMappingDetailsFound", (String[])new String[0]));
                }
                RepositoryDirectoryInterface repdir = this.repository.findDirectory(realDirectory);
                if (repdir == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Exception.UnableToFindRepositoryDirectory", (String[])new String[0]));
                }
                this.loadRepositoryTrans(realTransname, repdir);
                break;
            }
        }
    }

    private void getByReferenceData(ObjectId transObjectId) {
        try {
            if (this.repository == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Exception.NotConnectedToRepository.Message", (String[])new String[0]));
            }
            RepositoryObject transInf = this.repository.getObjectInformation(transObjectId, RepositoryObjectType.TRANSFORMATION);
            String path = this.getPath(transInf.getRepositoryDirectory().getPath());
            String fullPath = Const.NVL((String)path, (String)"") + "/" + Const.NVL((String)transInf.getName(), (String)"");
            this.wPath.setText(fullPath);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Exception.UnableToReferenceObjectId.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Exception.UnableToReferenceObjectId.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void getData() {
        this.setSpecificationMethod(this.mappingMeta.getSpecificationMethod());
        switch (this.getSpecificationMethod()) {
            case FILENAME: {
                this.wPath.setText(Const.NVL((String)this.mappingMeta.getFileName(), (String)""));
                break;
            }
            case REPOSITORY_BY_NAME: {
                String fullPath = Const.NVL((String)this.mappingMeta.getDirectoryPath(), (String)"") + "/" + Const.NVL((String)this.mappingMeta.getTransName(), (String)"");
                this.wPath.setText(fullPath);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.referenceObjectId = this.mappingMeta.getTransObjectId();
                this.getByReferenceData(this.referenceObjectId);
                break;
            }
        }
        this.addParametersTab(this.mappingParameters);
        this.wTabFolder.setSelection(0);
        this.addInputMappingDefinitionTab(this.inputMapping, 0);
        this.addOutputMappingDefinitionTab(this.outputMapping, 1);
        try {
            this.loadTransformation();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void addOutputMappingDefinitionTab(MappingIODefinition definition, int index) {
        this.addMappingDefinitionTab(definition, index + 1, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.OutputTab.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.OutputTab.Tooltip", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.OutputTab.column.SourceField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.OutputTab.column.TargetField", (String[])new String[0]), false);
    }

    private void addInputMappingDefinitionTab(MappingIODefinition definition, int index) {
        this.addMappingDefinitionTab(definition, index + 1, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.InputTab.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.InputTab.Tooltip", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.InputTab.column.SourceField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.InputTab.column.TargetField", (String[])new String[0]), true);
    }

    private void addParametersTab(MappingParameters parameters) {
        CTabItem wParametersTab = new CTabItem(this.wTabFolder, 0);
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.Title", (String[])new String[0]));
        wParametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.Tooltip", (String[])new String[0]));
        Composite wParametersComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wParametersComposite);
        FormLayout parameterTabLayout = new FormLayout();
        parameterTabLayout.marginWidth = 15;
        parameterTabLayout.marginHeight = 15;
        wParametersComposite.setLayout((Layout)parameterTabLayout);
        Button wInheritAll = new Button(wParametersComposite, 32);
        wInheritAll.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.InheritAll", (String[])new String[0]));
        this.props.setLook((Control)wInheritAll);
        FormData fdInheritAll = new FormData();
        fdInheritAll.bottom = new FormAttachment(100, 0);
        fdInheritAll.left = new FormAttachment(0, 0);
        fdInheritAll.right = new FormAttachment(100, -30);
        wInheritAll.setLayoutData((Object)fdInheritAll);
        wInheritAll.setSelection(parameters.isInheritingAllVariables());
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.column.Variable", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.column.ValueOrField", (String[])new String[0]), 1, false, false)};
        colinfo[1].setUsingVariables(true);
        TableView wMappingParameters = new TableView((VariableSpace)this.transMeta, wParametersComposite, 67588, colinfo, parameters.getVariable().length, false, this.lsMod, this.props, false);
        this.props.setLook((Control)wMappingParameters);
        FormData fdMappings = new FormData();
        fdMappings.left = new FormAttachment(0, 0);
        fdMappings.right = new FormAttachment(100, 0);
        fdMappings.top = new FormAttachment(0, 0);
        fdMappings.bottom = new FormAttachment((Control)wInheritAll, -10);
        wMappingParameters.setLayoutData(fdMappings);
        wMappingParameters.getTable().addListener(11, (Listener)new ColumnsResizer(0, 50, 50));
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            TableItem tableItem = wMappingParameters.table.getItem(i);
            tableItem.setText(1, parameters.getVariable()[i]);
            tableItem.setText(2, parameters.getInputField()[i]);
        }
        wMappingParameters.setRowNums();
        wMappingParameters.optWidth(true);
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wParametersComposite.setLayoutData((Object)fdParametersComposite);
        wParametersComposite.layout();
        wParametersTab.setControl((Control)wParametersComposite);
        this.changeList.add(new MappingParametersTab(wMappingParameters, wInheritAll, parameters));
    }

    public static String[] getMappingSteps(TransMeta mappingTransMeta, boolean mappingInput) {
        ArrayList<StepMeta> steps = new ArrayList<StepMeta>();
        for (StepMeta stepMeta : mappingTransMeta.getSteps()) {
            if (mappingInput && stepMeta.getStepID().equals("MappingInput")) {
                steps.add(stepMeta);
            }
            if (mappingInput || !stepMeta.getStepID().equals("MappingOutput")) continue;
            steps.add(stepMeta);
        }
        String[] stepnames = new String[steps.size()];
        for (int i = 0; i < stepnames.length; ++i) {
            stepnames[i] = ((StepMeta)steps.get(i)).getName();
        }
        return stepnames;
    }

    public RowMetaInterface getFieldsFromStep(boolean parent, boolean input) throws KettleException {
        if (input) {
            if (parent) {
                return this.transMeta.getPrevStepFields(this.stepMeta);
            }
            if (this.mappingTransMeta == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Exception.NoMappingSpecified", (String[])new String[0]));
            }
            StepMeta mappingInputStepMeta = this.mappingTransMeta.findMappingInputStep(null);
            return this.mappingTransMeta.getStepFields(mappingInputStepMeta);
        }
        StepMeta mappingOutputStepMeta = this.mappingTransMeta.findMappingOutputStep(null);
        return this.mappingTransMeta.getStepFields(mappingOutputStepMeta);
    }

    private void addMappingDefinitionTab(final MappingIODefinition definition, int index, String tabTitle, String tabTooltip, String sourceColumnLabel, String targetColumnLabel, final boolean input) {
        CTabItem wTab = index >= this.wTabFolder.getItemCount() ? new CTabItem(this.wTabFolder, 64) : new CTabItem(this.wTabFolder, 64, index);
        this.setMappingDefinitionTabNameAndToolTip(wTab, tabTitle, tabTooltip, definition, input);
        Composite wInputComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        Button wbEnterMapping = new Button(wInputComposite, 8);
        this.props.setLook((Control)wbEnterMapping);
        if (input) {
            wbEnterMapping.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.button.EnterMapping", (String[])new String[0]));
        } else {
            wbEnterMapping.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.button.GetFields", (String[])new String[0]));
        }
        FormData fdbEnterMapping = new FormData();
        fdbEnterMapping.bottom = new FormAttachment(100);
        fdbEnterMapping.right = new FormAttachment(100);
        wbEnterMapping.setLayoutData((Object)fdbEnterMapping);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(sourceColumnLabel, 1, false, false), new ColumnInfo(targetColumnLabel, 1, false, false)};
        final TableView wFieldMappings = new TableView((VariableSpace)this.transMeta, wInputComposite, 67588, colinfo, 1, false, this.lsMod, this.props, false);
        this.props.setLook((Control)wFieldMappings);
        FormData fdMappings = new FormData();
        fdMappings.left = new FormAttachment(0);
        fdMappings.right = new FormAttachment(100);
        fdMappings.top = new FormAttachment(0);
        fdMappings.bottom = new FormAttachment((Control)wbEnterMapping, -10);
        wFieldMappings.setLayoutData(fdMappings);
        wFieldMappings.getTable().addListener(11, (Listener)new ColumnsResizer(0, 50, 50));
        for (MappingValueRename valueRename : definition.getValueRenames()) {
            TableItem tableItem = new TableItem(wFieldMappings.table, 0);
            tableItem.setText(1, Const.NVL((String)valueRename.getSourceValueName(), (String)""));
            tableItem.setText(2, Const.NVL((String)valueRename.getTargetValueName(), (String)""));
        }
        wFieldMappings.removeEmptyRows();
        wFieldMappings.setRowNums();
        wFieldMappings.optWidth(true);
        wbEnterMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    if (input) {
                        RowMetaInterface sourceRowMeta = SimpleMappingDialog.this.getFieldsFromStep(true, input);
                        RowMetaInterface targetRowMeta = SimpleMappingDialog.this.getFieldsFromStep(false, input);
                        String[] sourceFields = sourceRowMeta.getFieldNames();
                        String[] targetFields = targetRowMeta.getFieldNames();
                        EnterMappingDialog dialog = new EnterMappingDialog(SimpleMappingDialog.this.shell, sourceFields, targetFields);
                        List<SourceToTargetMapping> mappings = dialog.open();
                        if (mappings != null) {
                            wFieldMappings.clearAll(false);
                            definition.getValueRenames().clear();
                            for (int i = 0; i < mappings.size(); ++i) {
                                SourceToTargetMapping mapping = mappings.get(i);
                                TableItem item = new TableItem(wFieldMappings.table, 0);
                                item.setText(1, mapping.getSourceString(sourceFields));
                                item.setText(2, mapping.getTargetString(targetFields));
                                String source = input ? item.getText(1) : item.getText(2);
                                String target = input ? item.getText(2) : item.getText(1);
                                definition.getValueRenames().add(new MappingValueRename(source, target));
                            }
                            wFieldMappings.removeEmptyRows();
                            wFieldMappings.setRowNums();
                            wFieldMappings.optWidth(true);
                        }
                    } else {
                        RowMetaInterface sourceRowMeta = SimpleMappingDialog.this.getFieldsFromStep(true, input);
                        BaseStepDialog.getFieldsFromPrevious(sourceRowMeta, wFieldMappings, 1, new int[]{1}, new int[0], -1, -1, null);
                    }
                }
                catch (KettleException e) {
                    new ErrorDialog(SimpleMappingDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SimpleMappingDialog.Exception.ErrorGettingMappingSourceAndTargetFields", (String[])new String[]{e.toString()}), (Exception)((Object)e));
                }
            }
        });
        if (input) {
            Button wRenameOutput = new Button(wInputComposite, 32);
            this.props.setLook((Control)wRenameOutput);
            wRenameOutput.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.input.RenamingOnOutput", (String[])new String[0]));
            FormData fdRenameOutput = new FormData();
            fdRenameOutput.top = new FormAttachment((Control)wFieldMappings, 10);
            fdRenameOutput.left = new FormAttachment(0, 0);
            wRenameOutput.setLayoutData((Object)fdRenameOutput);
            wRenameOutput.setSelection(definition.isRenamingOnOutput());
            wRenameOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    definition.setRenamingOnOutput(!definition.isRenamingOnOutput());
                }
            });
        }
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wInputComposite.setLayoutData((Object)fdParametersComposite);
        wInputComposite.layout();
        wTab.setControl((Control)wInputComposite);
        MappingDefinitionTab applyChanges = new MappingDefinitionTab(definition, wFieldMappings);
        this.changeList.add(applyChanges);
        this.wTabFolder.setSelection(wTab);
    }

    private void setMappingDefinitionTabNameAndToolTip(CTabItem wTab, String tabTitle, String tabTooltip, MappingIODefinition definition, boolean input) {
        String stepname = input ? definition.getInputStepname() : definition.getOutputStepname();
        String description = definition.getDescription();
        if (Utils.isEmpty((CharSequence)stepname)) {
            wTab.setText(tabTitle);
        } else {
            wTab.setText(tabTitle + " : " + stepname);
        }
        String tooltip = tabTooltip;
        if (!Utils.isEmpty((CharSequence)stepname)) {
            tooltip = tooltip + Const.CR + Const.CR + stepname;
        }
        if (!Utils.isEmpty((CharSequence)description)) {
            tooltip = tooltip + Const.CR + Const.CR + description;
        }
        wTab.setToolTipText(tooltip);
    }

    private void cancel() {
        this.stepname = null;
        this.mappingMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        try {
            this.loadTransformation();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorLoadingSpecifiedTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorLoadingSpecifiedTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.mappingMeta.setSpecificationMethod(this.getSpecificationMethod());
        switch (this.getSpecificationMethod()) {
            case FILENAME: {
                this.mappingMeta.setFileName(this.wPath.getText());
                this.mappingMeta.setDirectoryPath(null);
                this.mappingMeta.setTransName(null);
                this.mappingMeta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                String transName = transPath = this.wPath.getText();
                String directory = "";
                int index = transPath.lastIndexOf("/");
                if (index != -1) {
                    transName = transPath.substring(index + 1);
                    directory = transPath.substring(0, index);
                }
                this.mappingMeta.setDirectoryPath(directory);
                this.mappingMeta.setTransName(transName);
                this.mappingMeta.setFileName(null);
                this.mappingMeta.setTransObjectId(null);
            }
        }
        this.collectInformation();
        this.mappingMeta.setMappingParameters(this.mappingParameters);
        this.mappingMeta.setInputMapping(this.inputMapping);
        this.mappingMeta.setOutputMapping(this.outputMapping);
        this.mappingMeta.setChanged(true);
        this.dispose();
    }

    private void collectInformation() {
        for (ApplyChanges applyChanges : this.changeList) {
            applyChanges.applyChanges();
        }
    }

    ObjectId getReferenceObjectId() {
        return this.referenceObjectId;
    }

    private void setReferenceObjectId(ObjectId referenceObjectId) {
        this.referenceObjectId = referenceObjectId;
    }

    ObjectLocationSpecificationMethod getSpecificationMethod() {
        return this.specificationMethod;
    }

    private void setSpecificationMethod(ObjectLocationSpecificationMethod specificationMethod) {
        this.specificationMethod = specificationMethod;
    }

    private class MappingDefinitionTab
    implements ApplyChanges {
        private MappingIODefinition definition;
        private TableView wFieldMappings;

        public MappingDefinitionTab(MappingIODefinition definition, TableView fieldMappings) {
            this.definition = definition;
            this.wFieldMappings = fieldMappings;
        }

        @Override
        public void applyChanges() {
            int nrLines = this.wFieldMappings.nrNonEmpty();
            this.definition.getValueRenames().clear();
            for (int i = 0; i < nrLines; ++i) {
                TableItem item = this.wFieldMappings.getNonEmpty(i);
                this.definition.getValueRenames().add(new MappingValueRename(item.getText(1), item.getText(2)));
            }
        }
    }

    private class MappingParametersTab
    implements ApplyChanges {
        private TableView wMappingParameters;
        private MappingParameters parameters;
        private Button wInheritAll;

        public MappingParametersTab(TableView wMappingParameters, Button wInheritAll, MappingParameters parameters) {
            this.wMappingParameters = wMappingParameters;
            this.wInheritAll = wInheritAll;
            this.parameters = parameters;
        }

        @Override
        public void applyChanges() {
            int nrLines = this.wMappingParameters.nrNonEmpty();
            String[] variables = new String[nrLines];
            String[] inputFields = new String[nrLines];
            this.parameters.setVariable(variables);
            this.parameters.setInputField(inputFields);
            for (int i = 0; i < nrLines; ++i) {
                TableItem item = this.wMappingParameters.getNonEmpty(i);
                this.parameters.getVariable()[i] = item.getText(1);
                this.parameters.getInputField()[i] = item.getText(2);
            }
            this.parameters.setInheritingAllVariables(this.wInheritAll.getSelection());
        }
    }

    private static interface ApplyChanges {
        public void applyChanges();
    }
}

