/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.mappinginput;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mappinginput.MappingInputMeta;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class MappingInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = MappingInputMeta.class;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Button wUnspecified;
    private FormData fdUnspecified;
    private MappingInputMeta input;

    public MappingInputDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (MappingInputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingInputDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MappingInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"MappingInputDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.wUnspecified = new Button((Composite)this.shell, 32);
        this.wUnspecified.setText(BaseMessages.getString(PKG, (String)"MappingInputDialog.Unspecified.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wUnspecified);
        this.fdUnspecified = new FormData();
        this.fdUnspecified.left = new FormAttachment(0, 0);
        this.fdUnspecified.right = new FormAttachment(100, 0);
        this.fdUnspecified.bottom = new FormAttachment((Control)this.wOK, -margin * 2);
        this.wUnspecified.setLayoutData((Object)this.fdUnspecified);
        this.wUnspecified.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingInputDialog.this.input.setChanged();
            }
        });
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"MappingInputDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsRows = this.input.getFieldName().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MappingInputDialog.ColumnInfo.Name", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MappingInputDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"MappingInputDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MappingInputDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false)};
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wUnspecified, -margin * 2);
        this.wFields.setLayoutData(this.fdFields);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                MappingInputDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                MappingInputDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MappingInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MappingInputDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            if (this.input.getFieldName()[i] == null) continue;
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, this.input.getFieldName()[i]);
            String type = ValueMetaFactory.getValueMetaName((int)this.input.getFieldType()[i]);
            int length = this.input.getFieldLength()[i];
            int prec = this.input.getFieldPrecision()[i];
            if (type != null) {
                item.setText(2, type);
            }
            if (length >= 0) {
                item.setText(3, "" + length);
            }
            if (prec < 0) continue;
            item.setText(4, "" + prec);
        }
        this.wUnspecified.setSelection(this.input.isSelectingAndSortingUnspecifiedFields());
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        int nrfields = this.wFields.nrNonEmpty();
        this.input.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getFieldName()[i] = item.getText(1);
            this.input.getFieldType()[i] = ValueMetaFactory.getIdForValueMeta((String)item.getText(2));
            String slength = item.getText(3);
            String sprec = item.getText(4);
            this.input.getFieldLength()[i] = Const.toInt((String)slength, (int)-1);
            this.input.getFieldPrecision()[i] = Const.toInt((String)sprec, (int)-1);
        }
        this.input.setSelectingAndSortingUnspecifiedFields(this.wUnspecified.getSelection());
        this.dispose();
    }
}

