/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.partition.dialog.PartitionSchemaDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonSharedObjectDelegate;

public class SpoonPartitionsDelegate
extends SpoonSharedObjectDelegate {
    public SpoonPartitionsDelegate(Spoon spoon) {
        super(spoon);
    }

    public void newPartitioningSchema(TransMeta transMeta) {
        PartitionSchema partitionSchema = new PartitionSchema();
        PartitionSchemaDialog dialog = new PartitionSchemaDialog(this.spoon.getShell(), partitionSchema, transMeta.getPartitionSchemas(), transMeta.getDatabases(), (VariableSpace)transMeta);
        if (dialog.open()) {
            block7: {
                List partitions = transMeta.getPartitionSchemas();
                if (SpoonPartitionsDelegate.isDuplicate(partitions, (SharedObjectInterface)partitionSchema)) {
                    new ErrorDialog(this.spoon.getShell(), SpoonPartitionsDelegate.getMessage("Spoon.Dialog.ErrorSavingPartition.Title"), SpoonPartitionsDelegate.getMessage("Spoon.Dialog.ErrorSavingPartition.Message", partitionSchema.getName()), (Exception)((Object)new KettleException(SpoonPartitionsDelegate.getMessage("Spoon.Dialog.ErrorSavingPartition.NotUnique"))));
                    return;
                }
                partitions.add(partitionSchema);
                if (this.spoon.rep != null) {
                    try {
                        if (!this.spoon.rep.getSecurityProvider().isReadOnly()) {
                            this.spoon.rep.save((RepositoryElementInterface)partitionSchema, "Creation of initial version", null);
                            if (this.sharedObjectSyncUtil != null) {
                                this.sharedObjectSyncUtil.reloadTransformationRepositoryObjects(false);
                            }
                            break block7;
                        }
                        throw new KettleException(BaseMessages.getString((Class)PKG, (String)"Spoon.Dialog.Exception.ReadOnlyRepositoryUser", (String[])new String[0]));
                    }
                    catch (KettleException e) {
                        this.showSaveErrorDialog(partitionSchema, e);
                    }
                }
            }
            this.spoon.refreshTree();
        }
    }

    public void editPartitionSchema(TransMeta transMeta, PartitionSchema partitionSchema) {
        String originalName = partitionSchema.getName();
        PartitionSchemaDialog dialog = new PartitionSchemaDialog(this.spoon.getShell(), partitionSchema, transMeta.getPartitionSchemas(), transMeta.getDatabases(), (VariableSpace)transMeta);
        if (dialog.open()) {
            if (this.spoon.rep != null && partitionSchema.getObjectId() != null) {
                try {
                    this.saveSharedObjectToRepository(partitionSchema, null);
                    if (this.sharedObjectSyncUtil != null) {
                        this.sharedObjectSyncUtil.synchronizePartitionSchemas(partitionSchema, originalName);
                    }
                }
                catch (KettleException e) {
                    this.showSaveErrorDialog(partitionSchema, e);
                }
            }
            this.spoon.refreshTree();
        }
    }

    public void delPartitionSchema(TransMeta transMeta, PartitionSchema partitionSchema) {
        try {
            int idx = transMeta.getPartitionSchemas().indexOf(partitionSchema);
            transMeta.getPartitionSchemas().remove(idx);
            if (this.spoon.rep != null && partitionSchema.getObjectId() != null) {
                this.spoon.rep.deletePartitionSchema(partitionSchema.getObjectId());
                if (this.sharedObjectSyncUtil != null) {
                    this.sharedObjectSyncUtil.deletePartitionSchema(partitionSchema);
                }
            }
            this.spoon.refreshTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.spoon.getShell(), BaseMessages.getString((Class)PKG, (String)"Spoon.Dialog.ErrorDeletingClusterSchema.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"Spoon.Dialog.ErrorDeletingClusterSchema.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void showSaveErrorDialog(PartitionSchema partitionSchema, KettleException e) {
        new ErrorDialog(this.spoon.getShell(), BaseMessages.getString((Class)PKG, (String)"Spoon.Dialog.ErrorSavingPartition.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"Spoon.Dialog.ErrorSavingPartition.Message", (String[])new String[]{partitionSchema.getName()}), (Exception)((Object)e));
    }
}

