/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class SubjectDataBrowserDialog {
    private static Class<?> PKG = SubjectDataBrowserDialog.class;
    public static final int MAX_BINARY_STRING_PREVIEW_SIZE = 1000000;
    private Label wlSubjectMessage;
    private CCombo wSubject;
    private TableView wFields;
    private Button wClose;
    private Shell shell;
    private Map<String, List<Object[]>> dataMap;
    private Map<String, RowMetaInterface> metaMap;
    private PropsUI props;
    private String dialogTitle;
    private String subjectMessage;
    private LogChannelInterface log;
    private Shell parentShell;
    private String selectedSubject;
    private String[] subjects;

    public SubjectDataBrowserDialog(Shell parent, Map<String, RowMetaInterface> metaMap, Map<String, List<Object[]>> dataMap, String dialogTitle, String subjectMessage) {
        this.parentShell = parent;
        this.metaMap = metaMap;
        this.dataMap = dataMap;
        this.dialogTitle = dialogTitle;
        this.subjectMessage = subjectMessage;
        this.props = PropsUI.getInstance();
        this.subjects = metaMap.keySet().toArray(new String[metaMap.size()]);
        Arrays.sort(this.subjects);
        this.selectedSubject = "";
        if (!metaMap.isEmpty()) {
            this.selectedSubject = this.subjects[0];
        }
        this.log = new LogChannel((Object)"Subject Data Browser Dialog");
    }

    public void open() {
        this.shell = new Shell(this.parentShell, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.dialogTitle);
        if (this.addFields()) {
            return;
        }
        this.wClose = new Button((Composite)this.shell, 8);
        this.wClose.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        this.wClose.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SubjectDataBrowserDialog.this.close();
            }
        });
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wClose}, 4, null);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SubjectDataBrowserDialog.this.close();
            }
        });
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private boolean addFields() {
        int margin = 4;
        if (this.wlSubjectMessage == null) {
            this.wlSubjectMessage = new Label((Composite)this.shell, 16384);
            this.wlSubjectMessage.setText(this.subjectMessage);
            this.props.setLook((Control)this.wlSubjectMessage);
            FormData fdlFields = new FormData();
            fdlFields.left = new FormAttachment(0, 0);
            fdlFields.top = new FormAttachment(0, margin);
            this.wlSubjectMessage.setLayoutData((Object)fdlFields);
            this.wSubject = new CCombo((Composite)this.shell, 18440);
            this.wSubject.setItems(this.subjects);
            this.wSubject.setText(this.selectedSubject);
            this.props.setLook((Control)this.wSubject);
            FormData fdlSubject = new FormData();
            fdlSubject.left = new FormAttachment((Control)this.wlSubjectMessage, margin);
            fdlSubject.top = new FormAttachment((Control)this.wlSubjectMessage, 0, 0x1000000);
            this.wSubject.setLayoutData((Object)fdlSubject);
            this.wSubject.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    SubjectDataBrowserDialog.this.selectedSubject = SubjectDataBrowserDialog.this.wSubject.getText();
                    SubjectDataBrowserDialog.this.addFields();
                }
            });
        } else {
            this.wFields.dispose();
        }
        RowMetaInterface rowMeta = this.metaMap.get(this.selectedSubject);
        List<Object[]> buffer = this.dataMap.get(this.selectedSubject);
        if (buffer == null) {
            buffer = new ArrayList<Object[]>();
        }
        ColumnInfo[] colinf = new ColumnInfo[rowMeta.size()];
        for (int i = 0; i < rowMeta.size(); ++i) {
            ValueMetaInterface v = rowMeta.getValueMeta(i);
            colinf[i] = new ColumnInfo(v.getName(), 1, v.isNumeric());
            colinf[i].setToolTip(v.toStringMeta());
            colinf[i].setValueMeta(v);
        }
        this.wFields = new TableView((VariableSpace)new Variables(), (Composite)this.shell, 67586, colinf, 0, null, this.props);
        this.wFields.setShowingBlueNullValues(true);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wSubject, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(fdFields);
        for (int i = 0; i < buffer.size(); ++i) {
            TableItem item = i == 0 ? this.wFields.table.getItem(i) : new TableItem(this.wFields.table, 0);
            Object[] rowData = buffer.get(i);
            this.getDataForRow(item, rowMeta, rowData, i + 1);
        }
        if (!this.wFields.isDisposed()) {
            this.wFields.optWidth(true, 200);
        }
        this.shell.layout(true, true);
        return false;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    protected int getDataForRow(TableItem item, RowMetaInterface rowMeta, Object[] row, int lineNr) {
        String strNr;
        int nrErrors = 0;
        try {
            strNr = this.wFields.getNumberColumn().getValueMeta().getString((Object)new Long(lineNr));
        }
        catch (Exception e) {
            strNr = Integer.toString(lineNr);
        }
        item.setText(0, strNr);
        for (int c = 0; c < rowMeta.size(); ++c) {
            String show;
            ValueMetaInterface v = rowMeta.getValueMeta(c);
            try {
                show = v.getString(row[c]);
                if (v.isBinary() && show != null && show.length() > 1000000) {
                    show = show.substring(0, 1000000);
                }
            }
            catch (KettleValueException e) {
                if (++nrErrors < 25) {
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                show = null;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (++nrErrors < 25) {
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                show = null;
            }
            if (show != null) {
                item.setText(c + 1, show);
                item.setForeground(c + 1, GUIResource.getInstance().getColorBlack());
                continue;
            }
            item.setText(c + 1, "<null>");
            item.setForeground(c + 1, GUIResource.getInstance().getColorBlue());
        }
        return nrErrors;
    }

    private void close() {
        this.dispose();
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }
}

