/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.pig;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.bigdata.api.pig.PigResult;
import org.pentaho.bigdata.api.pig.PigService;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobListener;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.w3c.dom.Node;

@JobEntry(id="HadoopPigScriptExecutorPlugin", image="PIG.svg", name="HadoopPigScriptExecutorPlugin.Name", description="HadoopPigScriptExecutorPlugin.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", i18nPackageName="org.pentaho.di.job.entries.pig", documentationUrl="http://wiki.pentaho.com/display/EAI/Pig+Script+Executor")
public class JobEntryPigScriptExecutor
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public static final Class<?> PKG = JobEntryPigScriptExecutor.class;
    public static final String CLUSTER_NAME = "cluster_name";
    public static final String HDFS_HOSTNAME = "hdfs_hostname";
    public static final String HDFS_PORT = "hdfs_port";
    public static final String JOBTRACKER_HOSTNAME = "jobtracker_hostname";
    public static final String JOBTRACKER_PORT = "jobtracker_port";
    public static final String SCRIPT_FILE = "script_file";
    public static final String ENABLE_BLOCKING = "enable_blocking";
    public static final String LOCAL_EXECUTION = "local_execution";
    public static final String JOB_ENTRY_PIG_SCRIPT_EXECUTOR_ERROR_NO_PIG_SCRIPT_SPECIFIED = "JobEntryPigScriptExecutor.Error.NoPigScriptSpecified";
    public static final String JOB_ENTRY_PIG_SCRIPT_EXECUTOR_WARNING_LOCAL_EXECUTION = "JobEntryPigScriptExecutor.Warning.LocalExecution";
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    protected NamedCluster namedCluster;
    protected String m_scriptFile = "";
    protected boolean m_enableBlocking;
    protected boolean m_localExecution;
    protected Map<String, String> m_params = new HashMap<String, String>();

    public JobEntryPigScriptExecutor(NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester, NamedClusterServiceLocator namedClusterServiceLocator) {
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    private void loadClusterConfig(ObjectId id_jobentry, Repository rep, Node entrynode, IMetaStore metaStore) {
        boolean configLoaded = false;
        try {
            String clusterName = null;
            if (entrynode != null) {
                clusterName = XMLHandler.getTagValue((Node)entrynode, (String)CLUSTER_NAME);
            } else if (rep != null) {
                clusterName = rep.getJobEntryAttributeString(id_jobentry, CLUSTER_NAME);
            }
            if (!StringUtils.isEmpty((String)clusterName) && this.namedClusterService.contains(clusterName, metaStore)) {
                this.namedCluster = this.namedClusterService.read(clusterName, metaStore);
            }
            if (this.namedCluster != null) {
                configLoaded = true;
            }
        }
        catch (Throwable t) {
            this.logDebug(t.getMessage(), new Object[]{t});
        }
        if (!configLoaded) {
            this.namedCluster = this.namedClusterService.getClusterTemplate();
            if (entrynode != null) {
                this.namedCluster.setName(XMLHandler.getTagValue((Node)entrynode, (String)CLUSTER_NAME));
                this.namedCluster.setHdfsHost(XMLHandler.getTagValue((Node)entrynode, (String)HDFS_HOSTNAME));
                this.namedCluster.setHdfsPort(XMLHandler.getTagValue((Node)entrynode, (String)HDFS_PORT));
                this.namedCluster.setJobTrackerHost(XMLHandler.getTagValue((Node)entrynode, (String)JOBTRACKER_HOSTNAME));
                this.namedCluster.setJobTrackerPort(XMLHandler.getTagValue((Node)entrynode, (String)JOBTRACKER_PORT));
            } else if (rep != null) {
                try {
                    this.namedCluster.setName(rep.getJobEntryAttributeString(id_jobentry, CLUSTER_NAME));
                    this.namedCluster.setHdfsHost(rep.getJobEntryAttributeString(id_jobentry, HDFS_HOSTNAME));
                    this.namedCluster.setHdfsPort(rep.getJobEntryAttributeString(id_jobentry, HDFS_PORT));
                    this.namedCluster.setJobTrackerHost(rep.getJobEntryAttributeString(id_jobentry, JOBTRACKER_HOSTNAME));
                    this.namedCluster.setJobTrackerPort(rep.getJobEntryAttributeString(id_jobentry, JOBTRACKER_PORT));
                }
                catch (KettleException ke) {
                    this.logError(ke.getMessage(), ke);
                }
            }
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        if (this.namedCluster != null) {
            String namedClusterName = this.namedCluster.getName();
            if (!StringUtils.isEmpty((String)namedClusterName)) {
                retval.append("      ").append(XMLHandler.addTagValue((String)CLUSTER_NAME, (String)namedClusterName));
            }
            retval.append("    ").append(XMLHandler.addTagValue((String)HDFS_HOSTNAME, (String)this.namedCluster.getHdfsHost()));
            retval.append("    ").append(XMLHandler.addTagValue((String)HDFS_PORT, (String)this.namedCluster.getHdfsPort()));
            retval.append("    ").append(XMLHandler.addTagValue((String)JOBTRACKER_HOSTNAME, (String)this.namedCluster.getJobTrackerHost()));
            retval.append("    ").append(XMLHandler.addTagValue((String)JOBTRACKER_PORT, (String)this.namedCluster.getJobTrackerPort()));
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)SCRIPT_FILE, (String)this.m_scriptFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)ENABLE_BLOCKING, (boolean)this.m_enableBlocking));
        retval.append("    ").append(XMLHandler.addTagValue((String)LOCAL_EXECUTION, (boolean)this.m_localExecution));
        retval.append("    <script_parameters>").append(Const.CR);
        if (this.m_params != null) {
            for (String name : this.m_params.keySet()) {
                String value = this.m_params.get(name);
                if (Const.isEmpty((String)name) || Const.isEmpty((String)value)) continue;
                retval.append("      <parameter>").append(Const.CR);
                retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)name));
                retval.append("        ").append(XMLHandler.addTagValue((String)"value", (String)value));
                retval.append("      </parameter>").append(Const.CR);
            }
        }
        retval.append("    </script_parameters>").append(Const.CR);
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository repository, IMetaStore metaStore) throws KettleXMLException {
        super.loadXML(entrynode, databases, slaveServers);
        this.loadClusterConfig(null, this.rep, entrynode, metaStore);
        this.setRepository(repository);
        this.m_scriptFile = XMLHandler.getTagValue((Node)entrynode, (String)SCRIPT_FILE);
        this.m_enableBlocking = XMLHandler.getTagValue((Node)entrynode, (String)ENABLE_BLOCKING).equalsIgnoreCase("Y");
        this.m_localExecution = XMLHandler.getTagValue((Node)entrynode, (String)LOCAL_EXECUTION).equalsIgnoreCase("Y");
        this.m_params = new HashMap<String, String>();
        Node paramList = XMLHandler.getSubNode((Node)entrynode, (String)"script_parameters");
        if (paramList != null) {
            int numParams = XMLHandler.countNodes((Node)paramList, (String)"parameter");
            for (int i = 0; i < numParams; ++i) {
                Node paramNode = XMLHandler.getSubNodeByNr((Node)paramList, (String)"parameter", (int)i);
                String name = XMLHandler.getTagValue((Node)paramNode, (String)"name");
                String value = XMLHandler.getTagValue((Node)paramNode, (String)"value");
                this.m_params.put(name, value);
            }
        }
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        if (rep != null) {
            super.loadRep(rep, metaStore, id_jobentry, databases, slaveServers);
            this.loadClusterConfig(id_jobentry, rep, null, metaStore);
            this.setRepository(rep);
            this.setScriptFilename(rep.getJobEntryAttributeString(id_jobentry, SCRIPT_FILE));
            this.setEnableBlocking(rep.getJobEntryAttributeBoolean(id_jobentry, ENABLE_BLOCKING));
            this.setLocalExecution(rep.getJobEntryAttributeBoolean(id_jobentry, LOCAL_EXECUTION));
            this.m_params = new HashMap<String, String>();
            int numParams = rep.countNrJobEntryAttributes(id_jobentry, "param_name");
            if (numParams > 0) {
                for (int i = 0; i < numParams; ++i) {
                    String name = rep.getJobEntryAttributeString(id_jobentry, i, "param_name");
                    String value = rep.getJobEntryAttributeString(id_jobentry, i, "param_value");
                    this.m_params.put(name, value);
                }
            }
        } else {
            throw new KettleException("Unable to load from a repository. The repository is null.");
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        if (rep != null) {
            super.saveRep(rep, metaStore, id_job);
            if (this.namedCluster != null) {
                String namedClusterName = this.namedCluster.getName();
                if (!StringUtils.isEmpty((String)namedClusterName)) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), CLUSTER_NAME, namedClusterName);
                }
                rep.saveJobEntryAttribute(id_job, this.getObjectId(), HDFS_HOSTNAME, this.namedCluster.getHdfsHost());
                rep.saveJobEntryAttribute(id_job, this.getObjectId(), HDFS_PORT, this.namedCluster.getHdfsPort());
                rep.saveJobEntryAttribute(id_job, this.getObjectId(), JOBTRACKER_HOSTNAME, this.namedCluster.getJobTrackerHost());
                rep.saveJobEntryAttribute(id_job, this.getObjectId(), JOBTRACKER_PORT, this.namedCluster.getJobTrackerPort());
            }
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), SCRIPT_FILE, this.m_scriptFile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), ENABLE_BLOCKING, this.m_enableBlocking);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), LOCAL_EXECUTION, this.m_localExecution);
            if (this.m_params != null) {
                int i = 0;
                for (String name : this.m_params.keySet()) {
                    String value = this.m_params.get(name);
                    if (Const.isEmpty((String)name) || Const.isEmpty((String)value)) continue;
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "param_name", name);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "param_value", value);
                    ++i;
                }
            }
        } else {
            throw new KettleException("Unable to save to a repository. The repository is null.");
        }
    }

    public boolean evaluates() {
        return true;
    }

    public boolean getEnableBlocking() {
        return this.m_enableBlocking;
    }

    public void setEnableBlocking(boolean block) {
        this.m_enableBlocking = block;
    }

    public boolean getLocalExecution() {
        return this.m_localExecution;
    }

    public void setLocalExecution(boolean l) {
        this.m_localExecution = l;
    }

    public String getScriptFilename() {
        return this.m_scriptFile;
    }

    public void setScriptFilename(String filename) {
        this.m_scriptFile = filename;
    }

    public Map<String, String> getScriptParameters() {
        return this.m_params;
    }

    public void setScriptParameters(Map<String, String> params) {
        this.m_params = params;
    }

    public NamedCluster getNamedCluster() {
        return this.namedCluster;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        this.namedCluster = namedCluster;
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public RuntimeTestActionService getRuntimeTestActionService() {
        return this.runtimeTestActionService;
    }

    public RuntimeTester getRuntimeTester() {
        return this.runtimeTester;
    }

    public Result execute(final Result result, int arg1) throws KettleException {
        result.setNrErrors(0L);
        if (Const.isEmpty((String)this.m_scriptFile)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)JOB_ENTRY_PIG_SCRIPT_EXECUTOR_ERROR_NO_PIG_SCRIPT_SPECIFIED, (String[])new String[0]));
        }
        try {
            PigService.ExecutionMode execMode;
            String scriptFileS = this.m_scriptFile;
            scriptFileS = this.environmentSubstitute(scriptFileS);
            final PigService pigService = (PigService)this.namedClusterServiceLocator.getService(this.namedCluster, PigService.class);
            if (this.m_localExecution && !pigService.isLocalExecutionSupported()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)JOB_ENTRY_PIG_SCRIPT_EXECUTOR_WARNING_LOCAL_EXECUTION, (String[])new String[0]));
            }
            Properties properties = new Properties();
            final ArrayList<String> paramList = new ArrayList<String>();
            if (this.m_params != null) {
                for (Map.Entry<String, String> entry : this.m_params.entrySet()) {
                    String name = entry.getKey();
                    name = this.environmentSubstitute(name);
                    String value = entry.getValue();
                    value = this.environmentSubstitute(value);
                    paramList.add(name + "=" + value);
                }
            }
            PigService.ExecutionMode executionMode = execMode = this.m_localExecution ? PigService.ExecutionMode.LOCAL : PigService.ExecutionMode.MAPREDUCE;
            if (this.m_enableBlocking) {
                PigResult pigResult = pigService.executeScript(scriptFileS, execMode, paramList, this.getName(), this.getLogChannel(), (VariableSpace)this, this.parentJob.getLogLevel());
                this.processScriptExecutionResult(pigResult, result);
            } else {
                final String finalScriptFileS = scriptFileS;
                final Thread runThread = new Thread(){

                    @Override
                    public void run() {
                        PigResult pigResult = pigService.executeScript(finalScriptFileS, execMode, paramList, this.getName(), JobEntryPigScriptExecutor.this.getLogChannel(), (VariableSpace)JobEntryPigScriptExecutor.this, JobEntryPigScriptExecutor.this.parentJob.getLogLevel());
                        JobEntryPigScriptExecutor.this.processScriptExecutionResult(pigResult, result);
                    }
                };
                runThread.start();
                this.parentJob.addJobListener(new JobListener(){

                    public void jobStarted(Job job) throws KettleException {
                    }

                    public void jobFinished(Job job) throws KettleException {
                        if (runThread.isAlive()) {
                            JobEntryPigScriptExecutor.this.logMinimal(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.Warning.AsynctaskStillRunning", (String[])new String[]{JobEntryPigScriptExecutor.this.getName(), job.getJobname()}));
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result.setStopped(true);
            result.setNrErrors(1L);
            result.setResult(false);
            this.logError(ex.getMessage(), ex);
        }
        return result;
    }

    protected void processScriptExecutionResult(PigResult pigResult, Result result) {
        FileObject logFile;
        int[] executionStatus = pigResult.getResult();
        Exception pigResultException = pigResult.getException();
        if (executionStatus != null) {
            this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.JobCompletionStatus", (String[])new String[]{"" + executionStatus[0], "" + executionStatus[1]}));
            if (executionStatus[1] > 0) {
                result.setStopped(true);
                result.setNrErrors((long)executionStatus[1]);
                result.setResult(false);
            }
        } else if (pigResultException != null) {
            this.logError(pigResultException.getMessage(), pigResultException);
            result.setStopped(true);
            result.setNrErrors(1L);
            result.setResult(false);
        }
        if ((logFile = pigResult.getLogFile()) != null) {
            ResultFile resultFile = new ResultFile(1, logFile, this.parentJob.getJobname(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
        }
    }

    @VisibleForTesting
    void setLog(LogChannelInterface log) {
        this.log = log;
    }
}

