/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.daemon.spark.executor.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.pentaho.pdi.engine.daemon.app.service.DaemonConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkConfigGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SparkConfigGenerator.class);
    private DaemonConfiguration config;

    public SparkConfigGenerator(DaemonConfiguration config) {
        this.config = config;
    }

    public void createSparkDefaults(File confDir, List<String> jars) {
        try {
            boolean overwriteConfig = this.config.getOverwriteConfig();
            if (confDir.exists()) {
                if (overwriteConfig) {
                    FileUtils.deleteDirectory((File)confDir);
                } else {
                    return;
                }
            }
            confDir.mkdirs();
            File conf = new File(confDir, "spark-defaults.conf");
            conf.createNewFile();
            Properties properties = new Properties();
            File launcher = new File(this.config.getSparkApp());
            String dataIntegration = launcher.getAbsolutePath().replace("\\", "/");
            properties.put("spark.driver.memory", this.config.getSparkDriverMemory());
            properties.put("spark.driver.extraJavaOptions", this.driverExtraJavaOptions(dataIntegration));
            properties.put("spark.executor.memory", this.config.getSparkExecutorMemory());
            properties.put("spark.yarn.dist.archives", this.config.getAssemblyZip());
            properties.put("spark.executor.extraJavaOptions", this.executorExtraJavaOptions(dataIntegration));
            properties.put("spark.jars", jars.stream().collect(Collectors.joining(",")));
            FileOutputStream outputStream = new FileOutputStream(conf);
            properties.store(outputStream, "Spark Configuration");
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create Kettle Conf for Spark.", e);
        }
    }

    private Object executorExtraJavaOptions(String dataIntegration) {
        StringBuilder sb = new StringBuilder();
        sb.append("-DisExecutor=true").append(" ");
        sb.append("-Djava.library.path=" + dataIntegration + "/libswt/win64");
        sb.append(" ").append(this.config.getSparkExecutorExtraJavaOptions());
        if (this.config.getExecutorDebugPort() > -1) {
            sb.append(" -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=" + (this.config.suspendDebug() ? "y" : "n") + ",address=" + this.config.getExecutorDebugPort());
        }
        return sb.toString();
    }

    private String driverExtraJavaOptions(String dataIntegration) {
        StringBuilder sb = new StringBuilder();
        sb.append("-Duser.dir=" + dataIntegration).append(" ");
        sb.append("-Djava.library.path=" + dataIntegration + "/libswt/win64");
        this.appendSecurityExtraOpts(sb);
        sb.append(" ").append(this.config.getSparkDriverExtraJavaOptions());
        if (this.config.getDriverDebugPort() > -1) {
            sb.append(" -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=" + (this.config.suspendDebug() ? "y" : "n") + ",address=" + this.config.getDriverDebugPort());
        }
        return sb.toString();
    }

    private void appendSecurityExtraOpts(StringBuilder sb) {
        String jaasConf = this.config.getDaemonHome() + "/jaas/jaas.conf";
        if (new File(jaasConf).exists()) {
            sb.append(" -Djava.security.auth.login.config=" + jaasConf).append(" -Dsun.security.krb5.debug=true");
        }
    }

    public void copyLog4jProperties(File confDir) {
        try {
            File source = new File(this.config.getSparkHome() + "/conf", "log4j.properties");
            if (source.exists()) {
                FileUtils.copyFileToDirectory((File)source, (File)confDir);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to copy log4j.properties file.", (Throwable)e);
        }
    }
}

