/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.tcp;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.aries.rsa.provider.fastbin.api.AsyncCallback;
import org.apache.aries.rsa.provider.fastbin.api.SerializationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.AbstractInvocationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.ResponseFuture;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingInvocationStrategy
extends AbstractInvocationStrategy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BlockingInvocationStrategy.class);
    private static final Callable<Object> EMPTY_CALLABLE = new Callable<Object>(){

        @Override
        public Object call() {
            return null;
        }
    };

    @Override
    protected ResponseFuture createResponse(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object[] args) throws Exception {
        return new BlockingResponseFuture(loader, method, serializationStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doService(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object target, DataByteArrayInputStream requestStream, DataByteArrayOutputStream responseStream, Runnable onComplete) {
        int pos = responseStream.position();
        try {
            Object value = null;
            Throwable error = null;
            try {
                Class<?>[] types = method.getParameterTypes();
                Object[] args = new Object[types.length];
                serializationStrategy.decodeRequest(loader, types, requestStream, args);
                value = method.invoke(target, args);
                if (this.isStream(method.getReturnType())) {
                    value = this.replaceStream(value);
                }
            }
            catch (Throwable t) {
                error = t instanceof InvocationTargetException ? t.getCause() : t;
            }
            serializationStrategy.encodeResponse(loader, method.getReturnType(), value, error, responseStream);
        }
        catch (Exception e) {
            LOGGER.warn("Initial Encoding response for method " + method + " failed. Retrying", (Throwable)e);
            try {
                responseStream.position(pos);
                serializationStrategy.encodeResponse(loader, method.getReturnType(), null, new RemoteException(e.toString()), responseStream);
            }
            catch (Exception unexpected) {
                LOGGER.error("Error while servicing " + method, (Throwable)unexpected);
            }
        }
        finally {
            onComplete.run();
        }
    }

    private class BlockingResponseFuture
    extends FutureTask<Object>
    implements ResponseFuture,
    AsyncCallback {
        private final ClassLoader loader;
        private final Method method;
        private final SerializationStrategy serializationStrategy;

        public BlockingResponseFuture(ClassLoader loader, Method method, SerializationStrategy serializationStrategy) {
            super(EMPTY_CALLABLE);
            this.loader = loader;
            this.method = method;
            this.serializationStrategy = serializationStrategy;
        }

        @Override
        public void set(DataByteArrayInputStream source) throws IOException, ClassNotFoundException {
            try {
                this.serializationStrategy.decodeResponse(this.loader, this.method.getReturnType(), source, this);
            }
            catch (Throwable e) {
                super.setException(e);
            }
        }

        @Override
        public void fail(Throwable failure) {
            super.setException(failure);
        }

        public void onSuccess(Object result) {
            super.set(result);
        }

        @Override
        public void onFailure(Throwable failure) {
            super.setException(failure);
        }
    }
}

