/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.aries.rsa.provider.fastbin.Activator;
import org.apache.aries.rsa.provider.fastbin.streams.Chunk;
import org.apache.aries.rsa.provider.fastbin.streams.StreamProvider;

public class InputStreamProxy
extends InputStream
implements Serializable {
    private static final long serialVersionUID = 4741860068546150748L;
    private int streamID;
    private String address;
    private transient StreamProvider streamProvider;
    private transient byte[] buffer;
    private transient int position;
    private transient int expectedChunkNumber = 0;
    private transient boolean reachedEnd = false;

    public InputStreamProxy(int streamID, String address) {
        this.streamID = streamID;
        this.address = address;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.readInternal();
        }
        catch (IOException e) {
            this.closeSilent();
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return super.read(b, off, len);
        }
        catch (IOException e) {
            this.closeSilent();
            throw e;
        }
    }

    public int readInternal() throws IOException {
        if (this.buffer == null || this.position == this.buffer.length) {
            this.fillBuffer();
        }
        if (this.position == this.buffer.length) {
            if (this.reachedEnd) {
                return -1;
            }
            return this.read();
        }
        return this.buffer[this.position++];
    }

    private void fillBuffer() throws IOException {
        if (this.reachedEnd) {
            return;
        }
        this.position = 0;
        Chunk chunk = this.streamProvider.read(this.streamID);
        if (this.expectedChunkNumber != chunk.getChunkNumber()) {
            throw new IOException("Stream corrupted. Received Chunk " + chunk.getChunkNumber() + " but expected " + this.expectedChunkNumber);
        }
        ++this.expectedChunkNumber;
        this.buffer = chunk.getData();
        this.reachedEnd = chunk.isLast();
    }

    public int readInternal(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int available = this.available();
        if (available <= 0) {
            if (this.reachedEnd) {
                return -1;
            }
            this.fillBuffer();
            return this.read(b, off, len);
        }
        int processed = 0;
        int ready = Math.min(available, len);
        System.arraycopy(this.buffer, this.position, b, off, ready);
        this.position += ready;
        if ((processed += ready) == len) {
            return processed;
        }
        int alsoRead = Math.max(0, this.read(b, off + processed, len - processed));
        return processed + alsoRead;
    }

    @Override
    public int available() throws IOException {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length - this.position;
    }

    @Override
    public void close() throws IOException {
        this.streamProvider.close(this.streamID);
    }

    private void closeSilent() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        InvocationHandler handler = Activator.getInstance().getClient().getProxy(this.address, "stream-provider", this.getClass().getClassLoader());
        this.streamProvider = (StreamProvider)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{StreamProvider.class}, handler);
    }

    protected void setStreamProvider(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }
}

