/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseActivator
implements BundleActivator,
Runnable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BundleContext bundleContext;
    protected ExecutorService executor = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private AtomicBoolean scheduled = new AtomicBoolean();
    private long schedulerStopTimeout = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    private List<ServiceRegistration> registrations;
    private ServiceRegistration managedServiceRegistration;
    private Dictionary<String, ?> configuration;

    public long getSchedulerStopTimeout() {
        return this.schedulerStopTimeout;
    }

    public void setSchedulerStopTimeout(long schedulerStopTimeout) {
        this.schedulerStopTimeout = schedulerStopTimeout;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.scheduled.set(true);
        this.doOpen();
        this.scheduled.set(false);
        if (this.managedServiceRegistration == null) {
            try {
                this.doStart();
            }
            catch (Exception e) {
                this.logger.warn("Error starting activator", (Throwable)e);
                this.doStop();
            }
        } else {
            this.reconfigure();
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.scheduled.set(true);
        this.doClose();
        this.executor.shutdown();
        this.executor.awaitTermination(this.schedulerStopTimeout, TimeUnit.MILLISECONDS);
        this.doStop();
    }

    protected void doOpen() throws Exception {
        URL data = this.bundleContext.getBundle().getResource("OSGI-INF/karaf-tracker/" + this.getClass().getName());
        if (data != null) {
            Properties props = new Properties();
            try (InputStream is = data.openStream();){
                props.load(is);
            }
            for (String key : props.stringPropertyNames()) {
                if (!"pid".equals(key)) continue;
                this.manage(props.getProperty(key));
            }
        }
    }

    protected void doClose() {
        if (this.managedServiceRegistration != null) {
            this.managedServiceRegistration.unregister();
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() {
        if (this.registrations != null) {
            for (ServiceRegistration reg : this.registrations) {
                reg.unregister();
            }
            this.registrations = null;
        }
    }

    protected void manage(String pid) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", pid);
        this.managedServiceRegistration = this.bundleContext.registerService("org.osgi.service.cm.ManagedService", (Object)this, props);
    }

    public void updated(Dictionary<String, ?> properties) {
        this.configuration = properties;
        this.reconfigure();
    }

    protected Dictionary<String, ?> getConfiguration() {
        return this.configuration;
    }

    protected int getInt(String key, int def) {
        if (this.configuration != null) {
            Object val = this.configuration.get(key);
            if (val instanceof Number) {
                return ((Number)val).intValue();
            }
            if (val != null) {
                return Integer.parseInt(val.toString());
            }
        }
        return def;
    }

    protected boolean getBoolean(String key, boolean def) {
        if (this.configuration != null) {
            Object val = this.configuration.get(key);
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            if (val != null) {
                return Boolean.parseBoolean(val.toString());
            }
        }
        return def;
    }

    protected long getLong(String key, long def) {
        if (this.configuration != null) {
            Object val = this.configuration.get(key);
            if (val instanceof Number) {
                return ((Number)val).longValue();
            }
            if (val != null) {
                return Long.parseLong(val.toString());
            }
        }
        return def;
    }

    protected String getString(String key, String def) {
        Object val;
        if (this.configuration != null && (val = this.configuration.get(key)) != null) {
            return val.toString();
        }
        return def;
    }

    protected void reconfigure() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.executor.submit(this);
        }
    }

    @Override
    public void run() {
        this.scheduled.set(false);
        this.doStop();
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.logger.warn("Error starting activator", (Throwable)e);
            this.doStop();
        }
    }

    protected <T> void register(Class<T> clazz, T service) {
        this.register(clazz, service, null);
    }

    protected <T> void register(Class<T> clazz, T service, Dictionary<String, ?> props) {
        this.trackRegistration(this.bundleContext.registerService(clazz, service, props));
    }

    protected void register(Class[] clazz, Object service) {
        this.register(clazz, service, null);
    }

    protected void register(Class[] clazz, Object service, Dictionary<String, ?> props) {
        String[] names = new String[clazz.length];
        for (int i = 0; i < clazz.length; ++i) {
            names[i] = clazz[i].getName();
        }
        this.trackRegistration(this.bundleContext.registerService(names, service, props));
    }

    private void trackRegistration(ServiceRegistration registration) {
        if (this.registrations == null) {
            this.registrations = new ArrayList<ServiceRegistration>();
        }
        this.registrations.add(registration);
    }
}

