/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import org.apache.spark.sql.SparkSession;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.engine.spark.SystemManager;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.platform.servicecoordination.api.IServiceBarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkMain {
    private static final Logger LOG = LoggerFactory.getLogger(SparkMain.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SparkSession spark = null;
        int returnStatus = 1;
        try {
            spark = Util.getSparkSession();
        }
        catch (Exception e) {
            LOG.error("Failure while getting SparkSession.", (Throwable)e);
            System.exit(returnStatus);
        }
        String serviceId = args[0];
        LOG.info("Executing Service ID: " + serviceId);
        System.setProperty("PDI_SPARK_EXECUTION_ID", serviceId);
        try {
            IServiceBarrier serviceBarrier = SystemManager.getInstance().getServiceBarrier();
            serviceBarrier.hold();
            serviceBarrier.awaitAvailability();
        }
        catch (InterruptedException ie) {
            LOG.debug("Service barrier released.");
            returnStatus = 0;
        }
        catch (Exception e) {
            LOG.error("Failed to retrieve a service barrier.  Possibly error in Kettle initialization", (Throwable)e);
        }
        finally {
            LOG.debug("Shutting down Spark session.");
            spark.stop();
            KettleEnvironment.shutdown();
            System.exit(returnStatus);
        }
    }
}

