/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLParserFactoryProducer;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.IPhysicalColumn;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.SqlDataSource;
import org.pentaho.metadata.model.SqlPhysicalColumn;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.security.RowLevelSecurity;
import org.pentaho.metadata.model.concept.security.Security;
import org.pentaho.metadata.model.concept.security.SecurityOwner;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.Alignment;
import org.pentaho.metadata.model.concept.types.Color;
import org.pentaho.metadata.model.concept.types.ColumnWidth;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.FieldType;
import org.pentaho.metadata.model.concept.types.Font;
import org.pentaho.metadata.model.concept.types.LocaleType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.concept.types.RelationshipType;
import org.pentaho.metadata.model.concept.types.TableType;
import org.pentaho.metadata.model.concept.types.TargetColumnType;
import org.pentaho.metadata.model.concept.types.TargetTableType;
import org.pentaho.metadata.model.olap.OlapAnnotation;
import org.pentaho.metadata.model.olap.OlapCalculatedMember;
import org.pentaho.metadata.model.olap.OlapCube;
import org.pentaho.metadata.model.olap.OlapDimension;
import org.pentaho.metadata.model.olap.OlapDimensionUsage;
import org.pentaho.metadata.model.olap.OlapHierarchy;
import org.pentaho.metadata.model.olap.OlapHierarchyLevel;
import org.pentaho.metadata.model.olap.OlapMeasure;
import org.pentaho.metadata.model.olap.OlapRole;
import org.pentaho.metadata.model.olap.util.OlapUtil;
import org.pentaho.metadata.util.ThinModelConverter;
import org.pentaho.metadata.util.Util;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.locale.LocaleInterface;
import org.pentaho.pms.locale.LocaleMeta;
import org.pentaho.pms.schema.RelationshipMeta;
import org.pentaho.pms.schema.concept.types.aggregation.AggregationSettings;
import org.pentaho.pms.schema.concept.types.aggregation.ConceptPropertyAggregationList;
import org.pentaho.pms.schema.concept.types.alignment.AlignmentSettings;
import org.pentaho.pms.schema.concept.types.color.ColorSettings;
import org.pentaho.pms.schema.concept.types.columnwidth.ColumnWidth;
import org.pentaho.pms.schema.concept.types.datatype.DataTypeSettings;
import org.pentaho.pms.schema.concept.types.fieldtype.FieldTypeSettings;
import org.pentaho.pms.schema.concept.types.font.ConceptPropertyFont;
import org.pentaho.pms.schema.concept.types.font.FontSettings;
import org.pentaho.pms.schema.concept.types.tabletype.TableTypeSettings;
import org.pentaho.pms.schema.security.RowLevelSecurity;
import org.pentaho.pms.util.Const;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmiParser {
    private static final Log logger = LogFactory.getLog(XmiParser.class);

    public String generateXmi(Domain domain) {
        if (domain == null) {
            logger.error((Object)Messages.getErrorString("XmiParser.ERROR_0001_DOMAIN_NULL", new Object[0]));
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult();
            result.setWriter(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Document doc = this.toXmiDocument(domain);
            if (doc != null) {
                factory.newTransformer().transform(new DOMSource(doc), result);
                return stringWriter.getBuffer().toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("XmiParser.ERROR_0002_TO_XML_FAILED", new Object[0]), (Throwable)e);
        }
        return null;
    }

    public Document toXmiDocument(Domain domain) {
        if (domain == null) {
            logger.error((Object)Messages.getErrorString("XmiParser.ERROR_0001_DOMAIN_NULL", new Object[0]));
            return null;
        }
        try {
            SqlPhysicalModel sqlModel;
            DocumentBuilderFactory dbf = XmiParser.createSecureDocBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element xmiElement = doc.createElement("XMI");
            xmiElement.setAttribute("xmlns:CWM", "org.omg.xmi.namespace.CWM");
            xmiElement.setAttribute("xmlns:CWMMDB", "org.omg.xmi.namespace.CWMMDB");
            xmiElement.setAttribute("xmlns:CWMOLAP", "org.omg.xmi.namespace.CWMOLAP");
            xmiElement.setAttribute("xmlns:CWMRDB", "org.omg.xmi.namespace.CWMRDB");
            xmiElement.setAttribute("xmlns:CWMTFM", "org.omg.xmi.namespace.CWMTFM");
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
            xmiElement.setAttribute("timestamp", sdf.format(date));
            xmiElement.setAttribute("xmi.version", "1.2");
            doc.appendChild(xmiElement);
            Element xmiHeader = doc.createElement("XMI.header");
            xmiElement.appendChild(xmiHeader);
            Element xmiDocumentation = doc.createElement("XMI.documentation");
            xmiHeader.appendChild(xmiDocumentation);
            this.addTextElement(doc, xmiDocumentation, "XMI.exporter", "Pentaho XMI Generator");
            this.addTextElement(doc, xmiDocumentation, "XMI.exporterVersion", "1.0");
            Element xmiContent = doc.createElement("XMI.content");
            xmiElement.appendChild(xmiContent);
            ArrayList<Element> allDescriptions = new ArrayList<Element>();
            IdGen idGen = new IdGen();
            for (Concept concept : domain.getConcepts()) {
                Element cwmClass = doc.createElement("CWM:Class");
                cwmClass.setAttribute("isAbstract", "false");
                cwmClass.setAttribute("name", concept.getId());
                String idStr = idGen.getNextId();
                this.createDescriptions(doc, concept, "CWM:Class", idStr, allDescriptions, idGen);
                cwmClass.setAttribute("xmi.id", idStr);
                if (concept.getParentConcept() != null) {
                    Element element = doc.createElement("CWM:ModelElement.taggedValue");
                    element.appendChild(this.createTaggedValue(doc, "CONCEPT_PARENT_NAME", concept.getParentConcept().getId(), idGen.getNextId()));
                    cwmClass.appendChild(element);
                }
                xmiContent.appendChild(cwmClass);
            }
            Element beforeDesc = null;
            Element eventModelElement = null;
            for (String key : domain.getChildProperties().keySet()) {
                if (!key.startsWith("LEGACY_EVENT_")) continue;
                if (eventModelElement == null) {
                    eventModelElement = doc.createElement("CWM:ModelElement.taggedValue");
                }
                String string = key.substring("LEGACY_EVENT_".length());
                eventModelElement.appendChild(this.createTaggedValue(doc, string, (String)domain.getChildProperties().get(key), idGen.getNextId()));
            }
            if (eventModelElement != null) {
                Element event = doc.createElement("CWM:Event");
                event.setAttribute("xmi.id", idGen.getNextId());
                event.setAttribute("name", "SECURITY_SERVICE");
                event.appendChild(eventModelElement);
                xmiContent.appendChild(event);
            }
            int val = 1;
            for (LocaleType localeType : domain.getLocales()) {
                Element cwmParameter = doc.createElement("CWM:Parameter");
                if (beforeDesc == null) {
                    beforeDesc = cwmParameter;
                }
                cwmParameter.setAttribute("name", localeType.getCode());
                cwmParameter.setAttribute("xmi.id", idGen.getNextId());
                Element modelElement = doc.createElement("CWM:ModelElement.taggedValue");
                modelElement.appendChild(this.createTaggedValue(doc, "LOCALE_IS_DEFAULT", "" + (val == 1 ? "Y" : "N"), idGen.getNextId()));
                modelElement.appendChild(this.createTaggedValue(doc, "LOCALE_ORDER", "" + val++, idGen.getNextId()));
                modelElement.appendChild(this.createTaggedValue(doc, "LOCALE_DESCRIPTION", localeType.getDescription(), idGen.getNextId()));
                cwmParameter.appendChild(modelElement);
                xmiContent.appendChild(cwmParameter);
            }
            this.generateOlapXmi(domain, doc, idGen, xmiContent);
            for (IPhysicalModel iPhysicalModel : domain.getPhysicalModels()) {
                if (iPhysicalModel.getId().equals("__MISSING_PARENT_PHYSICAL_MODEL__")) continue;
                if (iPhysicalModel instanceof SqlPhysicalModel) {
                    sqlModel = (SqlPhysicalModel)iPhysicalModel;
                    SqlDataSource datasource = sqlModel.getDatasource();
                    Element catalog = doc.createElement("CWMRDB:Catalog");
                    catalog.setAttribute("name", iPhysicalModel.getId());
                    catalog.setAttribute("xmi.id", idGen.getNextId());
                    Element modelElement = doc.createElement("CWM:ModelElement.taggedValue");
                    modelElement.appendChild(this.createTaggedValue(doc, "DATABASE_TYPE", datasource.getDialectType(), idGen.getNextId()));
                    modelElement.appendChild(this.createTaggedValue(doc, "DATABASE_ACCESS", datasource.getType().toString(), idGen.getNextId()));
                    modelElement.appendChild(this.createTaggedValue(doc, "DATABASE_DATABASE", datasource.getDatabaseName(), idGen.getNextId()));
                    modelElement.appendChild(this.createTaggedValue(doc, "DATABASE_SERVER", datasource.getHostname(), idGen.getNextId()));
                    modelElement.appendChild(this.createTaggedValue(doc, "DATABASE_PORT", datasource.getPort(), idGen.getNextId()));
                    modelElement.appendChild(this.createTaggedValue(doc, "DATABASE_USERNAME", datasource.getUsername(), idGen.getNextId()));
                    modelElement.appendChild(this.createTaggedValue(doc, "DATABASE_PASSWORD", datasource.getPassword(), idGen.getNextId()));
                    if (!StringUtils.isEmpty((String)datasource.getServername())) {
                        modelElement.appendChild(this.createTaggedValue(doc, "DATABASE_SERVER_INSTANCE", datasource.getServername(), idGen.getNextId()));
                    }
                    for (String attribute : datasource.getAttributes().keySet()) {
                        modelElement.appendChild(this.createTaggedValue(doc, "DATABASE_ATTRIBUTE_PREFIX_" + attribute, datasource.getAttributes().get(attribute), idGen.getNextId()));
                    }
                    catalog.appendChild(modelElement);
                    xmiContent.appendChild(catalog);
                    continue;
                }
                logger.warn((Object)Messages.getErrorString("XmiParser.ERROR_0003_PHYSICAL_MODEL_NOT_SUPPORTED", iPhysicalModel.getClass().getName()));
            }
            for (IPhysicalModel iPhysicalModel : domain.getPhysicalModels()) {
                if (!(iPhysicalModel instanceof SqlPhysicalModel)) continue;
                sqlModel = (SqlPhysicalModel)iPhysicalModel;
                for (SqlPhysicalTable table : sqlModel.getPhysicalTables()) {
                    Element cwmRdbTable = doc.createElement("CWMRDB:Table");
                    cwmRdbTable.setAttribute("isAbstract", "false");
                    cwmRdbTable.setAttribute("isSystem", "false");
                    cwmRdbTable.setAttribute("isTemporary", "false");
                    cwmRdbTable.setAttribute("name", table.getId());
                    Object idstr = idGen.getNextId();
                    cwmRdbTable.setAttribute("xmi.id", (String)idstr);
                    this.createDescriptions(doc, table, "CWMRDB:Table", (String)idstr, (List<Element>)allDescriptions, idGen);
                    Element modelElement = null;
                    if (!iPhysicalModel.getId().equals("__MISSING_PARENT_PHYSICAL_MODEL__")) {
                        modelElement = doc.createElement("CWM:ModelElement.taggedValue");
                        modelElement.appendChild(this.createTaggedValue(doc, "TABLE_TARGET_DATABASE_NAME", iPhysicalModel.getId(), idGen.getNextId()));
                    }
                    if (table.getParentConcept() != null) {
                        if (modelElement == null) {
                            modelElement = doc.createElement("CWM:ModelElement.taggedValue");
                        }
                        modelElement.appendChild(this.createTaggedValue(doc, "CONCEPT_PARENT_NAME", table.getParentConcept().getId(), idGen.getNextId()));
                    }
                    if (modelElement != null) {
                        cwmRdbTable.appendChild(modelElement);
                    }
                    Element ownedElement = doc.createElement("CWM:Namespace.ownedElement");
                    for (IPhysicalColumn column : table.getPhysicalColumns()) {
                        SqlPhysicalColumn sqlColumn = (SqlPhysicalColumn)column;
                        Element rdbColumn = doc.createElement("CWMRDB:Column");
                        rdbColumn.setAttribute("name", sqlColumn.getId());
                        idstr = idGen.getNextId();
                        rdbColumn.setAttribute("xmi.id", (String)idstr);
                        this.createDescriptions(doc, column, "CWMRDB:Column", (String)idstr, allDescriptions, idGen);
                        if (sqlColumn.getParentConcept() != null) {
                            modelElement = doc.createElement("CWM:ModelElement.taggedValue");
                            modelElement.appendChild(this.createTaggedValue(doc, "CONCEPT_PARENT_NAME", sqlColumn.getParentConcept().getId(), idGen.getNextId()));
                            rdbColumn.appendChild(modelElement);
                        }
                        ownedElement.appendChild(rdbColumn);
                    }
                    cwmRdbTable.appendChild(ownedElement);
                    xmiContent.appendChild(cwmRdbTable);
                }
            }
            for (LogicalModel logicalModel : domain.getLogicalModels()) {
                Element modelElement;
                Element mdbSchema = doc.createElement("CWMMDB:Schema");
                mdbSchema.setAttribute("name", logicalModel.getId());
                String idstr = idGen.getNextId();
                mdbSchema.setAttribute("xmi.id", idstr);
                this.createDescriptions(doc, logicalModel, "CWMMDB:Schema", idstr, allDescriptions, idGen);
                List cubes = (List)logicalModel.getProperty("olap_cubes");
                if (cubes != null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("<cubes>");
                    for (OlapCube cube : cubes) {
                        if (cube.getOlapCalculatedMembers() == null || cube.getOlapCalculatedMembers().size() <= 0) continue;
                        buffer.append("<cube>");
                        buffer.append(XMLHandler.addTagValue((String)"name", (String)cube.getName()));
                        buffer.append(OlapUtil.toXmlCalculatedMembers(cube.getOlapCalculatedMembers()));
                        buffer.append("</cube>");
                    }
                    buffer.append("</cubes>");
                    this.createDescription(doc, buffer.toString(), "olap_calculated_members", "String", null, idGen, "CWMMDB:Schema", idstr, allDescriptions);
                }
                Element ownedElement = doc.createElement("CWM:Namespace.ownedElement");
                mdbSchema.appendChild(ownedElement);
                for (Category category : logicalModel.getCategories()) {
                    Element extent = doc.createElement("CWM:Extent");
                    extent.setAttribute("name", category.getId());
                    idstr = idGen.getNextId();
                    extent.setAttribute("xmi.id", idstr);
                    this.createDescriptions(doc, category, "CWM:Extent", idstr, allDescriptions, idGen);
                    modelElement = doc.createElement("CWM:ModelElement.taggedValue");
                    modelElement.appendChild(this.createTaggedValue(doc, "BUSINESS_CATEGORY_ROOT", "Y", idGen.getNextId()));
                    if (category.getParentConcept() != null) {
                        modelElement.appendChild(this.createTaggedValue(doc, "CONCEPT_PARENT_NAME", category.getParentConcept().getId(), idGen.getNextId()));
                    }
                    extent.appendChild(modelElement);
                    Element cOwnedElement = doc.createElement("CWM:Namespace.ownedElement");
                    extent.appendChild(cOwnedElement);
                    for (LogicalColumn col : category.getLogicalColumns()) {
                        Element attribute = doc.createElement("CWM:Attribute");
                        attribute.setAttribute("name", col.getId());
                        attribute.setAttribute("xmi.id", idGen.getNextId());
                        modelElement = doc.createElement("CWM:ModelElement.taggedValue");
                        modelElement.appendChild(this.createTaggedValue(doc, "BUSINESS_CATEGORY_TYPE", "Column", idGen.getNextId()));
                        attribute.appendChild(modelElement);
                        cOwnedElement.appendChild(attribute);
                    }
                    ownedElement.appendChild(extent);
                }
                for (LogicalRelationship rel : logicalModel.getLogicalRelationships()) {
                    Element keyRel = doc.createElement("CWM:KeyRelationship");
                    keyRel.setAttribute("xmi.id", idGen.getNextId());
                    modelElement = doc.createElement("CWM:ModelElement.taggedValue");
                    keyRel.appendChild(modelElement);
                    modelElement.appendChild(this.createTaggedValue(doc, "RELATIONSHIP_TYPE", rel.getRelationshipType().getType(), idGen.getNextId()));
                    if (rel.getToColumn() != null) {
                        modelElement.appendChild(this.createTaggedValue(doc, "RELATIONSHIP_FIELDNAME_CHILD", rel.getToColumn().getId(), idGen.getNextId()));
                    }
                    if (rel.getFromColumn() != null) {
                        modelElement.appendChild(this.createTaggedValue(doc, "RELATIONSHIP_FIELDNAME_PARENT", rel.getFromColumn().getId(), idGen.getNextId()));
                    }
                    if (rel.getToTable() != null) {
                        modelElement.appendChild(this.createTaggedValue(doc, "RELATIONSHIP_TABLENAME_CHILD", rel.getToTable().getId(), idGen.getNextId()));
                    }
                    if (rel.getFromTable() != null) {
                        modelElement.appendChild(this.createTaggedValue(doc, "RELATIONSHIP_TABLENAME_PARENT", rel.getFromTable().getId(), idGen.getNextId()));
                    }
                    if (rel.isComplex().booleanValue()) {
                        modelElement.appendChild(this.createTaggedValue(doc, "RELATIONSHIP_IS_COMPLEX", "Y", idGen.getNextId()));
                        modelElement.appendChild(this.createTaggedValue(doc, "RELATIONSHIP_COMPLEX_JOIN", rel.getComplexJoin(), idGen.getNextId()));
                    }
                    if (rel.getDescription() != null) {
                        modelElement.appendChild(this.createTaggedValue(doc, "RELATIONSHIP_DESCRIPTION", rel.getRelationshipDescription(), idGen.getNextId()));
                    }
                    if (rel.getJoinOrderKey() != null) {
                        modelElement.appendChild(this.createTaggedValue(doc, "RELATIONSHIP_JOIN_ORDER_KEY", rel.getJoinOrderKey(), idGen.getNextId()));
                    }
                    ownedElement.appendChild(keyRel);
                }
                Element sdo = doc.createElement("CWMMDB:Schema.dimensionedObject");
                Element sd = doc.createElement("CWMMDB:Schema.dimension");
                mdbSchema.appendChild(sdo);
                mdbSchema.appendChild(sd);
                for (LogicalTable table : logicalModel.getLogicalTables()) {
                    Element dim = doc.createElement("CWMMDB:Dimension");
                    sd.appendChild(dim);
                    dim.setAttribute("isAbstract", "false");
                    dim.setAttribute("name", table.getId());
                    String tblidstr = idGen.getNextId();
                    dim.setAttribute("xmi.id", tblidstr);
                    this.createDescriptions(doc, table, "CWMMDB:Dimension", tblidstr, allDescriptions, idGen);
                    Element modelElement2 = doc.createElement("CWM:ModelElement.taggedValue");
                    if (table.getProperty("__LEGACY_TABLE_IS_DRAWN") != null) {
                        modelElement2.appendChild(this.createTaggedValue(doc, "TABLE_IS_DRAWN", (String)table.getProperty("__LEGACY_TABLE_IS_DRAWN"), idGen.getNextId()));
                    }
                    if (table.getProperty("__LEGACY_TAG_POSITION_Y") != null) {
                        modelElement2.appendChild(this.createTaggedValue(doc, "TAG_POSITION_Y", (String)table.getProperty("__LEGACY_TAG_POSITION_Y"), idGen.getNextId()));
                    }
                    if (table.getProperty("__LEGACY_TAG_POSITION_X") != null) {
                        modelElement2.appendChild(this.createTaggedValue(doc, "TAG_POSITION_X", (String)table.getProperty("__LEGACY_TAG_POSITION_X"), idGen.getNextId()));
                    }
                    if (table.getParentConcept() != null) {
                        modelElement2.appendChild(this.createTaggedValue(doc, "CONCEPT_PARENT_NAME", table.getParentConcept().getId(), idGen.getNextId()));
                    }
                    modelElement2.appendChild(this.createTaggedValue(doc, "BUSINESS_TABLE_PHYSICAL_TABLE_NAME", table.getPhysicalTable().getId(), idGen.getNextId()));
                    dim.appendChild(modelElement2);
                    Element dimObjs = doc.createElement("CWMMDB:Dimension.dimensionedObject");
                    dim.appendChild(dimObjs);
                    for (LogicalColumn column : table.getLogicalColumns()) {
                        Element dimObj = doc.createElement("CWMMDB:DimensionedObject");
                        sdo.appendChild(dimObj);
                        dimObj.setAttribute("name", column.getId());
                        idstr = idGen.getNextId();
                        this.createDescriptions(doc, column, "CWMMDB:DimensionedObject", idstr, allDescriptions, idGen);
                        dimObj.setAttribute("xmi.id", idstr);
                        modelElement2 = doc.createElement("CWM:ModelElement.taggedValue");
                        modelElement2.appendChild(this.createTaggedValue(doc, "BUSINESS_COLUMN_BUSINESS_TABLE", column.getLogicalTable().getId(), idGen.getNextId()));
                        modelElement2.appendChild(this.createTaggedValue(doc, "BUSINESS_COLUMN_PHYSICAL_COLUMN_NAME", column.getPhysicalColumn().getId(), idGen.getNextId()));
                        if (column.getParentConcept() != null) {
                            modelElement2.appendChild(this.createTaggedValue(doc, "CONCEPT_PARENT_NAME", column.getParentConcept().getId(), idGen.getNextId()));
                        }
                        dimObj.appendChild(modelElement2);
                        Element parentRoot = doc.createElement("CWMMDB:DimensionedObject.dimension");
                        Element parent = doc.createElement("CWMMDB:Dimension");
                        parent.setAttribute("xmi.idref", tblidstr);
                        dimObj.appendChild(parentRoot);
                        parentRoot.appendChild(parent);
                        Element dimObjLink = doc.createElement("CWMMDB:DimensionedObject");
                        dimObjLink.setAttribute("xmi.idref", idstr);
                        dimObjs.appendChild(dimObjLink);
                    }
                }
                if (logicalModel.getParentConcept() != null) {
                    Element modelElement3 = doc.createElement("CWM:ModelElement.taggedValue");
                    modelElement3.appendChild(this.createTaggedValue(doc, "CONCEPT_PARENT_NAME", logicalModel.getParentConcept().getId(), idGen.getNextId()));
                    mdbSchema.appendChild(modelElement3);
                }
                xmiContent.appendChild(mdbSchema);
            }
            for (Element element : allDescriptions) {
                xmiContent.insertBefore(element, beforeDesc);
            }
            return doc;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("QueryXmlHelper.ERROR_0002_TO_DOCUMENT_FAILED", new Object[0]), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateOlapXmi(Domain domain, Document doc, IdGen idGen, Element xmiContent) {
        for (LogicalModel model : domain.getLogicalModels()) {
            List dims = (List)model.getProperty("olap_dimensions");
            List cubes = (List)model.getProperty("olap_cubes");
            HashMap<OlapDimension, String> dimMap = new HashMap<OlapDimension, String>();
            HashMap<OlapDimensionUsage, String> dimUsageIdMap = new HashMap<OlapDimensionUsage, String>();
            HashMap<OlapDimension, ArrayList<OlapDimensionUsage>> dimUsageMap = new HashMap<OlapDimension, ArrayList<OlapDimensionUsage>>();
            if ((dims == null || dims.size() <= 0) && (cubes == null || cubes.size() <= 0)) continue;
            Element olapSchema = doc.createElement("CWMOLAP:Schema");
            olapSchema.setAttribute("name", model.getId());
            olapSchema.setAttribute("xmi.id", idGen.getNextId());
            if (cubes != null && cubes.size() > 0) {
                Element cubesElement = doc.createElement("CWMOLAP:Schema.cube");
                for (OlapCube cube : cubes) {
                    Element cubeElement = doc.createElement("CWMOLAP:Cube");
                    cubeElement.setAttribute("xmi.id", idGen.getNextId());
                    cubeElement.setAttribute("name", cube.getName());
                    cubeElement.setAttribute("isAbstract", "false");
                    cubeElement.setAttribute("isVirtual", "false");
                    cubesElement.appendChild(cubeElement);
                    Element modelElement = doc.createElement("CWM:ModelElement.taggedValue");
                    modelElement.appendChild(this.createTaggedValue(doc, "CUBE_BUSINESS_TABLE", cube.getLogicalTable().getId(), idGen.getNextId()));
                    cubeElement.appendChild(modelElement);
                    if (cube.getOlapMeasures() != null && cube.getOlapMeasures().size() > 0) {
                        Element ownedElement = doc.createElement("CWM:Namespace.ownedElement");
                        for (OlapMeasure olapMeasure : cube.getOlapMeasures()) {
                            Element measureElement = doc.createElement("CWMOLAP:Measure");
                            measureElement.setAttribute("xmi.id", idGen.getNextId());
                            measureElement.setAttribute("name", olapMeasure.getName());
                            Element measModelElement = doc.createElement("CWM:ModelElement.taggedValue");
                            measModelElement.appendChild(this.createTaggedValue(doc, "MEASURE_BUSINESS_COLUMN", olapMeasure.getLogicalColumn().getId(), idGen.getNextId()));
                            if (olapMeasure.isHidden()) {
                                measModelElement.appendChild(this.createTaggedValue(doc, "MEASURE_HIDDEN", olapMeasure.isHidden() + "", idGen.getNextId()));
                            }
                            measureElement.appendChild(measModelElement);
                            ownedElement.appendChild(measureElement);
                        }
                        cubeElement.appendChild(ownedElement);
                    }
                    if (cube.getOlapDimensionUsages() == null || cube.getOlapDimensionUsages().size() <= 0) continue;
                    Element cubeDimAssoc = doc.createElement("CWMOLAP:Cube.cubeDimensionAssociation");
                    for (OlapDimensionUsage olapDimensionUsage : cube.getOlapDimensionUsages()) {
                        Element assoc = doc.createElement("CWMOLAP:CubeDimensionAssociation");
                        assoc.setAttribute("isAbstract", "false");
                        String usageId = idGen.getNextId();
                        dimUsageIdMap.put(olapDimensionUsage, usageId);
                        ArrayList<OlapDimensionUsage> list = (ArrayList<OlapDimensionUsage>)dimUsageMap.get(olapDimensionUsage.getOlapDimension());
                        if (list == null) {
                            list = new ArrayList<OlapDimensionUsage>();
                            dimUsageMap.put(olapDimensionUsage.getOlapDimension(), list);
                        }
                        list.add(olapDimensionUsage);
                        assoc.setAttribute("xmi.id", usageId);
                        assoc.setAttribute("name", olapDimensionUsage.getName());
                        Element cda = doc.createElement("CWMOLAP:CubeDimensionAssociation.dimension");
                        Element dim = doc.createElement("CWMOLAP:Dimension");
                        String id = idGen.getNextId();
                        dimMap.put(olapDimensionUsage.getOlapDimension(), id);
                        dim.setAttribute("xmi.idref", id);
                        cda.appendChild(dim);
                        assoc.appendChild(cda);
                        cubeDimAssoc.appendChild(assoc);
                    }
                    cubeElement.appendChild(cubeDimAssoc);
                }
                olapSchema.appendChild(cubesElement);
            }
            if (dims != null && dims.size() > 0) {
                Element dimsElement = doc.createElement("CWMOLAP:Schema.dimension");
                for (OlapDimension dim : dims) {
                    Element dimElement = doc.createElement("CWMOLAP:Dimension");
                    String id = (String)dimMap.get(dim);
                    if (id == null) {
                        id = idGen.getNextId();
                    }
                    dimElement.setAttribute("xmi.id", id);
                    dimElement.setAttribute("name", dim.getName());
                    dimElement.setAttribute("isAbstract", "false");
                    dimElement.setAttribute("isTime", "" + dim.isTimeDimension());
                    dimElement.setAttribute("isMeasure", "false");
                    List list = (List)dimUsageMap.get(dim);
                    if (list != null && list.size() > 0) {
                        Element cubeDimAssoc = doc.createElement("CWMOLAP:Dimension.cubeDimensionAssociation");
                        for (OlapDimensionUsage usage2 : list) {
                            Element cda = doc.createElement("CWMOLAP:CubeDimensionAssociation");
                            cda.setAttribute("xmi.idref", (String)dimUsageIdMap.get(usage2));
                            cubeDimAssoc.appendChild(cda);
                        }
                        dimElement.appendChild(cubeDimAssoc);
                    }
                    if (dim.getHierarchies() != null && dim.getHierarchies().size() > 0) {
                        void var20_25;
                        Element hierElement = doc.createElement("CWMOLAP:Dimension.hierarchy");
                        Object var20_24 = null;
                        for (OlapHierarchy hier : dim.getHierarchies()) {
                            Element hierarchyElement = doc.createElement("CWMOLAP:LevelBasedHierarchy");
                            String hierId = idGen.getNextId();
                            hierarchyElement.setAttribute("xmi.id", hierId);
                            hierarchyElement.setAttribute("name", hier.getName());
                            hierarchyElement.setAttribute("isAbstract", "false");
                            Element modelElement = doc.createElement("CWM:ModelElement.taggedValue");
                            modelElement.appendChild(this.createTaggedValue(doc, "HIERARCHY_BUSINESS_TABLE", hier.getLogicalTable().getId(), idGen.getNextId()));
                            if (hier.getPrimaryKey() != null) {
                                modelElement.appendChild(this.createTaggedValue(doc, "HIERARCHY_PRIMARY_KEY", hier.getPrimaryKey().getId(), idGen.getNextId()));
                            }
                            modelElement.appendChild(this.createTaggedValue(doc, "HIERARCHY_HAVING_ALL", hier.isHavingAll() ? "Y" : "N", idGen.getNextId()));
                            hierarchyElement.appendChild(modelElement);
                            if (hier.getHierarchyLevels() != null && hier.getHierarchyLevels().size() > 0) {
                                Element hla = doc.createElement("CWMOLAP:LevelBasedHierarchy.hierarchyLevelAssociation");
                                for (OlapHierarchyLevel level : hier.getHierarchyLevels()) {
                                    String tag;
                                    Element hierLvlAssoc = doc.createElement("CWMOLAP:HierarchyLevelAssociation");
                                    String hlaId = idGen.getNextId();
                                    hierLvlAssoc.setAttribute("xmi.id", hlaId);
                                    hierLvlAssoc.setAttribute("name", level.getName());
                                    hierLvlAssoc.setAttribute("isAbstract", "false");
                                    Element currLvl = doc.createElement("CWMOLAP:HierarchyLevelAssociation.currentLevel");
                                    Element lvlref = doc.createElement("CWMOLAP:Level");
                                    String lvlId = idGen.getNextId();
                                    if (var20_25 == null) {
                                        Element element = doc.createElement("CWMOLAP:Dimension.memberSelection");
                                    }
                                    Element lvlElement = doc.createElement("CWMOLAP:Level");
                                    lvlElement.setAttribute("xmi.id", lvlId);
                                    lvlElement.setAttribute("name", level.getName());
                                    lvlElement.setAttribute("isAbstract", "false");
                                    Element lvlModelElement = doc.createElement("CWM:ModelElement.taggedValue");
                                    lvlModelElement.appendChild(this.createTaggedValue(doc, "HIERARCHY_LEVEL_UNIQUE_MEMBERS", level.isHavingUniqueMembers() ? "Y" : "N", idGen.getNextId()));
                                    LogicalColumn logicalColumn = level.getReferenceColumn();
                                    if (logicalColumn != null) {
                                        tag = "HIERARCHY_LEVEL_REFERENCE_COLUMN";
                                        lvlModelElement.appendChild(this.createTaggedValue(doc, tag, logicalColumn.getId(), idGen.getNextId()));
                                    }
                                    if ((logicalColumn = level.getReferenceOrdinalColumn()) != null) {
                                        tag = "HIERARCHY_LEVEL_REFERENCE_ORDINAL_COLUMN";
                                        lvlModelElement.appendChild(this.createTaggedValue(doc, tag, logicalColumn.getId(), idGen.getNextId()));
                                    }
                                    if ((logicalColumn = level.getReferenceCaptionColumn()) != null) {
                                        tag = "HIERARCHY_LEVEL_REFERENCE_CAPTION_COLUMN";
                                        lvlModelElement.appendChild(this.createTaggedValue(doc, tag, logicalColumn.getId(), idGen.getNextId()));
                                    }
                                    if (dim.isTimeDimension()) {
                                        lvlModelElement.appendChild(this.createTaggedValue(doc, "HIERARCHY_LEVEL_TYPE", level.getLevelType(), idGen.getNextId()));
                                    }
                                    if (level.isHidden()) {
                                        lvlModelElement.appendChild(this.createTaggedValue(doc, "HIERARCHY_LEVEL_HIDDEN", level.isHidden() + "", idGen.getNextId()));
                                    }
                                    if (!StringUtils.isBlank((String)level.getFormatter())) {
                                        lvlModelElement.appendChild(this.createTaggedValue(doc, "HIERARCHY_LEVEL_FORMATTER", level.getFormatter(), idGen.getNextId()));
                                    }
                                    if (level.getAnnotations() != null & level.getAnnotations().size() > 0) {
                                        for (OlapAnnotation olapAnnotation : level.getAnnotations()) {
                                            Element annotationElement = this.createTaggedValue(doc, "ANNOTATION_" + olapAnnotation.getName(), olapAnnotation.getValue(), idGen.getNextId());
                                            lvlModelElement.appendChild(annotationElement);
                                        }
                                    }
                                    lvlElement.appendChild(lvlModelElement);
                                    if (level.getLogicalColumns() != null && level.getLogicalColumns().size() > 0) {
                                        Element ownedElement = doc.createElement("CWM:Namespace.ownedElement");
                                        for (LogicalColumn col : level.getLogicalColumns()) {
                                            Element dimObj = doc.createElement("CWMMDB:DimensionedObject");
                                            dimObj.setAttribute("xmi.id", idGen.getNextId());
                                            dimObj.setAttribute("name", col.getId());
                                            ownedElement.appendChild(dimObj);
                                        }
                                        lvlElement.appendChild(ownedElement);
                                    }
                                    Element lvlHierLvlAssoc = doc.createElement("CWMOLAP:Level.hierarchyLevelAssociation");
                                    Element element = doc.createElement("CWMOLAP:HierarchyLevelAssociation");
                                    element.setAttribute("xmi.idref", hlaId);
                                    lvlHierLvlAssoc.appendChild(element);
                                    lvlElement.appendChild(lvlHierLvlAssoc);
                                    var20_25.appendChild(lvlElement);
                                    lvlref.setAttribute("xmi.idref", lvlId);
                                    currLvl.appendChild(lvlref);
                                    hierLvlAssoc.appendChild(currLvl);
                                    hla.appendChild(hierLvlAssoc);
                                }
                                hierarchyElement.appendChild(hla);
                            }
                            hierElement.appendChild(hierarchyElement);
                        }
                        dimElement.appendChild(hierElement);
                        if (var20_25 != null) {
                            dimElement.appendChild((Node)var20_25);
                        }
                    }
                    dimsElement.appendChild(dimElement);
                }
                olapSchema.appendChild(dimsElement);
            }
            xmiContent.appendChild(olapSchema);
        }
    }

    protected void createDescriptions(Document doc, IConcept concept, String parentTag, String idstr, List<Element> allDescriptions, IdGen idGen) {
        for (String key : concept.getChildProperties().keySet()) {
            String body = null;
            String type = null;
            Object val = concept.getChildProperty(key);
            if (val instanceof String) {
                String str;
                if (key.equals("target_column")) {
                    key = "formula";
                }
                body = str = (String)val;
                type = "String";
            } else if (val instanceof Boolean) {
                Boolean bool = (Boolean)val;
                type = "Boolean";
                body = bool != false ? "Y" : "N";
            } else if (val instanceof Color) {
                Color c = (Color)val;
                ColorSettings cs = new ColorSettings(c.getRed(), c.getGreen(), c.getBlue());
                body = cs.toString();
                type = "Color";
            } else if (val instanceof URL) {
                body = val.toString();
                type = "URL";
            } else if (val instanceof org.pentaho.metadata.model.concept.types.ColumnWidth) {
                org.pentaho.metadata.model.concept.types.ColumnWidth ncw = (org.pentaho.metadata.model.concept.types.ColumnWidth)val;
                type = "ColumnWidth";
                ColumnWidth cw = new ColumnWidth(ncw.getType().ordinal(), ncw.getWidth());
                body = cw.toString();
            } else if (val instanceof Double) {
                type = "Number";
                BigDecimal bd = new BigDecimal((Double)val);
                body = bd.toString();
            } else if (val instanceof Alignment) {
                Alignment alignment = (Alignment)((Object)val);
                AlignmentSettings as = AlignmentSettings.types[alignment.ordinal()];
                body = as.toString();
                type = "Alignment";
            } else if (val instanceof Security) {
                Security security = (Security)val;
                HashMap<org.pentaho.pms.schema.security.SecurityOwner, Integer> map = new HashMap<org.pentaho.pms.schema.security.SecurityOwner, Integer>();
                for (SecurityOwner securityOwner : security.getOwners()) {
                    org.pentaho.pms.schema.security.SecurityOwner ownerObj = new org.pentaho.pms.schema.security.SecurityOwner(securityOwner.getOwnerType().ordinal(), securityOwner.getOwnerName());
                    map.put(ownerObj, security.getOwnerRights(securityOwner));
                }
                org.pentaho.pms.schema.security.Security legacySecurity = new org.pentaho.pms.schema.security.Security(map);
                body = legacySecurity.toXML();
                type = "Security";
            } else if (val instanceof RowLevelSecurity) {
                RowLevelSecurity nrls = (RowLevelSecurity)val;
                org.pentaho.pms.schema.security.RowLevelSecurity rls = new org.pentaho.pms.schema.security.RowLevelSecurity();
                rls.setType(RowLevelSecurity.Type.values()[nrls.getType().ordinal()]);
                rls.setGlobalConstraint(nrls.getGlobalConstraint());
                HashMap<org.pentaho.pms.schema.security.SecurityOwner, String> roleBasedConstraintMap = new HashMap<org.pentaho.pms.schema.security.SecurityOwner, String>();
                for (SecurityOwner owner3 : nrls.getRoleBasedConstraintMap().keySet()) {
                    org.pentaho.pms.schema.security.SecurityOwner ownerObj = new org.pentaho.pms.schema.security.SecurityOwner(owner3.getOwnerType().ordinal(), owner3.getOwnerName());
                    roleBasedConstraintMap.put(ownerObj, nrls.getRoleBasedConstraintMap().get(owner3));
                }
                rls.setRoleBasedConstraintMap(roleBasedConstraintMap);
                body = rls.toXML();
                type = "RowLevelSecurity";
            } else if (val instanceof Font) {
                ConceptPropertyFont font = (ConceptPropertyFont)ThinModelConverter.convertPropertyToLegacy("font", val);
                body = ((FontSettings)font.getValue()).toString();
                type = "Font";
            } else if (val instanceof TargetTableType) {
                TargetTableType ttt = (TargetTableType)((Object)val);
                if (ttt != TargetTableType.TABLE) {
                    type = "TargetTableType";
                    body = ttt.toString();
                }
            } else if (val instanceof TableType) {
                TableType tt = (TableType)((Object)val);
                body = TableTypeSettings.getTypeDescriptions()[tt.ordinal()];
                type = "TableType";
            } else if (val instanceof LocalizedString) {
                LocalizedString lstr = (LocalizedString)val;
                for (String locale : lstr.getLocales()) {
                    this.createDescription(doc, lstr.getLocalizedString(locale), key, "LocString", locale, idGen, parentTag, idstr, allDescriptions);
                }
            } else if (val instanceof TargetColumnType) {
                TargetColumnType tct = (TargetColumnType)((Object)val);
                body = tct == TargetColumnType.OPEN_FORMULA ? "Y" : "N";
                key = "exact";
                type = "Boolean";
            } else if (val instanceof FieldType) {
                FieldType ft = (FieldType)((Object)val);
                body = FieldTypeSettings.getTypeDescriptions()[ft.ordinal()];
                type = "FieldType";
            } else if (val instanceof DataType) {
                body = DataTypeSettings.types[((DataType)((Object)val)).ordinal()].getCode();
                type = "DataType";
            } else if (val instanceof AggregationType) {
                AggregationType at = (AggregationType)((Object)val);
                body = AggregationSettings.types[at.ordinal()].getCode();
                type = "Aggregation";
            } else if (val instanceof List) {
                List objs = (List)val;
                if (objs.size() == 0 && "aggregation_list".equals(key)) {
                    ConceptPropertyAggregationList list = new ConceptPropertyAggregationList(key, new ArrayList<AggregationSettings>());
                    type = "AggregationList";
                    body = list.toXML();
                } else if (objs.get(0) instanceof AggregationType) {
                    List aggTypes = objs;
                    type = "AggregationList";
                    ArrayList<AggregationSettings> aggSettings = new ArrayList<AggregationSettings>();
                    for (AggregationType aggType : aggTypes) {
                        aggSettings.add(AggregationSettings.types[aggType.ordinal()]);
                    }
                    ConceptPropertyAggregationList conceptPropertyAggregationList = new ConceptPropertyAggregationList(key, aggSettings);
                    type = "AggregationList";
                    body = conceptPropertyAggregationList.toXML();
                } else if (objs.get(0) instanceof OlapRole) {
                    body = OlapUtil.toXmlRoles(objs);
                    type = "String";
                } else if (!(objs.get(0) instanceof OlapCube) && !(objs.get(0) instanceof OlapDimension)) {
                    logger.error((Object)Messages.getErrorString("XmiParser.ERROR_0004_UNSUPPORTED_CONCEPT_PROPERTY_LIST", objs.get(0).getClass()));
                }
            } else if (val == null) {
                logger.error((Object)Messages.getErrorString("XmiParser.ERROR_0005_UNSUPPORTED_CONCEPT_PROPERTY", "null"));
            } else {
                logger.error((Object)Messages.getErrorString("XmiParser.ERROR_0005_UNSUPPORTED_CONCEPT_PROPERTY", val.getClass()));
            }
            if (type == null) continue;
            this.createDescription(doc, body, key, type, null, idGen, parentTag, idstr, allDescriptions);
        }
    }

    protected void createDescription(Document doc, String body, String key, String type, String locale, IdGen idGen, String parentTag, String idstr, List<Element> allDescriptions) {
        Element desc = doc.createElement("CWM:Description");
        desc.setAttribute("body", body);
        if (locale != null) {
            desc.setAttribute("language", locale);
        }
        desc.setAttribute("name", key);
        desc.setAttribute("type", type);
        desc.setAttribute("xmi.id", idGen.getNextId());
        Element modelElement = doc.createElement("CWM:Description.modelElement");
        Element parent = doc.createElement(parentTag);
        modelElement.appendChild(parent);
        parent.setAttribute("xmi.idref", idstr);
        desc.appendChild(modelElement);
        allDescriptions.add(desc);
    }

    protected Element createTaggedValue(Document doc, String tagName, String value, String id) {
        Element taggedValue = doc.createElement("CWM:TaggedValue");
        taggedValue.setAttribute("tag", tagName);
        taggedValue.setAttribute("value", value);
        taggedValue.setAttribute("xmi.id", id);
        return taggedValue;
    }

    protected void addTextElement(Document doc, Element element, String elementName, String text) {
        Element childElement = doc.createElement(elementName);
        childElement.appendChild(doc.createTextNode(text));
        element.appendChild(childElement);
    }

    public Domain parseXmi(InputStream xmi) throws Exception {
        String name;
        Document doc;
        try {
            DocumentBuilderFactory dbf = XmiParser.createSecureDocBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(new InputSource(xmi));
        }
        catch (ParserConfigurationException pcx) {
            throw new PentahoMetadataException(pcx);
        }
        catch (SAXException sax) {
            throw new PentahoMetadataException(sax);
        }
        catch (IOException iex) {
            throw new PentahoMetadataException(iex);
        }
        Element content = null;
        NodeList list = doc.getElementsByTagName("XMI.content");
        if (list != null && list.getLength() > 0) {
            content = (Element)list.item(0);
        }
        ArrayList<Element> concepts = new ArrayList<Element>();
        ArrayList<Element> descriptions = new ArrayList<Element>();
        ArrayList<Element> datasources = new ArrayList<Element>();
        ArrayList<Element> physicalTables = new ArrayList<Element>();
        ArrayList<Element> parameters = new ArrayList<Element>();
        ArrayList<Element> schemas = new ArrayList<Element>();
        ArrayList<Element> events = new ArrayList<Element>();
        ArrayList<Element> olapSchemas = new ArrayList<Element>();
        list = content.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("CWM:Class")) {
                concepts.add((Element)node);
                continue;
            }
            if (node.getNodeName().equals("CWM:Parameter")) {
                parameters.add((Element)node);
                continue;
            }
            if (node.getNodeName().equals("CWMRDB:Catalog")) {
                datasources.add((Element)node);
                continue;
            }
            if (node.getNodeName().equals("CWMRDB:Table")) {
                physicalTables.add((Element)node);
                continue;
            }
            if (node.getNodeName().equals("CWMMDB:Schema")) {
                schemas.add((Element)node);
                continue;
            }
            if (node.getNodeName().equals("CWM:Description")) {
                descriptions.add((Element)node);
                continue;
            }
            if (node.getNodeName().equals("CWM:Event")) {
                events.add((Element)node);
                continue;
            }
            if (node.getNodeName().equals("CWMOLAP:Schema")) {
                olapSchemas.add((Element)node);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Ignoring root : " + node.getNodeName()));
        }
        Domain domain = new Domain();
        HashMap<String, Concept> xmiConceptMap = new HashMap<String, Concept>();
        for (Element element : events) {
            Map<String, String> kvp = XmiParser.getKeyValuePairs(element, "CWM:TaggedValue", "tag", "value");
            for (String key : kvp.keySet()) {
                domain.setProperty("LEGACY_EVENT_" + key, kvp.get(key));
            }
        }
        this.populateLocales(domain, parameters);
        for (Element element : concepts) {
            Concept c = new Concept();
            name = element.getAttribute("name");
            c.setId(name);
            String xmiId = element.getAttribute("xmi.id");
            String parentName = XmiParser.getKeyValue(element, "CWM:TaggedValue", "tag", "value", "CONCEPT_PARENT_NAME");
            if (parentName != null) {
                c.setProperty("__TMP_CONCEPT_PARENT_NAME", parentName);
            }
            xmiConceptMap.put(xmiId, c);
            domain.addConcept(c);
        }
        for (Concept concept : domain.getConcepts()) {
            String parentName = (String)concept.getChildProperty("__TMP_CONCEPT_PARENT_NAME");
            if (parentName == null) continue;
            concept.removeChildProperty("__TMP_CONCEPT_PARENT_NAME");
            Concept conceptParent = domain.findConcept(parentName);
            concept.setParentConcept(conceptParent);
            conceptParent.addChild(concept);
        }
        for (Element element : datasources) {
            SqlPhysicalModel sqlPhysicalModel = new SqlPhysicalModel();
            domain.addPhysicalModel(sqlPhysicalModel);
            SqlDataSource sqlDataSource = new SqlDataSource();
            sqlPhysicalModel.setDatasource(sqlDataSource);
            String name2 = element.getAttribute("name");
            sqlPhysicalModel.setId(name2);
            Map<String, String> kvp = XmiParser.getKeyValuePairs(element, "CWM:TaggedValue", "tag", "value");
            String database_access_type = kvp.get("DATABASE_ACCESS");
            if (database_access_type.equals(", ")) {
                logger.warn((Object)Messages.getErrorString("XmiParser.ERROR_0011_UNSUPPORTED_DOMAIN", database_access_type));
                database_access_type = "JNDI";
            }
            sqlDataSource.setType(SqlDataSource.DataSourceType.values()[DatabaseMeta.getAccessType((String)database_access_type)]);
            sqlDataSource.setDatabaseName(kvp.get("DATABASE_DATABASE"));
            sqlDataSource.setHostname(kvp.get("DATABASE_SERVER"));
            sqlDataSource.setPort(kvp.get("DATABASE_PORT"));
            sqlDataSource.setUsername(kvp.get("DATABASE_USERNAME"));
            sqlDataSource.setPassword(kvp.get("DATABASE_PASSWORD"));
            sqlDataSource.setDialectType(kvp.get("DATABASE_TYPE"));
            sqlDataSource.setServername(kvp.get("DATABASE_SERVER_INSTANCE"));
            for (String tag : kvp.keySet()) {
                if (!tag.startsWith("DATABASE_ATTRIBUTE_PREFIX_")) continue;
                String key = tag.substring("DATABASE_ATTRIBUTE_PREFIX_".length());
                String attribute = kvp.get(tag);
                sqlDataSource.getAttributes().put(key, attribute);
            }
        }
        SqlPhysicalModel missingParentModel = null;
        for (Element physicalTable : physicalTables) {
            name = physicalTable.getAttribute("name");
            Element tagged = null;
            Element owned = null;
            NodeList ptcn = physicalTable.getChildNodes();
            for (int i = 0; i < ptcn.getLength(); ++i) {
                if (ptcn.item(i).getNodeType() != 1) continue;
                if (ptcn.item(i).getNodeName().equals("CWM:ModelElement.taggedValue")) {
                    tagged = (Element)ptcn.item(i);
                }
                if (!ptcn.item(i).getNodeName().equals("CWM:Namespace.ownedElement")) continue;
                owned = (Element)ptcn.item(i);
            }
            String databaseName = XmiParser.getKeyValue(tagged, "CWM:TaggedValue", "tag", "value", "TABLE_TARGET_DATABASE_NAME");
            if (databaseName == null) {
                logger.warn((Object)Messages.getErrorString("XmiParser.ERROR_0009_MISSING_DATABASE_PARENT", name));
                if (missingParentModel == null) {
                    missingParentModel = new SqlPhysicalModel();
                    missingParentModel.setId("__MISSING_PARENT_PHYSICAL_MODEL__");
                    domain.addPhysicalModel(missingParentModel);
                }
                databaseName = "__MISSING_PARENT_PHYSICAL_MODEL__";
            }
            SqlPhysicalModel model = (SqlPhysicalModel)domain.findPhysicalModel(databaseName);
            SqlPhysicalTable table = new SqlPhysicalTable(model);
            table.setId(physicalTable.getAttribute("name"));
            xmiConceptMap.put(physicalTable.getAttribute("xmi.id"), table);
            model.addPhysicalTable(table);
            this.bindParentConcept(physicalTable, domain, table);
            NodeList columns = owned.getElementsByTagName("CWMRDB:Column");
            for (int i = 0; i < columns.getLength(); ++i) {
                Element colelement = (Element)columns.item(i);
                SqlPhysicalColumn col = new SqlPhysicalColumn(table);
                col.setId(colelement.getAttribute("name"));
                xmiConceptMap.put(colelement.getAttribute("xmi.id"), col);
                table.addPhysicalColumn(col);
                this.bindParentConcept(colelement, domain, col);
            }
        }
        for (Element schema : schemas) {
            Map<String, String> nvp;
            LogicalModel logicalModel = new LogicalModel();
            logicalModel.setId(schema.getAttribute("name"));
            xmiConceptMap.put(schema.getAttribute("xmi.id"), logicalModel);
            this.bindParentConcept(schema, domain, logicalModel);
            domain.addLogicalModel(logicalModel);
            Element dimension = null;
            Element dimensionedObject = null;
            Element ownedElement = null;
            NodeList schemaChildren = schema.getChildNodes();
            for (int i = 0; i < schemaChildren.getLength(); ++i) {
                if (schemaChildren.item(i).getNodeType() != 1) continue;
                if (schemaChildren.item(i).getNodeName().equals("CWMMDB:Schema.dimension")) {
                    dimension = (Element)schemaChildren.item(i);
                    continue;
                }
                if (schemaChildren.item(i).getNodeName().equals("CWMMDB:Schema.dimensionedObject")) {
                    dimensionedObject = (Element)schemaChildren.item(i);
                    continue;
                }
                if (schemaChildren.item(i).getNodeName().equals("CWM:Namespace.ownedElement")) {
                    ownedElement = (Element)schemaChildren.item(i);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Schema ignored: " + schemaChildren.item(i).getNodeName()));
            }
            if (dimension != null) {
                NodeList bizTables = dimension.getElementsByTagName("CWMMDB:Dimension");
                for (int i = 0; i < bizTables.getLength(); ++i) {
                    Element biztable = (Element)bizTables.item(i);
                    LogicalTable table = new LogicalTable();
                    table.setId(biztable.getAttribute("name"));
                    this.bindParentConcept(biztable, domain, table);
                    nvp = XmiParser.getKeyValuePairs(biztable, "CWM:TaggedValue", "tag", "value");
                    String pt = nvp.get("BUSINESS_TABLE_PHYSICAL_TABLE_NAME");
                    IPhysicalTable iPhysicalTable = domain.findPhysicalTable(pt);
                    if (iPhysicalTable != null && logicalModel.getPhysicalModel() == null) {
                        logicalModel.setPhysicalModel(iPhysicalTable.getPhysicalModel());
                    }
                    table.setPhysicalTable(iPhysicalTable);
                    table.setLogicalModel(logicalModel);
                    if (nvp.containsKey("TABLE_IS_DRAWN")) {
                        table.setProperty("__LEGACY_TABLE_IS_DRAWN", nvp.get("TABLE_IS_DRAWN"));
                    }
                    if (nvp.containsKey("TAG_POSITION_Y")) {
                        table.setProperty("__LEGACY_TAG_POSITION_Y", nvp.get("TAG_POSITION_Y"));
                    }
                    if (nvp.containsKey("TAG_POSITION_X")) {
                        table.setProperty("__LEGACY_TAG_POSITION_X", nvp.get("TAG_POSITION_X"));
                    }
                    xmiConceptMap.put(biztable.getAttribute("xmi.id"), table);
                    logicalModel.addLogicalTable(table);
                }
            }
            if (dimensionedObject != null) {
                NodeList bizcols = dimensionedObject.getElementsByTagName("CWMMDB:DimensionedObject");
                block17: for (int i = 0; i < bizcols.getLength(); ++i) {
                    Element bizcol = (Element)bizcols.item(i);
                    LogicalColumn col = new LogicalColumn();
                    col.setId(bizcol.getAttribute("name"));
                    xmiConceptMap.put(bizcol.getAttribute("xmi.id"), col);
                    this.bindParentConcept(bizcol, domain, col);
                    nvp = XmiParser.getKeyValuePairs(bizcol, "CWM:TaggedValue", "tag", "value");
                    String biztbl = nvp.get("BUSINESS_COLUMN_BUSINESS_TABLE");
                    String string = nvp.get("BUSINESS_COLUMN_PHYSICAL_COLUMN_NAME");
                    LogicalTable parent = logicalModel.findLogicalTable(biztbl);
                    if (parent == null) continue;
                    col.setLogicalTable(parent);
                    parent.addLogicalColumn(col);
                    for (IPhysicalColumn phycol : parent.getPhysicalTable().getPhysicalColumns()) {
                        if (!phycol.getId().equals(string)) continue;
                        col.setPhysicalColumn(phycol);
                        continue block17;
                    }
                }
            }
            if (ownedElement == null) continue;
            NodeList categories = ownedElement.getElementsByTagName("CWM:Extent");
            for (int i = 0; i < categories.getLength(); ++i) {
                Element category = (Element)categories.item(i);
                Category cat = new Category(logicalModel);
                cat.setId(category.getAttribute("name"));
                xmiConceptMap.put(category.getAttribute("xmi.id"), cat);
                this.bindParentConcept(category, domain, cat);
                NodeList columns = category.getElementsByTagName("CWM:Attribute");
                for (int j = 0; j < columns.getLength(); ++j) {
                    Element element = (Element)columns.item(j);
                    String name3 = element.getAttribute("name");
                    LogicalColumn col = logicalModel.findLogicalColumn(name3);
                    if (col == null) {
                        logger.warn((Object)Messages.getString("XmiParser.ERROR_0010_UNABLE_TO_FIND_COL_FOR_CATEGORY", name3, cat.getId()));
                        continue;
                    }
                    cat.addLogicalColumn(col);
                }
                logicalModel.addCategory(cat);
            }
            NodeList rels = ownedElement.getElementsByTagName("CWM:KeyRelationship");
            for (int i = 0; i < rels.getLength(); ++i) {
                String joinOrderKey;
                Element rel = (Element)rels.item(i);
                nvp = XmiParser.getKeyValuePairs(rel, "CWM:TaggedValue", "tag", "value");
                LogicalRelationship relation = new LogicalRelationship();
                String string = nvp.get("RELATIONSHIP_TYPE");
                RelationshipType reltype = RelationshipType.values()[RelationshipMeta.getType(string)];
                relation.setRelationshipType(reltype);
                relation.setLogicalModel(logicalModel);
                String tablechild = nvp.get("RELATIONSHIP_TABLENAME_CHILD");
                String tableparent = nvp.get("RELATIONSHIP_TABLENAME_PARENT");
                String fieldchild = nvp.get("RELATIONSHIP_FIELDNAME_CHILD");
                String fieldparent = nvp.get("RELATIONSHIP_FIELDNAME_PARENT");
                relation.setFromTable(logicalModel.findLogicalTable(tableparent));
                if (fieldparent != null) {
                    relation.setFromColumn(logicalModel.findLogicalColumn(fieldparent));
                }
                relation.setToTable(logicalModel.findLogicalTable(tablechild));
                if (fieldchild != null) {
                    relation.setToColumn(logicalModel.findLogicalColumn(fieldchild));
                }
                relation.setComplex("Y".equals(nvp.get("RELATIONSHIP_IS_COMPLEX")));
                String val = nvp.get("RELATIONSHIP_COMPLEX_JOIN");
                if (val != null) {
                    relation.setComplexJoin(val);
                }
                if (!StringUtil.isEmpty((String)nvp.get("RELATIONSHIP_DESCRIPTION"))) {
                    relation.setRelationshipDescription(nvp.get("RELATIONSHIP_DESCRIPTION"));
                }
                if ((joinOrderKey = nvp.get("RELATIONSHIP_JOIN_ORDER_KEY")) != null) {
                    relation.setJoinOrderKey(joinOrderKey);
                }
                logicalModel.addLogicalRelationship(relation);
            }
        }
        this.populateOlapSchemas(olapSchemas, domain);
        for (Element description : descriptions) {
            Cloneable security;
            Element modelElem = (Element)description.getElementsByTagName("CWM:Description.modelElement").item(0);
            if (modelElem == null) continue;
            NodeList mecn = modelElem.getChildNodes();
            String parentRef = null;
            String type = null;
            for (int i = 0; i < mecn.getLength(); ++i) {
                if (mecn.item(i).getNodeType() != 1) continue;
                parentRef = ((Element)mecn.item(i)).getAttribute("xmi.idref");
                type = mecn.item(i).getNodeName();
                break;
            }
            if (parentRef == null) {
                logger.error((Object)Messages.getErrorString("XmiParser.ERROR_0007_PARENT_REF_NULL", new Object[0]));
                continue;
            }
            Concept concept = (Concept)xmiConceptMap.get(parentRef);
            String name4 = description.getAttribute("name");
            String body = description.getAttribute("body");
            if (concept == null) {
                logger.error((Object)Messages.getErrorString("XmiParser.ERROR_0010_CANNOT_FIND_PARENT", type, parentRef));
                continue;
            }
            String propType = description.getAttribute("type");
            if (propType.equals("LocString")) {
                this.addLocalizedString(description, concept, name4, body);
                continue;
            }
            if (propType.equals("String")) {
                if (name4.equals("olap_roles")) {
                    List<OlapRole> roles = OlapUtil.fromXmlRoles(body);
                    concept.setProperty(name4, roles);
                    continue;
                }
                if (name4.equals("olap_calculated_members")) {
                    Map<String, List<OlapCalculatedMember>> cubeMembers = OlapUtil.fromXmlCalculatedMembers(body);
                    List cubes = (List)concept.getProperty("olap_cubes");
                    for (OlapCube olapCube : cubes) {
                        if (!cubeMembers.containsKey(olapCube.getName())) continue;
                        olapCube.setOlapCalculatedMembers(cubeMembers.get(olapCube.getName()));
                    }
                    continue;
                }
                if (name4.equals("formula")) {
                    name4 = "target_column";
                }
                concept.setProperty(name4, body);
                continue;
            }
            if (propType.equals("Boolean")) {
                if (name4.equals("exact")) {
                    concept.setProperty("target_column_type", (Object)("Y".equals(body) ? TargetColumnType.OPEN_FORMULA : TargetColumnType.COLUMN_NAME));
                    continue;
                }
                concept.setProperty(name4, new Boolean("Y".equals(body)));
                continue;
            }
            if (propType.equals("FieldType")) {
                concept.setProperty(name4, (Object)FieldType.values()[FieldTypeSettings.getType(body).getType()]);
                continue;
            }
            if (propType.equals("TableType")) {
                concept.setProperty(name4, (Object)TableType.values()[TableTypeSettings.getType(body).getType()]);
                continue;
            }
            if (propType.equals("DataType")) {
                DataTypeSettings setting = DataTypeSettings.fromString(body);
                concept.setProperty(name4, (Object)DataType.valueOf(setting.getCode().toUpperCase()));
                if (setting.getPrecision() <= 0) continue;
                String mask = "#.";
                for (int i = 0; i < setting.getPrecision(); ++i) {
                    mask = mask + "0";
                }
                concept.setProperty("mask", mask);
                continue;
            }
            if (propType.equals("Security")) {
                security = org.pentaho.pms.schema.security.Security.fromXML(body);
                HashMap<SecurityOwner, Integer> map = new HashMap<SecurityOwner, Integer>();
                for (org.pentaho.pms.schema.security.SecurityOwner securityOwner : ((org.pentaho.pms.schema.security.Security)security).getOwners()) {
                    SecurityOwner ownerObj = new SecurityOwner(SecurityOwner.OwnerType.values()[securityOwner.getOwnerType()], securityOwner.getOwnerName());
                    Integer val = ((org.pentaho.pms.schema.security.Security)security).getOwnerRights(securityOwner);
                    map.put(ownerObj, val);
                }
                concept.setProperty(name4, new Security(map));
                continue;
            }
            if (propType.equals("RowLevelSecurity")) {
                security = org.pentaho.pms.schema.security.RowLevelSecurity.fromXML(body);
                RowLevelSecurity securityObj = new RowLevelSecurity();
                securityObj.setType(RowLevelSecurity.Type.values()[((org.pentaho.pms.schema.security.RowLevelSecurity)security).getType().ordinal()]);
                securityObj.setGlobalConstraint(((org.pentaho.pms.schema.security.RowLevelSecurity)security).getGlobalConstraint());
                HashMap<SecurityOwner, String> map = new HashMap<SecurityOwner, String>();
                for (org.pentaho.pms.schema.security.SecurityOwner owner2 : ((org.pentaho.pms.schema.security.RowLevelSecurity)security).getRoleBasedConstraintMap().keySet()) {
                    SecurityOwner ownerObj = new SecurityOwner(SecurityOwner.OwnerType.values()[owner2.getOwnerType()], owner2.getOwnerName());
                    map.put(ownerObj, ((org.pentaho.pms.schema.security.RowLevelSecurity)security).getRoleBasedConstraintMap().get(owner2));
                }
                securityObj.setRoleBasedConstraintMap(map);
                concept.setProperty(name4, securityObj);
                continue;
            }
            if (propType.equals("Aggregation")) {
                concept.setProperty(name4, (Object)AggregationType.values()[AggregationSettings.getType(body).getType()]);
                continue;
            }
            if (propType.equals("AggregationList")) {
                List<AggregationSettings> settings = ConceptPropertyAggregationList.fromXML(body);
                ArrayList<AggregationType> aggTypes = new ArrayList<AggregationType>();
                if (settings != null) {
                    for (AggregationSettings aggregationSettings : settings) {
                        aggTypes.add(AggregationType.values()[aggregationSettings.getType()]);
                    }
                }
                concept.setProperty(name4, aggTypes);
                continue;
            }
            if (propType.equals("Font")) {
                FontSettings font = FontSettings.fromString(body);
                concept.setProperty(name4, new Font(font.getName(), font.getHeight(), font.isBold(), font.isItalic()));
                continue;
            }
            if (propType.equals("Color")) {
                ColorSettings color = ColorSettings.fromString(body);
                concept.setProperty(name4, new Color(color.getRed(), color.getGreen(), color.getBlue()));
                continue;
            }
            if (propType.equals("Alignment")) {
                AlignmentSettings alignment = AlignmentSettings.fromString(body);
                concept.setProperty(name4, (Object)Alignment.values()[alignment.getType()]);
                continue;
            }
            if (propType.equals("Number")) {
                BigDecimal bd = new BigDecimal(body);
                concept.setProperty(name4, bd.doubleValue());
                continue;
            }
            if (propType.equals("ColumnWidth")) {
                ColumnWidth cw = ColumnWidth.fromString(body);
                ColumnWidth.WidthType cwt = ColumnWidth.WidthType.values()[cw.getType()];
                org.pentaho.metadata.model.concept.types.ColumnWidth ncw = new org.pentaho.metadata.model.concept.types.ColumnWidth(cwt, cw.getWidth().doubleValue());
                concept.setProperty(name4, ncw);
                continue;
            }
            if (propType.equals("URL")) {
                URL url = new URL(body);
                concept.setProperty(name4, url);
                continue;
            }
            if (propType.equals("TargetTableType")) {
                concept.setProperty(name4, (Object)TargetTableType.valueOf(body));
                continue;
            }
            logger.error((Object)Messages.getErrorString("XmiParser.ERROR_0008_FAILED_TO_CONVERT_PROPERTY", propType, concept.getId()));
        }
        this.validateDomain(domain);
        return domain;
    }

    protected void populateOlapSchemas(List<Element> olapSchemas, Domain domain) {
        for (Element olapSchema : olapSchemas) {
            int i;
            LogicalModel model = domain.findLogicalModel(olapSchema.getAttribute("name"));
            Element dimensionList = null;
            Element cubeList = null;
            NodeList schemaChildren = olapSchema.getChildNodes();
            for (int i2 = 0; i2 < schemaChildren.getLength(); ++i2) {
                if (schemaChildren.item(i2).getNodeType() != 1) continue;
                if (schemaChildren.item(i2).getNodeName().equals("CWMOLAP:Schema.cube")) {
                    cubeList = (Element)schemaChildren.item(i2);
                    continue;
                }
                if (schemaChildren.item(i2).getNodeName().equals("CWMOLAP:Schema.dimension")) {
                    dimensionList = (Element)schemaChildren.item(i2);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Schema ignored: " + schemaChildren.item(i2).getNodeName()));
            }
            HashMap<String, OlapDimension> dimensionMap = new HashMap<String, OlapDimension>();
            if (dimensionList != null) {
                ArrayList<OlapDimension> dimensionObjs = new ArrayList<OlapDimension>();
                NodeList dimensions = dimensionList.getElementsByTagName("CWMOLAP:Dimension");
                for (i = 0; i < dimensions.getLength(); ++i) {
                    int j;
                    Element dim = (Element)dimensions.item(i);
                    OlapDimension dimensionObj = new OlapDimension();
                    dimensionObj.setName(dim.getAttribute("name"));
                    boolean isTimeDimension = "true".equals(dim.getAttribute("isTime"));
                    dimensionObj.setTimeDimension(isTimeDimension);
                    dimensionMap.put(dim.getAttribute("xmi.id"), dimensionObj);
                    Element hierarchies = null;
                    Element memberSelections = null;
                    NodeList dimensionChildren = dim.getChildNodes();
                    for (int j2 = 0; j2 < dimensionChildren.getLength(); ++j2) {
                        if (dimensionChildren.item(j2).getNodeType() != 1) continue;
                        if (dimensionChildren.item(j2).getNodeName().equals("CWMOLAP:Dimension.hierarchy")) {
                            hierarchies = (Element)dimensionChildren.item(j2);
                            continue;
                        }
                        if (dimensionChildren.item(j2).getNodeName().equals("CWMOLAP:Dimension.memberSelection")) {
                            memberSelections = (Element)dimensionChildren.item(j2);
                            continue;
                        }
                        if (dimensionChildren.item(j2).getNodeName().equals("CWMOLAP:Dimension.cubeDimensionAssociation") || !logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Dimension object ignored: " + dimensionChildren.item(j2).getNodeName()));
                    }
                    HashMap<String, OlapHierarchyLevel> levelMap = new HashMap<String, OlapHierarchyLevel>();
                    if (hierarchies != null) {
                        NodeList hiers = hierarchies.getElementsByTagName("CWMOLAP:LevelBasedHierarchy");
                        for (j = 0; j < hiers.getLength(); ++j) {
                            Element hierarchy = (Element)hiers.item(j);
                            OlapHierarchy hierarchyObj = new OlapHierarchy(dimensionObj);
                            hierarchyObj.setName(hierarchy.getAttribute("name"));
                            Map<String, String> nvp = XmiParser.getKeyValuePairs(hierarchy, "CWM:TaggedValue", "tag", "value");
                            hierarchyObj.setHavingAll("Y".equals(nvp.get("HIERARCHY_HAVING_ALL")));
                            String ltblId = nvp.get("HIERARCHY_BUSINESS_TABLE");
                            LogicalTable table = null;
                            if (ltblId != null) {
                                table = model.findLogicalTable(ltblId);
                            }
                            String lcolId = nvp.get("HIERARCHY_PRIMARY_KEY");
                            LogicalColumn primaryKey = null;
                            if (lcolId != null) {
                                primaryKey = table.findLogicalColumn(lcolId);
                            }
                            hierarchyObj.setLogicalTable(table);
                            hierarchyObj.setPrimaryKey(primaryKey);
                            dimensionObj.getHierarchies().add(hierarchyObj);
                            NodeList levels = hierarchy.getElementsByTagName("CWMOLAP:HierarchyLevelAssociation");
                            ArrayList<OlapHierarchyLevel> hierarchyLevels = new ArrayList<OlapHierarchyLevel>();
                            for (int k = 0; k < levels.getLength(); ++k) {
                                Element level = (Element)levels.item(k);
                                OlapHierarchyLevel levelObj = new OlapHierarchyLevel(hierarchyObj);
                                levelObj.setName(level.getAttribute("name"));
                                hierarchyLevels.add(levelObj);
                                NodeList levelrefs = level.getElementsByTagName("CWMOLAP:Level");
                                if (levelrefs.getLength() != 1) continue;
                                Element levelRefElem = (Element)levelrefs.item(0);
                                String xmiid = levelRefElem.getAttribute("xmi.idref");
                                levelMap.put(xmiid, levelObj);
                            }
                            hierarchyObj.setHierarchyLevels(hierarchyLevels);
                        }
                        dimensionObjs.add(dimensionObj);
                    }
                    model.setProperty("olap_dimensions", dimensionObjs);
                    if (memberSelections == null) continue;
                    NodeList levels = memberSelections.getElementsByTagName("CWMOLAP:Level");
                    for (j = 0; j < levels.getLength(); ++j) {
                        Element level = (Element)levels.item(j);
                        String xmiid = level.getAttribute("xmi.id");
                        OlapHierarchyLevel levelObj = (OlapHierarchyLevel)levelMap.get(xmiid);
                        Map<String, String> nvp = XmiParser.getKeyValuePairs(level, "CWM:TaggedValue", "tag", "value");
                        levelObj.setHavingUniqueMembers("Y".equals(nvp.get("HIERARCHY_LEVEL_UNIQUE_MEMBERS")));
                        levelObj.setLevelType(nvp.get("HIERARCHY_LEVEL_TYPE"));
                        String tag = "HIERARCHY_LEVEL_REFERENCE_COLUMN";
                        String levelRefCol = nvp.get(tag);
                        if (levelRefCol != null) {
                            levelObj.setReferenceColumn(model.findLogicalColumn(levelRefCol));
                        }
                        if ((levelRefCol = nvp.get(tag = "HIERARCHY_LEVEL_REFERENCE_ORDINAL_COLUMN")) != null) {
                            levelObj.setReferenceOrdinalColumn(model.findLogicalColumn(levelRefCol));
                        }
                        if ((levelRefCol = nvp.get(tag = "HIERARCHY_LEVEL_REFERENCE_CAPTION_COLUMN")) != null) {
                            levelObj.setReferenceCaptionColumn(model.findLogicalColumn(levelRefCol));
                        }
                        ArrayList<LogicalColumn> referenceCols = new ArrayList<LogicalColumn>();
                        NodeList dimensionedObjs = level.getElementsByTagName("CWMMDB:DimensionedObject");
                        for (int k = 0; k < dimensionedObjs.getLength(); ++k) {
                            Element col = (Element)dimensionedObjs.item(k);
                            referenceCols.add(model.findLogicalColumn(col.getAttribute("name")));
                        }
                        levelObj.setHidden(nvp.get("HIERARCHY_LEVEL_HIDDEN") != null ? Boolean.parseBoolean(nvp.get("HIERARCHY_LEVEL_HIDDEN")) : false);
                        levelObj.setFormatter(nvp.get("HIERARCHY_LEVEL_FORMATTER"));
                        for (String taggedValueKey : nvp.keySet()) {
                            if (taggedValueKey == null || !taggedValueKey.startsWith("ANNOTATION_")) continue;
                            String name = taggedValueKey.substring(11);
                            String value = nvp.get(taggedValueKey);
                            OlapAnnotation annotationObj = new OlapAnnotation();
                            annotationObj.setName(name);
                            annotationObj.setValue(value);
                            levelObj.getAnnotations().add(annotationObj);
                        }
                        levelObj.setLogicalColumns(referenceCols);
                    }
                }
            }
            if (cubeList == null) continue;
            ArrayList<OlapCube> cubesList = new ArrayList<OlapCube>();
            NodeList cubes = cubeList.getElementsByTagName("CWMOLAP:Cube");
            for (i = 0; i < cubes.getLength(); ++i) {
                Element cube = (Element)cubes.item(i);
                OlapCube cubeObj = new OlapCube();
                cubeObj.setName(cube.getAttribute("name"));
                Map<String, String> nvp = XmiParser.getKeyValuePairs(cube, "CWM:TaggedValue", "tag", "value");
                cubeObj.setLogicalTable(model.findLogicalTable(nvp.get("CUBE_BUSINESS_TABLE")));
                ArrayList<OlapMeasure> measureList = new ArrayList<OlapMeasure>();
                NodeList measures = cube.getElementsByTagName("CWMOLAP:Measure");
                for (int j = 0; j < measures.getLength(); ++j) {
                    Element measure = (Element)measures.item(j);
                    OlapMeasure measureObj = new OlapMeasure();
                    measureObj.setName(measure.getAttribute("name"));
                    Map<String, String> nvp2 = XmiParser.getKeyValuePairs(measure, "CWM:TaggedValue", "tag", "value");
                    measureObj.setLogicalColumn(model.findLogicalColumn(nvp2.get("MEASURE_BUSINESS_COLUMN")));
                    measureObj.setHidden(nvp2.get("MEASURE_HIDDEN") != null ? Boolean.parseBoolean(nvp2.get("MEASURE_HIDDEN")) : false);
                    measureList.add(measureObj);
                }
                cubeObj.setOlapMeasures(measureList);
                ArrayList<OlapDimensionUsage> dimensionUsages = new ArrayList<OlapDimensionUsage>();
                NodeList usedDims = cube.getElementsByTagName("CWMOLAP:CubeDimensionAssociation");
                for (int j = 0; j < usedDims.getLength(); ++j) {
                    Element dim = (Element)usedDims.item(j);
                    OlapDimensionUsage dimUsage = new OlapDimensionUsage();
                    dimUsage.setName(dim.getAttribute("name"));
                    dimensionUsages.add(dimUsage);
                    NodeList dimensionLinks = dim.getElementsByTagName("CWMOLAP:Dimension");
                    if (dimensionLinks.getLength() != 1) continue;
                    Element dimensionLink = (Element)dimensionLinks.item(0);
                    dimUsage.setOlapDimension((OlapDimension)dimensionMap.get(dimensionLink.getAttribute("xmi.idref")));
                }
                cubeObj.setOlapDimensionUsages(dimensionUsages);
                cubesList.add(cubeObj);
            }
            model.setProperty("olap_cubes", cubesList);
        }
    }

    protected void bindParentConcept(Element element, Domain domain, IConcept concept) {
        String conceptParentName;
        Element tagged = null;
        NodeList pccn = element.getChildNodes();
        for (int j = 0; j < pccn.getLength(); ++j) {
            if (pccn.item(j).getNodeType() != 1 || !pccn.item(j).getNodeName().equals("CWM:ModelElement.taggedValue")) continue;
            tagged = (Element)pccn.item(j);
        }
        if (tagged != null && (conceptParentName = XmiParser.getKeyValue(tagged, "CWM:TaggedValue", "tag", "value", "CONCEPT_PARENT_NAME")) != null) {
            Concept parent = domain.findConcept(conceptParentName);
            if (parent == null) {
                logger.error((Object)Messages.getErrorString("XmiParser.ERROR_0006_FAILED_TO_LOCATE_CONCEPT", conceptParentName));
            } else {
                concept.setParentConcept(parent);
            }
        }
    }

    protected void addLocalizedString(Element description, Concept concept, String name, String body) {
        String lang = description.getAttribute("language");
        LocalizedString str = (LocalizedString)concept.getChildProperty(name);
        if (str == null) {
            str = new LocalizedString();
            concept.setProperty(name, str);
        }
        str.setString(lang, body);
    }

    protected void populateLocales(Domain domain, List<Element> parameters) {
        ArrayList<LocaleInterface> legacyLocaleList = new ArrayList<LocaleInterface>();
        for (Element parameter : parameters) {
            LocaleInterface locale = new LocaleMeta();
            locale.setCode(parameter.getAttribute("name"));
            Map<String, String> kvp = XmiParser.getKeyValuePairs(parameter, "CWM:TaggedValue", "tag", "value");
            String description = kvp.get("LOCALE_DESCRIPTION");
            if (!Const.isEmpty(description)) {
                locale.setDescription(description);
            }
            String strOrder = kvp.get("LOCALE_ORDER");
            locale.setOrder(Const.toInt(strOrder, -1));
            legacyLocaleList.add(locale);
        }
        ArrayList<LocaleType> localeTypes = new ArrayList<LocaleType>();
        Collections.sort(legacyLocaleList, new Comparator<LocaleInterface>(){

            @Override
            public int compare(LocaleInterface o1, LocaleInterface o2) {
                if (o1.getOrder() > o2.getOrder()) {
                    return 1;
                }
                if (o1.getOrder() < o2.getOrder()) {
                    return -1;
                }
                return 0;
            }
        });
        for (LocaleInterface locale : legacyLocaleList) {
            LocaleType localeType = new LocaleType();
            localeType.setDescription(locale.getDescription());
            localeType.setCode(locale.getCode());
            localeTypes.add(localeType);
        }
        domain.setLocales(localeTypes);
    }

    private void validateDomain(Domain domain) {
        for (LogicalModel model : domain.getLogicalModels()) {
            this.validateModel(model);
        }
    }

    private void validateModel(LogicalModel model) {
        Map<String, LogicalTable> tablesMapping = XmiParser.createIdToConceptMapping(model.getLogicalTables());
        for (LogicalTable table : model.getLogicalTables()) {
            this.validateTable(table, tablesMapping);
        }
        Map<String, Category> categoiesMapping = XmiParser.createIdToConceptMapping(model.getCategories());
        for (Category category : model.getCategories()) {
            this.validateCategory(category, categoiesMapping);
        }
    }

    private void validateTable(LogicalTable table, Map<String, LogicalTable> mapping) {
        XmiParser.validateConceptId(table, mapping, "XmiParser.ERROR_0012_INVALID_TABLE_ID");
        Map<String, LogicalColumn> columnsMapping = XmiParser.createIdToConceptMapping(table.getLogicalColumns());
        for (LogicalColumn column : table.getLogicalColumns()) {
            this.validateColumn(column, columnsMapping);
        }
    }

    private void validateColumn(LogicalColumn column, Map<String, LogicalColumn> mapping) {
        XmiParser.validateConceptId(column, mapping, "XmiParser.ERROR_0012_INVALID_COLUMN_ID");
    }

    private void validateCategory(Category category, Map<String, Category> mapping) {
        XmiParser.validateConceptId(category, mapping, "XmiParser.ERROR_0012_INVALID_CATEGORY_ID");
    }

    private static <T extends Concept> Map<String, T> createIdToConceptMapping(List<T> concepts) {
        HashMap<String, Concept> map = new HashMap<String, Concept>(concepts.size());
        for (Concept concept : concepts) {
            map.put(concept.getId(), concept);
        }
        return map;
    }

    private static <T extends Concept> void validateConceptId(T concept, Map<String, T> siblings, String i18nKey) {
        String id = concept.getId();
        if (!Util.validateId(id)) {
            String newId = Util.toId(id);
            int n = 1;
            String tmp = newId;
            while (siblings.containsKey(tmp)) {
                tmp = newId + n;
                ++n;
            }
            newId = tmp;
            siblings.remove(id);
            siblings.put(newId, concept);
            concept.setId(newId);
            logger.info((Object)Messages.getString(i18nKey, id, newId));
        }
    }

    private static Map<String, String> getKeyValuePairs(Element parent, String childName, String keyAttrib, String valAttrib) {
        HashMap<String, String> map = new HashMap<String, String>();
        NodeList nodeList = parent.getElementsByTagName(childName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            map.put(((Element)nodeList.item(i)).getAttribute(keyAttrib), ((Element)nodeList.item(i)).getAttribute(valAttrib));
        }
        return map;
    }

    private static String getKeyValue(Element parent, String childName, String keyAttrib, String valAttrib, String keyVal) {
        if (parent == null) {
            return null;
        }
        NodeList nodeList = parent.getElementsByTagName(childName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String key = ((Element)nodeList.item(i)).getAttribute(keyAttrib);
            if (!key.equals(keyVal)) continue;
            return ((Element)nodeList.item(i)).getAttribute(valAttrib);
        }
        return null;
    }

    public static DocumentBuilderFactory createSecureDocBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = XMLParserFactoryProducer.createSecureDocBuilderFactory();
        return documentBuilderFactory;
    }

    protected static class IdGen {
        int val = 1;

        protected IdGen() {
        }

        public String getNextId() {
            return "a" + this.val++;
        }
    }
}

