/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.spark;

import java.io.IOException;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.pentaho.capabilities.api.ICapability;
import org.pentaho.capabilities.api.ICapabilityManager;
import org.pentaho.capabilities.impl.DefaultCapabilityManager;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationExecutor;
import org.pentaho.di.engine.configuration.impl.spark.SparkRunConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;

public class SparkRunConfigurationExecutor
implements RunConfigurationExecutor {
    public static String ZOOKEEPER_CAPABILITY_ID = "aries-rsa-discovery-zookeeper";
    public static String PENTAHO_SERVER_CAPABILITY_ID = "pentaho-server";
    public static String CONFIG_KEY = "org.apache.aries.rsa.discovery.zookeeper";
    public static String JAAS_CAPABILITY_ID = "pentaho-kerberos-jaas";
    public static String AEL_SECURITY_CAPABILITY_ID = "ael-security";
    public static String DEFAULT_HOST = "127.0.0.1";
    public static String DEFAULT_PORT = "2181";
    private ConfigurationAdmin configurationAdmin;
    private ICapabilityManager capabilityManager = DefaultCapabilityManager.getInstance();

    public SparkRunConfigurationExecutor(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void execute(RunConfiguration runConfiguration, TransExecutionConfiguration configuration, AbstractMeta meta, VariableSpace variableSpace) {
        ICapability capability;
        ICapability securityCapability = this.capabilityManager.getCapabilityById(AEL_SECURITY_CAPABILITY_ID);
        ICapability jaasCapability = this.capabilityManager.getCapabilityById(JAAS_CAPABILITY_ID);
        if (securityCapability != null && securityCapability.isInstalled() && jaasCapability != null && !jaasCapability.isInstalled()) {
            jaasCapability.install();
        }
        if ((capability = this.capabilityManager.getCapabilityById(ZOOKEEPER_CAPABILITY_ID)) != null && !capability.isInstalled()) {
            capability.install();
        }
        if (this.capabilityManager.getCapabilityById(PENTAHO_SERVER_CAPABILITY_ID) == null) {
            SparkRunConfiguration sparkRunConfiguration = (SparkRunConfiguration)runConfiguration;
            String[] parts = Const.NVL((String)sparkRunConfiguration.getUrl(), (String)"").split(":");
            String host = parts[0];
            String port = parts.length > 1 ? parts[1] : DEFAULT_PORT;
            try {
                Configuration zookeeperConfiguration = this.configurationAdmin.getConfiguration(CONFIG_KEY);
                Dictionary properties = zookeeperConfiguration.getProperties();
                if (properties != null) {
                    properties.put("zookeeper.host", Const.NVL((String)host, (String)DEFAULT_HOST));
                    properties.put("zookeeper.port", Const.NVL((String)port, (String)DEFAULT_PORT));
                    zookeeperConfiguration.update(properties);
                }
            }
            catch (IOException ioe) {
                System.out.println("Error occurred accessing configuration");
            }
        }
        variableSpace.setVariable("engine", "remote");
        variableSpace.setVariable("engine.remote", "spark");
    }
}

