/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class LcidLocale {
    final Map<Short, Info> lcidLocaleMap = new HashMap<Short, Info>();
    final Map<String, Info> localeToLcidMap = new HashMap<String, Info>();
    private static LcidLocale INSTANCE;

    private LcidLocale() {
        URL resource = this.getClass().getResource("nls.properties");
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            Properties map = properties;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("locale.") || !key.endsWith(".lcid")) continue;
                String root = key.substring(0, key.length() - ".lcid".length());
                Info info = new Info(Short.parseShort(((String)entry.getValue()).substring(2), 16), root.substring("locale.".length()).replace('-', '_'), (String)map.get(root + ".locale"), (String)map.get(root + ".language"), (String)map.get(root + ".languageLocal"), Short.parseShort((String)map.get(root + ".codepageAnsi")), Short.parseShort((String)map.get(root + ".codepageOem")), (String)map.get(root + ".regionAbbrev"), (String)map.get(root + ".languageAbbrev"));
                this.lcidLocaleMap.put(info.lcid, info);
                this.localeToLcidMap.put(info.localeCode, info);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while initializing LcidLocale", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static LcidLocale instance() {
        if (INSTANCE == null) {
            INSTANCE = new LcidLocale();
        }
        return INSTANCE;
    }

    private Locale toLocale(short lcid) {
        Info s = this.lcidLocaleMap.get(lcid);
        if (s == null) {
            throw new RuntimeException("Unknown LCID " + lcid);
        }
        return s.getLocale();
    }

    public static Locale lcidToLocale(short lcid) {
        if (lcid == 1033) {
            return Locale.US;
        }
        return LcidLocale.instance().toLocale(lcid);
    }

    public static short localeToLcid(Locale locale) {
        if (locale.equals(Locale.US)) {
            return 1033;
        }
        return LcidLocale.instance().toLcid(locale.toString());
    }

    private short toLcid(String localeName) {
        String localeName0 = localeName;
        Info info;
        while ((info = this.localeToLcidMap.get(localeName)) == null) {
            int underscore = localeName.lastIndexOf(95);
            if (underscore < 0) {
                throw new RuntimeException("Unknown locale " + localeName0);
            }
            localeName = localeName.substring(0, underscore);
        }
        return info.lcid;
    }

    public static Locale parseLocale(String localeString) {
        String[] strings = localeString.split("_");
        switch (strings.length) {
            case 1: {
                return new Locale(strings[0]);
            }
            case 2: {
                return new Locale(strings[0], strings[1]);
            }
            case 3: {
                return new Locale(strings[0], strings[1], strings[2]);
            }
        }
        throw new RuntimeException("bad locale string '" + localeString + "'");
    }

    public static class Info {
        public final short lcid;
        public final String localeCode;
        public final String locale;
        public final String language;
        public final String languageLocal;
        public final short codepageAnsi;
        public final short codepageOem;
        public final String regionAbbrev;
        public final String languageAbbrev;

        private Info(short lcid, String localeCode, String locale, String language, String languageLocal, short codepageAnsi, short codepageOem, String regionAbbrev, String languageAbbrev) {
            this.lcid = lcid;
            this.localeCode = localeCode;
            this.locale = locale;
            this.language = language;
            this.languageLocal = languageLocal;
            this.codepageAnsi = codepageAnsi;
            this.codepageOem = codepageOem;
            this.regionAbbrev = regionAbbrev;
            this.languageAbbrev = languageAbbrev;
        }

        public Locale getLocale() {
            return LcidLocale.parseLocale(this.localeCode);
        }
    }
}

