/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.core;

import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProducer {
    private static final Logger LOG = LoggerFactory.getLogger(EventProducer.class);
    private final BundleContext bctx;

    public EventProducer(BundleContext bc) {
        this.bctx = bc;
    }

    protected void publishNotification(List<ExportRegistration> erl) {
        for (ExportRegistration exportRegistration : erl) {
            this.publishNotification(exportRegistration);
        }
    }

    protected void publishNotification(ExportRegistration er) {
        if (er.getException() == null) {
            this.notify(2, er.getExportReference(), null);
        } else {
            this.notify(6, (ExportReference)null, er.getException());
        }
    }

    protected void publishNotification(ImportRegistration ir) {
        if (ir.getException() == null) {
            this.notify(1, ir.getImportReference(), null);
        } else {
            this.notify(5, (ImportReference)null, ir.getException());
        }
    }

    public void notifyRemoval(ExportReference er) {
        this.notify(3, er, null);
    }

    public void notifyRemoval(ImportRegistration ir) {
        this.notify(4, ir.getImportReference(), null);
    }

    private void notify(int type, ExportReference er, Throwable ex) {
        try {
            RemoteServiceAdminEvent event = new RemoteServiceAdminEvent(type, this.bctx.getBundle(), er, ex);
            this.notifyListeners(event);
        }
        catch (IllegalStateException ise) {
            LOG.debug("can't send notifications since bundle context is no longer valid");
        }
    }

    private void notify(int type, ImportReference ir, Throwable ex) {
        try {
            RemoteServiceAdminEvent event = new RemoteServiceAdminEvent(type, this.bctx.getBundle(), ir, ex);
            this.notifyListeners(event);
        }
        catch (IllegalStateException ise) {
            LOG.debug("can't send notifications since bundle context is no longer valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(RemoteServiceAdminEvent rsae) {
        try {
            ServiceReference[] listenerRefs = this.bctx.getServiceReferences(RemoteServiceAdminListener.class.getName(), null);
            if (listenerRefs != null) {
                for (ServiceReference sref : listenerRefs) {
                    RemoteServiceAdminListener rsal = (RemoteServiceAdminListener)this.bctx.getService(sref);
                    if (rsal == null) continue;
                    try {
                        Bundle bundle = sref.getBundle();
                        if (bundle == null) continue;
                        LOG.debug("notify RemoteServiceAdminListener {} of bundle {}", (Object)rsal, (Object)bundle.getSymbolicName());
                        rsal.remoteAdminEvent(rsae);
                    }
                    finally {
                        this.bctx.ungetService(sref);
                    }
                }
            }
        }
        catch (InvalidSyntaxException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

