/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.importer;

import java.util.Collection;
import org.apache.aries.rsa.topologymanager.importer.FilterHelper;
import org.apache.aries.rsa.topologymanager.importer.ServiceInterestListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.service.ListenerHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerHookImpl
implements ListenerHook {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerHookImpl.class);
    private final BundleContext bctx;
    private final ServiceInterestListener serviceInterestListener;
    private final String frameworkUUID;

    public ListenerHookImpl(BundleContext bc, ServiceInterestListener serviceInterestListener) {
        this.bctx = bc;
        this.frameworkUUID = this.bctx.getProperty("org.osgi.framework.uuid");
        this.serviceInterestListener = serviceInterestListener;
    }

    public void added(Collection<ListenerHook.ListenerInfo> listeners) {
        LOG.debug("added listeners {}", listeners);
        for (ListenerHook.ListenerInfo listenerInfo : listeners) {
            LOG.debug("Filter {}", (Object)listenerInfo.getFilter());
            String className = FilterHelper.getObjectClass(listenerInfo.getFilter());
            if (listenerInfo.getBundleContext().equals(this.bctx)) {
                LOG.debug("ListenerHookImpl: skipping request from myself");
                continue;
            }
            if (listenerInfo.getFilter() == null) {
                LOG.debug("skipping empty filter");
                continue;
            }
            if (FilterHelper.isClassExcluded(className)) {
                LOG.debug("Skipping import request for excluded class [{}]", (Object)className);
                continue;
            }
            String exFilter = this.extendFilter(listenerInfo.getFilter());
            this.serviceInterestListener.addServiceInterest(exFilter);
        }
    }

    public void removed(Collection<ListenerHook.ListenerInfo> listeners) {
        LOG.debug("removed listeners {}", listeners);
        for (ListenerHook.ListenerInfo listenerInfo : listeners) {
            LOG.debug("Filter {}", (Object)listenerInfo.getFilter());
            String exFilter = this.extendFilter(listenerInfo.getFilter());
            this.serviceInterestListener.removeServiceInterest(exFilter);
        }
    }

    String extendFilter(String filter) {
        return "(&" + filter + "(!(" + "endpoint.framework.uuid" + "=" + this.frameworkUUID + ")))";
    }
}

