/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.importer;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointListenerManager {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointListenerManager.class);
    private final BundleContext bctx;
    private volatile ServiceRegistration<EndpointListener> serviceRegistration;
    private final List<String> filters = new ArrayList<String>();
    private final EndpointListener endpointListener;

    public EndpointListenerManager(BundleContext bc, EndpointListener endpointListener) {
        this.bctx = bc;
        this.endpointListener = endpointListener;
    }

    protected void start() {
        this.serviceRegistration = this.bctx.registerService(EndpointListener.class, (Object)this.endpointListener, this.getRegistrationProperties());
    }

    public void stop() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extendScope(String filter) {
        if (filter == null) {
            return;
        }
        LOG.debug("EndpointListener: extending scope by {}", (Object)filter);
        List<String> list = this.filters;
        synchronized (list) {
            this.filters.add(filter);
        }
        this.updateRegistration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reduceScope(String filter) {
        if (filter == null) {
            return;
        }
        LOG.debug("EndpointListener: reducing scope by {}", (Object)filter);
        List<String> list = this.filters;
        synchronized (list) {
            this.filters.remove(filter);
        }
        this.updateRegistration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary<String, Object> getRegistrationProperties() {
        Hashtable<String, Object> p = new Hashtable<String, Object>();
        List<String> list = this.filters;
        synchronized (list) {
            LOG.debug("Current filter: {}", this.filters);
            ((Dictionary)p).put("endpoint.listener.scope", new ArrayList<String>(this.filters));
        }
        return p;
    }

    private void updateRegistration() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.setProperties(this.getRegistrationProperties());
        }
    }
}

