/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;

public class WorkflowJobGetForSLAJPAExecutor
implements JPAExecutor<WorkflowJobBean> {
    private String wfJobId;

    public WorkflowJobGetForSLAJPAExecutor(String wfJobId) {
        ParamChecker.notNull(wfJobId, "wfJobId");
        this.wfJobId = wfJobId;
    }

    @Override
    public String getName() {
        return "WorkflowJobGetForSLAJPAExecutor";
    }

    @Override
    public WorkflowJobBean execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_WORKFLOW_FOR_SLA");
            q.setParameter("id", (Object)this.wfJobId);
            Object[] obj = (Object[])q.getSingleResult();
            return this.getBeanFromArray(obj);
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }

    private WorkflowJobBean getBeanFromArray(Object[] arr) {
        WorkflowJobBean wjb = new WorkflowJobBean();
        if (arr[0] != null) {
            wjb.setId((String)arr[0]);
        }
        if (arr[1] != null) {
            wjb.setStatus(WorkflowJob.Status.valueOf((String)((String)arr[1])));
        }
        if (arr[2] != null) {
            wjb.setStartTime(DateUtils.toDate((Timestamp)arr[2]));
        }
        if (arr[3] != null) {
            wjb.setEndTime(DateUtils.toDate((Timestamp)arr[3]));
        }
        return wjb;
    }
}

