/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.List;
import java.util.Map;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.executor.jpa.SLAEventsGetForFilterJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class SLAEventsXCommand
extends XCommand<List<SLAEventBean>> {
    private long seqId = 0L;
    private int maxNoEvents = 100;
    private long lastSeqId = -1L;
    private final Map<String, List<String>> filter;
    public static final String SLA_DEFAULT_MAXEVENTS = "oozie.service.sla.default.maxevents";

    public SLAEventsXCommand(long seqId, int maxNoEvnts, Map<String, List<String>> filter) {
        super("SLAEventsXCommand", "SLAEventsXCommand", 1);
        this.seqId = seqId;
        int sysMax = Services.get().getConf().getInt(SLA_DEFAULT_MAXEVENTS, 1000);
        this.maxNoEvents = maxNoEvnts > sysMax ? sysMax : maxNoEvnts;
        this.filter = filter;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return Long.toString(this.seqId);
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected List<SLAEventBean> execute() throws CommandException {
        try {
            JPAService jpaService = Services.get().get(JPAService.class);
            List<SLAEventBean> slaEventList = null;
            long[] lastSeqId = new long[1];
            if (jpaService != null) {
                slaEventList = jpaService.execute(new SLAEventsGetForFilterJPAExecutor(this.seqId, this.maxNoEvents, this.filter, lastSeqId));
            } else {
                this.LOG.error((Object)ErrorCode.E0610);
            }
            this.setLastSeqId(lastSeqId[0]);
            return slaEventList;
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    public void setLastSeqId(long lastSeqId) {
        this.lastSeqId = lastSeqId;
    }

    public long getLastSeqId() {
        return this.lastSeqId;
    }
}

