/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.engine.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.pentaho.di.engine.api.events.StatusEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.remote.RemoteSource;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.pdi.engine.serializers.BaseSerializer;

public class StatusEventSerializer
extends BaseSerializer<StatusEvent> {
    public StatusEventSerializer() {
        super(StatusEvent.class);
        SimpleModule module = new SimpleModule();
        module.addSerializer(StatusEvent.class, (JsonSerializer)new JsonSerializer<StatusEvent>(){

            public void serialize(StatusEvent statusEvent, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("model-id", statusEvent.getSource().getId());
                jsonGenerator.writeStringField("status-type", statusEvent.getData().toString());
                jsonGenerator.writeEndObject();
            }
        });
        module.addDeserializer(StatusEvent.class, (JsonDeserializer)new StdNodeBasedDeserializer<StatusEvent>(StatusEvent.class){

            public StatusEvent convert(JsonNode jsonNode, DeserializationContext deserializationContext) throws IOException {
                return new StatusEvent((LogicalModelElement)new RemoteSource(jsonNode.get("model-id").asText()), Status.valueOf((String)jsonNode.get("status-type").asText()));
            }
        });
        this.mapper.registerModule((Module)module);
    }
}

