/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.ColumnNameHelper;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.StreamingHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableMetadata {
    public static final double NO_BLOOM_FLITER_FP_CHANCE = -1.0;
    public static final double NO_COMPRESSION_RATIO = -1.0;
    public static final SSTableMetadataSerializer serializer = new SSTableMetadataSerializer();
    public final EstimatedHistogram estimatedRowSize;
    public final EstimatedHistogram estimatedColumnCount;
    public final ReplayPosition replayPosition;
    public final long minTimestamp;
    public final long maxTimestamp;
    public final int maxLocalDeletionTime;
    public final double bloomFilterFPChance;
    public final double compressionRatio;
    public final String partitioner;
    public final StreamingHistogram estimatedTombstoneDropTime;
    public final int sstableLevel;
    public final List<ByteBuffer> maxColumnNames;
    public final List<ByteBuffer> minColumnNames;

    private SSTableMetadata() {
        this(SSTableMetadata.defaultRowSizeHistogram(), SSTableMetadata.defaultColumnCountHistogram(), ReplayPosition.NONE, Long.MIN_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE, -1.0, -1.0, null, SSTableMetadata.defaultTombstoneDropTimeHistogram(), 0, Collections.emptyList(), Collections.emptyList());
    }

    private SSTableMetadata(EstimatedHistogram rowSizes, EstimatedHistogram columnCounts, ReplayPosition replayPosition, long minTimestamp, long maxTimestamp, int maxLocalDeletionTime, double bloomFilterFPChance, double compressionRatio, String partitioner, StreamingHistogram estimatedTombstoneDropTime, int sstableLevel, List<ByteBuffer> minColumnNames, List<ByteBuffer> maxColumnNames) {
        this.estimatedRowSize = rowSizes;
        this.estimatedColumnCount = columnCounts;
        this.replayPosition = replayPosition;
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.maxLocalDeletionTime = maxLocalDeletionTime;
        this.bloomFilterFPChance = bloomFilterFPChance;
        this.compressionRatio = compressionRatio;
        this.partitioner = partitioner;
        this.estimatedTombstoneDropTime = estimatedTombstoneDropTime;
        this.sstableLevel = sstableLevel;
        this.minColumnNames = minColumnNames;
        this.maxColumnNames = maxColumnNames;
    }

    public static Collector createCollector(AbstractType<?> columnNameComparator) {
        return new Collector(columnNameComparator);
    }

    public static Collector createCollector(Collection<SSTableReader> sstables, AbstractType<?> columnNameComparator, int level) {
        Collector collector = new Collector(columnNameComparator);
        collector.replayPosition(ReplayPosition.getReplayPosition(sstables));
        collector.sstableLevel(level);
        for (SSTableReader sstable : sstables) {
            collector.addAncestor(sstable.descriptor.generation);
            for (Integer i : sstable.getAncestors()) {
                if (!new File(sstable.descriptor.withGeneration(i).filenameFor(Component.DATA)).exists()) continue;
                collector.addAncestor(i);
            }
        }
        return collector;
    }

    @Deprecated
    public static SSTableMetadata copyWithNewSSTableLevel(SSTableMetadata metadata, int sstableLevel) {
        return new SSTableMetadata(metadata.estimatedRowSize, metadata.estimatedColumnCount, metadata.replayPosition, metadata.minTimestamp, metadata.maxTimestamp, metadata.maxLocalDeletionTime, metadata.bloomFilterFPChance, metadata.compressionRatio, metadata.partitioner, metadata.estimatedTombstoneDropTime, sstableLevel, metadata.minColumnNames, metadata.maxColumnNames);
    }

    static EstimatedHistogram defaultColumnCountHistogram() {
        return new EstimatedHistogram(114);
    }

    static EstimatedHistogram defaultRowSizeHistogram() {
        return new EstimatedHistogram(150);
    }

    static StreamingHistogram defaultTombstoneDropTimeHistogram() {
        return new StreamingHistogram(100);
    }

    public double getEstimatedDroppableTombstoneRatio(int gcBefore) {
        long estimatedColumnCount = this.estimatedColumnCount.mean() * this.estimatedColumnCount.count();
        if (estimatedColumnCount > 0L) {
            double droppable = this.getDroppableTombstonesBefore(gcBefore);
            return droppable / (double)estimatedColumnCount;
        }
        return 0.0;
    }

    public double getDroppableTombstonesBefore(int gcBefore) {
        return this.estimatedTombstoneDropTime.sum(gcBefore);
    }

    public static class SSTableMetadataSerializer {
        private static final Logger logger = LoggerFactory.getLogger(SSTableMetadataSerializer.class);

        public void serialize(SSTableMetadata sstableStats, Set<Integer> ancestors, DataOutput out) throws IOException {
            assert (sstableStats.partitioner != null);
            EstimatedHistogram.serializer.serialize(sstableStats.estimatedRowSize, out);
            EstimatedHistogram.serializer.serialize(sstableStats.estimatedColumnCount, out);
            ReplayPosition.serializer.serialize(sstableStats.replayPosition, out);
            out.writeLong(sstableStats.minTimestamp);
            out.writeLong(sstableStats.maxTimestamp);
            out.writeInt(sstableStats.maxLocalDeletionTime);
            out.writeDouble(sstableStats.bloomFilterFPChance);
            out.writeDouble(sstableStats.compressionRatio);
            out.writeUTF(sstableStats.partitioner);
            out.writeInt(ancestors.size());
            for (Integer g : ancestors) {
                out.writeInt(g);
            }
            StreamingHistogram.serializer.serialize(sstableStats.estimatedTombstoneDropTime, out);
            out.writeInt(sstableStats.sstableLevel);
            this.serializeMinMaxColumnNames(sstableStats.minColumnNames, sstableStats.maxColumnNames, out);
        }

        private void serializeMinMaxColumnNames(List<ByteBuffer> minColNames, List<ByteBuffer> maxColNames, DataOutput out) throws IOException {
            out.writeInt(minColNames.size());
            for (ByteBuffer columnName : minColNames) {
                ByteBufferUtil.writeWithShortLength(columnName, out);
            }
            out.writeInt(maxColNames.size());
            for (ByteBuffer columnName : maxColNames) {
                ByteBufferUtil.writeWithShortLength(columnName, out);
            }
        }

        @Deprecated
        public void legacySerialize(SSTableMetadata sstableStats, Set<Integer> ancestors, Descriptor legacyDesc, DataOutput out) throws IOException {
            EstimatedHistogram.serializer.serialize(sstableStats.estimatedRowSize, out);
            EstimatedHistogram.serializer.serialize(sstableStats.estimatedColumnCount, out);
            ReplayPosition.serializer.serialize(sstableStats.replayPosition, out);
            out.writeLong(sstableStats.minTimestamp);
            out.writeLong(sstableStats.maxTimestamp);
            if (legacyDesc.version.tracksMaxLocalDeletionTime) {
                out.writeInt(sstableStats.maxLocalDeletionTime);
            }
            if (legacyDesc.version.hasBloomFilterFPChance) {
                out.writeDouble(sstableStats.bloomFilterFPChance);
            }
            out.writeDouble(sstableStats.compressionRatio);
            out.writeUTF(sstableStats.partitioner);
            out.writeInt(ancestors.size());
            for (Integer g : ancestors) {
                out.writeInt(g);
            }
            StreamingHistogram.serializer.serialize(sstableStats.estimatedTombstoneDropTime, out);
            out.writeInt(sstableStats.sstableLevel);
            if (legacyDesc.version.tracksMaxMinColumnNames) {
                this.serializeMinMaxColumnNames(sstableStats.minColumnNames, sstableStats.maxColumnNames, out);
            }
        }

        public Pair<SSTableMetadata, Set<Integer>> deserialize(Descriptor descriptor) throws IOException {
            return this.deserialize(descriptor, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Pair<SSTableMetadata, Set<Integer>> deserialize(Descriptor descriptor, boolean loadSSTableLevel) throws IOException {
            logger.debug("Load metadata for {}", (Object)descriptor);
            File statsFile = new File(descriptor.filenameFor(SSTable.COMPONENT_STATS));
            if (!statsFile.exists()) {
                logger.debug("No sstable stats for {}", (Object)descriptor);
                return Pair.create(new SSTableMetadata(), Collections.emptySet());
            }
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(statsFile)));
            try {
                Pair<SSTableMetadata, Set<Integer>> pair = this.deserialize(in, descriptor, loadSSTableLevel);
                return pair;
            }
            finally {
                FileUtils.closeQuietly(in);
            }
        }

        public Pair<SSTableMetadata, Set<Integer>> deserialize(DataInputStream in, Descriptor desc) throws IOException {
            return this.deserialize(in, desc, true);
        }

        public Pair<SSTableMetadata, Set<Integer>> deserialize(DataInputStream in, Descriptor desc, boolean loadSSTableLevel) throws IOException {
            List maxColumnNames;
            List minColumnNames;
            EstimatedHistogram rowSizes = EstimatedHistogram.serializer.deserialize(in);
            EstimatedHistogram columnCounts = EstimatedHistogram.serializer.deserialize(in);
            ReplayPosition replayPosition = ReplayPosition.serializer.deserialize(in);
            long minTimestamp = in.readLong();
            long maxTimestamp = in.readLong();
            int maxLocalDeletionTime = desc.version.tracksMaxLocalDeletionTime ? in.readInt() : Integer.MAX_VALUE;
            double bloomFilterFPChance = desc.version.hasBloomFilterFPChance ? in.readDouble() : -1.0;
            double compressionRatio = in.readDouble();
            String partitioner = in.readUTF();
            int nbAncestors = in.readInt();
            HashSet<Integer> ancestors = new HashSet<Integer>(nbAncestors);
            for (int i = 0; i < nbAncestors; ++i) {
                ancestors.add(in.readInt());
            }
            StreamingHistogram tombstoneHistogram = StreamingHistogram.serializer.deserialize(in);
            int sstableLevel = 0;
            if (loadSSTableLevel && in.available() > 0) {
                sstableLevel = in.readInt();
            }
            if (desc.version.tracksMaxMinColumnNames) {
                int i;
                int colCount = in.readInt();
                minColumnNames = new ArrayList(colCount);
                for (i = 0; i < colCount; ++i) {
                    minColumnNames.add(ByteBufferUtil.readWithShortLength(in));
                }
                colCount = in.readInt();
                maxColumnNames = new ArrayList(colCount);
                for (i = 0; i < colCount; ++i) {
                    maxColumnNames.add(ByteBufferUtil.readWithShortLength(in));
                }
            } else {
                minColumnNames = Collections.emptyList();
                maxColumnNames = Collections.emptyList();
            }
            return Pair.create(new SSTableMetadata(rowSizes, columnCounts, replayPosition, minTimestamp, maxTimestamp, maxLocalDeletionTime, bloomFilterFPChance, compressionRatio, partitioner, tombstoneHistogram, sstableLevel, minColumnNames, maxColumnNames), ancestors);
        }
    }

    public static class Collector {
        protected EstimatedHistogram estimatedRowSize = SSTableMetadata.defaultRowSizeHistogram();
        protected EstimatedHistogram estimatedColumnCount = SSTableMetadata.defaultColumnCountHistogram();
        protected ReplayPosition replayPosition = ReplayPosition.NONE;
        protected long minTimestamp = Long.MAX_VALUE;
        protected long maxTimestamp = Long.MIN_VALUE;
        protected int maxLocalDeletionTime = Integer.MIN_VALUE;
        protected double compressionRatio = -1.0;
        protected Set<Integer> ancestors = new HashSet<Integer>();
        protected StreamingHistogram estimatedTombstoneDropTime = SSTableMetadata.defaultTombstoneDropTimeHistogram();
        protected int sstableLevel;
        protected List<ByteBuffer> minColumnNames = Collections.emptyList();
        protected List<ByteBuffer> maxColumnNames = Collections.emptyList();
        private final AbstractType<?> columnNameComparator;

        private Collector(AbstractType<?> columnNameComparator) {
            this.columnNameComparator = columnNameComparator;
        }

        public void addRowSize(long rowSize) {
            this.estimatedRowSize.add(rowSize);
        }

        public void addColumnCount(long columnCount) {
            this.estimatedColumnCount.add(columnCount);
        }

        public void mergeTombstoneHistogram(StreamingHistogram histogram) {
            this.estimatedTombstoneDropTime.merge(histogram);
        }

        public void addCompressionRatio(long compressed, long uncompressed) {
            this.compressionRatio = (double)compressed / (double)uncompressed;
        }

        public void updateMinTimestamp(long potentialMin) {
            this.minTimestamp = Math.min(this.minTimestamp, potentialMin);
        }

        public void updateMaxTimestamp(long potentialMax) {
            this.maxTimestamp = Math.max(this.maxTimestamp, potentialMax);
        }

        public void updateMaxLocalDeletionTime(int maxLocalDeletionTime) {
            this.maxLocalDeletionTime = Math.max(this.maxLocalDeletionTime, maxLocalDeletionTime);
        }

        public SSTableMetadata finalizeMetadata(String partitioner, double bloomFilterFPChance) {
            return new SSTableMetadata(this.estimatedRowSize, this.estimatedColumnCount, this.replayPosition, this.minTimestamp, this.maxTimestamp, this.maxLocalDeletionTime, bloomFilterFPChance, this.compressionRatio, partitioner, this.estimatedTombstoneDropTime, this.sstableLevel, this.minColumnNames, this.maxColumnNames);
        }

        public Collector estimatedRowSize(EstimatedHistogram estimatedRowSize) {
            this.estimatedRowSize = estimatedRowSize;
            return this;
        }

        public Collector estimatedColumnCount(EstimatedHistogram estimatedColumnCount) {
            this.estimatedColumnCount = estimatedColumnCount;
            return this;
        }

        public Collector replayPosition(ReplayPosition replayPosition) {
            this.replayPosition = replayPosition;
            return this;
        }

        public Collector addAncestor(int generation) {
            this.ancestors.add(generation);
            return this;
        }

        void update(long size, ColumnStats stats) {
            this.updateMinTimestamp(stats.minTimestamp);
            this.updateMaxTimestamp(stats.maxTimestamp);
            this.updateMaxLocalDeletionTime(stats.maxLocalDeletionTime);
            this.addRowSize(size);
            this.addColumnCount(stats.columnCount);
            this.mergeTombstoneHistogram(stats.tombstoneHistogram);
            this.updateMinColumnNames(stats.minColumnNames);
            this.updateMaxColumnNames(stats.maxColumnNames);
        }

        public Collector sstableLevel(int sstableLevel) {
            this.sstableLevel = sstableLevel;
            return this;
        }

        public Collector updateMinColumnNames(List<ByteBuffer> minColumnNames) {
            if (minColumnNames.size() > 0) {
                this.minColumnNames = ColumnNameHelper.mergeMin(this.minColumnNames, minColumnNames, this.columnNameComparator);
            }
            return this;
        }

        public Collector updateMaxColumnNames(List<ByteBuffer> maxColumnNames) {
            if (maxColumnNames.size() > 0) {
                this.maxColumnNames = ColumnNameHelper.mergeMax(this.maxColumnNames, maxColumnNames, this.columnNameComparator);
            }
            return this;
        }
    }
}

