/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.spi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.LoggingToAccumAdapter;
import org.pentaho.di.engine.spark.impl.functions.FunctionLogger;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowHandler;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class KettleStepFunction
extends ConfigurableFunction<Iterator<Row>, Row> {
    private static final long serialVersionUID = 7177117844030482527L;
    private transient StepMeta stepMeta;
    private final AtomicBoolean disposed = new AtomicBoolean();
    protected FunctionLogger transLogger = FunctionLogger.empty();
    protected FunctionLogger operationLogger = FunctionLogger.empty();

    public KettleStepFunction() {
    }

    public KettleStepFunction(StepMeta stepMeta) {
        this();
        this.stepMeta = stepMeta;
    }

    public StepMeta getStepMeta() {
        return this.stepMeta;
    }

    public void setStepMeta(StepMeta stepMeta) {
        this.stepMeta = stepMeta;
    }

    public Iterator<Row> call(Iterator<Row> input) {
        Objects.requireNonNull(this.stepMeta, "Missing stepMeta");
        if (LoggingToAccumAdapter.getInstance().getAccumulator() == null) {
            LoggingToAccumAdapter.getInstance().setAccumulator(this.operationLogger.getAccumulator());
        }
        final BaseStep step = this.createStep();
        StepMetaInterface smi = step.getStepMetaInterface();
        StepDataInterface sdi = step.getStepDataInterface();
        step.init(smi, sdi);
        PeekingIterator lookAheadInput = Iterators.peekingIterator(input);
        if (lookAheadInput.hasNext()) {
            step.setInputRowMeta(Util.getPrevStepFields(this.stepMeta.getParentTransMeta(), this.stepMeta.getName()));
        }
        final LinkedList<KettleRow> outputQueue = new LinkedList<KettleRow>();
        step.setRowHandler((RowHandler)new RowIterator((Iterator<? extends Row>)lookAheadInput, outputQueue));
        this.operationLogger.basic("KettleStepFunction has initialized for processing");
        return new Iterator<Row>(){
            private boolean continueProcessing = true;

            @Override
            public boolean hasNext() {
                while (outputQueue.isEmpty() && this.continueProcessing) {
                    this.continueProcessing = KettleStepFunction.this.processRow(step);
                }
                if (outputQueue.isEmpty() && KettleStepFunction.this.disposed.compareAndSet(false, true)) {
                    KettleStepFunction.this.dispose(step);
                    KettleStepFunction.this.operationLogger.basic("KettleStepFunction has completed");
                }
                return !outputQueue.isEmpty();
            }

            @Override
            public KettleRow next() {
                return (KettleRow)outputQueue.remove();
            }
        };
    }

    protected BaseStep createStep() {
        return Util.getTypedStep(this.stepMeta, BaseStep.class);
    }

    protected boolean processRow(BaseStep step) {
        try {
            boolean toRet = step.processRow(step.getStepMetaInterface(), step.getStepDataInterface());
            if (step.getErrors() > 0L) {
                throw new RuntimeException("Error processing rows on " + this.stepMeta.getName());
            }
            return toRet;
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    protected void dispose(BaseStep step) {
        step.dispose(step.getStepMetaInterface(), step.getStepDataInterface());
    }

    public List<Row> runOnDriver() {
        return ImmutableList.copyOf(this.call(Collections.emptyIterator()));
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)SerializableStepMeta.class.getName(), (Object)new SerializableStepMeta(this.stepMeta));
    }

    public void setConfig(String key, Serializable value) {
        if (Objects.equals(key, SerializableStepMeta.class.getName())) {
            SerializableStepMeta delegate = (SerializableStepMeta)value;
            this.stepMeta = delegate.getStepMeta();
        }
    }

    public void setOperationLogger(FunctionLogger logger) {
        this.operationLogger = logger;
    }

    public void setTransLogger(FunctionLogger logger) {
        this.transLogger = logger;
    }

    private class RowIterator
    implements RowHandler {
        private final Iterator<? extends Row> input;
        private final Queue<KettleRow> outputQueue;

        public RowIterator(Iterator<? extends Row> input, Queue<KettleRow> outputQueue) {
            this.input = input;
            this.outputQueue = outputQueue;
        }

        public Object[] getRow() {
            return this.input.hasNext() ? this.input.next().getObjects() : null;
        }

        public void putRow(RowMetaInterface rowMeta, Object[] row) {
            this.outputQueue.add(new KettleRow(rowMeta, row));
        }

        public void putError(RowMetaInterface rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws KettleStepException {
            throw new KettleStepException("Error handling is not supported from Spark: " + errorDescriptions);
        }
    }
}

