/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import scala.Tuple2;

public class MergeJoinFunctions {

    public static class FullOuterJoinToRddFunction
    extends BaseToRddFunction
    implements Function<Tuple2<List<Object>, Tuple2<Optional<Row>, Optional<Row>>>, Row> {
        public FullOuterJoinToRddFunction(String rowMetaXML, int row1Size, int row2Size) {
            super(rowMetaXML, row1Size, row2Size);
        }

        public Row call(Tuple2<List<Object>, Tuple2<Optional<Row>, Optional<Row>>> tuple) throws Exception {
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])(((Optional)((Tuple2)tuple._2)._1).isPresent() ? ((Row)((Optional)((Tuple2)tuple._2)._1).get()).getObjects() : new Object[this.row1Size]), (int)this.getRowMeta().size());
            Object[] values = RowDataUtil.addRowData((Object[])outputRowData, (int)this.row1Size, (Object[])(((Optional)((Tuple2)tuple._2)._2).isPresent() ? ((Row)((Optional)((Tuple2)tuple._2)._2).get()).getObjects() : new Object[this.row2Size]));
            return new KettleRow(this.getRowMeta(), values);
        }
    }

    public static class RightOuterJoinToRddFunction
    extends BaseToRddFunction
    implements Function<Tuple2<List<Object>, Tuple2<Optional<Row>, Row>>, Row> {
        public RightOuterJoinToRddFunction(String rowMetaXML, int row1Size, int row2Size) {
            super(rowMetaXML, row1Size, row2Size);
        }

        public Row call(Tuple2<List<Object>, Tuple2<Optional<Row>, Row>> tuple) throws Exception {
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])(((Optional)((Tuple2)tuple._2)._1).isPresent() ? ((Row)((Optional)((Tuple2)tuple._2)._1).get()).getObjects() : new Object[this.row1Size]), (int)this.getRowMeta().size());
            Object[] values = RowDataUtil.addRowData((Object[])outputRowData, (int)this.row1Size, (Object[])((Row)((Tuple2)tuple._2)._2).getObjects());
            return new KettleRow(this.getRowMeta(), values);
        }
    }

    public static class LeftOuterJoinToRddFunction
    extends BaseToRddFunction
    implements Function<Tuple2<List<Object>, Tuple2<Row, Optional<Row>>>, Row> {
        public LeftOuterJoinToRddFunction(String rowMetaXML, int row1Size, int row2Size) {
            super(rowMetaXML, row1Size, row2Size);
        }

        public Row call(Tuple2<List<Object>, Tuple2<Row, Optional<Row>>> tuple) throws Exception {
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])((Row)((Tuple2)tuple._2)._1).getObjects(), (int)this.getRowMeta().size());
            Object[] values = RowDataUtil.addRowData((Object[])outputRowData, (int)this.row1Size, (Object[])(((Optional)((Tuple2)tuple._2)._2).isPresent() ? ((Row)((Optional)((Tuple2)tuple._2)._2).get()).getObjects() : new Object[this.row2Size]));
            return new KettleRow(this.getRowMeta(), values);
        }
    }

    public static class InnerJoinToRddFunction
    extends BaseToRddFunction
    implements Function<Tuple2<List<Object>, Tuple2<Row, Row>>, Row> {
        public InnerJoinToRddFunction(String rowMetaXML, int row1Size, int row2Size) {
            super(rowMetaXML, row1Size, row2Size);
        }

        public Row call(Tuple2<List<Object>, Tuple2<Row, Row>> tuple) throws Exception {
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])((Row)((Tuple2)tuple._2)._1).getObjects(), (int)this.getRowMeta().size());
            Object[] values = RowDataUtil.addRowData((Object[])outputRowData, (int)this.row1Size, (Object[])((Row)((Tuple2)tuple._2)._2).getObjects());
            return new KettleRow(this.getRowMeta(), values);
        }
    }

    public static abstract class BaseToRddFunction
    implements Serializable {
        private final String rowMetaXML;
        private transient RowMetaInterface rowMeta;
        protected final int row1Size;
        protected final int row2Size;

        public BaseToRddFunction(String rowMetaXML, int row1Size, int row2Size) {
            this.rowMetaXML = rowMetaXML;
            this.row1Size = row1Size;
            this.row2Size = row2Size;
        }

        protected RowMetaInterface getRowMeta() {
            if (this.rowMeta == null) {
                try {
                    Document doc = XMLHandler.loadXMLString((String)this.rowMetaXML);
                    Node rowMetaNode = XMLHandler.getSubNode((Node)doc, (String)"row-meta");
                    this.rowMeta = new RowMeta(rowMetaNode);
                }
                catch (KettleException ke) {
                    throw new RuntimeException(ke);
                }
            }
            return this.rowMeta;
        }
    }

    public static class ToPairRddFunction
    implements PairFunction<Row, List<Object>, Row>,
    Serializable {
        private final int[] keyIndexes;

        public ToPairRddFunction(String[] fields, String[] keyFields) {
            this.keyIndexes = Stream.of(keyFields).mapToInt(key -> Arrays.binarySearch(fields, key)).toArray();
        }

        public Tuple2<List<Object>, Row> call(Row row) throws Exception {
            List keys = IntStream.of(this.keyIndexes).mapToObj(i -> row.getObjects()[i]).collect(Collectors.toList());
            return new Tuple2(keys, (Object)row);
        }
    }
}

