/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.functions.TransSerializingBase;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.fileinput.BaseFileInputStepMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputUtils;
import org.pentaho.di.trans.steps.fileinput.text.TextFileLine;

public class FileInputContentFunctionPartitioned
extends TransSerializingBase
implements Serializable,
FlatMapFunction<Iterator<String>, Row> {
    private transient boolean isInitialized = false;
    private transient TextFileInputMeta fileMeta;
    private transient RowMetaInterface rowMetaInterface;
    private transient RowMetaInterface convertRowMeta;

    public FileInputContentFunctionPartitioned(String id, TransMeta transMeta) {
        super(transMeta, id);
        this.init(transMeta, id);
    }

    @Override
    public void init(TransMeta transMeta, String id) {
        if (!this.isInitialized) {
            super.init(transMeta, id);
            logChannel.logBasic("In fileInputContentFunctionPartitioned init (logchannel)");
            System.out.println("In fileInputContentFunctionPartitioned init (println)");
            Logger.getLogger(this.getClass()).info((Object)"In fileInputContentFunctionPartitioned init (rootlogger)");
            this.fileMeta = Util.getTypedStepMeta(transMeta.findStep(id), TextFileInputMeta.class);
            try {
                this.rowMetaInterface = transMeta.getStepFields(transMeta.findStep(id));
                this.convertRowMeta = this.rowMetaInterface.cloneToType(2);
                this.isInitialized = true;
            }
            catch (KettleStepException | KettleValueException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Iterator<Row> call(Iterator<String> stringIterator) throws Exception {
        ArrayList output = new ArrayList();
        LogChannelInterface logChannelInterface = KettleLogStore.getLogChannelInterfaceFactory().create((Object)this.fileMeta);
        Date theDate = new Date();
        BaseFileInputStepMeta.AdditionalOutputFields additionalOutputFields = new BaseFileInputStepMeta.AdditionalOutputFields();
        stringIterator.forEachRemaining(s -> {
            this.logRow();
            TextFileLine line = new TextFileLine(s, 0L, null);
            Object[] row = new Object[]{};
            try {
                row = TextFileInputUtils.convertLineToRow((LogChannelInterface)logChannelInterface, (TextFileLine)line, (TextFileInputMeta)this.fileMeta, (Object[])new Object[0], (int)0, (RowMetaInterface)this.rowMetaInterface, (RowMetaInterface)this.convertRowMeta, (String)this.fileMeta.getFileName()[0], (long)0L, (String)this.fileMeta.content.separator, (String)this.fileMeta.content.enclosure, (String)this.fileMeta.content.escapeCharacter, null, (BaseFileInputStepMeta.AdditionalOutputFields)additionalOutputFields, (String)this.fileMeta.content.filenameField, (String)"", (boolean)false, (Date)theDate, (String)"", (String)"", (String)"", (Long)0L);
            }
            catch (KettleException e) {
                e.printStackTrace();
            }
            output.add(row);
        });
        return output.stream().map(objects -> new KettleRow(this.rowMetaInterface, (Object[])objects)).collect(Collectors.toList()).iterator();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        super.writeObjectDefault(oos);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        super.readObjectDefault(ois);
    }
}

