/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Date;
import org.apache.spark.api.java.function.Function;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.functions.TransSerializingBase;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.fileinput.BaseFileInputStepMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputUtils;
import org.pentaho.di.trans.steps.fileinput.text.TextFileLine;

public class FileInputContentFunction
extends TransSerializingBase
implements Function<String, Row> {
    private transient TextFileInputMeta fileMeta;
    private transient RowMetaInterface rowMetaInterface;
    private transient RowMetaInterface convertRowMeta;

    public FileInputContentFunction(String id, TransMeta transMeta) {
        super(transMeta, id);
        this.init(transMeta, id);
    }

    @Override
    public void init(TransMeta transMeta, String id) {
        super.init(transMeta, id);
        this.fileMeta = Util.getTypedStepMeta(transMeta.findStep(id), TextFileInputMeta.class);
        try {
            this.rowMetaInterface = transMeta.getStepFields(transMeta.findStep(id));
            this.convertRowMeta = this.rowMetaInterface.cloneToType(2);
        }
        catch (KettleStepException | KettleValueException e) {
            throw new RuntimeException(e);
        }
    }

    public Row call(String s) throws Exception {
        this.logRow();
        TextFileLine line = new TextFileLine(s, 0L, null);
        Object[] row = TextFileInputUtils.convertLineToRow((LogChannelInterface)KettleLogStore.getLogChannelInterfaceFactory().create((Object)this.fileMeta), (TextFileLine)line, (TextFileInputMeta)this.fileMeta, (Object[])new Object[0], (int)0, (RowMetaInterface)this.rowMetaInterface, (RowMetaInterface)this.convertRowMeta, (String)this.fileMeta.getFileName()[0], (long)0L, (String)this.fileMeta.content.separator, (String)this.fileMeta.content.enclosure, (String)this.fileMeta.content.escapeCharacter, null, (BaseFileInputStepMeta.AdditionalOutputFields)new BaseFileInputStepMeta.AdditionalOutputFields(), (String)this.fileMeta.content.filenameField, (String)"", (boolean)false, (Date)new Date(), (String)"", (String)"", (String)"", (Long)0L);
        return new KettleRow(Arrays.asList(this.rowMetaInterface.getFieldNames()), row);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        super.writeObjectDefault(oos);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        super.readObjectDefault(ois);
    }
}

