/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.execution;

import io.reactivex.subjects.ReplaySubject;
import java.util.Date;
import java.util.Optional;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.LogLevel;

public class OperationLogger {
    private final ReplaySubject<LogEntry> loggingSubject;

    public OperationLogger(ReplaySubject<LogEntry> loggingSubject) {
        this.loggingSubject = loggingSubject;
    }

    public void basic(String message) {
        this.create(LogLevel.BASIC, message, Optional.empty());
    }

    public void basic(String message, Throwable throwable) {
        this.create(LogLevel.BASIC, message, Optional.of(throwable));
    }

    public void error(String message) {
        this.create(LogLevel.ERROR, message, Optional.empty());
    }

    public void error(String message, Throwable throwable) {
        this.create(LogLevel.ERROR, message, Optional.of(throwable));
    }

    public void minimal(String message) {
        this.create(LogLevel.MINIMAL, message, Optional.empty());
    }

    public void minimal(String message, Throwable throwable) {
        this.create(LogLevel.MINIMAL, message, Optional.of(throwable));
    }

    public void detailed(String message) {
        this.create(LogLevel.DETAILED, message, Optional.empty());
    }

    public void detailed(String message, Throwable throwable) {
        this.create(LogLevel.DETAILED, message, Optional.of(throwable));
    }

    public void debug(String message) {
        this.create(LogLevel.DEBUG, message, Optional.empty());
    }

    public void debug(String message, Throwable throwable) {
        this.create(LogLevel.DEBUG, message, Optional.of(throwable));
    }

    private void create(LogLevel level, String message, Optional<Throwable> throwableOptional) {
        LogEntry.LogEntryBuilder logEntryBuilder = new LogEntry.LogEntryBuilder().withMessage(message).withLogLevel(level).withTimestamp(new Date());
        if (throwableOptional.isPresent()) {
            logEntryBuilder = logEntryBuilder.withThrowable(throwableOptional.get());
        }
        this.loggingSubject.onNext((Object)logEntryBuilder.build());
    }
}

