/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.ValidCompactorTxnList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TxnUtils.class);

    public static ValidTxnList createValidReadTxnList(GetOpenTxnsResponse txns, long currentTxn) {
        long highWater = txns.getTxn_high_water_mark();
        Set<Long> open = txns.getOpen_txns();
        long[] exceptions = new long[open.size() - (currentTxn > 0L ? 1 : 0)];
        int i = 0;
        for (long txn : open) {
            if (currentTxn > 0L && currentTxn == txn) continue;
            exceptions[i++] = txn;
        }
        return new ValidReadTxnList(exceptions, highWater);
    }

    public static ValidTxnList createValidCompactTxnList(GetOpenTxnsInfoResponse txns) {
        long highWater = txns.getTxn_high_water_mark();
        long minOpenTxn = Long.MAX_VALUE;
        long[] exceptions = new long[txns.getOpen_txnsSize()];
        int i = 0;
        for (TxnInfo txn : txns.getOpen_txns()) {
            if (txn.getState() == TxnState.OPEN) {
                minOpenTxn = Math.min(minOpenTxn, txn.getId());
            }
            exceptions[i++] = txn.getId();
        }
        highWater = minOpenTxn == Long.MAX_VALUE ? highWater : minOpenTxn - 1L;
        return new ValidCompactorTxnList(exceptions, -1L, highWater);
    }

    public static TxnStore getTxnStore(HiveConf conf) {
        String className = conf.getVar(HiveConf.ConfVars.METASTORE_TXN_STORE_IMPL);
        try {
            TxnStore handler = (TxnStore)((Object)MetaStoreUtils.getClass(className).newInstance());
            handler.setConf(conf);
            return handler;
        }
        catch (Exception e) {
            LOG.error("Unable to instantiate raw store directly in fastpath mode", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean isAcidTable(Table table) {
        if (table == null) {
            return false;
        }
        Map<String, String> parameters = table.getParameters();
        String tableIsTransactional = parameters.get("transactional");
        return tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true");
    }

    public static void buildQueryWithINClause(HiveConf conf, List<String> queries, StringBuilder prefix, StringBuilder suffix, List<Long> inList, String inColumn, boolean addParens, boolean notIn) {
        int batchSize = conf.getIntVar(HiveConf.ConfVars.METASTORE_DIRECT_SQL_MAX_ELEMENTS_IN_CLAUSE);
        int numWholeBatches = inList.size() / batchSize;
        StringBuilder buf = new StringBuilder();
        buf.append((CharSequence)prefix);
        if (addParens) {
            buf.append("(");
        }
        buf.append(inColumn);
        if (notIn) {
            buf.append(" not in (");
        } else {
            buf.append(" in (");
        }
        for (int i = 0; i <= numWholeBatches; ++i) {
            if (TxnUtils.needNewQuery(conf, buf)) {
                if (addParens) {
                    buf.append(")");
                }
                buf.append((CharSequence)suffix);
                queries.add(buf.toString());
                buf.setLength(0);
            }
            if (i > 0) {
                if (notIn) {
                    if (buf.length() == 0) {
                        buf.append((CharSequence)prefix);
                        if (addParens) {
                            buf.append("(");
                        }
                    } else {
                        buf.append(" and ");
                    }
                    buf.append(inColumn);
                    buf.append(" not in (");
                } else {
                    if (buf.length() == 0) {
                        buf.append((CharSequence)prefix);
                        if (addParens) {
                            buf.append("(");
                        }
                    } else {
                        buf.append(" or ");
                    }
                    buf.append(inColumn);
                    buf.append(" in (");
                }
            }
            if (i * batchSize == inList.size()) {
                return;
            }
            for (int j = i * batchSize; j < (i + 1) * batchSize && j < inList.size(); ++j) {
                buf.append(inList.get(j)).append(",");
            }
            buf.setCharAt(buf.length() - 1, ')');
        }
        if (addParens) {
            buf.append(")");
        }
        buf.append((CharSequence)suffix);
        queries.add(buf.toString());
    }

    private static boolean needNewQuery(HiveConf conf, StringBuilder sb) {
        int queryMemoryLimit = conf.getIntVar(HiveConf.ConfVars.METASTORE_DIRECT_SQL_MAX_QUERY_LENGTH);
        long sizeInBytes = 8 * ((sb.length() * 2 + 45) / 8);
        return sizeInBytes / 1024L > (long)queryMemoryLimit;
    }
}

