/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.webjars;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.WarningLevel;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.pentaho.js.require.RequireJsGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebjarsURLConnection
extends URLConnection {
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(5, r -> {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setDaemon(true);
        thread.setName("WebjarsURLConnection pool");
        return thread;
    });
    Future<Void> transform_thread;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean minificationEnabled;

    public WebjarsURLConnection(URL url) {
        this(url, true);
    }

    public WebjarsURLConnection(URL url, boolean minificationEnabled) {
        super(url);
        this.minificationEnabled = minificationEnabled;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            URLConnection urlConnection = this.url.openConnection();
            urlConnection.connect();
            InputStream originalInputStream = urlConnection.getInputStream();
            this.transform_thread = EXECUTOR.submit(new WebjarsTransformer(this.url, originalInputStream, pipedOutputStream, this.minificationEnabled));
            return pipedInputStream;
        }
        catch (Exception e) {
            this.logger.error(this.getURL().toString() + ": Error opening url");
            throw new IOException("Error opening url", e);
        }
    }

    private static class WebjarsTransformer
    implements Callable<Void> {
        private static final String DEBUG_MESSAGE_FAILED_WRITING = "Problem transfering Jar content, probably JarOutputStream was already closed.";
        private static final String MANIFEST_MF = "MANIFEST.MF";
        private static final String PENTAHO_RJS_LOCATION = "META-INF/js/require.json";
        private static final String WEBJARS_REQUIREJS_NAME = "webjars-requirejs.js";
        private static final Pattern MODULE_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]+)/([^/]+)/webjars-requirejs.js");
        private static final String POM_NAME = "pom.xml";
        private static final Pattern POM_PATTERN = Pattern.compile("META-INF/maven/org.webjars([^/]*)/([^/]+)/pom.xml");
        private static final String BOWER_NAME = "bower.json";
        private static final Pattern BOWER_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]+)/([^/]+)/bower.json");
        private static final String NPM_NAME = "package.json";
        private static final Pattern NPM_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]+)/([^/]+)/package.json");
        private static final Pattern PACKAGE_FILES_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]+)/([^/]+)/.*");
        private static final ArrayList<String> JS_KNOWN_GLOBALS = new ArrayList();
        private static final int BYTES_BUFFER_SIZE = 4096;
        private static final String WEBJAR_SRC_ALIAS_PREFIX = "webjar-src";
        private static final String MINIFIED_RESOURCES_OUTPUT_PATH = "META-INF/resources/dist-gen";
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final URL url;
        private final InputStream inputStream;
        private final OutputStream outputStream;
        private final boolean minificationEnabled;
        private RequireJsGenerator.ArtifactInfo artifactInfo;
        private JarOutputStream jarOutputStream;
        private boolean isClassicWebjar;
        private boolean isNpmWebjar;
        private boolean isBowerWebjar;
        private String pomProjectVersion;
        private boolean wasReadFromPom;
        private RequireJsGenerator requireConfig;
        private ArrayList<String> exportedGlobals;
        private boolean isAmdPackage;
        private String lastPrefix;
        private SourceMap.LocationMapping lastLocationMapping;
        private String webjarUrl;
        private String packageNameFromResourcesPath;
        private String packageVersionFromResourcesPath;
        private String relativeResourcesPath;
        private Path absoluteResourcesPath;
        private Path absoluteTempPath;

        WebjarsTransformer(URL url, InputStream inputStream, PipedOutputStream outputStream, boolean minificationEnabled) {
            this.url = url;
            this.inputStream = inputStream;
            this.outputStream = outputStream;
            this.minificationEnabled = minificationEnabled;
        }

        @Override
        public Void call() throws Exception {
            try {
                this.transform();
            }
            catch (Exception e) {
                this.logger.error(this.url.toString() + ": Error Transforming zip", (Throwable)e);
                this.outputStream.close();
                throw e;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transform() throws IOException {
            JarInputStream jarInputStream = new JarInputStream(this.inputStream);
            try {
                JarEntry entry;
                this.init();
                this.extractArtifactInfo(this.url);
                this.jarOutputStream = new JarOutputStream(this.outputStream, this.getManifest(this.artifactInfo, jarInputStream));
                boolean minificationFailed = false;
                while ((entry = jarInputStream.getNextJarEntry()) != null) {
                    String name = entry.getName();
                    if (name.endsWith(MANIFEST_MF)) {
                        jarInputStream.closeEntry();
                        continue;
                    }
                    if (name.endsWith(POM_NAME) && POM_PATTERN.matcher(name).matches()) {
                        this.handlePomFile(jarInputStream);
                        continue;
                    }
                    boolean isPackageFile = this.isPackageFile(name);
                    if (!entry.isDirectory()) {
                        int read;
                        Object temporarySourceFile = null;
                        BufferedOutputStream temporarySourceFileOutputStream = null;
                        if (isPackageFile) {
                            temporarySourceFile = new File(this.absoluteTempPath.toAbsolutePath() + File.separator + FilenameUtils.separatorsToSystem((String)name));
                            ((File)temporarySourceFile).getParentFile().mkdirs();
                            temporarySourceFileOutputStream = new BufferedOutputStream(new FileOutputStream((File)temporarySourceFile));
                        }
                        ZipEntry zipEntry = new ZipEntry(name);
                        this.jarOutputStream.putNextEntry(zipEntry);
                        byte[] bytes = new byte[4096];
                        while ((read = jarInputStream.read(bytes)) != -1) {
                            if (isPackageFile) {
                                temporarySourceFileOutputStream.write(bytes, 0, read);
                            }
                            this.jarOutputStream.write(bytes, 0, read);
                        }
                        this.jarOutputStream.closeEntry();
                        if (isPackageFile) {
                            temporarySourceFileOutputStream.close();
                            if (!this.isAmdPackage && this.isJsFile(name) && this.findAmdDefine(new FileInputStream((File)temporarySourceFile), this.exportedGlobals)) {
                                this.isAmdPackage = true;
                            }
                        }
                        if (this.requireConfig == null || this.isClassicWebjar && !this.wasReadFromPom) {
                            if (this.isClassicWebjar && name.endsWith(WEBJARS_REQUIREJS_NAME)) {
                                this.handleWebjarsRequireJS(name, (File)temporarySourceFile);
                            } else if (this.isNpmWebjar && name.endsWith(NPM_NAME)) {
                                this.handlePackageJson(name, (File)temporarySourceFile);
                            } else if (this.isBowerWebjar && name.endsWith(BOWER_NAME)) {
                                this.handleBowerJson(name, (File)temporarySourceFile);
                            }
                        }
                    }
                    jarInputStream.closeEntry();
                }
                if (this.absoluteResourcesPath != null) {
                    Collection scrFiles = FileUtils.listFiles((File)this.absoluteResourcesPath.toFile(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                    if (this.minificationEnabled) {
                        try {
                            CompilerOptions options = this.initCompilationResources();
                            for (File srcFile : scrFiles) {
                                String name = srcFile.getName();
                                if (name.endsWith(WEBJARS_REQUIREJS_NAME)) continue;
                                String relSrcFilePath = FilenameUtils.separatorsToUnix((String)this.absoluteResourcesPath.relativize(srcFile.toPath()).toString());
                                String relOutFilePath = "META-INF/resources/dist-gen/" + relSrcFilePath;
                                if (this.isJsFile(name)) {
                                    File mapFile = new File(name + ".map", srcFile.getParent());
                                    if (mapFile.exists()) {
                                        this.copyFileToZip(this.jarOutputStream, relOutFilePath, srcFile);
                                        this.copyFileToZip(this.jarOutputStream, relOutFilePath + ".map", mapFile);
                                        continue;
                                    }
                                    options.setSourceMapLocationMappings(this.getLocationMappings(srcFile.toPath().getParent(), this.absoluteResourcesPath, this.packageNameFromResourcesPath, this.packageVersionFromResourcesPath));
                                    try {
                                        CompiledScript compiledScript = new CompiledScript(srcFile, relSrcFilePath, options).invoke();
                                        this.addContentToZip(this.jarOutputStream, relOutFilePath, compiledScript.getCode());
                                        this.addContentToZip(this.jarOutputStream, relOutFilePath + ".map", compiledScript.getSourcemap());
                                    }
                                    catch (Exception failedCompilationException) {
                                        this.logger.warn(this.webjarUrl + ": error minifing " + relSrcFilePath + ", copied original version");
                                        this.copyFileToZip(this.jarOutputStream, relOutFilePath, srcFile);
                                    }
                                    continue;
                                }
                                if (this.isMapFile(name)) continue;
                                this.copyFileToZip(this.jarOutputStream, relOutFilePath, srcFile);
                            }
                        }
                        catch (Exception e) {
                            minificationFailed = true;
                            this.logger.warn(this.webjarUrl + ": exception minifing, serving original files", (Throwable)e);
                        }
                    }
                    if (this.requireConfig == null) {
                        this.requireConfig = RequireJsGenerator.emptyGenerator((String)this.packageNameFromResourcesPath, (String)this.packageVersionFromResourcesPath);
                        this.logger.warn(this.webjarUrl + ": malformed webjar deployed using root path mapping");
                    }
                    if (this.requireConfig != null) {
                        try {
                            String exports = !this.isAmdPackage && !this.exportedGlobals.isEmpty() ? this.exportedGlobals.get(0) : null;
                            RequireJsGenerator.ModuleInfo moduleInfo = this.requireConfig.getConvertedConfig(this.artifactInfo, this.isAmdPackage, exports);
                            this.addContentToZip(this.jarOutputStream, PENTAHO_RJS_LOCATION, moduleInfo.exportRequireJs());
                            try {
                                String blueprintTemplate = !this.minificationEnabled || minificationFailed ? this.generateBlueprintWithoutMinifiedResources(this.relativeResourcesPath, moduleInfo) : this.generateBlueprint(this.relativeResourcesPath, moduleInfo);
                                this.addContentToZip(this.jarOutputStream, "OSGI-INF/blueprint/blueprint.xml", blueprintTemplate);
                            }
                            catch (Exception e) {
                                this.logger.error(this.webjarUrl + ": error saving OSGI-INF/blueprint/blueprint.xml - " + e.getMessage());
                            }
                        }
                        catch (Exception e) {
                            this.logger.error(this.webjarUrl + ": error saving " + PENTAHO_RJS_LOCATION + " - " + e.getMessage());
                        }
                    }
                }
                try {
                    this.jarOutputStream.closeEntry();
                    this.outputStream.flush();
                    this.jarOutputStream.close();
                }
                catch (IOException ioexception) {
                    this.logger.debug(this.webjarUrl + ": " + DEBUG_MESSAGE_FAILED_WRITING, (Throwable)ioexception);
                }
            }
            catch (IOException e) {
                this.logger.debug(this.webjarUrl + ": Pipe is closed, no need to continue.");
            }
            finally {
                try {
                    FileUtils.deleteDirectory((File)this.absoluteTempPath.toFile());
                }
                catch (IOException e) {}
                try {
                    jarInputStream.close();
                }
                catch (IOException ioexception) {
                    this.logger.debug(this.webjarUrl + ": Tried to close JarInputStream, but it was already closed.", (Throwable)ioexception);
                }
            }
        }

        private void init() throws IOException {
            this.wasReadFromPom = false;
            this.requireConfig = null;
            this.exportedGlobals = new ArrayList();
            this.isAmdPackage = false;
            this.pomProjectVersion = null;
            this.packageNameFromResourcesPath = null;
            this.packageVersionFromResourcesPath = null;
            this.relativeResourcesPath = null;
            this.absoluteResourcesPath = null;
            this.absoluteTempPath = Files.createTempDirectory("WebjarsURLConnection", new FileAttribute[0]);
        }

        private void extractArtifactInfo(URL url) {
            this.artifactInfo = new RequireJsGenerator.ArtifactInfo(url);
            this.isClassicWebjar = this.artifactInfo.getGroup().equals("org.webjars");
            this.isNpmWebjar = this.artifactInfo.getGroup().equals("org.webjars.npm");
            this.isBowerWebjar = this.artifactInfo.getGroup().equals("org.webjars.bower");
            this.webjarUrl = url.toString();
        }

        private Manifest getManifest(RequireJsGenerator.ArtifactInfo artifactInfo, JarInputStream jarInputStream) {
            Manifest manifest = jarInputStream.getManifest();
            if (manifest == null) {
                manifest = new Manifest();
                manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            }
            manifest.getMainAttributes().put(new Attributes.Name("Bundle-SymbolicName"), "pentaho-webjars-" + artifactInfo.getArtifactId());
            manifest.getMainAttributes().put(new Attributes.Name("Import-Package"), "org.osgi.service.http,org.apache.felix.http.api,org.ops4j.pax.web.extender.whiteboard.runtime,org.ops4j.pax.web.extender.whiteboard");
            manifest.getMainAttributes().put(new Attributes.Name("Bundle-Version"), artifactInfo.getOsgiCompatibleVersion());
            return manifest;
        }

        private void handlePomFile(JarInputStream jarInputStream) {
            if (this.isClassicWebjar) {
                try {
                    this.requireConfig = RequireJsGenerator.parsePom((InputStream)jarInputStream);
                    this.wasReadFromPom = true;
                    this.logger.debug(this.webjarUrl + ": Classic WebJar -> requirejs configuration from pom.xml");
                }
                catch (Exception exception) {}
            } else if (this.isBowerWebjar) {
                try {
                    this.pomProjectVersion = RequireJsGenerator.getWebjarVersionFromPom((InputStream)jarInputStream);
                    if (this.requireConfig != null && this.requireConfig.getModuleInfo() != null && this.requireConfig.getModuleInfo().getVersion() == null) {
                        this.requireConfig.getModuleInfo().setVersion(this.pomProjectVersion);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void handleWebjarsRequireJS(String name, File temporarySourceFile) {
            Matcher matcher = MODULE_PATTERN.matcher(name);
            if (matcher.matches()) {
                try {
                    this.requireConfig = RequireJsGenerator.processJsScript((String)matcher.group(1), (String)matcher.group(2), (InputStream)new FileInputStream(temporarySourceFile));
                    this.logger.debug(this.webjarUrl + ": Classic WebJar -> read requirejs configuration from webjars-requirejs.js");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void handlePackageJson(String name, File temporarySourceFile) {
            if (NPM_PATTERN.matcher(name).matches()) {
                try {
                    this.requireConfig = RequireJsGenerator.parseJsonPackage((InputStream)new FileInputStream(temporarySourceFile));
                    this.logger.debug(this.webjarUrl + ": NPM WebJar -> read requirejs configuration from package.json");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void handleBowerJson(String name, File temporarySourceFile) {
            if (BOWER_PATTERN.matcher(name).matches()) {
                try {
                    this.requireConfig = RequireJsGenerator.parseJsonPackage((InputStream)new FileInputStream(temporarySourceFile));
                    if (this.pomProjectVersion != null && this.requireConfig != null && this.requireConfig.getModuleInfo() != null && this.requireConfig.getModuleInfo().getVersion() == null) {
                        this.requireConfig.getModuleInfo().setVersion(this.pomProjectVersion);
                    }
                    this.logger.debug(this.webjarUrl + ": Bower WebJar -> read requirejs configuration from bower.json");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private boolean isPackageFile(String name) {
            boolean isPackageFile = false;
            if (this.packageNameFromResourcesPath == null) {
                Matcher matcher = PACKAGE_FILES_PATTERN.matcher(name);
                if (matcher.matches()) {
                    this.packageNameFromResourcesPath = matcher.group(1);
                    this.packageVersionFromResourcesPath = matcher.group(2);
                    this.relativeResourcesPath = "META-INF/resources/webjars/" + this.packageNameFromResourcesPath + "/" + this.packageVersionFromResourcesPath;
                    this.absoluteResourcesPath = this.absoluteTempPath.resolve(FilenameUtils.separatorsToSystem((String)this.relativeResourcesPath));
                    isPackageFile = true;
                }
            } else {
                isPackageFile = name.contains(this.packageNameFromResourcesPath + "/" + this.packageVersionFromResourcesPath);
            }
            return isPackageFile;
        }

        private String generateBlueprint(String relSrcPath, RequireJsGenerator.ModuleInfo moduleInfo) throws IOException {
            String blueprintTemplate = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/org/pentaho/osgi/platform/webjars/blueprint-minified-template.xml"));
            blueprintTemplate = blueprintTemplate.replace("{src_path}", relSrcPath);
            blueprintTemplate = blueprintTemplate.replace("{src_alias}", "webjar-src/" + moduleInfo.getVersionedPath());
            blueprintTemplate = blueprintTemplate.replace("{dist_path}", MINIFIED_RESOURCES_OUTPUT_PATH);
            blueprintTemplate = blueprintTemplate.replace("{dist_alias}", moduleInfo.getVersionedPath());
            return blueprintTemplate;
        }

        private String generateBlueprintWithoutMinifiedResources(String relSrcPath, RequireJsGenerator.ModuleInfo moduleInfo) throws IOException {
            String blueprintTemplate = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/org/pentaho/osgi/platform/webjars/blueprint-template.xml"));
            blueprintTemplate = blueprintTemplate.replace("{dist_path}", relSrcPath);
            blueprintTemplate = blueprintTemplate.replace("{dist_alias}", moduleInfo.getVersionedPath());
            return blueprintTemplate;
        }

        private boolean isJsFile(String name) {
            return name.endsWith(".js");
        }

        private boolean isMapFile(String name) {
            return name.endsWith(".map");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyFileToZip(JarOutputStream zip, String entry, File file) throws IOException {
            byte[] readBuffer = new byte[4096];
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                ZipEntry zipEntry = new ZipEntry(entry);
                zip.putNextEntry(zipEntry);
                int bytesIn = inputStream.read(readBuffer);
                while (bytesIn != -1) {
                    zip.write(readBuffer, 0, bytesIn);
                    bytesIn = inputStream.read(readBuffer);
                }
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        private void addContentToZip(JarOutputStream zip, String entry, String content) throws IOException {
            ZipEntry zipEntry = new ZipEntry(entry);
            zip.putNextEntry(zipEntry);
            zip.write(content.getBytes("UTF-8"));
            zip.closeEntry();
        }

        private boolean findAmdDefine(InputStream is, ArrayList<String> exports) {
            Pattern definePattern = Pattern.compile("\bdefine\b(\\s*)\\(((\\s*)\"[^\"]+\"(\\s*),)?((\\s*)\\[((\\s*)\"[^\"]+\"(\\s*),?)+(\\s*)\\](\\s*),)?((\\s*)function)");
            Pattern globalPattern = Pattern.compile("(\\bwindow\\b|\\bexports\\b)\\.(([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*)\\s*=\\s*[\\w${][^,;]+");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    String var;
                    String varSegment;
                    Matcher matcher = definePattern.matcher(line);
                    if (matcher.find()) {
                        return true;
                    }
                    matcher = globalPattern.matcher(line);
                    if (!matcher.find() || (varSegment = (var = matcher.group(2)).split("\\.", 2)[0]).startsWith("on") || JS_KNOWN_GLOBALS.contains(varSegment) || exports.contains(var)) continue;
                    exports.add(var);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        private CompilerOptions initCompilationResources() {
            CompilerOptions options = new CompilerOptions();
            CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
            options.setSourceMapOutputPath(".");
            WarningLevel.QUIET.setOptionsForWarningLevel(options);
            options.setWarningLevel(DiagnosticGroups.LINT_CHECKS, CheckLevel.OFF);
            options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT5);
            this.lastPrefix = null;
            this.lastLocationMapping = null;
            return options;
        }

        private List<SourceMap.LocationMapping> getLocationMappings(Path srcFileFolder, Path absSrcPath, String packageName, String packageVersion) {
            String prefix = FilenameUtils.separatorsToUnix((String)srcFileFolder.toString());
            if (this.lastPrefix == null || !this.lastPrefix.equals(prefix)) {
                String reverseRelPath;
                String relPath = FilenameUtils.separatorsToUnix((String)absSrcPath.relativize(srcFileFolder).toString());
                if (!relPath.isEmpty()) {
                    relPath = "/" + relPath;
                }
                if (!(reverseRelPath = FilenameUtils.separatorsToUnix((String)srcFileFolder.relativize(absSrcPath).toString())).isEmpty()) {
                    reverseRelPath = reverseRelPath + "/";
                }
                String replacement = "../../" + reverseRelPath + WEBJAR_SRC_ALIAS_PREFIX + "/" + packageName + "/" + packageVersion + relPath;
                this.lastLocationMapping = new SourceMap.LocationMapping(prefix, replacement);
                this.lastPrefix = prefix;
            }
            ArrayList<SourceMap.LocationMapping> lms = new ArrayList<SourceMap.LocationMapping>();
            lms.add(this.lastLocationMapping);
            return lms;
        }

        static {
            JS_KNOWN_GLOBALS.add("applicationCache");
            JS_KNOWN_GLOBALS.add("caches");
            JS_KNOWN_GLOBALS.add("closed");
            JS_KNOWN_GLOBALS.add("Components");
            JS_KNOWN_GLOBALS.add("console");
            JS_KNOWN_GLOBALS.add("content");
            JS_KNOWN_GLOBALS.add("_content");
            JS_KNOWN_GLOBALS.add("controllers");
            JS_KNOWN_GLOBALS.add("crypto");
            JS_KNOWN_GLOBALS.add("defaultStatus");
            JS_KNOWN_GLOBALS.add("devicePixelRatio");
            JS_KNOWN_GLOBALS.add("dialogArguments");
            JS_KNOWN_GLOBALS.add("directories");
            JS_KNOWN_GLOBALS.add("document");
            JS_KNOWN_GLOBALS.add("frameElement");
            JS_KNOWN_GLOBALS.add("frames");
            JS_KNOWN_GLOBALS.add("fullScreen");
            JS_KNOWN_GLOBALS.add("globalStorage");
            JS_KNOWN_GLOBALS.add("history");
            JS_KNOWN_GLOBALS.add("innerHeight");
            JS_KNOWN_GLOBALS.add("innerWidth");
            JS_KNOWN_GLOBALS.add("length");
            JS_KNOWN_GLOBALS.add("location");
            JS_KNOWN_GLOBALS.add("locationbar");
            JS_KNOWN_GLOBALS.add("localStorage");
            JS_KNOWN_GLOBALS.add("menubar");
            JS_KNOWN_GLOBALS.add("messageManager");
            JS_KNOWN_GLOBALS.add("name");
            JS_KNOWN_GLOBALS.add("navigator");
            JS_KNOWN_GLOBALS.add("opener");
            JS_KNOWN_GLOBALS.add("outerHeight");
            JS_KNOWN_GLOBALS.add("outerWidth");
            JS_KNOWN_GLOBALS.add("pageXOffset");
            JS_KNOWN_GLOBALS.add("pageYOffset");
            JS_KNOWN_GLOBALS.add("sessionStorage");
            JS_KNOWN_GLOBALS.add("parent");
            JS_KNOWN_GLOBALS.add("performance");
            JS_KNOWN_GLOBALS.add("personalbar");
            JS_KNOWN_GLOBALS.add("pkcs11");
            JS_KNOWN_GLOBALS.add("returnValue");
            JS_KNOWN_GLOBALS.add("screen");
            JS_KNOWN_GLOBALS.add("screenX");
            JS_KNOWN_GLOBALS.add("screenY");
            JS_KNOWN_GLOBALS.add("scrollbars");
            JS_KNOWN_GLOBALS.add("scrollMaxX");
            JS_KNOWN_GLOBALS.add("scrollMaxY");
            JS_KNOWN_GLOBALS.add("scrollX");
            JS_KNOWN_GLOBALS.add("scrollY");
            JS_KNOWN_GLOBALS.add("self");
            JS_KNOWN_GLOBALS.add("sessionStorage");
            JS_KNOWN_GLOBALS.add("sidebar");
            JS_KNOWN_GLOBALS.add("status");
            JS_KNOWN_GLOBALS.add("statusbar");
            JS_KNOWN_GLOBALS.add("toolbar");
            JS_KNOWN_GLOBALS.add("top");
            JS_KNOWN_GLOBALS.add("window");
        }

        private static class CompiledScript {
            private static final SourceFile EMPTY_EXTERNS_SOURCE_FILE = SourceFile.fromCode((String)"externs.js", (String)"");
            private final File srcFile;
            private final String relSrcFilePath;
            private final CompilerOptions options;
            private StringBuilder code;
            private StringBuilder sourcemap;

            CompiledScript(File srcFile, String relSrcFilePath, CompilerOptions options) {
                this.srcFile = srcFile;
                this.relSrcFilePath = relSrcFilePath;
                this.options = options;
            }

            String getCode() {
                return this.code.toString();
            }

            String getSourcemap() {
                return this.sourcemap.toString();
            }

            CompiledScript invoke() throws Exception {
                Compiler compiler = new Compiler();
                Compiler.setLoggingLevel((Level)Level.OFF);
                SourceFile input = SourceFile.fromFile((File)this.srcFile);
                input.setOriginalPath(this.relSrcFilePath);
                Result res = compiler.compile(EMPTY_EXTERNS_SOURCE_FILE, input, this.options);
                if (res.success) {
                    String name = this.srcFile.getName();
                    this.code = new StringBuilder(compiler.toSource());
                    this.code.append("\n//# sourceMappingURL=").append(name).append(".map");
                    this.sourcemap = new StringBuilder();
                    SourceMap sm = compiler.getSourceMap();
                    sm.appendTo((Appendable)this.sourcemap, name);
                    return this;
                }
                throw new Exception("Failed script compilation");
            }
        }
    }
}

