/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile;

import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsParser;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.PercentilesBucketPipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class PercentilesBucketParser
extends BucketMetricsParser {
    public static final ParseField PERCENTS = new ParseField("percents", new String[0]);

    @Override
    public String type() {
        return PercentilesBucketPipelineAggregator.TYPE.name();
    }

    @Override
    protected PipelineAggregatorFactory buildFactory(String pipelineAggregatorName, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, ValueFormatter formatter, Map<String, Object> unparsedParams) throws ParseException {
        double[] percents = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};
        int counter = 0;
        Object percentParam = unparsedParams.get(PERCENTS.getPreferredName());
        if (percentParam != null) {
            if (percentParam instanceof List) {
                percents = new double[((List)percentParam).size()];
                for (Object p : (List)percentParam) {
                    if (p instanceof Double) {
                        percents[counter] = (Double)p;
                        ++counter;
                        continue;
                    }
                    throw new ParseException("Parameter [" + PERCENTS.getPreferredName() + "] must be an array of doubles, type `" + percentParam.getClass().getSimpleName() + "` provided instead", 0);
                }
                unparsedParams.remove(PERCENTS.getPreferredName());
            } else {
                throw new ParseException("Parameter [" + PERCENTS.getPreferredName() + "] must be an array of doubles, type `" + percentParam.getClass().getSimpleName() + "` provided instead", 0);
            }
        }
        return new PercentilesBucketPipelineAggregator.Factory(pipelineAggregatorName, bucketsPaths, gapPolicy, formatter, percents);
    }
}

