/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.threadpool.ThreadPool;

public class RoutingService
extends AbstractLifecycleComponent<RoutingService>
implements ClusterStateListener {
    private static final String CLUSTER_UPDATE_TASK_SOURCE = "cluster_reroute";
    final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private AtomicBoolean rerouting = new AtomicBoolean();
    private volatile long minDelaySettingAtLastSchedulingNanos = Long.MAX_VALUE;
    private volatile ScheduledFuture registeredNextDelayFuture;

    @Inject
    public RoutingService(Settings settings, ThreadPool threadPool, ClusterService clusterService, AllocationService allocationService) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        if (clusterService != null) {
            clusterService.addFirst(this);
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        FutureUtils.cancel(this.registeredNextDelayFuture);
        this.clusterService.remove(this);
    }

    public AllocationService getAllocationService() {
        return this.allocationService;
    }

    public final void reroute(String reason) {
        this.performReroute(reason);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().nodes().localNodeMaster()) {
            long minDelaySetting = UnassignedInfo.findSmallestDelayedAllocationSettingNanos(this.settings, event.state());
            if (minDelaySetting <= 0L) {
                this.logger.trace("no need to schedule reroute - no delayed unassigned shards, minDelaySetting [{}], scheduled [{}]", minDelaySetting, this.minDelaySettingAtLastSchedulingNanos);
                this.minDelaySettingAtLastSchedulingNanos = Long.MAX_VALUE;
                FutureUtils.cancel(this.registeredNextDelayFuture);
            } else if (minDelaySetting < this.minDelaySettingAtLastSchedulingNanos) {
                FutureUtils.cancel(this.registeredNextDelayFuture);
                this.minDelaySettingAtLastSchedulingNanos = minDelaySetting;
                TimeValue nextDelay = TimeValue.timeValueNanos(UnassignedInfo.findNextDelayedAllocationIn(event.state()));
                assert (nextDelay.nanos() > 0L) : "next delay must be non 0 as minDelaySetting is [" + minDelaySetting + "]";
                this.logger.info("delaying allocation for [{}] unassigned shards, next check in [{}]", UnassignedInfo.getNumberOfDelayedUnassigned(event.state()), nextDelay);
                this.registeredNextDelayFuture = this.threadPool.schedule(nextDelay, "same", new AbstractRunnable(){

                    @Override
                    protected void doRun() throws Exception {
                        RoutingService.this.minDelaySettingAtLastSchedulingNanos = Long.MAX_VALUE;
                        RoutingService.this.reroute("assign delayed unassigned shards");
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        RoutingService.this.logger.warn("failed to schedule/execute reroute post unassigned shard", t, new Object[0]);
                        RoutingService.this.minDelaySettingAtLastSchedulingNanos = Long.MAX_VALUE;
                    }
                });
            } else {
                this.logger.trace("no need to schedule reroute - current schedule reroute is enough. minDelaySetting [{}], scheduled [{}]", minDelaySetting, this.minDelaySettingAtLastSchedulingNanos);
            }
        }
    }

    long getMinDelaySettingAtLastSchedulingNanos() {
        return this.minDelaySettingAtLastSchedulingNanos;
    }

    protected void performReroute(final String reason) {
        try {
            if (this.lifecycle.stopped()) {
                return;
            }
            if (!this.rerouting.compareAndSet(false, true)) {
                this.logger.trace("already has pending reroute, ignoring {}", reason);
                return;
            }
            this.logger.trace("rerouting {}", reason);
            this.clusterService.submitStateUpdateTask("cluster_reroute(" + reason + ")", new ClusterStateUpdateTask(Priority.HIGH){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RoutingService.this.rerouting.set(false);
                    RoutingAllocation.Result routingResult = RoutingService.this.allocationService.reroute(currentState, reason);
                    if (!routingResult.changed()) {
                        return currentState;
                    }
                    return ClusterState.builder(currentState).routingResult(routingResult).build();
                }

                @Override
                public void onNoLongerMaster(String source) {
                    RoutingService.this.rerouting.set(false);
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    RoutingService.this.rerouting.set(false);
                    ClusterState state = RoutingService.this.clusterService.state();
                    if (RoutingService.this.logger.isTraceEnabled()) {
                        RoutingService.this.logger.error("unexpected failure during [{}], current state:\n{}", t, source, state.prettyPrint());
                    } else {
                        RoutingService.this.logger.error("unexpected failure during [{}], current state version [{}]", t, source, state.version());
                    }
                }
            });
        }
        catch (Throwable e) {
            this.rerouting.set(false);
            ClusterState state = this.clusterService.state();
            this.logger.warn("failed to reroute routing table, current state:\n{}", e, state.prettyPrint());
        }
    }
}

