/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.interpreter.AbstractSingleNode;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterNode
extends AbstractSingleNode<Filter> {
    private final Scalar condition;
    private final Context context;

    public FilterNode(Interpreter interpreter, Filter rel) {
        super(interpreter, rel);
        this.condition = interpreter.compile((List<RexNode>)ImmutableList.of((Object)rel.getCondition()), rel.getInputs());
        this.context = interpreter.createContext();
    }

    @Override
    public void run() throws InterruptedException {
        Row row;
        while ((row = this.source.receive()) != null) {
            this.context.values = row.getValues();
            Boolean b = (Boolean)this.condition.execute(this.context);
            if (b == null || !b.booleanValue()) continue;
            this.sink.send(row);
        }
    }
}

